/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.estrategiaswing;

import br.com.politec.estrategiaswing.IFormularioEstrategiaSwing;
import br.com.politec.estrategiaswing.IFormularioEstrategiaSwingFactory;
import br.com.politec.estrategiaswing.constante.Arquivo;
import br.com.politec.estrategiaswing.util.UtilLog;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.arquivo.UtilCarregarMapaDeObjetos;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.Component;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FormularioEstrategiaSwingFactory
implements IFormularioEstrategiaSwingFactory {
    private static IFormularioEstrategiaSwingFactory instancia = new FormularioEstrategiaSwingFactory();
    private Map estrategias;

    protected FormularioEstrategiaSwingFactory() {
    }

    public static IFormularioEstrategiaSwingFactory getInstancia() {
        return instancia;
    }

    public IFormularioEstrategiaSwing getEstrategia(String componente) {
        IFormularioEstrategiaSwing estrategia = null;
        if (UtilObjeto.isReferencia((Object)componente)) {
            estrategia = (IFormularioEstrategiaSwing)this.getEstrategias().get(componente);
            this.verificaExistenciaDeEstrategia(componente, estrategia);
        }
        return estrategia;
    }

    public IFormularioEstrategiaSwing getEstrategia(Class componente) {
        IFormularioEstrategiaSwing estrategia = null;
        if (UtilObjeto.isReferencia((Object)componente)) {
            String tipo = UtilObjeto.getNome((Object)componente);
            estrategia = this.getEstrategia(tipo);
        }
        return estrategia;
    }

    public IFormularioEstrategiaSwing getEstrategia(Component componente) {
        IFormularioEstrategiaSwing estrategia = null;
        if (UtilObjeto.isReferencia((Object)componente)) {
            Class<?> tipo = componente.getClass();
            estrategia = this.getEstrategia(tipo);
        }
        return estrategia;
    }

    public boolean isExisteEstrategia(String componente) {
        Set chaves = this.getEstrategias().keySet();
        return chaves.contains(componente);
    }

    public boolean isExisteEstrategia(Class componente) {
        boolean resultado = false;
        if (UtilObjeto.isReferencia((Object)componente)) {
            String tipo = UtilObjeto.getNome((Object)componente);
            resultado = this.isExisteEstrategia(tipo);
        }
        return resultado;
    }

    public boolean isExisteEstrategia(Component componente) {
        boolean resultado = false;
        if (UtilObjeto.isReferencia((Object)componente)) {
            Class<?> tipo = componente.getClass();
            resultado = this.isExisteEstrategia(tipo);
        }
        return resultado;
    }

    protected Properties getPropertiesDasEstrategias() {
        String path = Arquivo.getPathArquivoFormularioEstrategia();
        return UtilArquivo.getProperties((String)path);
    }

    protected Map getEstrategias() {
        if (!UtilObjeto.isReferencia((Object)this.estrategias)) {
            this.estrategias = this.novoMapaDeEstrategias();
        }
        return this.estrategias;
    }

    protected Map novoMapaDeEstrategias() {
        Properties prop = this.getPropertiesDasEstrategias();
        UtilCarregarMapaDeObjetos util = new UtilCarregarMapaDeObjetos();
        return util.getMapa(prop);
    }

    protected LogAbstrato getLog() {
        return UtilLog.getLog();
    }

    private void verificaExistenciaDeEstrategia(String tipo, IFormularioEstrategiaSwing estrategia) {
        if (!UtilObjeto.isReferencia((Object)estrategia)) {
            this.getLog().warn((Object)("Estrategia inexistente: " + tipo));
        }
    }
}

