/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscStmtHandle;
import org.firebirdsql.gds.IscSvcHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractGDS;
import org.firebirdsql.gds.impl.AbstractIscTrHandle;
import org.firebirdsql.gds.impl.DatabaseParameterBufferExtension;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.impl.wire.BlobParameterBufferImp;
import org.firebirdsql.gds.impl.wire.DatabaseParameterBufferImp;
import org.firebirdsql.gds.impl.wire.EventCoordinator;
import org.firebirdsql.gds.impl.wire.EventHandleImp;
import org.firebirdsql.gds.impl.wire.ServiceParameterBufferImp;
import org.firebirdsql.gds.impl.wire.ServiceRequestBufferImp;
import org.firebirdsql.gds.impl.wire.TransactionParameterBufferImpl;
import org.firebirdsql.gds.impl.wire.WireXdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.impl.wire.Xdrable;
import org.firebirdsql.gds.impl.wire.isc_blob_handle_impl;
import org.firebirdsql.gds.impl.wire.isc_db_handle_impl;
import org.firebirdsql.gds.impl.wire.isc_stmt_handle_impl;
import org.firebirdsql.gds.impl.wire.isc_svc_handle_impl;
import org.firebirdsql.gds.impl.wire.isc_tr_handle_impl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractJavaGDSImpl
extends AbstractGDS
implements GDS {
    public static final String PURE_JAVA_TYPE_NAME = "PURE_JAVA";
    private static Logger log = LoggerFactory.getLogger(AbstractJavaGDSImpl.class, false);
    static final int op_void = 0;
    static final int op_connect = 1;
    static final int op_exit = 2;
    static final int op_accept = 3;
    static final int op_reject = 4;
    static final int op_protocol = 5;
    static final int op_disconnect = 6;
    static final int op_credit = 7;
    static final int op_continuation = 8;
    static final int op_response = 9;
    static final int op_open_file = 10;
    static final int op_create_file = 11;
    static final int op_close_file = 12;
    static final int op_read_page = 13;
    static final int op_write_page = 14;
    static final int op_lock = 15;
    static final int op_convert_lock = 16;
    static final int op_release_lock = 17;
    static final int op_blocking = 18;
    static final int op_attach = 19;
    static final int op_create = 20;
    static final int op_detach = 21;
    static final int op_compile = 22;
    static final int op_start = 23;
    static final int op_start_and_send = 24;
    static final int op_send = 25;
    static final int op_receive = 26;
    static final int op_unwind = 27;
    static final int op_release = 28;
    static final int op_transaction = 29;
    static final int op_commit = 30;
    static final int op_rollback = 31;
    static final int op_prepare = 32;
    static final int op_reconnect = 33;
    static final int op_create_blob = 34;
    static final int op_open_blob = 35;
    static final int op_get_segment = 36;
    static final int op_put_segment = 37;
    static final int op_cancel_blob = 38;
    static final int op_close_blob = 39;
    static final int op_info_database = 40;
    static final int op_info_request = 41;
    static final int op_info_transaction = 42;
    static final int op_info_blob = 43;
    static final int op_batch_segments = 44;
    static final int op_mgr_set_affinity = 45;
    static final int op_mgr_clear_affinity = 46;
    static final int op_mgr_report = 47;
    static final int op_que_events = 48;
    static final int op_cancel_events = 49;
    static final int op_commit_retaining = 50;
    static final int op_prepare2 = 51;
    static final int op_event = 52;
    static final int op_connect_request = 53;
    static final int op_aux_connect = 54;
    static final int op_ddl = 55;
    static final int op_open_blob2 = 56;
    static final int op_create_blob2 = 57;
    static final int op_get_slice = 58;
    static final int op_put_slice = 59;
    static final int op_slice = 60;
    static final int op_seek_blob = 61;
    static final int op_allocate_statement = 62;
    static final int op_execute = 63;
    static final int op_exec_immediate = 64;
    static final int op_fetch = 65;
    static final int op_fetch_response = 66;
    static final int op_free_statement = 67;
    static final int op_prepare_statement = 68;
    static final int op_set_cursor = 69;
    static final int op_info_sql = 70;
    static final int op_dummy = 71;
    static final int op_response_piggyback = 72;
    static final int op_start_and_receive = 73;
    static final int op_start_send_and_receive = 74;
    static final int op_exec_immediate2 = 75;
    static final int op_execute2 = 76;
    static final int op_insert = 77;
    static final int op_sql_response = 78;
    static final int op_transact = 79;
    static final int op_transact_response = 80;
    static final int op_drop_database = 81;
    static final int op_service_attach = 82;
    static final int op_service_detach = 83;
    static final int op_service_info = 84;
    static final int op_service_start = 85;
    static final int op_rollback_retaining = 86;
    static final int MAX_BUFFER_SIZE = 1024;
    static final byte[] describe_database_info = new byte[]{62, 103, 32, 33, 11, 102, 13, 1};
    static final byte[] describe_select_info = new byte[]{21, 4, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 8};
    static final byte[] describe_bind_info = new byte[]{21, 5, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 8};
    static final byte[] sql_prepare_info = new byte[]{21, 4, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 8};
    private static byte[] stmtInfo = new byte[]{23, 21, 1};
    private static int INFO_SIZE = 128;

    public AbstractJavaGDSImpl() {
        super(GDSType.getType(PURE_JAVA_TYPE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCreateDatabase(String file_name, IscDbHandle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            DbAttachInfo dbai = new DbAttachInfo(file_name);
            this.connect(db, dbai, databaseParameterBuffer);
            String filenameCharset = databaseParameterBuffer.getArgumentAsString(139);
            try {
                if (debug) {
                    log.debug("op_create ");
                }
                db.out.writeInt(20);
                db.out.writeInt(0);
                db.out.writeString(dbai.getFileName(), filenameCharset);
                databaseParameterBuffer = ((DatabaseParameterBufferExtension)databaseParameterBuffer).removeExtensionParams();
                db.out.writeTyped(1, (Xdrable)((Object)databaseParameterBuffer));
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                try {
                    this.receiveResponse(db, -1);
                    db.setRdb_id(db.getResp_object());
                }
                catch (GDSException g) {
                    this.disconnect(db);
                    throw g;
                }
            }
            catch (IOException ex) {
                throw new GDSException(335544727);
            }
        }
    }

    public void internalAttachDatabase(String host, Integer port, String file_name, IscDbHandle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        DbAttachInfo dbai = new DbAttachInfo(host, port, file_name);
        this.internalAttachDatabase(dbai, db_handle, databaseParameterBuffer);
    }

    public void iscAttachDatabase(String connectString, IscDbHandle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        DbAttachInfo dbai = new DbAttachInfo(connectString);
        this.internalAttachDatabase(dbai, db_handle, databaseParameterBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalAttachDatabase(DbAttachInfo dbai, IscDbHandle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.connect(db, dbai, databaseParameterBuffer);
            String filenameCharset = databaseParameterBuffer.getArgumentAsString(139);
            try {
                if (debug) {
                    log.debug("op_attach ");
                }
                db.out.writeInt(19);
                db.out.writeInt(0);
                db.out.writeString(dbai.getFileName(), filenameCharset);
                databaseParameterBuffer = ((DatabaseParameterBufferExtension)databaseParameterBuffer).removeExtensionParams();
                db.out.writeTyped(1, (Xdrable)((Object)databaseParameterBuffer));
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                try {
                    this.receiveResponse(db, -1);
                    db.setRdb_id(db.getResp_object());
                }
                catch (GDSException ge) {
                    this.disconnect(db);
                    throw ge;
                }
                this.parseAttachDatabaseInfo(this.iscDatabaseInfo(db, describe_database_info, 1024), db);
            }
            catch (IOException ex) {
                throw new GDSException(335544727);
            }
        }
    }

    public byte[] iscDatabaseInfo(IscDbHandle handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)handle;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_info_database ");
                }
                db.out.writeInt(40);
                db.out.writeInt(db.getRdb_id());
                db.out.writeInt(0);
                db.out.writeBuffer(items);
                db.out.writeInt(buffer_length);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                return db.getResp_data_truncated();
            }
            catch (IOException ex) {
                throw new GDSException(335544721);
            }
        }
    }

    public byte[] iscBlobInfo(IscBlobHandle handle, byte[] items, int buffer_length) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_blob_handle_impl blob = (isc_blob_handle_impl)handle;
        isc_db_handle_impl db = blob.getDb();
        isc_blob_handle_impl isc_blob_handle_impl2 = blob;
        synchronized (isc_blob_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_info_blob ");
                }
                db.out.writeInt(43);
                db.out.writeInt(blob.getRbl_id());
                db.out.writeInt(0);
                db.out.writeBuffer(items);
                db.out.writeInt(buffer_length);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                return db.getResp_data_truncated();
            }
            catch (IOException ex) {
                throw new GDSException(335544721);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscSeekBlob(IscBlobHandle handle, int position, int seekMode) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_blob_handle_impl blob = (isc_blob_handle_impl)handle;
        isc_db_handle_impl db = blob.getDb();
        isc_blob_handle_impl isc_blob_handle_impl2 = blob;
        synchronized (isc_blob_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_info_blob ");
                }
                db.out.writeInt(61);
                db.out.writeInt(blob.getRbl_id());
                db.out.writeInt(seekMode);
                db.out.writeInt(position);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                blob.setPosition(db.getResp_object());
            }
            catch (IOException ex) {
                throw new GDSException(335544721);
            }
        }
    }

    private void parseAttachDatabaseInfo(byte[] info, IscDbHandle handle) throws GDSException {
        boolean debug;
        boolean bl = debug = log != null && log.isDebugEnabled();
        if (debug) {
            log.debug("parseDatabaseInfo: first 2 bytes are " + this.iscVaxInteger(info, 0, 2) + " or: " + info[0] + ", " + info[1]);
        }
        int value = 0;
        int len = 0;
        int i = 0;
        isc_db_handle_impl db = (isc_db_handle_impl)handle;
        block10: while (info[i] != 1) {
            switch (info[i++]) {
                case 62: {
                    len = this.iscVaxInteger(info, i, 2);
                    value = this.iscVaxInteger(info, i += 2, len);
                    i += len;
                    db.setDialect(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_db_sql_dialect:" + value);
                    continue block10;
                }
                case 32: {
                    len = this.iscVaxInteger(info, i, 2);
                    value = this.iscVaxInteger(info, i += 2, len);
                    i += len;
                    db.setODSMajorVersion(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_ods_version:" + value);
                    continue block10;
                }
                case 33: {
                    len = this.iscVaxInteger(info, i, 2);
                    value = this.iscVaxInteger(info, i += 2, len);
                    i += len;
                    db.setODSMinorVersion(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_ods_minor_version:" + value);
                    continue block10;
                }
                case 103: {
                    len = this.iscVaxInteger(info, i, 2);
                    byte[] fb_vers = new byte[len - 2];
                    System.arraycopy(info, (i += 2) + 2, fb_vers, 0, len - 2);
                    i += len;
                    String fb_versS = new String(fb_vers);
                    db.setVersion(fb_versS);
                    if (!debug) continue block10;
                    log.debug("isc_info_firebird_version:" + fb_versS);
                    continue block10;
                }
                case 11: {
                    len = this.iscVaxInteger(info, i, 2);
                    byte[] impl = new byte[len - 2];
                    System.arraycopy(info, (i += 2) + 2, impl, 0, len - 2);
                    i += len;
                    continue block10;
                }
                case 102: {
                    len = this.iscVaxInteger(info, i, 2);
                    byte[] db_class = new byte[len - 2];
                    System.arraycopy(info, (i += 2) + 2, db_class, 0, len - 2);
                    i += len;
                    continue block10;
                }
                case 13: {
                    len = this.iscVaxInteger(info, i, 2);
                    byte[] base_level = new byte[len - 2];
                    System.arraycopy(info, (i += 2) + 2, base_level, 0, len - 2);
                    i += len;
                    continue block10;
                }
                case 2: {
                    if (debug) {
                        log.debug("isc_info_truncated ");
                    }
                    return;
                }
            }
            throw new GDSException(335544583);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDetachDatabase(IscDbHandle db_handle) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (db.eventCoordinator != null) {
                    db.eventCoordinator.close();
                }
                if (debug) {
                    log.debug("op_detach ");
                }
                db.out.writeInt(21);
                db.out.writeInt(db.getRdb_id());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544721);
            }
            finally {
                try {
                    this.disconnect(db);
                }
                catch (IOException ex2) {
                    throw new GDSException(335544721);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDropDatabase(IscDbHandle db_handle) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_drop_database ");
                }
                db.out.writeInt(81);
                db.out.writeInt(db.getRdb_id());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544721);
            }
        }
    }

    public byte[] iscExpandDpb(byte[] dpb, int dpb_length, int param, Object[] params) throws GDSException {
        return dpb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscStartTransaction(IscTrHandle tr_handle, IscDbHandle db_handle, TransactionParameterBuffer tpb) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        TransactionParameterBufferImpl tpbImpl = (TransactionParameterBufferImpl)tpb;
        if (tr_handle == null) {
            throw new GDSException(335544332);
        }
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 0) {
                throw new GDSException(335544468);
            }
            tr.setState(1);
            try {
                if (debug) {
                    log.debug("op_transaction ");
                }
                db.out.writeInt(29);
                db.out.writeInt(db.getRdb_id());
                db.out.writeTyped(3, tpbImpl);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544721);
            }
            tr.setTransactionId(db.getResp_object());
            tr.setDbHandle(db);
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscReconnectTransaction(IscTrHandle tr_handle, IscDbHandle db_handle, long transactionId) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (tr_handle == null) {
            throw new GDSException(335544332);
        }
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 0) {
                throw new GDSException(335544468);
            }
            tr.setState(1);
            try {
                if (debug) {
                    log.debug("op_reconnect ");
                }
                db.out.writeInt(33);
                db.out.writeInt(db.getRdb_id());
                byte[] buf = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    buf[i] = (byte)(transactionId >>> i * 8);
                }
                db.out.writeBuffer(buf);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544721);
            }
            tr.setTransactionId(db.getResp_object());
            tr.setDbHandle(db);
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCommitTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug;
        boolean bl = debug = log != null && log.isDebugEnabled();
        if (tr_handle == null) {
            throw new GDSException(335544332);
        }
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            try {
                if (debug) {
                    log.debug("op_commit ");
                    log.debug("tr.rtr_id: " + tr.getTransactionId());
                }
                db.out.writeInt(30);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
            tr.setState(0);
            tr.unsetDbHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCommitRetaining(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            try {
                if (debug) {
                    log.debug("op_commit_retaining ");
                }
                db.out.writeInt(50);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscPrepareTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            try {
                if (debug) {
                    log.debug("op_prepare ");
                }
                db.out.writeInt(32);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
            tr.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscPrepareTransaction2(IscTrHandle tr_handle, byte[] bytes) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            try {
                if (debug) {
                    log.debug("op_prepare2 ");
                }
                db.out.writeInt(51);
                db.out.writeInt(tr.getTransactionId());
                db.out.writeBuffer(bytes);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
            tr.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscRollbackTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() == 0) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            try {
                if (debug) {
                    log.debug("op_rollback ");
                }
                db.out.writeInt(31);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
            finally {
                tr.setState(0);
                tr.unsetDbHandle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscRollbackRetaining(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            try {
                if (debug) {
                    log.debug("op_rollback_retaining ");
                }
                db.out.writeInt(86);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
            tr.setState(2);
        }
    }

    public byte[] iscTransactionInformation(IscTrHandle tr_handle, byte[] requestBuffer, int bufferLen) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_info_transaction ");
                }
                db.out.writeInt(42);
                db.out.writeInt(tr.getTransactionId());
                db.out.writeInt(0);
                db.out.writeBuffer(requestBuffer);
                db.out.writeInt(bufferLen);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                return db.getResp_data();
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlAllocateStatement(IscDbHandle db_handle, IscStmtHandle stmt_handle) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_allocate_statement ");
                }
                db.out.writeInt(62);
                db.out.writeInt(db.getRdb_id());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                stmt.setRsr_id(db.getResp_object());
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
            stmt.setRsr_rdb(db);
            stmt.setAllRowsFetched(false);
        }
    }

    public void isc_dsql_alloc_statement2(IscDbHandle db_handle, IscStmtHandle stmt_handle) throws GDSException {
        throw new GDSException(335544378);
    }

    public XSQLDA iscDsqlDescribe(IscStmtHandle stmt_handle, int da_version) throws GDSException {
        byte[] buffer = this.iscDsqlSqlInfo(stmt_handle, describe_select_info, 1024);
        return this.parseSqlInfo(stmt_handle, buffer, buffer.length, describe_select_info);
    }

    public XSQLDA iscDsqlDescribeBind(IscStmtHandle stmt_handle, int da_version) throws GDSException {
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        byte[] buffer = this.iscDsqlSqlInfo(stmt_handle, describe_bind_info, 1024);
        stmt.setInSqlda(this.parseSqlInfo(stmt_handle, buffer, buffer.length, describe_bind_info));
        return stmt.getInSqlda();
    }

    public void iscDsqlExecute(IscTrHandle tr_handle, IscStmtHandle stmt_handle, int da_version, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecute2(tr_handle, stmt_handle, da_version, xsqlda, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlExecute2(IscTrHandle tr_handle, IscStmtHandle stmt_handle, int da_version, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            XdrOutputStream out = db.out;
            try {
                int op;
                if (debug) {
                    log.debug(out_xsqlda == null ? "op_execute " : "op_execute2 ");
                }
                out.writeInt(out_xsqlda == null ? 63 : 76);
                out.writeInt(stmt.getRsr_id());
                out.writeInt(tr.getTransactionId());
                if (in_xsqlda != null) {
                    out.writeBuffer(in_xsqlda.blr);
                    out.writeInt(0);
                    out.writeInt(1);
                    out.writeSQLData(in_xsqlda);
                } else {
                    out.writeBuffer(null);
                    out.writeInt(0);
                    out.writeInt(0);
                }
                if (out_xsqlda != null) {
                    stmt.clearRows();
                    out.writeBuffer(out_xsqlda.blr);
                    out.writeInt(0);
                }
                out.flush();
                if (stmt.getOutSqlda() != null) {
                    stmt.notifyOpenResultSet();
                }
                if (debug) {
                    log.debug("sent");
                }
                if ((op = this.nextOperation(db)) == 78) {
                    stmt.ensureCapacity(1);
                    this.receiveSqlResponse(db, out_xsqlda, stmt);
                    op = this.nextOperation(db);
                    stmt.setAllRowsFetched(true);
                    stmt.setSingletonResult(true);
                } else {
                    stmt.setSingletonResult(false);
                    stmt.setAllRowsFetched(false);
                }
                this.receiveResponse(db, op);
                stmt.registerTransaction(tr);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
        }
    }

    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, dialect, xsqlda, null);
    }

    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, String encoding, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, encoding, dialect, xsqlda, null);
    }

    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, byte[] statement, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, dialect, xsqlda, null);
    }

    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, "NONE", dialect, in_xsqlda, out_xsqlda);
    }

    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, String encoding, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        try {
            this.iscDsqlExecImmed2(db_handle, tr_handle, this.getByteArrayForString(statement, encoding), dialect, in_xsqlda, out_xsqlda);
        }
        catch (UnsupportedEncodingException e) {
            throw new GDSException("Unsupported encoding: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, byte[] statement, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)db_handle;
        synchronized (isc_db_handle_impl2) {
            XdrOutputStream out = db.out;
            try {
                int op;
                if (in_xsqlda == null && out_xsqlda == null) {
                    if (debug) {
                        log.debug("op_exec_immediate ");
                    }
                    out.writeInt(64);
                } else {
                    if (debug) {
                        log.debug("op_exec_immediate2 ");
                    }
                    out.writeInt(75);
                    if (in_xsqlda != null) {
                        out.writeBuffer(in_xsqlda.blr);
                        out.writeInt(0);
                        out.writeInt(1);
                        out.writeSQLData(in_xsqlda);
                    } else {
                        out.writeBuffer(null);
                        out.writeInt(0);
                        out.writeInt(0);
                    }
                    if (out_xsqlda != null) {
                        out.writeBuffer(out_xsqlda.blr);
                    } else {
                        out.writeBuffer(null);
                    }
                    out.writeInt(0);
                }
                out.writeInt(tr.getTransactionId());
                out.writeInt(0);
                out.writeInt(dialect);
                out.writeBuffer(statement);
                out.writeString("");
                out.writeInt(0);
                out.flush();
                if (debug) {
                    log.debug("sent");
                }
                if ((op = this.nextOperation(db)) == 78) {
                    this.receiveSqlResponse(db, out_xsqlda, null);
                    op = this.nextOperation(db);
                }
                this.receiveResponse(db, op);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlFetch(IscStmtHandle stmt_handle, int da_version, XSQLDA xsqlda, int fetchSize) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl db = stmt.getRsr_rdb();
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        if (xsqlda == null) {
            throw new GDSException(335544583);
        }
        if (fetchSize <= 0) {
            throw new GDSException(335544583);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            XdrOutputStream out = db.out;
            WireXdrInputStream in = db.in;
            try {
                stmt.ensureCapacity(fetchSize);
                if (debug) {
                    log.debug("op_fetch ");
                }
                out.writeInt(65);
                out.writeInt(stmt.getRsr_id());
                out.writeBuffer(xsqlda.blr);
                out.writeInt(0);
                out.writeInt(fetchSize);
                out.flush();
                if (debug) {
                    log.debug("sent");
                }
                int op = this.nextOperation(db);
                stmt.notifyOpenResultSet();
                if (op == 66) {
                    int sqldata_status;
                    int sqldata_messages;
                    do {
                        sqldata_status = in.readInt();
                        sqldata_messages = in.readInt();
                        if (sqldata_messages <= 0 || sqldata_status != 0) continue;
                        in.readSQLData(xsqlda.ioLength, stmt);
                        op = this.nextOperation(db);
                        if (op != 9) continue;
                        this.receiveResponse(db, op);
                    } while (sqldata_messages > 0 && sqldata_status == 0);
                    if (sqldata_status == 100) {
                        if (debug) {
                            log.debug("all rows successfully fetched");
                        }
                        stmt.setAllRowsFetched(true);
                    }
                } else {
                    this.receiveResponse(db, op);
                }
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
        }
    }

    public static void calculateIOLength(XSQLDA xsqlda) {
        xsqlda.ioLength = new int[xsqlda.sqld];
        block6: for (int i = 0; i < xsqlda.sqld; ++i) {
            switch (xsqlda.sqlvar[i].sqltype & 0xFFFFFFFE) {
                case 452: {
                    xsqlda.ioLength[i] = xsqlda.sqlvar[i].sqllen + 1;
                    continue block6;
                }
                case 448: {
                    xsqlda.ioLength[i] = 0;
                    continue block6;
                }
                case 482: 
                case 496: 
                case 500: 
                case 560: 
                case 570: {
                    xsqlda.ioLength[i] = -4;
                    continue block6;
                }
                case 480: 
                case 510: 
                case 520: 
                case 540: 
                case 550: 
                case 580: {
                    xsqlda.ioLength[i] = -8;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlFreeStatement(IscStmtHandle stmt_handle, int option) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl db = stmt.getRsr_rdb();
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        if (stmt.isSingletonResult() && option == 1) {
            return;
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (!db.isValid()) {
                    return;
                }
                if (debug) {
                    log.debug("op_free_statement ");
                }
                db.out.writeInt(67);
                db.out.writeInt(stmt.getRsr_id());
                db.out.writeInt(option);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                if (option == 2) {
                    stmt.setInSqlda(null);
                    stmt.setOutSqlda(null);
                    stmt.setRsr_rdb(null);
                }
                stmt.clearRows();
                try {
                    AbstractIscTrHandle tr = stmt.getTransaction();
                    if (tr != null) {
                        tr.unregisterStatementFromTransaction(stmt);
                    }
                }
                finally {
                    stmt.unregisterTransaction();
                }
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
        }
    }

    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, String statement, int dialect) throws GDSException {
        return this.iscDsqlPrepare(tr_handle, stmt_handle, statement, "NONE", dialect);
    }

    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, String statement, String encoding, int dialect) throws GDSException {
        try {
            return this.iscDsqlPrepare(tr_handle, stmt_handle, this.getByteArrayForString(statement, encoding), dialect);
        }
        catch (UnsupportedEncodingException ex) {
            throw new GDSException("Unsupported encoding: " + ex.getMessage());
        }
    }

    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, byte[] statement, int dialect) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl db = stmt.getRsr_rdb();
        if (tr_handle == null) {
            throw new GDSException(335544332);
        }
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        stmt.setInSqlda(null);
        stmt.setOutSqlda(null);
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_prepare_statement ");
                }
                db.out.writeInt(68);
                db.out.writeInt(tr.getTransactionId());
                db.out.writeInt(stmt.getRsr_id());
                db.out.writeInt(dialect);
                db.out.writeBuffer(statement);
                db.out.writeBuffer(sql_prepare_info);
                db.out.writeInt(1024);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                stmt.setOutSqlda(this.parseSqlInfo(stmt_handle, db.getResp_data(), db.getResp_data_len(), sql_prepare_info));
                return stmt.getOutSqlda();
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlSetCursorName(IscStmtHandle stmt_handle, String cursor_name, int type) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl db = stmt.getRsr_rdb();
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_set_cursor ");
                }
                db.out.writeInt(69);
                db.out.writeInt(stmt.getRsr_id());
                byte[] buffer = new byte[cursor_name.length() + 1];
                System.arraycopy(cursor_name.getBytes(), 0, buffer, 0, cursor_name.length());
                buffer[cursor_name.length()] = 0;
                db.out.writeBuffer(buffer);
                db.out.writeInt(0);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
        }
    }

    public byte[] iscDsqlSqlInfo(IscStmtHandle stmt_handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_info_sql ");
                }
                db.out.writeInt(70);
                db.out.writeInt(stmt.getRsr_id());
                db.out.writeInt(0);
                db.out.writeBuffer(items);
                db.out.writeInt(buffer_length);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                return db.getResp_data_truncated();
            }
            catch (IOException ex) {
                throw new GDSException(335544726);
            }
        }
    }

    public void getSqlCounts(IscStmtHandle stmt_handle) throws GDSException {
        byte type;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        byte[] buffer = this.iscDsqlSqlInfo(stmt, stmtInfo, INFO_SIZE);
        int pos = 0;
        block10: while ((type = buffer[pos++]) != 1) {
            int length = this.iscVaxInteger(buffer, pos, 2);
            pos += 2;
            switch (type) {
                case 23: {
                    byte t;
                    while ((t = buffer[pos++]) != 1) {
                        int l = this.iscVaxInteger(buffer, pos, 2);
                        pos += 2;
                        switch (t) {
                            case 14: {
                                stmt.setInsertCount(this.iscVaxInteger(buffer, pos, l));
                                break;
                            }
                            case 15: {
                                stmt.setUpdateCount(this.iscVaxInteger(buffer, pos, l));
                                break;
                            }
                            case 16: {
                                stmt.setDeleteCount(this.iscVaxInteger(buffer, pos, l));
                                break;
                            }
                            case 13: {
                                stmt.setSelectCount(this.iscVaxInteger(buffer, pos, l));
                                break;
                            }
                        }
                        pos += l;
                    }
                    continue block10;
                }
                case 21: {
                    stmt.setStatementType(this.iscVaxInteger(buffer, pos, length));
                    pos += length;
                    continue block10;
                }
            }
            pos += length;
        }
    }

    public int iscVaxInteger(byte[] buffer, int pos, int length) {
        int shift = 0;
        int value = 0;
        int i = pos;
        while (--length >= 0) {
            value += (buffer[i++] & 0xFF) << shift;
            shift += 8;
        }
        return value;
    }

    public void iscCreateBlob2(IscDbHandle db_handle, IscTrHandle tr_handle, IscBlobHandle blob_handle, BlobParameterBuffer blobParameterBuffer) throws GDSException {
        this.openOrCreateBlob(db_handle, tr_handle, blob_handle, blobParameterBuffer, blobParameterBuffer == null ? 34 : 57);
        ((isc_blob_handle_impl)blob_handle).rbl_flagsAdd(8);
    }

    public void iscOpenBlob2(IscDbHandle db_handle, IscTrHandle tr_handle, IscBlobHandle blob_handle, BlobParameterBuffer blobParameterBuffer) throws GDSException {
        this.openOrCreateBlob(db_handle, tr_handle, blob_handle, blobParameterBuffer, blobParameterBuffer == null ? 35 : 56);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openOrCreateBlob(IscDbHandle db_handle, IscTrHandle tr_handle, IscBlobHandle blob_handle, BlobParameterBuffer blobParameterBuffer, int op) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        if (tr == null) {
            throw new GDSException(335544332);
        }
        if (blob == null) {
            throw new GDSException(335544328);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug(blobParameterBuffer == null ? "op_open/create_blob " : "op_open/create_blob2 ");
                    log.debug("op: " + op);
                }
                db.out.writeInt(op);
                if (blobParameterBuffer != null) {
                    db.out.writeTyped(1, (Xdrable)((Object)blobParameterBuffer));
                }
                db.out.writeInt(tr.getTransactionId());
                if (debug) {
                    log.debug("sending blob_id: " + blob.getBlobId());
                }
                db.out.writeLong(blob.getBlobId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                blob.setDb(db);
                blob.setTr(tr);
                blob.setRbl_id(db.getResp_object());
                blob.setBlobId(db.getResp_blob_id());
                tr.addBlob(blob);
            }
            catch (IOException ioe) {
                throw new GDSException(335544726);
            }
        }
    }

    public byte[] iscGetSegment(IscBlobHandle blob_handle, int requested) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        isc_db_handle_impl db = blob.getDb();
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_tr_handle_impl tr = blob.getTr();
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_get_segment ");
                }
                db.out.writeInt(36);
                db.out.writeInt(blob.getRbl_id());
                if (debug) {
                    log.debug("trying to read bytes: " + (requested + 2 < Short.MAX_VALUE ? requested + 2 : Short.MAX_VALUE));
                }
                db.out.writeInt(requested + 2 < Short.MAX_VALUE ? requested + 2 : Short.MAX_VALUE);
                db.out.writeInt(0);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                blob.rbl_flagsRemove(2);
                if (db.getResp_object() == 1) {
                    blob.rbl_flagsAdd(2);
                } else if (db.getResp_object() == 2) {
                    blob.rbl_flagsAdd(4);
                }
                if (db.getResp_data_len() == 0) {
                    return new byte[0];
                }
                byte[] buffer = db.getResp_data();
                int bufferLength = db.getResp_data_len();
                int len = 0;
                int srcpos = 0;
                int destpos = 0;
                while (srcpos < bufferLength) {
                    len = this.iscVaxInteger(buffer, srcpos, 2);
                    System.arraycopy(buffer, srcpos += 2, buffer, destpos, len);
                    srcpos += len;
                    destpos += len;
                }
                byte[] result = new byte[destpos];
                System.arraycopy(buffer, 0, result, 0, destpos);
                return result;
            }
            catch (IOException ioe) {
                throw new GDSException(335544726);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscPutSegment(IscBlobHandle blob_handle, byte[] buffer) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        isc_db_handle_impl db = blob.getDb();
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_tr_handle_impl tr = blob.getTr();
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_batch_segments ");
                }
                db.out.writeInt(44);
                if (debug) {
                    log.debug("blob.rbl_id:  " + blob.getRbl_id());
                }
                db.out.writeInt(blob.getRbl_id());
                if (debug) {
                    log.debug("buffer.length " + buffer.length);
                }
                db.out.writeBlobBuffer(buffer);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException ioe) {
                throw new GDSException(335544726);
            }
        }
    }

    public void iscCloseBlob(IscBlobHandle blob_handle) throws GDSException {
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        isc_db_handle_impl db = blob.getDb();
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_tr_handle_impl tr = blob.getTr();
        if (tr == null) {
            throw new GDSException(335544332);
        }
        this.releaseObject(db, 39, blob.getRbl_id());
        tr.removeBlob(blob);
    }

    private byte[] getByteArrayForString(String statement, String encoding) throws UnsupportedEncodingException {
        String javaEncoding = null;
        if (encoding != null && !"NONE".equals(encoding)) {
            javaEncoding = EncodingFactory.getJavaEncoding(encoding);
        }
        byte[] stringBytes = javaEncoding != null ? statement.getBytes(javaEncoding) : statement.getBytes();
        return stringBytes;
    }

    public IscDbHandle createIscDbHandle() {
        return new isc_db_handle_impl();
    }

    public IscTrHandle createIscTrHandle() {
        return new isc_tr_handle_impl();
    }

    public IscStmtHandle createIscStmtHandle() {
        return new isc_stmt_handle_impl();
    }

    public IscBlobHandle createIscBlobHandle() {
        return new isc_blob_handle_impl();
    }

    public void connect(isc_db_handle_impl db, String host, Integer port, String filename, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        DbAttachInfo dbai = new DbAttachInfo(host, port, filename);
        this.connect(db, dbai, databaseParameterBuffer);
    }

    protected void connect(isc_db_handle_impl db, DbAttachInfo dbai, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        block11: {
            boolean debug = log != null && log.isDebugEnabled();
            int socketBufferSize = -1;
            if (databaseParameterBuffer.hasArgument(129)) {
                socketBufferSize = databaseParameterBuffer.getArgumentAsInt(129);
            }
            try {
                this.openSocket(db, dbai, debug, socketBufferSize);
                String user = System.getProperty("user.name");
                if (debug) {
                    log.debug("user.name: " + user);
                }
                String host = InetAddress.getLocalHost().getHostName();
                byte[] user_id = new byte[6 + user.length() + host.length()];
                int n = 0;
                user_id[n++] = 1;
                user_id[n++] = (byte)user.length();
                System.arraycopy(user.getBytes(), 0, user_id, n, user.length());
                n += user.length();
                user_id[n++] = 4;
                user_id[n++] = (byte)host.length();
                System.arraycopy(host.getBytes(), 0, user_id, n, host.length());
                n += host.length();
                user_id[n++] = 6;
                user_id[n++] = 0;
                if (debug) {
                    log.debug("op_connect ");
                }
                db.out.writeInt(1);
                db.out.writeInt(19);
                db.out.writeInt(2);
                db.out.writeInt(1);
                db.out.writeString(dbai.getFileName());
                db.out.writeInt(1);
                db.out.writeBuffer(user_id);
                db.out.writeInt(10);
                db.out.writeInt(1);
                db.out.writeInt(2);
                db.out.writeInt(3);
                db.out.writeInt(2);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                if (debug) {
                    log.debug("op_accept ");
                }
                if (this.nextOperation(db) == 3) {
                    db.setProtocol(db.in.readInt());
                    int arch = db.in.readInt();
                    int min = db.in.readInt();
                    if (debug) {
                        log.debug("received");
                    }
                    break block11;
                }
                this.disconnect(db);
                if (debug) {
                    log.debug("not received");
                }
                throw new GDSException(335544421);
            }
            catch (IOException ex) {
                if (debug) {
                    log.debug("IOException while trying to connect to db:", ex);
                }
                throw new GDSException(1, 335544721, dbai.getServer());
            }
        }
    }

    public abstract Socket getSocket(String var1, int var2) throws IOException, UnknownHostException;

    protected void openSocket(isc_db_handle_impl db, DbAttachInfo dbai, boolean debug, int socketBufferSize) throws IOException, SocketException, GDSException {
        try {
            db.socket = this.getSocket(dbai.getServer(), dbai.getPort());
            db.socket.setTcpNoDelay(true);
            if (socketBufferSize != -1) {
                db.socket.setReceiveBufferSize(socketBufferSize);
                db.socket.setSendBufferSize(socketBufferSize);
            }
            if (debug) {
                log.debug("Got socket");
            }
        }
        catch (UnknownHostException ex2) {
            String message = "Cannot resolve host " + dbai.getServer();
            if (debug) {
                log.error(message, ex2);
            }
            throw new GDSException(1, 335544721, dbai.getServer());
        }
        db.out = new XdrOutputStream(db.socket.getOutputStream());
        db.in = new WireXdrInputStream(db.socket.getInputStream());
    }

    public void disconnect(isc_db_handle_impl db) throws IOException {
        if (log != null) {
            log.debug("About to invalidate db handle");
        }
        db.invalidate();
        if (log != null) {
            log.debug("successfully invalidated db handle");
        }
    }

    private void receiveSqlResponse(isc_db_handle_impl db, XSQLDA xsqlda, isc_stmt_handle_impl stmt) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        try {
            if (debug) {
                log.debug("op_sql_response ");
            }
            int messages = db.in.readInt();
            if (debug) {
                log.debug("received");
            }
            if (messages > 0) {
                db.in.readSQLData(xsqlda.ioLength, stmt);
            }
        }
        catch (IOException ex) {
            if (debug) {
                log.warn("IOException in receiveSQLResponse", ex);
            }
            throw new GDSException(1, 335544726, ex.getMessage());
        }
    }

    public void receiveResponse(isc_db_handle_impl db, int op) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        try {
            if (op == -1) {
                op = this.nextOperation(db);
            }
            if (debug) {
                log.debug("op_response ");
            }
            if (op == 9) {
                db.setResp_object(db.in.readInt());
                db.setResp_blob_id(db.in.readLong());
                db.in.readBuffer(db);
                this.readStatusVector(db);
                if (debug) {
                    log.debug("received");
                }
            } else if (debug) {
                log.debug("not received: op is " + op);
            }
        }
        catch (IOException ex) {
            if (debug) {
                log.warn("IOException in receiveResponse", ex);
            }
            throw new GDSException(1, 335544726, ex.getMessage());
        }
    }

    protected int nextOperation(isc_db_handle_impl db) throws IOException {
        boolean debug = log != null && log.isDebugEnabled();
        int op = 0;
        do {
            op = db.in.readInt();
            if (!debug || op != 71) continue;
            log.debug("op_dummy received");
        } while (op == 71);
        return op;
    }

    private void readStatusVector(isc_db_handle_impl db) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        try {
            GDSException head = null;
            GDSException tail = null;
            block8: while (true) {
                int arg = db.in.readInt();
                switch (arg) {
                    case 1: {
                        int er = db.in.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_gds int: " + er);
                        }
                        if (er == 0) continue block8;
                        GDSException td = new GDSException(arg, er);
                        if (head == null) {
                            head = td;
                            tail = td;
                            break;
                        }
                        tail.setNext(td);
                        tail = td;
                        break;
                    }
                    case 0: {
                        if (head != null && !head.isWarning()) {
                            throw head;
                        }
                        if (head != null && head.isWarning()) {
                            db.addWarning(head);
                        }
                        return;
                    }
                    case 2: 
                    case 5: {
                        GDSException ts = new GDSException(arg, db.in.readString());
                        if (debug) {
                            log.debug("readStatusVector string: " + ts.getMessage());
                        }
                        if (head == null) {
                            head = ts;
                            tail = ts;
                            break;
                        }
                        tail.setNext(ts);
                        tail = ts;
                        break;
                    }
                    case 4: {
                        int arg_value = db.in.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_number int: " + arg_value);
                        }
                        GDSException td = new GDSException(arg, arg_value);
                        if (head == null) {
                            head = td;
                            tail = td;
                            break;
                        }
                        tail.setNext(td);
                        tail = td;
                        break;
                    }
                    default: {
                        int e = db.in.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg: " + arg + " int: " + e);
                        }
                        if (e == 0) continue block8;
                        GDSException td = new GDSException(arg, e);
                        if (head == null) {
                            head = td;
                            tail = td;
                            break;
                        }
                        tail.setNext(td);
                        tail = td;
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new GDSException(1, 335544726, ioe.getMessage());
        }
    }

    public static void calculateBLR(XSQLDA xsqlda) throws GDSException {
        int blr_len = 0;
        if (xsqlda != null) {
            blr_len = 8;
            int par_count = 0;
            for (int i = 0; i < xsqlda.sqld; ++i) {
                int dtype = xsqlda.sqlvar[i].sqltype & 0xFFFFFFFE;
                blr_len = dtype == 448 || dtype == 452 ? (blr_len += 3) : (dtype == 500 || dtype == 496 || dtype == 580 || dtype == 550 || dtype == 520 || dtype == 540 ? (blr_len += 2) : ++blr_len);
                blr_len += 2;
                par_count += 2;
            }
            byte[] blr = new byte[blr_len];
            int n = 0;
            blr[n++] = 5;
            blr[n++] = 2;
            blr[n++] = 4;
            blr[n++] = 0;
            blr[n++] = (byte)(par_count & 0xFF);
            blr[n++] = (byte)(par_count >> 8);
            for (int i = 0; i < xsqlda.sqld; ++i) {
                int dtype = xsqlda.sqlvar[i].sqltype & 0xFFFFFFFE;
                int len = xsqlda.sqlvar[i].sqllen;
                if (dtype == 448) {
                    blr[n++] = 37;
                    blr[n++] = (byte)(len & 0xFF);
                    blr[n++] = (byte)(len >> 8);
                } else if (dtype == 452) {
                    blr[n++] = 14;
                    blr[n++] = (byte)(len & 0xFF);
                    blr[n++] = (byte)(len >> 8);
                } else if (dtype == 480) {
                    blr[n++] = 27;
                } else if (dtype == 482) {
                    blr[n++] = 10;
                } else if (dtype == 530) {
                    blr[n++] = 11;
                } else if (dtype == 570) {
                    blr[n++] = 12;
                } else if (dtype == 560) {
                    blr[n++] = 13;
                } else if (dtype == 510) {
                    blr[n++] = 35;
                } else if (dtype == 520) {
                    blr[n++] = 9;
                    blr[n++] = 0;
                } else if (dtype == 540) {
                    blr[n++] = 9;
                    blr[n++] = 0;
                } else if (dtype == 496) {
                    blr[n++] = 8;
                    blr[n++] = (byte)xsqlda.sqlvar[i].sqlscale;
                } else if (dtype == 500) {
                    blr[n++] = 7;
                    blr[n++] = (byte)xsqlda.sqlvar[i].sqlscale;
                } else if (dtype == 580) {
                    blr[n++] = 16;
                    blr[n++] = (byte)xsqlda.sqlvar[i].sqlscale;
                } else if (dtype == 550) {
                    blr[n++] = 9;
                    blr[n++] = (byte)xsqlda.sqlvar[i].sqlscale;
                }
                blr[n++] = 7;
                blr[n++] = 0;
            }
            blr[n++] = -1;
            blr[n++] = 76;
            xsqlda.blr = blr;
        }
    }

    private XSQLDA parseSqlInfo(IscStmtHandle stmt_handle, byte[] info, int infoLength, byte[] items) throws GDSException {
        int i;
        boolean debug;
        boolean bl = debug = log != null && log.isDebugEnabled();
        if (debug) {
            log.debug("parseSqlInfo started");
        }
        if (info[i = 0] == 21) {
            int dataLength = this.iscVaxInteger(info, ++i, 2);
            int statementType = this.iscVaxInteger(info, i += 2, dataLength);
            ((isc_stmt_handle_impl)stmt_handle).setStatementType(statementType);
            i += dataLength;
        }
        XSQLDA xsqlda = new XSQLDA();
        int lastindex = 0;
        int index = 0;
        while ((index = this.parseTruncSqlInfo(i + 2, info, infoLength, xsqlda, lastindex)) > 0) {
            byte[] new_items = new byte[4 + items.length - 1];
            new_items[0] = 20;
            new_items[1] = 2;
            new_items[2] = (byte)(index & 0xFF);
            new_items[3] = (byte)(index >> 8);
            System.arraycopy(items, 1, new_items, 4, items.length - 1);
            int size = infoLength;
            if (index == lastindex) {
                size = infoLength * 2;
            }
            info = this.iscDsqlSqlInfo(stmt_handle, new_items, size);
            lastindex = index;
            i = 0;
        }
        if (debug) {
            log.debug("parseSqlInfo ended");
        }
        AbstractJavaGDSImpl.calculateBLR(xsqlda);
        AbstractJavaGDSImpl.calculateIOLength(xsqlda);
        return xsqlda;
    }

    private int parseTruncSqlInfo(int startAt, byte[] info, int infoLength, XSQLDA xsqlda, int lastindex) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        int index = 0;
        if (debug) {
            log.debug("parseSqlInfo: first 2 bytes are " + this.iscVaxInteger(info, 0, 2) + " or: " + info[0] + ", " + info[1]);
        }
        int i = startAt;
        int len = this.iscVaxInteger(info, i, 2);
        int n = this.iscVaxInteger(info, i += 2, len);
        i += len;
        if (xsqlda.sqlvar == null) {
            xsqlda.sqld = xsqlda.sqln = n;
            xsqlda.sqlvar = new XSQLVAR[xsqlda.sqln];
        }
        if (debug) {
            log.debug("xsqlda.sqln read as " + xsqlda.sqln);
        }
        while (info[i] != 1) {
            byte item;
            block13: while ((item = info[i++]) != 8) {
                switch (item) {
                    case 9: {
                        len = this.iscVaxInteger(info, i, 2);
                        index = this.iscVaxInteger(info, i += 2, len);
                        i += len;
                        xsqlda.sqlvar[index - 1] = new XSQLVAR();
                        if (!debug) continue block13;
                        log.debug("new xsqlvar " + (index - 1));
                        continue block13;
                    }
                    case 11: {
                        len = this.iscVaxInteger(info, i, 2);
                        xsqlda.sqlvar[index - 1].sqltype = this.iscVaxInteger(info, i += 2, len);
                        i += len;
                        if (!debug) continue block13;
                        log.debug("isc_info_sql_type " + xsqlda.sqlvar[index - 1].sqltype);
                        continue block13;
                    }
                    case 12: {
                        len = this.iscVaxInteger(info, i, 2);
                        xsqlda.sqlvar[index - 1].sqlsubtype = this.iscVaxInteger(info, i += 2, len);
                        i += len;
                        if (!debug) continue block13;
                        log.debug("isc_info_sql_sub_type " + xsqlda.sqlvar[index - 1].sqlsubtype);
                        continue block13;
                    }
                    case 13: {
                        len = this.iscVaxInteger(info, i, 2);
                        xsqlda.sqlvar[index - 1].sqlscale = this.iscVaxInteger(info, i += 2, len);
                        i += len;
                        if (!debug) continue block13;
                        log.debug("isc_info_sql_scale " + xsqlda.sqlvar[index - 1].sqlscale);
                        continue block13;
                    }
                    case 14: {
                        len = this.iscVaxInteger(info, i, 2);
                        xsqlda.sqlvar[index - 1].sqllen = this.iscVaxInteger(info, i += 2, len);
                        i += len;
                        if (!debug) continue block13;
                        log.debug("isc_info_sql_length " + xsqlda.sqlvar[index - 1].sqllen);
                        continue block13;
                    }
                    case 16: {
                        len = this.iscVaxInteger(info, i, 2);
                        xsqlda.sqlvar[index - 1].sqlname = new String(info, i += 2, len);
                        i += len;
                        if (!debug) continue block13;
                        log.debug("isc_info_sql_field " + xsqlda.sqlvar[index - 1].sqlname);
                        continue block13;
                    }
                    case 17: {
                        len = this.iscVaxInteger(info, i, 2);
                        xsqlda.sqlvar[index - 1].relname = new String(info, i += 2, len);
                        i += len;
                        if (!debug) continue block13;
                        log.debug("isc_info_sql_relation " + xsqlda.sqlvar[index - 1].relname);
                        continue block13;
                    }
                    case 18: {
                        len = this.iscVaxInteger(info, i, 2);
                        xsqlda.sqlvar[index - 1].ownname = new String(info, i += 2, len);
                        i += len;
                        if (!debug) continue block13;
                        log.debug("isc_info_sql_owner " + xsqlda.sqlvar[index - 1].ownname);
                        continue block13;
                    }
                    case 19: {
                        len = this.iscVaxInteger(info, i, 2);
                        xsqlda.sqlvar[index - 1].aliasname = new String(info, i += 2, len);
                        i += len;
                        if (!debug) continue block13;
                        log.debug("isc_info_sql_alias " + xsqlda.sqlvar[index - 1].aliasname);
                        continue block13;
                    }
                    case 2: {
                        if (debug) {
                            log.debug("isc_info_truncated ");
                        }
                        return index;
                    }
                }
                throw new GDSException(335544583);
            }
            ++lastindex;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseObject(isc_db_handle_impl db, int op, int id) throws GDSException {
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                db.out.writeInt(op);
                db.out.writeInt(id);
                db.out.flush();
                this.receiveResponse(db, -1);
            }
            catch (IOException ioe) {
                throw new GDSException(335544726);
            }
        }
    }

    public DatabaseParameterBuffer createDatabaseParameterBuffer() {
        return new DatabaseParameterBufferImp();
    }

    public TransactionParameterBuffer newTransactionParameterBuffer() {
        return new TransactionParameterBufferImpl();
    }

    public BlobParameterBuffer createBlobParameterBuffer() {
        return new BlobParameterBufferImp();
    }

    public ServiceParameterBuffer createServiceParameterBuffer() {
        return new ServiceParameterBufferImp();
    }

    public ServiceRequestBuffer createServiceRequestBuffer(int taskIdentifier) {
        return new ServiceRequestBufferImp(taskIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscServiceAttach(String service, IscSvcHandle serviceHandle, ServiceParameterBuffer serviceParameterBuffer) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_svc_handle_impl svc = (isc_svc_handle_impl)serviceHandle;
        if (svc == null) {
            throw new GDSException(335544559);
        }
        String serviceMgrStr = "service_mgr";
        int mgrIndex = service.indexOf(serviceMgrStr);
        if (mgrIndex == -1 || mgrIndex + serviceMgrStr.length() != service.length()) {
            throw new GDSException(1, 335544563, service);
        }
        if (mgrIndex > 0 && service.charAt(mgrIndex - 1) != ':') {
            throw new GDSException(1, 335544563, service);
        }
        int port = 3050;
        String host = null;
        if (mgrIndex > 0) {
            String server;
            host = server = service.substring(0, mgrIndex - 1);
            int portIndex = server.indexOf(47);
            if (portIndex != -1) {
                try {
                    port = Integer.parseInt(server.substring(portIndex + 1));
                    host = server.substring(0, portIndex);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        isc_svc_handle_impl isc_svc_handle_impl2 = svc;
        synchronized (isc_svc_handle_impl2) {
            try {
                try {
                    svc.socket = new Socket(host, port);
                    svc.socket.setTcpNoDelay(true);
                    if (debug) {
                        log.debug("Got socket");
                    }
                }
                catch (UnknownHostException ex2) {
                    String message = "Cannot resolve host " + host;
                    if (debug) {
                        log.error(message, ex2);
                    }
                    throw new GDSException(1, 335544721, host);
                }
                svc.out = new XdrOutputStream(svc.socket.getOutputStream());
                svc.in = new XdrInputStream(svc.socket.getInputStream());
                if (debug) {
                    log.debug("op_service_attach ");
                }
                svc.out.writeInt(82);
                svc.out.writeInt(0);
                svc.out.writeString(serviceMgrStr);
                svc.out.writeTyped(2, (Xdrable)((Object)serviceParameterBuffer));
                svc.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                try {
                    this.receiveResponse(svc, -1);
                    svc.setHandle(svc.getResp_object());
                }
                catch (GDSException ge) {
                    if (log != null) {
                        log.debug("About to invalidate db handle");
                    }
                    svc.invalidate();
                    if (log != null) {
                        log.debug("successfully invalidated db handle");
                    }
                    throw ge;
                }
            }
            catch (IOException ex) {
                throw new GDSException(335544727);
            }
        }
    }

    public void receiveResponse(isc_svc_handle_impl svc, int op) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        try {
            if (op == -1) {
                op = this.nextOperation(svc);
            }
            if (debug) {
                log.debug("op_response ");
            }
            if (op == 9) {
                svc.setResp_object(svc.in.readInt());
                svc.setResp_blob_id(svc.in.readLong());
                svc.setResp_data(svc.in.readBuffer());
                if (debug) {
                    log.debug("op_response resp_object: " + svc.getResp_object());
                }
                this.readStatusVector(svc);
                if (debug) {
                    log.debug("received");
                }
            } else if (debug) {
                log.debug("not received: op is " + op);
            }
        }
        catch (IOException ex) {
            if (debug) {
                log.warn("IOException in receiveResponse", ex);
            }
            throw new GDSException(1, 335544726, ex.getMessage());
        }
    }

    protected int nextOperation(isc_svc_handle_impl svc) throws IOException {
        boolean debug = log != null && log.isDebugEnabled();
        int op = 0;
        do {
            op = svc.in.readInt();
            if (!debug || op != 71) continue;
            log.debug("op_dummy received");
        } while (op == 71);
        return op;
    }

    private void readStatusVector(isc_svc_handle_impl svc) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        try {
            GDSException head = null;
            GDSException tail = null;
            block8: while (true) {
                int arg = svc.in.readInt();
                switch (arg) {
                    case 1: {
                        int er = svc.in.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_gds int: " + er);
                        }
                        if (er == 0) continue block8;
                        GDSException td = new GDSException(arg, er);
                        if (head == null) {
                            head = td;
                            tail = td;
                            break;
                        }
                        tail.setNext(td);
                        tail = td;
                        break;
                    }
                    case 0: {
                        if (head != null && !head.isWarning()) {
                            throw head;
                        }
                        if (head != null && head.isWarning()) {
                            svc.addWarning(head);
                        }
                        return;
                    }
                    case 2: 
                    case 5: {
                        GDSException ts = new GDSException(arg, svc.in.readString());
                        if (debug) {
                            log.debug("readStatusVector string: " + ts.getMessage());
                        }
                        if (head == null) {
                            head = ts;
                            tail = ts;
                            break;
                        }
                        tail.setNext(ts);
                        tail = ts;
                        break;
                    }
                    case 4: {
                        int arg_value = svc.in.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_number int: " + arg_value);
                        }
                        GDSException td = new GDSException(arg, arg_value);
                        if (head == null) {
                            head = td;
                            tail = td;
                            break;
                        }
                        tail.setNext(td);
                        tail = td;
                        break;
                    }
                    default: {
                        int e = svc.in.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg: " + arg + " int: " + e);
                        }
                        if (e == 0) continue block8;
                        GDSException td = new GDSException(arg, e);
                        if (head == null) {
                            head = td;
                            tail = td;
                            break;
                        }
                        tail.setNext(td);
                        tail = td;
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new GDSException(1, 335544726, ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscServiceDetach(IscSvcHandle serviceHandle) throws GDSException {
        isc_svc_handle_impl svc = (isc_svc_handle_impl)serviceHandle;
        if (svc == null || svc.out == null) {
            throw new GDSException(335544559);
        }
        try {
            try {
                svc.out.writeInt(83);
                svc.out.writeInt(svc.getHandle());
                svc.out.flush();
                this.receiveResponse(svc, -1);
            }
            finally {
                svc.invalidate();
            }
        }
        catch (IOException ex) {
            if (log != null && log.isDebugEnabled()) {
                log.warn("IOException in isc_service_detach", ex);
            }
            throw new GDSException(1, 335544726, ex.getMessage());
        }
    }

    public void iscServiceStart(IscSvcHandle serviceHandle, ServiceRequestBuffer serviceRequestBuffer) throws GDSException {
        isc_svc_handle_impl svc = (isc_svc_handle_impl)serviceHandle;
        ServiceRequestBufferImp svcBuff = (ServiceRequestBufferImp)serviceRequestBuffer;
        if (svc == null || svc.out == null) {
            throw new GDSException(335544559);
        }
        try {
            svc.out.writeInt(85);
            svc.out.writeInt(svc.getHandle());
            svc.out.writeInt(0);
            svc.out.writeBuffer(svcBuff.toByteArray());
            svc.out.flush();
            this.receiveResponse(svc, -1);
        }
        catch (IOException ex) {
            if (log != null && log.isDebugEnabled()) {
                log.warn("IOException in isc_service_start", ex);
            }
            throw new GDSException(1, 335544726, ex.getMessage());
        }
    }

    public void iscServiceQuery(IscSvcHandle serviceHandle, ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, byte[] resultBuffer) throws GDSException {
        isc_svc_handle_impl svc = (isc_svc_handle_impl)serviceHandle;
        ServiceParameterBufferImp spb = (ServiceParameterBufferImp)serviceParameterBuffer;
        ServiceRequestBufferImp srb = (ServiceRequestBufferImp)serviceRequestBuffer;
        if (svc == null || svc.out == null) {
            throw new GDSException(335544559);
        }
        try {
            svc.out.writeInt(84);
            svc.out.writeInt(svc.getHandle());
            svc.out.writeInt(0);
            svc.out.writeBuffer(spb != null ? spb.toByteArray() : null);
            svc.out.writeBuffer(srb != null ? srb.toByteArray() : null);
            svc.out.writeInt(resultBuffer.length);
            svc.out.flush();
            this.receiveResponse(svc, -1);
            int toCopy = Math.min(resultBuffer.length, svc.getResp_data().length);
            System.arraycopy(svc.getResp_data(), 0, resultBuffer, 0, toCopy);
        }
        catch (IOException ex) {
            if (log != null && log.isDebugEnabled()) {
                log.warn("IOException in isc_service_query", ex);
            }
            throw new GDSException(1, 335544726, ex.getMessage());
        }
    }

    public IscSvcHandle createIscSvcHandle() {
        return new isc_svc_handle_impl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int iscQueueEvents(IscDbHandle dbHandle, EventHandle eventHandle, EventHandler eventHandler) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)dbHandle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (db.eventCoordinator == null) {
                    if (debug) {
                        log.debug("op_connect_request ");
                    }
                    db.out.writeInt(53);
                    db.out.writeInt(1);
                    db.out.writeInt(db.getRdb_id());
                    db.out.writeInt(0);
                    db.out.flush();
                    this.nextOperation(db);
                    int auxHandle = db.in.readInt();
                    int port = this.iscVaxInteger(db.in.readRawBuffer(2), 0, 2);
                    db.in.readRawBuffer(2);
                    byte[] ipBytes = db.in.readRawBuffer(4);
                    StringBuffer ipBuf = new StringBuffer();
                    for (int i = 3; i >= 0; --i) {
                        ipBuf.append(ipBytes[i] & 0xFF);
                        if (i <= 0) continue;
                        ipBuf.append(".");
                    }
                    String ipAddress = ipBuf.toString();
                    db.in.readRawBuffer(12);
                    this.readStatusVector(db);
                    db.eventCoordinator = new EventCoordinatorImp(auxHandle, ipAddress, port);
                }
                db.eventCoordinator.queueEvents(db, (EventHandleImp)eventHandle, eventHandler);
            }
            catch (IOException ioe) {
                throw new GDSException(1, 335544726, ioe.getMessage());
            }
        }
        return 0;
    }

    public void iscEventBlock(EventHandle eventHandle) throws GDSException {
    }

    public void iscEventCounts(EventHandle eventHandle) throws GDSException {
        EventHandleImp handleImp = (EventHandleImp)eventHandle;
        handleImp.calculateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCancelEvents(IscDbHandle dbHandle, EventHandle eventHandle) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)dbHandle;
        EventHandleImp handleImp = (EventHandleImp)eventHandle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        if (db.eventCoordinator.cancelEvents(handleImp)) {
            isc_db_handle_impl isc_db_handle_impl2 = db;
            synchronized (isc_db_handle_impl2) {
                try {
                    db.out.writeInt(49);
                    db.out.writeInt(db.getRdb_id());
                    db.out.writeInt(handleImp.getLocalId());
                    db.out.flush();
                    this.receiveResponse(db, -1);
                }
                catch (IOException ioe) {
                    throw new GDSException(1, 335544726, ioe.getMessage());
                }
            }
        }
    }

    public EventHandle createEventHandle(String eventName) {
        return new EventHandleImp(eventName);
    }

    class EventGlob {
        private EventHandler eventHandler;
        private EventHandleImp eventHandle;

        public EventGlob(EventHandler handler, EventHandleImp handle) {
            this.eventHandler = handler;
            this.eventHandle = handle;
        }

        public EventHandler getEventHandler() {
            return this.eventHandler;
        }

        public EventHandleImp getEventHandle() {
            return this.eventHandle;
        }
    }

    class EventCoordinatorImp
    implements EventCoordinator,
    Runnable {
        private int handle;
        private String ipAddress;
        private int port;
        private Socket socket;
        private XdrOutputStream out;
        private WireXdrInputStream in;
        private int eventsId = 0;
        isc_db_handle_impl db;
        private Map globMap = new HashMap();
        private boolean running = true;

        public EventCoordinatorImp(int handle, String ipAddress, int port) throws GDSException {
            this.handle = handle;
            this.ipAddress = ipAddress;
            this.port = port;
            this.connect();
            Thread eventThread = new Thread(this);
            eventThread.setDaemon(true);
            eventThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancelEvents(EventHandleImp eventHandle) {
            Map map = this.globMap;
            synchronized (map) {
                return this.globMap.remove(Integer.toString(eventHandle.getLocalId())) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    int op = AbstractJavaGDSImpl.this.nextOperation(this.db);
                    switch (op) {
                        case 9: {
                            AbstractJavaGDSImpl.this.receiveResponse(this.db, op);
                            break;
                        }
                        case 2: 
                        case 6: {
                            this.close();
                            break;
                        }
                        case 52: {
                            int dbHandle = this.db.in.readInt();
                            byte[] buffer = this.db.in.readBuffer();
                            for (int i = 0; i < 8; ++i) {
                                this.db.in.read();
                            }
                            int eventId = this.db.in.readInt();
                            int count = 0;
                            int shift = 0;
                            if (buffer.length > 4) {
                                for (int i = buffer.length - 4; i < buffer.length; ++i) {
                                    count += (buffer[i] & 0xFF) << shift;
                                    shift += 8;
                                }
                            }
                            EventGlob glob = null;
                            Map map = this.globMap;
                            synchronized (map) {
                                glob = (EventGlob)this.globMap.remove(Integer.toString(eventId));
                            }
                            if (glob == null) break;
                            glob.getEventHandle().setInternalCount(count);
                            glob.getEventHandler().eventOccurred();
                        }
                    }
                }
                this.doClose();
            }
            catch (IOException ioe) {
                throw new RuntimeException("IOException in event loop: " + ioe.getMessage());
            }
            catch (GDSException gdse) {
                throw new RuntimeException("GDSException in event loop: " + gdse.getMessage());
            }
        }

        private void connect() throws GDSException {
            try {
                this.db = new isc_db_handle_impl();
                this.socket = new Socket(this.ipAddress, this.port);
                this.socket.setTcpNoDelay(true);
                this.out = new XdrOutputStream(this.socket.getOutputStream());
                this.db.in = this.in = new WireXdrInputStream(this.socket.getInputStream());
                this.db.out = this.out;
            }
            catch (UnknownHostException uhe) {
                throw new GDSException(1, 335544721, this.ipAddress);
            }
            catch (IOException ioe) {
                throw new GDSException(1, 335544721, this.ipAddress);
            }
        }

        public void close() throws IOException {
            this.running = false;
        }

        private void doClose() throws IOException {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvents(isc_db_handle_impl mainDb, EventHandleImp eventHandle, EventHandler eventHandler) throws GDSException {
            isc_db_handle_impl isc_db_handle_impl2 = mainDb;
            synchronized (isc_db_handle_impl2) {
                try {
                    Map map = this.globMap;
                    synchronized (map) {
                        eventHandle.setLocalId(++this.eventsId);
                        mainDb.out.writeInt(48);
                        mainDb.out.writeInt(this.handle);
                        byte[] epb = eventHandle.toByteArray();
                        mainDb.out.writeBuffer(epb);
                        mainDb.out.writeInt(0);
                        mainDb.out.writeInt(0);
                        mainDb.out.writeInt(eventHandle.getLocalId());
                        mainDb.out.flush();
                        AbstractJavaGDSImpl.this.receiveResponse(mainDb, -1);
                        int eventId = mainDb.getResp_object();
                        eventHandle.setEventId(eventId);
                        this.globMap.put(Integer.toString(eventHandle.getLocalId()), new EventGlob(eventHandler, eventHandle));
                    }
                }
                catch (IOException ioe) {
                    throw new GDSException(1, 335544726, ioe.getMessage());
                }
            }
        }
    }

    protected static class DbAttachInfo {
        private String server = "localhost";
        private int port = 3050;
        private String fileName;

        public DbAttachInfo(String connectInfo) throws GDSException {
            char portSepChar;
            char hostSepChar;
            if (connectInfo == null) {
                throw new GDSException("Connection string missing");
            }
            if ((connectInfo = connectInfo.trim()).startsWith("//")) {
                connectInfo = connectInfo.substring(2);
                hostSepChar = '/';
                portSepChar = ':';
            } else {
                hostSepChar = ':';
                portSepChar = '/';
            }
            int sep = connectInfo.indexOf(hostSepChar);
            if (sep == 0 || sep == connectInfo.length() - 1) {
                throw new GDSException("Bad connection string: '" + hostSepChar + "' at beginning or end of:" + connectInfo + 335544323);
            }
            if (sep > 0) {
                this.server = connectInfo.substring(0, sep);
                this.fileName = connectInfo.substring(sep + 1);
                int portSep = this.server.indexOf(portSepChar);
                if (portSep == 0 || portSep == this.server.length() - 1) {
                    throw new GDSException("Bad server string: '" + portSepChar + "' at beginning or end of: " + this.server + 335544323);
                }
                if (portSep > 0) {
                    this.port = Integer.parseInt(this.server.substring(portSep + 1));
                    this.server = this.server.substring(0, portSep);
                }
            } else if (sep == -1) {
                this.fileName = connectInfo;
            }
        }

        public DbAttachInfo(String server, Integer port, String fileName) throws GDSException {
            if (fileName == null || fileName.equals("")) {
                throw new GDSException("null filename in DbAttachInfo");
            }
            if (server != null) {
                this.server = server;
            }
            if (port != null) {
                this.port = port;
            }
            this.fileName = fileName;
            if (fileName == null || fileName.equals("")) {
                throw new GDSException("null filename in DbAttachInfo");
            }
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

