/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.beans;

import br.com.bb.plugins.beans.BBPluginButton;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class BBBarraProgresso
extends Panel
implements IBarraProgresso,
ActionListener {
    private int valor;
    public int valorMaximo = 100;
    private String mensagem = "";
    private Vector actionListeners = null;
    private Label lblBarra;
    private Label lblMensagem;
    private Label labelBorda = null;
    private boolean cancelado;
    private BBPluginButton botaoCancelar = null;
    private boolean cancelavel = false;
    private Label labelFundo = null;

    public BBBarraProgresso() {
        this.setLayout(null);
        this.add(this.getBotaoCancelar());
        this.add(this.getLblMensagem());
        this.add(this.getLblBarra());
        this.add(this.getLabelBorda());
        this.getBotaoCancelar().addActionListener(this);
    }

    public BBBarraProgresso(LayoutManager layout) {
        super(layout);
    }

    public void actionPerformed(ActionEvent e) {
        this.setCancelado(true);
    }

    public void add(int valor) {
        this.setValor(this.getValor() + valor);
    }

    public void addActionListener(ActionListener al) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.addElement(al);
    }

    public void finalizar() {
        if (this.actionListeners != null) {
            this.fireActionEvent("Fechou");
            int i = 0;
            while (i < this.actionListeners.size()) {
                this.actionListeners.setElementAt(null, i);
                ++i;
            }
            this.actionListeners = null;
        }
    }

    private void fireActionEvent(String evento) {
        if (this.actionListeners != null) {
            ActionEvent ae = new ActionEvent(this, 1, evento);
            int i = 0;
            while (i < this.actionListeners.size()) {
                ((ActionListener)this.actionListeners.elementAt(i)).actionPerformed(ae);
                ++i;
            }
        }
    }

    private BBPluginButton getBotaoCancelar() {
        if (this.botaoCancelar == null) {
            this.botaoCancelar = new BBPluginButton("X");
            this.botaoCancelar.setBounds(0, 0, 0, 0);
            this.botaoCancelar.setToolTipText("Pressione para cancelar");
        }
        return this.botaoCancelar;
    }

    private Label getLabelBorda() {
        if (this.labelBorda == null) {
            this.labelBorda = new Label();
            this.labelBorda.setBackground(Color.white);
        }
        return this.labelBorda;
    }

    private Label getLabelFundo() {
        if (this.labelFundo == null) {
            this.labelFundo = new Label();
            this.labelFundo.setBackground(Color.lightGray);
        }
        return this.labelFundo;
    }

    private Label getLblBarra() {
        if (this.lblBarra == null) {
            this.lblBarra = new Label();
            this.lblBarra.setBackground(Color.blue);
            this.lblBarra.setBounds(0, 0, 0, 0);
        }
        return this.lblBarra;
    }

    private Label getLblMensagem() {
        if (this.lblMensagem == null) {
            this.lblMensagem = new Label();
            this.lblMensagem.setFont(new Font("Dialog", 0, 10));
            this.lblMensagem.setBounds(0, 0, 0, 0);
        }
        return this.lblMensagem;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public int getValor() {
        return this.valor;
    }

    public int getValorMaximo() {
        return this.valorMaximo;
    }

    public void inicializar(String titulo, int valorMaximo, boolean isCancelavel) {
        this.setMensagem(titulo);
        this.setValorMaximo(valorMaximo);
        this.setCancelado(false);
        this.setCancelavel(isCancelavel);
    }

    public boolean isCancelado() {
        return this.cancelado;
    }

    private boolean isCancelavel() {
        return this.cancelavel;
    }

    public void recalcula() {
        double pos = (double)this.getValor() / (double)this.getValorMaximo() * (double)this.getSize().width * 0.3;
        this.getLabelFundo().setBounds(0, 0, this.getSize().width, this.getSize().width);
        this.getLblBarra().setBounds(2, 2, (int)pos, this.getSize().height - 6);
        this.getLabelBorda().setBounds(2, 2, (int)((double)this.getSize().width * 0.3), this.getSize().height - 6);
        this.getLblMensagem().setBounds((int)((double)this.getSize().width * 0.3) + 5 + this.getBotaoCancelar().getSize().width, 2, (int)((double)this.getSize().width * 0.6) - this.getBotaoCancelar().getSize().width, this.getSize().height - 6);
        this.getLblMensagem().setText(this.mensagem);
    }

    public void removeActionListener(ActionListener al) {
        if (this.actionListeners != null) {
            this.actionListeners.removeElement(al);
        }
    }

    public void repaint() {
        super.repaint();
    }

    private void setBotaoCancelar(BBPluginButton newBotaoCancelar) {
        this.botaoCancelar = newBotaoCancelar;
    }

    public void setCancelado(boolean newCancelado) {
        this.cancelado = newCancelado;
    }

    private void setCancelavel(boolean newCancelavel) {
        this.cancelavel = newCancelavel;
        if (this.cancelavel) {
            this.getBotaoCancelar().setBounds((int)((double)this.getSize().width * 0.3) + 3, 1, this.getSize().height - 6, this.getSize().height - 4);
        } else {
            this.getBotaoCancelar().setBounds(0, 0, 0, 0);
        }
    }

    private void setLabelBorda(Label newLabelBorda) {
        this.labelBorda = newLabelBorda;
    }

    private void setLabelFundo(Label newLabelFundo) {
        this.labelFundo = newLabelFundo;
    }

    private void setLblBarra(Label newLblBarra) {
        this.lblBarra = newLblBarra;
    }

    private void setLblMensagem(Label newLblMensagem) {
        this.lblMensagem = newLblMensagem;
    }

    public void setMensagem(String newMensagem) {
        this.mensagem = newMensagem;
        this.recalcula();
    }

    public void setValor(int newValor) {
        this.valor = newValor;
        this.recalcula();
    }

    public void setValorMaximo(int newValorMaximo) {
        this.valorMaximo = newValorMaximo;
        this.recalcula();
    }
}

