/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.beans;

import br.com.bb.plugins.beans.BBToolTip;
import br.com.bb.plugins.beans.ToolTipText;
import br.com.bb.plugins.persistencia.infraestrutura.ImagemBD;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class BBPluginButtonPlus
extends Canvas
implements MouseListener,
Runnable,
ToolTipText {
    private String imagemBotaoNormal = "btIncluirPessoa.gif";
    private String imagemBotaoPressionado = "btIncluirPessoa_press.gif";
    private String imagemBotaoDesativado = "btIncluirPessoa_des.gif";
    private Image imagemPressionada;
    private Image imagemNormal;
    private Image imagemDesativada;
    private Image imagemAtual;
    protected transient ActionListener aActionListener = null;
    private String toolTipText;
    private boolean enabled = true;

    public BBPluginButtonPlus() {
        this.inicializar();
    }

    public BBPluginButtonPlus(String imagemBotaoNormal) {
        this.imagemBotaoNormal = imagemBotaoNormal;
        int i = imagemBotaoNormal.indexOf(".");
        String baseName = imagemBotaoNormal.substring(0, i);
        this.imagemBotaoDesativado = String.valueOf(baseName) + "_des" + imagemBotaoNormal.substring(i);
        this.imagemBotaoPressionado = String.valueOf(baseName) + "_press" + imagemBotaoNormal.substring(i);
        this.inicializar();
    }

    public void addActionListener(ActionListener newListener) {
        this.aActionListener = AWTEventMulticaster.add(this.aActionListener, newListener);
    }

    public void changeImage() {
        Image image = this.imagemAtual;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            System.out.println("Cannot load image");
        }
        this.setSize(image.getWidth(null), image.getHeight(null));
        this.repaint();
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.aActionListener == null) {
            return;
        }
        this.aActionListener.actionPerformed(e);
    }

    public String getImagemBotaoDesativado() {
        return this.imagemBotaoDesativado;
    }

    public String getImagemBotaoNormal() {
        return this.imagemBotaoNormal;
    }

    public String getImagemBotaoPressionado() {
        return this.imagemBotaoPressionado;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    private void inicializar() {
        this.imagemNormal = ImagemBD.obter(this.imagemBotaoNormal);
        if (this.imagemNormal == null) {
            this.imagemNormal = ImagemBD.obter("btBranco.gif");
            this.imagemBotaoDesativado = "btBranco.gif";
            this.imagemBotaoPressionado = "btBranco.gif";
        }
        this.imagemDesativada = ImagemBD.obter(this.imagemBotaoDesativado);
        this.imagemPressionada = ImagemBD.obter(this.imagemBotaoPressionado);
        this.imagemAtual = this.enabled ? this.imagemNormal : this.imagemDesativada;
        this.setSize(41, 38);
        this.setName("BBPluginButtonPlus");
        this.addMouseListener(this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadImage(Image image) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            System.out.println("Cannot load image");
        }
        this.setSize(image.getWidth(null), image.getHeight(null));
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this && this.imagemAtual == this.imagemPressionada) {
            this.imagemAtual = this.imagemNormal;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this && this.isEnabled()) {
            this.imagemAtual = this.imagemPressionada;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this && this.imagemAtual == this.imagemPressionada) {
            Thread t = new Thread(this);
            t.start();
            this.imagemAtual = this.imagemNormal;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.imagemAtual, 0, 0, this);
    }

    public void removeActionListener(ActionListener newListener) {
        this.aActionListener = AWTEventMulticaster.remove(this.aActionListener, newListener);
    }

    public void run() {
        if (this.isEnabled()) {
            this.repaint();
            this.fireActionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void setEnabled(boolean newEnabled) {
        this.enabled = newEnabled;
        this.imagemAtual = newEnabled ? this.imagemNormal : this.imagemDesativada;
        this.repaint();
    }

    public void setImagemBotaoDesativado(String newImagemBotaoDesativado) {
        this.imagemBotaoDesativado = newImagemBotaoDesativado;
    }

    public void setImagemBotaoNormal(String newValue) {
        this.imagemBotaoNormal = newValue;
    }

    public void setImagemBotaoPressionado(String newValue) {
        this.imagemBotaoPressionado = newValue;
    }

    public void setToolTipText(String newToolTipText) {
        this.toolTipText = newToolTipText;
        if (this.toolTipText != null && this.toolTipText.length() > 0) {
            BBToolTip.addBBToolTip(this);
        }
    }
}

