/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.impressao;

import br.com.bb.plugins.controle.impressao.CodBarras;
import br.com.bb.plugins.controle.impressao.FrameVisualizacao;
import br.com.bb.plugins.controle.impressao.JobImpressao;
import br.com.bb.plugins.controle.impressao.Linha;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.negocio.infraestrutura.PaginaImpressao;
import br.com.bb.plugins.persistencia.infraestrutura.ImagemBD;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;

public class CanvasVisualizacao
extends Canvas
implements ComponentListener {
    private int paginaAtual = 1;
    private boolean fim = false;
    private JobImpressao jobImpressao;
    private int limiteLinhas = 65;
    private int linhasTratadas = 0;
    private int posicaoX = 0;
    private int posicaoY;
    private Vector paginas = null;
    private Vector numeracaoPaginas = null;
    private int linhaAtual = 0;
    private int limiteColunas = 80;
    private double multiplicadorFonte = 1.3;
    private boolean paginado = false;
    private boolean indicadorNovaLinha = false;
    public boolean isGrafico = false;
    public Vector desenhaString = null;
    public Vector desenhaLinha = null;
    public Vector desenhaImagem = null;
    public Vector desenhaLinhaPontilhada = null;
    public Vector desenhaBlocoHachurado = null;
    public String nomeImagem = null;
    public static int DIREITO = 0;
    public static int ESQUERDO = 2;
    public static int CENTRO = 1;
    private double fatorZoom;
    private CodBarras codeBar2de5;
    private Image logoBB = null;
    public FrameVisualizacao FrameVisualizacao;

    public CanvasVisualizacao() {
        this.addComponentListener(this);
        this.setSize(1024, 2160);
        this.setIsGrafico(false);
    }

    public CanvasVisualizacao(boolean grafico) {
        this.addComponentListener(this);
        this.setSize(1024, 2160);
        this.setIsGrafico(grafico);
    }

    private int alinhamento(String nome, int posicao, FontMetrics fonte, int alinhamento) {
        int tam = fonte.stringWidth(nome);
        if (alinhamento == ESQUERDO) {
            return posicao;
        }
        if (alinhamento == DIREITO) {
            if (posicao > tam) {
                return posicao - tam;
            }
        } else if (alinhamento == CENTRO && posicao > tam / 2) {
            return posicao - tam / 2;
        }
        return 0;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void desenhaLogoBB(Graphics g) {
        if (ControleAplicacao.getPlugin().getCodigoPlugin().equalsIgnoreCase("CLT") || ControleAplicacao.getPlugin().getCodigoPlugin().equalsIgnoreCase("PAG")) {
            g.drawImage(this.getLogoBB(), (int)(35.0 * this.getFatorZoom()), (int)(17.0 * this.getFatorZoom()), (int)(135.0 * this.getFatorZoom()), (int)(16.0 * this.getFatorZoom()), null);
        }
    }

    public CodBarras getCodeBar2de5() {
        if (this.codeBar2de5 == null) {
            this.codeBar2de5 = new CodBarras();
        }
        return this.codeBar2de5;
    }

    public double getFatorZoom() {
        return this.fatorZoom;
    }

    public FrameVisualizacao getFrameVisualizacao() {
        if (this.FrameVisualizacao == null) {
            this.FrameVisualizacao = new FrameVisualizacao();
        }
        return this.FrameVisualizacao;
    }

    public JobImpressao getJobImpressao() {
        return this.jobImpressao;
    }

    public int getLimiteColunas() {
        return this.limiteColunas;
    }

    public int getLimiteLinhas() {
        return this.limiteLinhas;
    }

    private int getLinhaAtual() {
        return this.linhaAtual;
    }

    public int getLinhasTratadas() {
        return this.linhasTratadas;
    }

    public Image getLogoBB() {
        if (this.logoBB == null) {
            this.logoBB = ImagemBD.obter("infra", "BBSimbolo4.jpg");
        }
        this.setLogoBB(this.logoBB);
        return this.logoBB;
    }

    public double getMultiplicadorFonte() {
        return this.multiplicadorFonte;
    }

    public String getNomeImagem() {
        return this.nomeImagem;
    }

    private Vector getNumeracaoPaginas() {
        if (this.numeracaoPaginas == null) {
            this.numeracaoPaginas = new Vector();
        }
        return this.numeracaoPaginas;
    }

    public int getNumeroPaginas() {
        if (!this.paginado) {
            this.paginar();
        }
        return this.getPaginas().size();
    }

    public int getPaginaAtual() {
        return this.paginaAtual;
    }

    private Vector getPaginas() {
        if (this.paginas == null) {
            this.paginas = new Vector();
        }
        return this.paginas;
    }

    private int getPosicaoX() {
        return this.posicaoX;
    }

    private int getPosicaoY() {
        return this.posicaoY;
    }

    private void imprimirRodape(Graphics g) {
        int count = 0;
        while (this.linhaAtual < this.limiteLinhas - 2) {
            if (count == 0 && ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getFonte() != null) {
                switch (this.jobImpressao.getVLinhas().size()) {
                    case 1: {
                        Font f = ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getFonte();
                        break;
                    }
                    case 2: {
                        Font f = ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getFonte().getSize() <= ((Linha)this.jobImpressao.getVLinhas().elementAt(1)).getFonte().getSize() ? ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getFonte() : ((Linha)this.jobImpressao.getVLinhas().elementAt(1)).getFonte();
                        g.setFont(new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * this.multiplicadorFonte)));
                        break;
                    }
                    default: {
                        Font f = ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getFonte().getSize() <= ((Linha)this.jobImpressao.getVLinhas().elementAt(1)).getFonte().getSize() && ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getFonte().getSize() <= ((Linha)this.jobImpressao.getVLinhas().elementAt(2)).getFonte().getSize() ? ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getFonte() : (((Linha)this.jobImpressao.getVLinhas().elementAt(1)).getFonte().getSize() <= ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getFonte().getSize() && ((Linha)this.jobImpressao.getVLinhas().elementAt(1)).getFonte().getSize() <= ((Linha)this.jobImpressao.getVLinhas().elementAt(2)).getFonte().getSize() ? ((Linha)this.jobImpressao.getVLinhas().elementAt(1)).getFonte() : ((Linha)this.jobImpressao.getVLinhas().elementAt(2)).getFonte());
                        g.setFont(new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * this.multiplicadorFonte)));
                    }
                }
                g.setFont(new Font(g.getFont().getName(), g.getFont().getStyle(), (int)((double)g.getFont().getSize() * this.getFatorZoom())));
            }
            this.println(g, "");
            ++this.linhaAtual;
            ++count;
        }
        try {
            int tamFonte = (int)(11.0 * this.multiplicadorFonte);
            g.setFont(new Font("monospaced", 1, (int)((double)tamFonte * this.getFatorZoom())));
            this.println(g, "     " + Util.padR("", this.limiteColunas, "_"));
            this.println(g, "     " + Util.padR(String.valueOf((Integer)this.getNumeracaoPaginas().elementAt(this.paginaAtual - 1)), this.limiteColunas));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isFim() {
        return this.fim;
    }

    private boolean isIndicadorNovaLinha() {
        return this.indicadorNovaLinha;
    }

    public boolean isIsGrafico() {
        return this.isGrafico;
    }

    public void loadCabec(Graphics g) {
        this.setLinhaAtual(0);
        this.setPosicaoY(0);
        this.setPosicaoX(0);
        this.println(g, "");
        this.println(g, "");
        int i = 0;
        while (i < this.jobImpressao.getVLinhasCabecalho().size()) {
            Font f = ((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getFonte();
            int tamFonte = (int)((double)(f = new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * this.getFatorZoom()))).getSize() * this.multiplicadorFonte);
            if ((double)tamFonte < (double)f.getSize() * this.multiplicadorFonte && !f.getName().equalsIgnoreCase("Monospaced")) {
                ++tamFonte;
            }
            g.setFont(new Font(f.getName(), f.getStyle(), tamFonte));
            if (((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getTab() > 0) {
                this.tab(g, ((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getTab());
            }
            if (((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).isSalto()) {
                this.println(g, ((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getTexto());
                this.setLinhaAtual(this.getLinhaAtual() + 1);
            } else {
                this.print(g, ((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getTexto());
            }
            ++i;
        }
    }

    public void loadGrafico(Graphics g) {
        Vector paginas = this.getJobImpressao().getPaginasImpressao();
        Vector desenhaGuiaFinal = new Vector();
        boolean coluna = false;
        boolean linha = false;
        boolean largura = false;
        boolean altura = false;
        PaginaImpressao pi = null;
        if (this.paginaAtual == this.getPaginas().size()) {
            this.setFim(true);
        } else {
            this.setFim(false);
        }
        if (paginas.size() > 0) {
            int y;
            FontMetrics f;
            String s;
            FontMetrics fontMetrics;
            Color cor;
            int linha2;
            int desloc;
            int y2;
            int finalLinha;
            int alturaLinha;
            int inicioLinha;
            int larguraLinha;
            int tam;
            String s2;
            FontMetrics f2;
            Vector aux;
            pi = (PaginaImpressao)paginas.elementAt(this.getPaginaAtual() - 1);
            int i = 0;
            while (pi.getDesenhaBlocosHachuradoFundo() != null && i < pi.getDesenhaBlocosHachuradoFundo().size()) {
                aux = (Vector)pi.getDesenhaBlocosHachuradoFundo().elementAt(i);
                g.setFont(new Font(((Font)aux.elementAt(5)).getName(), ((Font)aux.elementAt(5)).getStyle(), (int)((double)((Font)aux.elementAt(5)).getSize() * this.getFatorZoom())));
                g.setColor((Color)aux.elementAt(4));
                f2 = g.getFontMetrics();
                s2 = "";
                tam = f2.charWidth('.');
                larguraLinha = (int)(this.getFatorZoom() * (double)(Integer.parseInt((String)aux.elementAt(2)) - Integer.parseInt((String)aux.elementAt(0))));
                if (Integer.parseInt((String)aux.elementAt(6)) == 0) {
                    larguraLinha = Math.round(larguraLinha / 2);
                }
                inicioLinha = (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1)));
                alturaLinha = (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(3)) - (double)inicioLinha);
                finalLinha = alturaLinha + inicioLinha;
                if (Integer.parseInt((String)aux.elementAt(6)) == 0) {
                    y2 = 0;
                    while (y2 <= larguraLinha) {
                        s2 = String.valueOf(s2) + ". ";
                        y2 += tam;
                    }
                    desloc = 1;
                    linha2 = inicioLinha;
                    while (linha2 <= finalLinha) {
                        g.drawString(s2, (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0)) + (double)desloc), linha2);
                        if (++desloc > 1) {
                            desloc = 0;
                        }
                        ++linha2;
                    }
                } else {
                    g.drawRect((int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))), larguraLinha, alturaLinha);
                    g.fillRect((int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0)) + 1.0), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1)) + 1.0), larguraLinha - 1, alturaLinha - 1);
                }
                ++i;
            }
            i = 0;
            while (pi.getDesenhaImagensFundo() != null && i < pi.getDesenhaImagensFundo().size()) {
                aux = (Vector)pi.getDesenhaImagensFundo().elementAt(i);
                cor = (Color)aux.elementAt(5);
                g.drawImage((Image)aux.elementAt(0), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(2))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(3))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(4))), cor, this);
                ++i;
            }
            i = 0;
            while (pi.getDesenhaStringsFundo() != null && i < pi.getDesenhaStringsFundo().size()) {
                aux = (Vector)pi.getDesenhaStringsFundo().elementAt(i);
                g.setFont(new Font(((Font)aux.elementAt(3)).getName(), ((Font)aux.elementAt(3)).getStyle(), (int)((double)((Font)aux.elementAt(3)).getSize() * this.getFatorZoom())));
                fontMetrics = g.getFontMetrics();
                g.setColor((Color)aux.elementAt(4));
                g.drawString((String)aux.elementAt(0), this.alinhamento((String)aux.elementAt(0), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))), fontMetrics, Integer.parseInt((String)aux.elementAt(5))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(2))));
                ++i;
            }
            i = 0;
            while (pi.getDesenhaLinhasFundo() != null && i < pi.getDesenhaLinhasFundo().size()) {
                aux = (Vector)pi.getDesenhaLinhasFundo().elementAt(i);
                g.setColor((Color)aux.elementAt(4));
                g.drawLine((int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(2))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(3))));
                ++i;
            }
            i = 0;
            while (pi.getDesenhaLinhasPontilhadaFundo() != null && i < pi.getDesenhaLinhasPontilhadaFundo().size()) {
                aux = (Vector)pi.getDesenhaLinhasPontilhadaFundo().elementAt(i);
                s = "";
                g.setFont(new Font(((Font)aux.elementAt(4)).getName(), ((Font)aux.elementAt(4)).getStyle(), (int)((double)((Font)aux.elementAt(4)).getSize() * this.getFatorZoom())));
                g.setColor((Color)aux.elementAt(5));
                f = g.getFontMetrics();
                tam = f.charWidth('.');
                larguraLinha = (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(2)) - (double)Integer.parseInt((String)aux.elementAt(0)));
                y = 0;
                while (y <= larguraLinha) {
                    s = String.valueOf(s) + '.';
                    y += tam;
                }
                g.drawString(s, (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))));
                ++i;
            }
            i = 0;
            while (pi.getDesenhaBlocosHachurado() != null && i < pi.getDesenhaBlocosHachurado().size()) {
                aux = (Vector)pi.getDesenhaBlocosHachurado().elementAt(i);
                g.setFont(new Font(((Font)aux.elementAt(5)).getName(), ((Font)aux.elementAt(5)).getStyle(), (int)((double)((Font)aux.elementAt(5)).getSize() * this.getFatorZoom())));
                g.setColor((Color)aux.elementAt(4));
                f2 = g.getFontMetrics();
                s2 = "";
                tam = f2.charWidth('.');
                larguraLinha = (int)(this.getFatorZoom() * (double)(Integer.parseInt((String)aux.elementAt(2)) - Integer.parseInt((String)aux.elementAt(0))));
                if (Integer.parseInt((String)aux.elementAt(6)) == 0) {
                    larguraLinha = Math.round(larguraLinha / 2);
                }
                inicioLinha = (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1)));
                alturaLinha = (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(3)) - (double)inicioLinha);
                finalLinha = alturaLinha + inicioLinha;
                if (Integer.parseInt((String)aux.elementAt(6)) == 0) {
                    y2 = 0;
                    while (y2 <= larguraLinha) {
                        s2 = String.valueOf(s2) + ". ";
                        y2 += tam;
                    }
                    desloc = 1;
                    linha2 = inicioLinha;
                    while (linha2 <= finalLinha) {
                        g.drawString(s2, (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0)) + (double)desloc), linha2);
                        if (++desloc > 1) {
                            desloc = 0;
                        }
                        ++linha2;
                    }
                } else {
                    g.drawRect((int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))), larguraLinha, alturaLinha);
                    g.fillRect((int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0)) + 1.0), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1)) + 1.0), larguraLinha - 1, alturaLinha - 1);
                }
                ++i;
            }
            i = 0;
            while (pi.getDesenhaImagens() != null && i < pi.getDesenhaImagens().size()) {
                aux = (Vector)pi.getDesenhaImagens().elementAt(i);
                cor = (Color)aux.elementAt(5);
                g.drawImage((Image)aux.elementAt(0), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(2))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(3))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(4))), cor, this);
                ++i;
            }
            i = 0;
            while (pi.getDesenhaStrings() != null && i < pi.getDesenhaStrings().size()) {
                aux = (Vector)pi.getDesenhaStrings().elementAt(i);
                g.setFont(new Font(((Font)aux.elementAt(3)).getName(), ((Font)aux.elementAt(3)).getStyle(), (int)((double)((Font)aux.elementAt(3)).getSize() * this.getFatorZoom())));
                fontMetrics = g.getFontMetrics();
                g.setColor((Color)aux.elementAt(4));
                g.drawString((String)aux.elementAt(0), this.alinhamento((String)aux.elementAt(0), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))), fontMetrics, Integer.parseInt((String)aux.elementAt(5))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(2))));
                ++i;
            }
            i = 0;
            while (pi.getDesenhaLinhas() != null && i < pi.getDesenhaLinhas().size()) {
                aux = (Vector)pi.getDesenhaLinhas().elementAt(i);
                g.setColor((Color)aux.elementAt(4));
                g.drawLine((int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(2))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(3))));
                ++i;
            }
            i = 0;
            while (pi.getDesenhaLinhasPontilhada() != null && i < pi.getDesenhaLinhasPontilhada().size()) {
                aux = (Vector)pi.getDesenhaLinhasPontilhada().elementAt(i);
                s = "";
                g.setFont((Font)aux.elementAt(4));
                g.setColor((Color)aux.elementAt(5));
                f = g.getFontMetrics();
                tam = f.charWidth('.');
                larguraLinha = Integer.parseInt((String)aux.elementAt(2)) - Integer.parseInt((String)aux.elementAt(0));
                y = 0;
                while (y <= larguraLinha) {
                    s = String.valueOf(s) + '.';
                    y += tam;
                }
                g.drawString(s, Integer.parseInt((String)aux.elementAt(0)), Integer.parseInt((String)aux.elementAt(1)));
                ++i;
            }
            i = 0;
            while (pi.getDesenhaLinhasPontilhada() != null && i < pi.getDesenhaLinhasPontilhada().size()) {
                aux = (Vector)pi.getDesenhaLinhasPontilhada().elementAt(i);
                s = "";
                g.setFont(new Font(((Font)aux.elementAt(4)).getName(), ((Font)aux.elementAt(4)).getStyle(), (int)((double)((Font)aux.elementAt(4)).getSize() * this.getFatorZoom())));
                g.setColor((Color)aux.elementAt(5));
                f = g.getFontMetrics();
                tam = f.charWidth('.');
                larguraLinha = (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(2)) - (double)Integer.parseInt((String)aux.elementAt(0)));
                y = 0;
                while (y <= larguraLinha) {
                    s = String.valueOf(s) + '.';
                    y += tam;
                }
                g.drawString(s, (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(0))), (int)(this.getFatorZoom() * (double)Integer.parseInt((String)aux.elementAt(1))));
                ++i;
            }
            i = 0;
            while (pi.getDesenhaCodigoBarras() != null && i < pi.getDesenhaCodigoBarras().size()) {
                aux = (Vector)pi.getDesenhaCodigoBarras().elementAt(i);
                g.setFont(new Font("ArialNarrow", 0, (int)(6.0 * this.getFatorZoom())));
                this.getCodeBar2de5().setFont(new Font("ArialNarrow", 0, (int)(6.0 * this.getFatorZoom())));
                this.getCodeBar2de5().setTextoCodigo((String)aux.elementAt(2));
                this.getCodeBar2de5().montaBarra(g, Integer.parseInt((String)aux.elementAt(0)), Integer.parseInt((String)aux.elementAt(1)), Integer.parseInt((String)aux.elementAt(3)), this.getFatorZoom());
                ++i;
            }
            if (pi.getNomeImagem() != null && pi.getNomeImagem().trim().length() > 0) {
                this.setNomeImagem(pi.getNomeImagem());
            } else {
                this.setNomeImagem(String.valueOf(ControleAplicacao.getPlugin().getCodigoPlugin()) + "_Imagem de Relat\u00f3rio");
            }
        }
    }

    public void loadLogoBB(Graphics g) throws Throwable {
        this.desenhaLogoBB(g);
    }

    public void loadStrings(Graphics g) throws Throwable {
        int fimPagina;
        this.linhaAtual = 0;
        if (!this.paginado) {
            this.paginar();
        }
        this.setPosicaoY(0);
        if (this.paginaAtual > this.getPaginas().size()) {
            this.paginaAtual = this.getPaginas().size();
        }
        int inicioPagina = (Integer)this.getPaginas().elementAt(this.paginaAtual - 1);
        if (this.paginaAtual == this.getPaginas().size()) {
            fimPagina = this.jobImpressao.getVLinhas().size();
            this.setFim(true);
        } else {
            this.setFim(false);
            fimPagina = (Integer)this.getPaginas().elementAt(this.paginaAtual);
        }
        this.setFim(this.paginaAtual == this.getPaginas().size());
        if (this.jobImpressao.isCabecalhoPadrao() && this.jobImpressao.getVLinhasCabecalho() != null && this.jobImpressao.getVLinhasCabecalho().size() > 0) {
            this.loadCabec(g);
        }
        int i = inicioPagina;
        while (i < fimPagina) {
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getFonte() != null) {
                Font f = ((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getFonte();
                f = new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * this.getFatorZoom()));
                g.setFont(new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * this.multiplicadorFonte)));
            }
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getTab() > 0) {
                this.tab(g, ((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getTab());
            }
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).isSalto()) {
                this.println(g, ((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getTexto());
                ++this.linhaAtual;
            } else {
                this.print(g, ((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getTexto());
            }
            ++this.linhasTratadas;
            ++i;
        }
        if (ControleAplicacao.getPlugin().getCodigoPlugin().equalsIgnoreCase("CLT") || ControleAplicacao.getPlugin().getCodigoPlugin().equalsIgnoreCase("PAG")) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.imprimirRodape(g);
    }

    public void numeroPaginasGuia() {
        this.setPaginas(this.getJobImpressao().getPaginasImpressao());
        this.paginado = true;
        this.getNumeroPaginas();
    }

    private void paginar() {
        int linha = 0;
        int numeroPagina = 1;
        int pagina = 1;
        int linhasCabecalho = 0;
        if (this.jobImpressao.isCabecalhoPadrao() && this.jobImpressao.getVLinhasCabecalho() != null && this.jobImpressao.getVLinhasCabecalho().size() > 0) {
            linhasCabecalho = this.jobImpressao.getVLinhasCabecalho().size();
        }
        linha = linhasCabecalho;
        this.getPaginas().addElement(new Integer(0));
        if (((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getNumeroPaginaAtual() != 0) {
            numeroPagina = ((Linha)this.jobImpressao.getVLinhas().elementAt(0)).getNumeroPaginaAtual();
        }
        int i = 0;
        while (i < this.jobImpressao.getVLinhas().size()) {
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).isNovaPagina() && linha != 0 && i != 0) {
                this.getNumeracaoPaginas().addElement(new Integer(numeroPagina));
                ++numeroPagina;
                this.getPaginas().addElement(new Integer(i));
                ++pagina;
                linha = linhasCabecalho;
            }
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).isSalto()) {
                ++linha;
            }
            if (linha > this.limiteLinhas - 2) {
                this.getNumeracaoPaginas().addElement(new Integer(numeroPagina));
                ++numeroPagina;
                ++pagina;
                this.getPaginas().addElement(new Integer(i + 1));
                linha = linhasCabecalho;
            }
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getNumeroPaginaAtual() != 0) {
                numeroPagina = ((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getNumeroPaginaAtual();
            }
            ++i;
        }
        this.getNumeracaoPaginas().addElement(new Integer(numeroPagina));
        this.paginado = true;
    }

    public void paint(Graphics g) {
        try {
            if (this.isGrafico) {
                this.loadGrafico(g);
            } else {
                this.loadStrings(g);
            }
            g.fillRect(this.getSize().width - 2, 0, this.getSize().width, this.getSize().height);
            g.fillRect(0, this.getSize().height - 2, this.getSize().width, this.getSize().height);
            if (ControleAplicacao.getPlugin().getCodigoPlugin().equalsIgnoreCase("CLT") || ControleAplicacao.getPlugin().getCodigoPlugin().equalsIgnoreCase("PAG")) {
                this.loadLogoBB(g);
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
        }
    }

    private void print(Graphics g, String texto) {
        if (this.isIndicadorNovaLinha()) {
            this.setPosicaoY(this.getPosicaoY() + g.getFontMetrics().getHeight());
            this.setIndicadorNovaLinha(false);
        }
        g.drawString(texto, this.getPosicaoX(), this.getPosicaoY());
        this.setPosicaoX(this.getPosicaoX() + g.getFontMetrics().stringWidth(texto));
    }

    private void println(Graphics g, String texto) {
        if (this.isIndicadorNovaLinha()) {
            this.setPosicaoY(this.getPosicaoY() + g.getFontMetrics().getHeight());
        }
        g.drawString(texto, this.getPosicaoX(), this.getPosicaoY());
        this.setPosicaoX(0);
        this.setIndicadorNovaLinha(true);
    }

    public void setDesenhaString(Vector vString) {
        this.desenhaString = vString;
    }

    public void setFatorZoom(double newFatorZoom) {
        this.fatorZoom = newFatorZoom;
        this.setSize((int)(this.fatorZoom * 775.0), (int)(this.fatorZoom * 1200.0));
        this.repaint();
    }

    public void setFim(boolean newFim) {
        this.fim = newFim;
    }

    public void setFrameVisualizacao(FrameVisualizacao newFrameVisualizacao) {
        this.FrameVisualizacao = newFrameVisualizacao;
    }

    private void setIndicadorNovaLinha(boolean newIndicadorNovaLinha) {
        this.indicadorNovaLinha = newIndicadorNovaLinha;
    }

    public void setIsGrafico(boolean newIsGrafico) {
        this.isGrafico = newIsGrafico;
    }

    public void setJobImpressao(JobImpressao newJobImpressao) {
        this.jobImpressao = newJobImpressao;
    }

    public void setLimiteColunas(int newLimiteColunas) {
        this.limiteColunas = newLimiteColunas;
    }

    public void setLimiteLinhas(int newLimiteLinhas) {
        this.limiteLinhas = newLimiteLinhas;
    }

    private void setLinhaAtual(int newLinhaAtual) {
        this.linhaAtual = newLinhaAtual;
    }

    public void setLinhasTratadas(int newLinhasTratadas) {
        this.linhasTratadas = newLinhasTratadas;
    }

    public void setLogoBB(Image newLogoBB) {
        this.logoBB = newLogoBB;
    }

    public void setMultiplicadorFonte(double newMultiplicadorFonte) {
        this.multiplicadorFonte = newMultiplicadorFonte;
    }

    public void setNomeImagem(String newNomeImagem) {
        this.nomeImagem = newNomeImagem;
    }

    private void setNumeracaoPaginas(Vector newNumeracaoPaginas) {
        this.numeracaoPaginas = newNumeracaoPaginas;
    }

    public void setPaginaAtual(int newPaginaAtual) {
        this.paginaAtual = newPaginaAtual;
    }

    private void setPaginas(Vector newPaginas) {
        this.paginas = newPaginas;
    }

    private void setPosicaoX(int newPosicaoX) {
        this.posicaoX = newPosicaoX;
    }

    private void setPosicaoY(int newPosicaoY) {
        this.posicaoY = newPosicaoY;
    }

    private void tab(Graphics g, int tamanho) {
        int i = g.getFontMetrics(new Font("MonoSpaced", 0, (int)(12.0 * this.getFatorZoom()))).stringWidth("M") * tamanho;
        this.setPosicaoX(i);
    }
}

