/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.impressao;

import br.com.bb.plugins.controle.impressao.Cabec;
import br.com.bb.plugins.controle.impressao.JobImpressao;
import br.com.bb.plugins.controle.impressao.Linha;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePlugin;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Hashtable;
import java.util.Vector;

public class ControleImpressao
extends Roteador {
    private static ControleImpressao controle = null;
    private String tituloPadrao = "";
    public String tituloCliente = "";
    private Font fonte = new Font("MonoSpaced", 0, 10);
    private int linhasPorPagina = 58;
    private JobImpressao jobImpressao = null;
    private String codigoRelatorio;
    private String descricao2;
    private String descricao1;
    private int largura = 80;
    private int[][] colunasMulticolumComTotais;
    private Hashtable totais = new Hashtable();
    private String tituloVisualizacao = "";

    private ControleImpressao() {
    }

    public void abrirSalvarImagem(Vector dadosImagem) {
        IInterfacePlugin ip = this.abrirInterface("SalvarImagem", null);
        ip.popular(dadosImagem);
        ip.exibir();
    }

    public int getCasasDecimaisTotalizador(int coluna) {
        if (this.colunasMulticolumComTotais != null) {
            int i = 0;
            while (i < this.colunasMulticolumComTotais.length) {
                if (coluna == this.colunasMulticolumComTotais[i][0]) {
                    return this.colunasMulticolumComTotais[i][1];
                }
                ++i;
            }
        }
        return 0;
    }

    public String getCodigoRelatorio() {
        return this.codigoRelatorio;
    }

    public static ControleImpressao getControle() {
        if (controle == null) {
            controle = new ControleImpressao();
        }
        return controle;
    }

    public String getDescricao1() {
        if (this.descricao1 == null) {
            return this.getTituloCliente();
        }
        return this.descricao1;
    }

    public String getDescricao2() {
        return this.descricao2;
    }

    public Font getFonte() {
        return this.fonte;
    }

    public int getLargura() {
        return this.largura;
    }

    public int getLinhasPorPagina() {
        return this.linhasPorPagina;
    }

    public String getTituloCliente() {
        return this.tituloCliente;
    }

    public String getTituloPadrao() {
        return this.tituloPadrao;
    }

    public String getTituloVisualizacao() {
        return this.tituloVisualizacao;
    }

    private void handleException(Throwable exception) {
        Util.exibirMensagemErro(exception);
    }

    public boolean imprimir(MultiColumnListbox mclb, String tituloPadrao) {
        this.tituloPadrao = tituloPadrao;
        this.jobImpressao = new JobImpressao(tituloPadrao, this.tituloCliente);
        this.jobImpressao.setNumeroLinhasPagina(this.linhasPorPagina);
        this.jobImpressao.setLargura(this.getLargura());
        this.tratarMultiColumnListbox(mclb);
        return this.jobImpressao.visualizar();
    }

    public boolean imprimir(MultiColumnListbox mclb, String tituloPadrao, int tamanhoFonte) {
        if (tamanhoFonte != 0) {
            this.fonte = new Font(this.fonte.getName(), 0, tamanhoFonte);
        }
        return this.imprimir(mclb, tituloPadrao);
    }

    public boolean imprimir(Vector lista, String tituloPadrao) {
        this.tituloPadrao = tituloPadrao;
        this.jobImpressao = new JobImpressao(tituloPadrao, this.tituloCliente);
        this.jobImpressao.setNumeroLinhasPagina(this.linhasPorPagina);
        this.tratarVetorStrings(lista);
        return this.jobImpressao.visualizar();
    }

    public boolean imprimir(Vector lista, String tituloPadrao, boolean msgFim, boolean cabecalho) {
        this.tituloPadrao = tituloPadrao;
        this.jobImpressao = new JobImpressao(tituloPadrao, this.tituloCliente, msgFim, cabecalho);
        this.jobImpressao.setNumeroLinhasPagina(this.linhasPorPagina);
        this.tratarVetorStrings(lista);
        return this.jobImpressao.visualizar();
    }

    public boolean imprimirLinhas(Vector lista, String tituloPadrao) {
        this.tituloPadrao = tituloPadrao;
        this.jobImpressao = new JobImpressao(tituloPadrao, this.tituloCliente);
        this.jobImpressao.setNumeroLinhasPagina(this.linhasPorPagina);
        this.tratarVetorLinhas(lista);
        return this.jobImpressao.visualizar();
    }

    public boolean imprimirLinhas(Vector lista, String tituloPadrao, boolean msgFim, boolean cabecalho) {
        this.tituloPadrao = tituloPadrao;
        this.jobImpressao = new JobImpressao(tituloPadrao, this.tituloCliente, msgFim, cabecalho);
        this.jobImpressao.setNumeroLinhasPagina(this.linhasPorPagina);
        this.tratarVetorLinhas(lista);
        return this.jobImpressao.visualizar();
    }

    public boolean isTotalizador(int coluna) {
        if (this.colunasMulticolumComTotais != null) {
            int i = 0;
            while (i < this.colunasMulticolumComTotais.length) {
                if (coluna == this.colunasMulticolumComTotais[i][0]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setCodigoRelatorio(String newCodigoRelatorio) {
        this.codigoRelatorio = newCodigoRelatorio;
    }

    public void setColunasMulticolumComTotais(int[][] colunas) {
        this.colunasMulticolumComTotais = colunas;
    }

    public void setDescricao1(String newDescricao1) {
        this.descricao1 = newDescricao1;
    }

    public void setDescricao2(String newDescricao2) {
        this.descricao2 = newDescricao2;
    }

    public void setFonte(Font newValue) {
        this.fonte = newValue;
    }

    public void setLargura(int newLargura) {
        this.largura = newLargura;
    }

    public void setLinhasPorPagina(int newValue) {
        this.linhasPorPagina = newValue;
    }

    public void setTituloCliente(String newValue) {
        this.tituloCliente = newValue;
    }

    public void setTituloPadrao(String newValue) {
        this.tituloPadrao = newValue;
    }

    public void setTituloVisualizacao(String newTituloVisualizacao) {
        this.tituloVisualizacao = newTituloVisualizacao;
    }

    private void tratarMultiColumnListbox(MultiColumnListbox mcListBox) {
        try {
            int nrLin = mcListBox.getRowCount();
            int nrCol = mcListBox.getColumnCount();
            int primeiraCol = -1;
            int ultCol = 0;
            int tamTotal = 0;
            int[] tamCol = new int[nrCol];
            Object[] o = new Object[nrCol];
            String label = "";
            Font fCab = new Font("MonoSpaced", 0, 11);
            FontMetrics fm = mcListBox.getFontMetrics(mcListBox.getFont());
            int tamMaxCaractere = fm.stringWidth("W");
            Cabec cabec = new Cabec(this.getCodigoRelatorio(), this.getTituloPadrao(), this.getDescricao1(), this.getDescricao2(), this.getLargura());
            this.jobImpressao.setVLinhasCabecalho(cabec.getVLinhas());
            int i = 0;
            while (i < nrCol) {
                label = (String)mcListBox.getColumnInfo(i).getLabel();
                if (mcListBox.getColumnInfo(i).isVisible()) {
                    tamCol[i] = mcListBox.getColumnInfo(i).getWidth();
                    tamCol[i] = Math.round(tamCol[i] / tamMaxCaractere);
                    tamCol[i] = tamCol[i] + Math.round(tamCol[i] / 5);
                    if (label.length() > tamCol[i]) {
                        tamCol[i] = label.length();
                    }
                    tamTotal += tamCol[i];
                    if (primeiraCol == -1) {
                        primeiraCol = i;
                    }
                    ultCol = i;
                }
                ++i;
            }
            Linha linha = new Linha();
            linha.setFonte(new Font(this.fonte.getName(), 1, this.fonte.getSize()));
            linha.setTab(5);
            linha.setSalto(true);
            linha.setTexto("");
            i = 0;
            while (i <= ultCol) {
                if (mcListBox.getColumnInfo(i).isVisible()) {
                    if (mcListBox.getColumnInfo(i).getAlignment().isRight()) {
                        linha.setTexto(String.valueOf(linha.getTexto()) + "  " + Util.padR((String)mcListBox.getColumnInfo(i).getLabel(), tamCol[i]));
                    } else {
                        linha.setTexto(String.valueOf(linha.getTexto()) + "  " + Util.padL((String)mcListBox.getColumnInfo(i).getLabel(), tamCol[i]));
                    }
                }
                ++i;
            }
            this.jobImpressao.getVLinhasCabecalho().addElement(linha);
            int l = 0;
            while (l < nrLin) {
                o = mcListBox.getRow(l);
                linha = new Linha();
                linha.setFonte(this.fonte);
                linha.setSalto(true);
                linha.setTab(5);
                linha.setTexto("");
                int c = 0;
                while (c <= ultCol) {
                    if (mcListBox.getColumnInfo(c).isVisible()) {
                        if (o[c] == null) {
                            o[c] = "";
                        }
                        if (this.isTotalizador(c)) {
                            if (this.totais != null && this.totais.get("coluna" + String.valueOf(c)) != null) {
                                this.totais.put("coluna" + String.valueOf(c), new Double((Double)this.totais.get("coluna" + String.valueOf(c)) + Double.valueOf(Util.desformatarValor((String)o[c]))));
                            } else {
                                this.totais.put("coluna" + String.valueOf(c), Double.valueOf(Util.desformatarValor((String)o[c])));
                            }
                        }
                        if (mcListBox.getColumnInfo(c).getAlignment().isRight()) {
                            linha.setTexto(String.valueOf(linha.getTexto()) + "  " + Util.padR((String)o[c], tamCol[c]));
                        } else {
                            linha.setTexto(String.valueOf(linha.getTexto()) + "  " + Util.padL((String)o[c], tamCol[c]));
                        }
                    }
                    ++c;
                }
                this.jobImpressao.getVLinhas().addElement(linha);
                ++l;
            }
            if (this.colunasMulticolumComTotais != null && this.colunasMulticolumComTotais.length != 0) {
                linha = new Linha();
                linha.setFonte(this.fonte);
                linha.setSalto(true);
                linha.setTab(5);
                linha.setTexto("");
                this.jobImpressao.getVLinhas().addElement(linha);
                linha = new Linha();
                linha.setFonte(this.fonte);
                linha.setSalto(true);
                linha.setTab(5);
                linha.setTexto("");
                i = 0;
                while (i <= ultCol) {
                    if (mcListBox.getColumnInfo(i).isVisible()) {
                        if (this.isTotalizador(i)) {
                            if (mcListBox.getColumnInfo(i).getAlignment().isRight()) {
                                linha.setTexto(String.valueOf(linha.getTexto()) + "  " + Util.padR(Util.formatarValor((Double)this.totais.get("coluna" + String.valueOf(i)) / Math.pow(10.0, this.getCasasDecimaisTotalizador(i)), this.getCasasDecimaisTotalizador(i)), tamCol[i]));
                            } else {
                                linha.setTexto(String.valueOf(linha.getTexto()) + "  " + Util.padL(Util.formatarValor((Double)this.totais.get("coluna" + String.valueOf(i)) / Math.pow(10.0, this.getCasasDecimaisTotalizador(i)), this.getCasasDecimaisTotalizador(i)), tamCol[i]));
                            }
                        } else {
                            linha.setTexto(String.valueOf(linha.getTexto()) + "  " + Util.padL(" ", tamCol[i]));
                        }
                    }
                    ++i;
                }
                this.setColunasMulticolumComTotais(null);
                this.totais.clear();
                this.jobImpressao.getVLinhas().addElement(linha);
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    private void tratarVetorLinhas(Vector vLin) {
        Cabec cabec = new Cabec(this.getCodigoRelatorio(), this.getTituloPadrao(), this.getDescricao1(), this.getDescricao2(), this.getLargura());
        this.jobImpressao.setVLinhasCabecalho(cabec.getVLinhas());
        this.jobImpressao.setVLinhas(vLin);
    }

    private void tratarVetorStrings(Vector vStr) {
        Cabec cabec = new Cabec(this.getCodigoRelatorio(), this.getTituloPadrao(), this.getDescricao1(), this.getDescricao2(), this.getLargura());
        boolean indNovaPagina = false;
        this.jobImpressao.setVLinhasCabecalho(cabec.getVLinhas());
        int i = 0;
        while (i < vStr.size()) {
            String texto = (String)vStr.elementAt(i);
            if (texto.equalsIgnoreCase("/NP")) {
                indNovaPagina = true;
            } else {
                Linha linha = new Linha(texto);
                linha.setSalto(true);
                if (indNovaPagina) {
                    linha.setNovaPagina(true);
                    indNovaPagina = false;
                }
                this.jobImpressao.getVLinhas().addElement(linha);
            }
            ++i;
        }
    }
}

