/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.impressao;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.FileOutputStream;

public class GravaImagemBmp
extends Component {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 196608;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int[] bitmap;
    private FileOutputStream fo;

    private boolean convertImage(Image parImage, int parWidth, int parHeight) throws Throwable {
        this.bitmap = new int[parWidth * parHeight];
        PixelGrabber pg = new PixelGrabber(parImage, 0, 0, parWidth, parHeight, this.bitmap, 0, parWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        int pad = (4 - parWidth * 3 % 4) * parHeight;
        this.biSizeImage = parWidth * parHeight * 3 + pad;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = parWidth;
        this.biHeight = parHeight;
        return true;
    }

    private byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }

    private byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    public void salvarBitmap(String nomeArquivo, Image imagem, int comprimento, int altura) throws Throwable {
        try {
            this.fo = new FileOutputStream(nomeArquivo);
            this.save(imagem, comprimento, altura);
            this.fo.close();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private void save(Image parImage, int parWidth, int parHeight) throws Throwable {
        try {
            this.convertImage(parImage, parWidth, parHeight);
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private void writeBitmap() throws Throwable {
        int rowIndex;
        byte[] rgb = new byte[3];
        int size = this.biWidth * this.biHeight - 1;
        int pad = 4 - this.biWidth * 3 % 4;
        if (pad == 4) {
            pad = 0;
        }
        int rowCount = 1;
        int padCount = 0;
        int lastRowIndex = rowIndex = size - this.biWidth;
        try {
            int j = 0;
            while (j < size) {
                int value = this.bitmap[rowIndex];
                rgb[0] = (byte)(value & 0xFF);
                rgb[1] = (byte)(value >> 8 & 0xFF);
                rgb[2] = (byte)(value >> 16 & 0xFF);
                this.fo.write(rgb);
                if (rowCount == this.biWidth) {
                    padCount += pad;
                    int i = 1;
                    while (i <= pad) {
                        this.fo.write(0);
                        ++i;
                    }
                    rowCount = 1;
                    lastRowIndex = rowIndex = lastRowIndex - this.biWidth;
                } else {
                    ++rowCount;
                }
                ++rowIndex;
                ++j;
            }
            this.bfSize += padCount - pad;
            this.biSizeImage += padCount - pad;
        }
        catch (Exception wb) {
            wb.printStackTrace();
        }
    }

    private void writeBitmapFileHeader() throws Throwable {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize));
            this.fo.write(this.intToWord(this.bfReserved1));
            this.fo.write(this.intToWord(this.bfReserved2));
            this.fo.write(this.intToDWord(this.bfOffBits));
        }
        catch (Exception wbfh) {
            wbfh.printStackTrace();
        }
    }

    private void writeBitmapInfoHeader() throws Throwable {
        try {
            this.fo.write(this.intToDWord(this.biSize));
            this.fo.write(this.intToDWord(this.biWidth));
            this.fo.write(this.intToDWord(this.biHeight));
            this.fo.write(this.intToWord(this.biPlanes));
            this.fo.write(this.intToWord(this.biBitCount));
            this.fo.write(this.intToDWord(this.biCompression));
            this.fo.write(this.intToDWord(this.biSizeImage));
            this.fo.write(this.intToDWord(this.biXPelsPerMeter));
            this.fo.write(this.intToDWord(this.biYPelsPerMeter));
            this.fo.write(this.intToDWord(this.biClrUsed));
            this.fo.write(this.intToDWord(this.biClrImportant));
        }
        catch (Exception wbih) {
            wbih.printStackTrace();
        }
    }
}

