/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.impressao;

import br.com.bb.plugins.controle.impressao.Cabec;
import br.com.bb.plugins.controle.impressao.ControleImpressao;
import br.com.bb.plugins.controle.impressao.FrameVisualizacao;
import br.com.bb.plugins.controle.impressao.Imprimindo;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.Font;
import java.util.Vector;

public class JobImpressao
extends Thread {
    private boolean numeracaoPagina = false;
    private Vector vLinhasCabecalho = null;
    private Vector vLinhas = null;
    private String titulo = null;
    private int numeroLinhasPagina = 58;
    private boolean cabecalhoPadrao = true;
    public Font fontePadrao = new Font("Serif", 0, 11);
    private String titulo2 = "";
    private boolean mensagemImpressaoConcluida = true;
    private Imprimindo imprimindo = null;
    private int largura = 80;
    private Vector paginasImpressao;

    public JobImpressao() {
    }

    public JobImpressao(String titulo) {
        this.titulo = titulo;
        this.titulo2 = null;
    }

    public JobImpressao(String titulo, String titulo2) {
        this.titulo = titulo;
        this.titulo2 = titulo2;
    }

    public JobImpressao(String titulo, String titulo2, boolean msgFim, boolean cabecalho) {
        this.titulo = titulo;
        this.titulo2 = titulo2;
        this.mensagemImpressaoConcluida = msgFim;
        this.cabecalhoPadrao = cabecalho;
    }

    public Font getFontePadrao() {
        return this.fontePadrao;
    }

    private Imprimindo getImprimindo() {
        return this.imprimindo;
    }

    public int getLargura() {
        return this.largura;
    }

    public boolean getNumeracaoPagina() {
        return this.numeracaoPagina;
    }

    public int getNumeroLinhasPagina() {
        return this.numeroLinhasPagina;
    }

    public Vector getPaginasImpressao() {
        return this.paginasImpressao;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public String getTitulo2() {
        return this.titulo2;
    }

    public Vector getVLinhas() {
        if (this.vLinhas == null) {
            this.vLinhas = new Vector();
        }
        return this.vLinhas;
    }

    public Vector getVLinhasCabecalho() {
        if (this.vLinhasCabecalho == null && this.titulo != null) {
            Cabec cabec = this.titulo2 != null ? new Cabec(this.titulo, this.titulo2) : new Cabec(this.titulo);
            this.vLinhasCabecalho = cabec.getVLinhas();
        }
        return this.vLinhasCabecalho;
    }

    private void handleException(Throwable exception) {
        Util.exibirMensagemErro(exception);
    }

    public boolean imprime() {
        try {
            this.imprimindo = new Imprimindo(this, this.getNumeroLinhasPagina(), this.getLargura());
            this.start();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isCabecalhoPadrao() {
        return this.cabecalhoPadrao;
    }

    public boolean isMensagemImpressaoConcluida() {
        return this.mensagemImpressaoConcluida;
    }

    public void run() {
        try {
            this.imprimindo.imprimir();
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public void setFontePadrao(Font newValue) {
        this.fontePadrao = newValue;
    }

    private void setImprimindo(Imprimindo newImprimindo) {
        this.imprimindo = newImprimindo;
    }

    public void setLargura(int newLargura) {
        this.largura = newLargura;
    }

    public void setNumeracaoPagina(boolean newValue) {
        this.numeracaoPagina = newValue;
    }

    public void setNumeroLinhasPagina(int newValue) {
        this.numeroLinhasPagina = newValue;
    }

    public void setPaginasImpressao(Vector newPaginasImpressao) {
        this.paginasImpressao = newPaginasImpressao;
    }

    public void setTitulo(String newValue) {
        this.titulo = newValue;
    }

    public void setTitulo2(String newValue) {
        this.titulo2 = newValue;
    }

    public void setVLinhas(Vector newValue) {
        this.vLinhas = newValue;
    }

    public void setVLinhasCabecalho(Vector newValue) {
        this.vLinhasCabecalho = newValue;
    }

    public boolean visualizar() {
        try {
            FrameVisualizacao frameVisualizacao = new FrameVisualizacao(this, this.getNumeroLinhasPagina(), this.getLargura());
            frameVisualizacao.setTitle(ControleImpressao.getControle().getTituloVisualizacao());
            frameVisualizacao.show();
            frameVisualizacao.setZoom("3.0");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

