/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.impressao;

import br.com.bb.plugins.controle.impressao.newLine;
import br.com.bb.plugins.controle.impressao.printFont;
import br.com.bb.plugins.controle.impressao.printString;
import br.com.bb.plugins.controle.impressao.printTab;
import br.com.bb.plugins.controle.impressao.printerObject;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.util.Vector;

public class Printer
extends Canvas {
    Frame f;
    PrintJob pjob;
    Graphics pg;
    Vector objects;
    Point pt;
    Font fnt;
    Font tabFont;

    public Printer() {
    }

    public Printer(Frame frm) {
        this.f = frm;
        this.f.add(this);
        this.setVisible(false);
        this.pjob = null;
        this.pt = new Point(0, 0);
        this.objects = new Vector();
        this.tabFont = new Font("MonoSpaced", 0, 12);
        this.fnt = new Font("SansSerif", 0, 12);
    }

    public void endJob() {
        this.pjob.end();
        this.f.remove(this);
    }

    public void finalize() {
        if (this.objects.size() > 0) {
            this.newPage();
        }
        this.endJob();
    }

    public boolean newPage() {
        if (this.pjob == null) {
            this.pjob = this.getToolkit().getPrintJob(this.f, "Printer", null);
        }
        if (this.pjob == null) {
            return false;
        }
        this.pg = this.pjob.getGraphics();
        this.print(this.pg);
        this.pg.dispose();
        this.pt = new Point(0, 0);
        this.objects = new Vector();
        return true;
    }

    public Dimension pageSize() {
        if (this.pjob == null) {
            return new Dimension(620, 790);
        }
        this.pjob = this.getToolkit().getPrintJob(this.f, "Printer", null);
        return this.pjob.getPageDimension();
    }

    public void paint(Graphics g) {
        this.pt = new Point(0, 0);
        this.print(g);
    }

    public void print(Graphics g) {
        this.f.setFont(this.fnt);
        int i = 0;
        while (i < this.objects.size()) {
            printerObject p = (printerObject)this.objects.elementAt(i);
            p.draw(g, this.pt);
            ++i;
        }
    }

    public void print(String s) {
        this.objects.addElement(new printString(s));
    }

    public void println(String s) {
        this.print(s);
        this.objects.addElement(new newLine());
    }

    public void setFont(Font f) {
        this.objects.addElement(new printFont(f));
    }

    public void tab(int tabstop) {
        this.objects.addElement(new printTab(this.tabFont, tabstop));
    }

    public void tab(Font font, int tabstop) {
        this.objects.addElement(new printTab(font, tabstop));
    }
}

