/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.ControleInstalacao;
import br.com.bb.plugins.controle.infraestrutura.ControleSessao;
import br.com.bb.plugins.interfaces.infraestrutura.DialogSenha;
import br.com.bb.plugins.negocio.comum.ContaCorrente;
import br.com.bb.plugins.negocio.comum.Convenente;
import br.com.bb.plugins.negocio.comum.Identificacao;
import br.com.bb.plugins.negocio.comum.Plugin;
import br.com.bb.plugins.negocio.infraestrutura.Usuario;
import br.com.bb.plugins.persistencia.comum.ContaCorrenteBD;
import br.com.bb.plugins.persistencia.comum.ConvenenteBD;
import br.com.bb.plugins.persistencia.comum.IdentificacaoBD;
import br.com.bb.plugins.persistencia.comum.PessoaBD;
import br.com.bb.plugins.persistencia.comum.PluginBD;
import br.com.bb.plugins.persistencia.infraestrutura.UsuarioBD;
import br.com.bb.plugins.utilitarios.Criptografia;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;

public abstract class ControleAcesso {
    private static Usuario usuario;

    public static Usuario getUsuario() {
        return usuario;
    }

    public static void inicializar(String chave, String senha) {
    }

    public static void obterPermissoes(Vector listaPermissoes) {
    }

    public static void obterPermissoesPlugin(Plugin plugin, Vector listaTransacoes) {
    }

    public static void obterPluginsPermitidos(Vector listaPlugins) {
    }

    public static void setAcessoDemonstracao() {
        try {
            usuario = new Usuario();
            usuario.setCodigoChave("Demonstra\u00e7\u00e3o");
            usuario.setNomeUsuario("Demonstra\u00e7\u00e3o");
            Convenente convenente = new Convenente();
            convenente.getPessoa().setCodigoPessoa("0000500");
            if (!ConvenenteBD.getConvenenteBD().localizado(convenente)) {
                convenente.getPessoa().setNomePessoa("Empresa de Demonstra\u00e7\u00e3o LTDA");
                convenente.getPessoa().setTextoCidade("Demonstra\u00e7\u00e3o");
                convenente.getPessoa().setTextoEndereco("Demonstra\u00e7\u00e3o");
                convenente.getPessoa().setCodigoUFRel("DF");
                if (!PessoaBD.getPessoaBD().localizado(convenente.getPessoa())) {
                    PessoaBD.getPessoaBD().adicionar(convenente.getPessoa());
                }
                Identificacao identificacao = new Identificacao();
                identificacao.setCodigoPessoaRel("0000500");
                identificacao.setCodigoIdentificador("CNPJ");
                identificacao.setNumeroIdentificador("99999999999999");
                identificacao.setCodigoPessoaIdentificadorRel("0000002");
                IdentificacaoBD.getIdentificacaoBD().salvar(identificacao);
                ConvenenteBD.getConvenenteBD().salvar(convenente);
            } else {
                ConvenenteBD.getConvenenteBD().obter(convenente);
            }
            ControleAplicacao.setConvenente(convenente);
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void trocarSenha(String senha, String novaSenha) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean validarAcesso(String chave, String senha) throws Throwable {
        usuario = new Usuario();
        usuario.setCodigoChave(chave);
        UsuarioBD.getUsuarioBD().obter(usuario);
        if (usuario.getTextoSenha() == null) {
            throw new Throwable("Usu\u00e1rio n\u00e3o cadastrado!");
        }
        if (chave.equalsIgnoreCase("admin") && ControleInstalacao.getInstance().obterStatus().equalsIgnoreCase("C")) {
            ControleInstalacao.getInstance().setStatus("F");
        }
        if (!usuario.verificarSenha(senha)) {
            if (!chave.equalsIgnoreCase("admin")) throw new Throwable("Senha n\u00e3o confere!");
            if (!ControleAcesso.verificarSeChaveMestra(senha)) throw new Throwable("Senha n\u00e3o confere!");
            DialogSenha ds = new DialogSenha((Frame)ControleAplicacao.getFramePlugin(), true);
            ds.show();
        }
        if (!ControleAcesso.verificarSePrimeiroLogin()) {
            throw new Throwable("Acesso n\u00e3o permitido!");
        }
        if (ControleSessao.iniciarSessao(usuario)) return true;
        throw new Throwable("Sess\u00e3o n\u00e3o pode ser iniciada!");
    }

    private static boolean verificarSeChaveMestra(String senha) {
        boolean mestra = false;
        if (senha.length() < 11) {
            return false;
        }
        try {
            Vector vConvenentes = ConvenenteBD.getConvenenteBD().obterLista();
            int i = 0;
            while (i < vConvenentes.size()) {
                ContaCorrente contaCorrente = new ContaCorrente();
                contaCorrente.setCodigoPessoaBancoRel("0000001");
                contaCorrente.getPessoa().setCodigoPessoa(((Convenente)vConvenentes.elementAt(i)).getPessoa().getCodigoPessoa());
                Vector contasCorrentes = ContaCorrenteBD.getContaCorrenteBD().obterLista(contaCorrente);
                int j = 0;
                while (j < contasCorrentes.size()) {
                    contaCorrente = (ContaCorrente)contasCorrentes.elementAt(j);
                    if (contaCorrente.getcodigoPrefixoAgenciaRel() != null && contaCorrente.getnumeroContaCorrente() != null && senha.equalsIgnoreCase(Criptografia.obterChaveMestra(contaCorrente.getcodigoPrefixoAgenciaRel(), contaCorrente.getnumeroContaCorrente()))) {
                        Plugin plugin = new Plugin();
                        plugin.setCodigoPlugin(ControleAplicacao.getPlugin().getCodigoPlugin());
                        PluginBD.getPluginBD().obter(plugin);
                        if (Util.formatarData(new Date(), "AAAAMMDD").compareTo(Util.formatarData(plugin.getDataInstalacao(), "AAAAMMDD")) > 0) {
                            plugin.setDataInstalacao(new Date());
                            PluginBD.getPluginBD().salvar(plugin);
                            mestra = true;
                            break;
                        }
                        Util.exibirMensagemErro(new Exception("Chave de acesso j\u00e1 utilizada. Procure o suporte."));
                    }
                    ++j;
                }
                if (!mestra) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Throwable ex) {
            Util.exibirMensagemErro(ex);
        }
        return mestra;
    }

    private static boolean verificarSePrimeiroLogin() {
        return true;
    }
}

