/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.IInterfaceExportacao;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.controle.infraestrutura.RoteadorUtilitarios;
import br.com.bb.plugins.negocio.infraestrutura.ArquivoRemessa;
import br.com.bb.plugins.negocio.infraestrutura.Leiaute;
import br.com.bb.plugins.persistencia.infraestrutura.ArquivoRemessaBD;
import br.com.bb.plugins.persistencia.infraestrutura.LeiauteBD;
import br.com.bb.plugins.persistencia.infraestrutura.TipoLeiauteBD;
import br.com.bb.plugins.utilitarios.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class ControleExportacao
extends Roteador {
    private static ControleExportacao controleExportacao = null;
    private IInterfaceExportacao interfaceExportacao;

    private ControleExportacao() {
    }

    public String exportar(Leiaute leiaute, Vector stringCampoLeiaute, IInterfaceExportacao interfaceExportacao, Vector listaObjetoPlugin) throws Throwable {
        if (listaObjetoPlugin.size() == 0) {
            RoteadorUtilitarios.getRoteadorUtilitarios().exibirMensagem("N\u00e3o existem registros a serem exportados.");
            return "";
        }
        Date dataAtual = new Date();
        Calendar dataHoje = Calendar.getInstance();
        dataHoje.setTime(dataAtual);
        String data = Util.dataSql(dataHoje.getTime()).toString();
        String dia = data.substring(8, 10);
        String mes = data.substring(5, 7);
        IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
        ArquivoRemessa ar = new ArquivoRemessa();
        int contadorArquivo = 0;
        try {
            ar = ArquivoRemessaBD.obterArquivoImportacao(leiaute);
            interfaceExportacao.iniciarExportacao();
            File arq = new File(String.valueOf(ControleAplicacao.getDiretorioRemessa()) + "EXPORT_" + ControleAplicacao.getPlugin().getCodigoPlugin() + "_" + Util.strZero(String.valueOf(contadorArquivo), 3) + ".TXT");
            while (arq.exists()) {
                arq = new File(String.valueOf(ControleAplicacao.getDiretorioRemessa()) + "EXPORT_" + ControleAplicacao.getPlugin().getCodigoPlugin() + "_" + Util.strZero(String.valueOf(++contadorArquivo), 3) + ".TXT");
            }
            ar.abrirArquivoSaida(arq);
            FileOutputStream arqExp = new FileOutputStream(arq.toString(), true);
            PrintWriter registro = new PrintWriter(arqExp);
            StringBuffer stringBuffer = new StringBuffer(leiaute.getTamanhoRegistro());
            barra.setValorMaximo(listaObjetoPlugin.size());
            barra.inicializar("Exportando dados. Aguarde...", listaObjetoPlugin.size(), false);
            String[] itensPesquisar = null;
            int t = 0;
            while (t < listaObjetoPlugin.size()) {
                stringBuffer.insert(0, Util.padL(" ", leiaute.getTamanhoRegistro()));
                itensPesquisar = (String[])listaObjetoPlugin.elementAt(t);
                barra.setValor(t);
                int i = 0;
                while (i < stringCampoLeiaute.size()) {
                    stringBuffer = interfaceExportacao.exportar(leiaute, stringBuffer, registro, stringCampoLeiaute.elementAt(i), itensPesquisar);
                    ++i;
                }
                registro.println(Util.padL(stringBuffer.toString(), leiaute.getTamanhoRegistro()));
                stringBuffer = new StringBuffer();
                ++t;
            }
            ar.fecharArquivoSaida();
            registro.close();
            arqExp.close();
            barra.finalizar();
            interfaceExportacao.finalizarExportacao();
            barra = this.getFramePlugin().obterBarraProgresso();
            return arq.toString();
        }
        catch (Throwable t) {
            t.getMessage();
            try {
                barra.finalizar();
                interfaceExportacao.abortarExportacao(t);
                try {
                    ar.fecharArquivoEntrada();
                }
                catch (Throwable t1) {
                    this.exibirMensagemErro(t1);
                }
            }
            catch (Throwable t1) {
                barra.finalizar();
                this.exibirMensagemErro(t1);
            }
            return "";
        }
    }

    public static ControleExportacao getControleExportacao() {
        if (controleExportacao == null) {
            controleExportacao = new ControleExportacao();
        }
        return controleExportacao;
    }

    public Leiaute obterLeiaute(Leiaute leiaute) throws SQLException {
        LeiauteBD.getLeiauteBD().obter(leiaute);
        return leiaute;
    }

    public Vector obterListaLeiaute(String codigoLeiaute) throws SQLException {
        return LeiauteBD.getLeiauteBD().obterLista(codigoLeiaute);
    }

    public Vector obterListaTipoLeiaute() throws SQLException {
        return TipoLeiauteBD.getTipoLeiauteBD().obterLista();
    }
}

