/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleAcesso;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.negocio.infraestrutura.StatusInstalacao;
import br.com.bb.plugins.persistencia.comum.PluginBD;
import br.com.bb.plugins.persistencia.infraestrutura.GeradorTabelas;
import br.com.bb.plugins.persistencia.infraestrutura.GeradorTabelasListener;
import br.com.bb.plugins.persistencia.infraestrutura.InstalacaoBD;
import java.awt.Component;
import java.awt.Cursor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ControleInstalacao
extends Roteador
implements GeradorTabelasListener {
    private static ControleInstalacao instance = null;
    private IBarraProgresso barraProgresso;

    public void geracaoCancelada(Throwable exception) {
        this.exibirMensagemErro(exception);
        ControleAplicacao.getRoteadorPlugins().sairSemConfirmacao();
    }

    public void geracaoIniciada() {
        this.getFramePlugin().exibir();
        this.getBarraProgresso().inicializar("Verificando estrutura...", 100, false);
        ((Component)this.getFramePlugin()).setCursor(new Cursor(3));
    }

    public void geracaoTerminada() {
        this.getBarraProgresso().setValor(100);
        this.getBarraProgresso().setMensagem("Processo conclu\u00eddo");
        try {
            if (this.obterStatus().equals("N")) {
                StatusInstalacao si = new StatusInstalacao();
                this.setStatus("T");
            }
            this.getBarraProgresso().finalizar();
            ((Component)this.getFramePlugin()).setCursor(new Cursor(0));
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
            ControleAplicacao.getRoteadorPlugins().sairSemConfirmacao();
        }
    }

    private IBarraProgresso getBarraProgresso() {
        if (this.barraProgresso == null) {
            this.setBarraProgresso(this.getFramePlugin().obterBarraProgresso());
        }
        return this.barraProgresso;
    }

    public static ControleInstalacao getInstance() {
        if (instance == null) {
            instance = new ControleInstalacao();
        }
        return instance;
    }

    public void gravarTabelaInstalacao() {
        try {
            InstalacaoBD.getInstalacaoBD().gravarTabelaInstalacao();
        }
        catch (SQLException ex) {
            ControleAplicacao.getRoteadorPlugins().exibirMensagem("N\u00e3o foi poss\u00edvel gravar dados da instala\u00e7\u00e3o. Reinstale o aplicativo");
            ControleAplicacao.getRoteadorPlugins().sairSemConfirmacao();
        }
    }

    public void inicializandoGeracao() {
        this.getBarraProgresso().inicializar("Atualiza\u00e7\u00e3o de base de dados...", 100, false);
    }

    public String obterStatus() throws Exception {
        try {
            StatusInstalacao statusInstalacao = new StatusInstalacao();
            InstalacaoBD.getInstalacaoBD().obter(statusInstalacao);
            return statusInstalacao.getStatus();
        }
        catch (SQLException ex) {
            if (InstalacaoBD.getInstalacaoBD().obterNomeBD() != null) {
                this.gravarTabelaInstalacao();
                return "N";
            }
            throw new Exception("Banco de dados n\u00e3o pode ser conectado. Tente novamente ou reinstale o aplicativo");
        }
    }

    public void percentualConcluido(int percentual) {
        this.getBarraProgresso().setValor(percentual);
    }

    private void setBarraProgresso(IBarraProgresso newBarraProgresso) {
        this.barraProgresso = newBarraProgresso;
    }

    public void setStatus(String status) {
        try {
            StatusInstalacao statusInstalacao = new StatusInstalacao();
            statusInstalacao.setStatus(status);
            InstalacaoBD.getInstalacaoBD().alterar(statusInstalacao);
        }
        catch (SQLException ex) {
            this.exibirMensagemErro(ex);
        }
    }

    public void verificarAtualizacao() {
        block11: {
            File arquivoAtualizacao = new File(String.valueOf(ControleAplicacao.getDiretorioDados()) + this.getPlugin().getCodigoPlugin().toLowerCase() + ".bba");
            String versao = null;
            ZipFile zf = null;
            double nroTotalBytes = 0.0;
            double nroBytesLidos = 0.0;
            if (!arquivoAtualizacao.exists()) {
                return;
            }
            try {
                InputStream is;
                FileInputStream fis = null;
                fis = new FileInputStream(arquivoAtualizacao);
                byte[] b = new byte[2];
                fis.read(b);
                String header = new String(b);
                fis.close();
                if (!header.equalsIgnoreCase("PK")) {
                    throw new Throwable("Arquivo inv\u00e1lido!");
                }
                b = new byte[512];
                zf = new ZipFile(arquivoAtualizacao);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                ZipEntry ze = null;
                while (entries.hasMoreElements()) {
                    ze = entries.nextElement();
                    if (ze.getName().equalsIgnoreCase("versao.txt")) {
                        is = zf.getInputStream(ze);
                        is.read(b);
                        versao = new String(b, 0, 7);
                        is.close();
                        continue;
                    }
                    nroTotalBytes += (double)ze.getSize();
                }
                zf.close();
                if (versao != null && versao.compareTo(this.getPlugin().getTextoVersao()) > 0 && this.exibirMensagemConfirmacao("Atualiza\u00e7\u00e3o de vers\u00e3o", "Arquivo de atualiza\u00e7\u00e3o da vers\u00e3o " + versao + " (" + arquivoAtualizacao + ") recebida. Deseja atualizar agora?")) {
                    this.getFramePlugin().setCursor(Cursor.getPredefinedCursor(3));
                    IBarraProgresso barraProgresso = this.obterBarraProgresso();
                    barraProgresso.inicializar("Atualizando vers\u00e3o...", 100, false);
                    zf = new ZipFile(arquivoAtualizacao);
                    entries = zf.entries();
                    while (entries.hasMoreElements()) {
                        int lidos;
                        ze = entries.nextElement();
                        if (ze.getName().equalsIgnoreCase("versao.txt")) continue;
                        barraProgresso.setMensagem("Atualizando " + ze.getName());
                        is = zf.getInputStream(ze);
                        FileOutputStream os = new FileOutputStream(String.valueOf(ControleAplicacao.getDiretorioClasses()) + ze.getName());
                        b = new byte[512];
                        int totalLidos = 0;
                        long tamanho = ze.getSize();
                        while ((lidos = is.read(b)) > 0) {
                            totalLidos += lidos;
                            os.write(b, 0, lidos);
                            barraProgresso.setValor((int)((nroBytesLidos += (double)lidos) / nroTotalBytes * 100.0));
                        }
                        is.close();
                        os.close();
                    }
                    zf.close();
                    barraProgresso.finalizar();
                    this.getFramePlugin().setCursor(Cursor.getDefaultCursor());
                    this.exibirMensagem("O aplicativo foi atualizado! Ser\u00e1 necess\u00e1rio reinici\u00e1-lo!");
                    System.exit(0);
                }
            }
            catch (Throwable t) {
                this.getFramePlugin().setCursor(Cursor.getDefaultCursor());
                this.exibirMensagem("Arquivo de atualiza\u00e7\u00e3o de vers\u00e3o " + arquivoAtualizacao + " n\u00e3o \u00e9 um arquivo v\u00e1lido. Receba novamente o arquivo.");
                try {
                    zf.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                arquivoAtualizacao.delete();
                if (!arquivoAtualizacao.exists()) break block11;
                arquivoAtualizacao.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verificarDownloadAtualizacao() {
        URL url = null;
        URL url14 = null;
        boolean www14 = false;
        URLConnection urlConnection = null;
        URLConnection urlConnection14 = null;
        Object input = null;
        String versao = null;
        if (!this.exibirMensagemConfirmacao("Atualiza\u00e7\u00e3o de vers\u00e3o", "O aplicativo tentar\u00e1 localizar nova vers\u00e3o no servidor do Banco do Brasil. Confirma?")) {
            return;
        }
        IBarraProgresso barraProgresso = this.obterBarraProgresso();
        try {
            block23: {
                try {
                    this.getFramePlugin().setCursor(Cursor.getPredefinedCursor(3));
                    String urlOfficePlugins = "http://office.bancobrasil.com.br/office/plugins/";
                    String urlOfficePlugins14 = "http://www14.bancobrasil.com.br/office/plugins/";
                    barraProgresso.inicializar("Localizando servidor...", 100, false);
                    try {
                        url14 = new URL(String.valueOf(urlOfficePlugins14) + this.getPlugin().getCodigoPlugin().toLowerCase() + "/versao.txt");
                        url = new URL(String.valueOf(urlOfficePlugins) + this.getPlugin().getCodigoPlugin().toLowerCase() + "/versao.txt");
                    }
                    catch (MalformedURLException mue) {
                        throw new Throwable("Erro na conex\u00e3o! " + mue);
                    }
                    try {
                        urlConnection14 = url14.openConnection();
                        urlConnection = url.openConnection();
                    }
                    catch (IOException ioe) {
                        throw new Throwable("N\u00e3o foi poss\u00edvel conectar o servidor do Banco do Brasil.  Verifique sua conex\u00e3o e tente novamente.");
                    }
                    barraProgresso.setValor(50);
                    barraProgresso.setMensagem("Obtendo n\u00famero da vers\u00e3o dispon\u00edvel.");
                    try {
                        input = urlConnection14.getContent();
                        if (input instanceof BufferedInputStream) {
                            input = urlConnection.getContent();
                            if (input instanceof BufferedInputStream) {
                                throw new Throwable("N\u00e3o h\u00e1 vers\u00e3o dispon\u00edvel nos servidores do Banco do Brasil");
                            }
                        } else {
                            www14 = true;
                        }
                        versao = null;
                        InputStream ptis = (InputStream)input;
                        byte[] b = new byte[7];
                        ptis.read(b);
                        versao = new String(b);
                        ptis.close();
                    }
                    catch (IOException ioe) {
                        throw new Throwable("N\u00e3o h\u00e1 vers\u00e3o dispon\u00edvel nos servidores do Banco do Brasil.");
                    }
                    try {
                        url = www14 ? new URL(String.valueOf(urlOfficePlugins14) + this.getPlugin().getCodigoPlugin().toLowerCase() + "/" + this.getPlugin().getCodigoPlugin().toLowerCase() + ".bba") : new URL(String.valueOf(urlOfficePlugins) + this.getPlugin().getCodigoPlugin().toLowerCase() + "/" + this.getPlugin().getCodigoPlugin().toLowerCase() + ".bba");
                    }
                    catch (MalformedURLException mue) {
                        throw new Throwable("Erro na conex\u00e3o! " + mue);
                    }
                    if (versao.compareTo(this.getPlugin().getTextoVersao()) > 0) {
                        long total;
                        barraProgresso.setValor(66);
                        barraProgresso.setMensagem("Obtendo informa\u00e7\u00f5es do arquivo de atualiza\u00e7\u00e3o.");
                        try {
                            urlConnection = url.openConnection();
                            total = urlConnection.getContentLength();
                            if (total < 1000L) {
                                throw new Throwable("Arquivo n\u00e3o dispon\u00edvel no servidor do Banco do Brasil.");
                            }
                        }
                        catch (IOException ioe) {
                            throw new Throwable("N\u00e3o foi poss\u00edvel obter informa\u00e7\u00f5es sobre a vers\u00e3o. Verifique a conex\u00e3o e tente novamente.");
                        }
                        barraProgresso.setValor(100);
                        barraProgresso.setMensagem("Vers\u00e3o localizada.");
                        this.getFramePlugin().setCursor(Cursor.getDefaultCursor());
                        if (this.exibirMensagemConfirmacao("Atualiza\u00e7\u00e3o de vers\u00e3o", "Vers\u00e3o " + versao + " do aplicativo dispon\u00edvel. Deseja baixar o arquivo agora? (" + total / 1024L + " KB)")) {
                            barraProgresso.finalizar();
                            final IBarraProgresso barraProgresso1 = this.obterBarraProgresso();
                            barraProgresso1.inicializar("Recebendo arquivo de atualiza\u00e7\u00e3o de vers\u00e3o...", 100, true);
                            final URL url1 = url;
                            final long total1 = total;
                            Thread thread = new Thread(new Runnable(){

                                public void run() {
                                    try {
                                        File arquivoRecebido = new File(String.valueOf(ControleAplicacao.getDiretorioDados()) + ControleInstalacao.this.getPlugin().getCodigoPlugin().toLowerCase() + ".bba");
                                        FileOutputStream fos = null;
                                        InputStream is = null;
                                        BufferedInputStream bis = null;
                                        try {
                                            int lidos;
                                            is = url1.openStream();
                                            bis = new BufferedInputStream(is);
                                            fos = new FileOutputStream(arquivoRecebido);
                                            long totalLido = 0L;
                                            byte[] b1 = new byte[512];
                                            while ((lidos = bis.read(b1)) > 0) {
                                                barraProgresso1.setValor((int)((double)(totalLido += (long)lidos) * 1.0 / ((double)total1 * 1.0) * 100.0));
                                                ((Component)((Object)barraProgresso1)).repaint();
                                                fos.write(b1, 0, lidos);
                                                if (barraProgresso1.isCancelado() && ControleInstalacao.this.exibirMensagemConfirmacao("Atualiza\u00e7\u00e3o de vers\u00e3o", "Deseja cancelar a recep\u00e7\u00e3o do arquivo de atualiza\u00e7\u00e3o?")) break;
                                                barraProgresso1.setCancelado(false);
                                            }
                                            bis.close();
                                            fos.close();
                                            if (totalLido != total1) {
                                                arquivoRecebido.delete();
                                                throw new Throwable("Arquivo recebido est\u00e1 incompleto. Execute a atualiza\u00e7\u00e3o novamente.");
                                            }
                                        }
                                        catch (IOException ioe) {
                                            try {
                                                bis.close();
                                                fos.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            if (arquivoRecebido.exists()) {
                                                arquivoRecebido.delete();
                                            }
                                            throw new Throwable("Erro na recep\u00e7\u00e3o do arquivo. Verifique a conex\u00e3o e o espa\u00e7o em disco e tente novamente.");
                                        }
                                        barraProgresso1.finalizar();
                                        ControleInstalacao.this.verificarAtualizacao();
                                    }
                                    catch (Throwable t) {
                                        barraProgresso1.finalizar();
                                        ControleInstalacao.this.exibirMensagem(t.getMessage());
                                    }
                                }
                            });
                            thread.start();
                            break block23;
                        } else {
                            barraProgresso.finalizar();
                        }
                        break block23;
                    }
                    barraProgresso.setValor(100);
                    barraProgresso.setMensagem("Vers\u00e3o localizada.");
                    this.getFramePlugin().setCursor(Cursor.getDefaultCursor());
                    this.exibirMensagem("A vers\u00e3o atualmente instalada \u00e9 a vers\u00e3o atual do aplicativo.");
                    barraProgresso.finalizar();
                }
                catch (Throwable t) {
                    this.exibirMensagem(t.getMessage());
                    barraProgresso.finalizar();
                }
            }
            Object var18_26 = null;
            this.getFramePlugin().setCursor(Cursor.getDefaultCursor());
            return;
        }
        catch (Throwable throwable) {
            Object var18_25 = null;
            this.getFramePlugin().setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    public void verificarStatusInstalacao() {
        try {
            this.verificarAtualizacao();
            GeradorTabelas gt = new GeradorTabelas();
            gt.addGeradorTabelasListener(this);
            gt.verSeAtualizouTabelas(ControleAplicacao.getPlugin());
            if (this.obterStatus().equalsIgnoreCase("N")) {
                ControleAplicacao.getPlugin().setDataInstalacao(ControleAplicacao.getDataAtual());
                PluginBD.getPluginBD().salvar(ControleAplicacao.getPlugin());
            }
            if (this.obterStatus().equalsIgnoreCase("T")) {
                if (this.exibirMensagemConfirmacao("Banco do Brasil", "Utilizar o aplicativo no modo DEMONSTRA\u00c7\u00c3O?")) {
                    ControleAcesso.setAcessoDemonstracao();
                    ControleAplicacao.getRoteadorPlugins().configurarDemonstracao();
                    this.setStatus("D");
                    return;
                }
                if (ControleAplicacao.getRoteadorPlugins().configurarAplicativo()) {
                    this.setStatus("C");
                } else {
                    ControleAplicacao.getRoteadorPlugins().sairSemConfirmacao();
                }
            }
            if (this.obterStatus().equalsIgnoreCase("D")) {
                if (!this.exibirMensagemConfirmacao("Banco do Brasil", "Continuar utilizando o aplicativo no modo DEMONSTRA\u00c7\u00c3O?")) {
                    if (ControleAplicacao.getRoteadorPlugins().configurarAplicativo()) {
                        this.setStatus("C");
                    } else {
                        ControleAplicacao.getRoteadorPlugins().sairSemConfirmacao();
                    }
                } else {
                    ControleAcesso.setAcessoDemonstracao();
                    return;
                }
            }
            if (this.obterStatus().equalsIgnoreCase("C")) {
                this.exibirMensagem("Aten\u00e7\u00e3o!", "A seguir, acesse o sistema informando USU\u00c1RIO = 'ADMIN' e SENHA = 'admin'.", 1);
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
            ControleAplicacao.getRoteadorPlugins().sairSemConfirmacao();
        }
    }
}

