/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleAcesso;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.ControleInstalacao;
import br.com.bb.plugins.controle.infraestrutura.ControleManutencaoAccess;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.IRoteadorUsuario;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.controle.infraestrutura.RoteadorUsuario;
import br.com.bb.plugins.controle.infraestrutura.RoteadorUtilitarios;
import br.com.bb.plugins.interfaces.infraestrutura.DialogMensagensInstitucionais;
import br.com.bb.plugins.interfaces.infraestrutura.FramePlugin;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePlugin;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.interfaces.infraestrutura.Splash;
import br.com.bb.plugins.negocio.comum.Plugin;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.PluginBD;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public abstract class RoteadorPlugins
extends Roteador
implements IRoteadorUsuario {
    private RoteadorUsuario roteadorUsuario;
    private RoteadorUtilitarios roteadorUtilitarios;

    public RoteadorPlugins() {
        if (!ConexaoBancoDados.getNomeBancoDados().trim().equalsIgnoreCase("BBPluginBD")) {
            this.conectarBD();
        }
    }

    public RoteadorPlugins(Plugin plugin) {
        this.inicializarPlugin(plugin, true, true);
    }

    public RoteadorPlugins(Plugin plugin, boolean efetuarLogin, boolean utilizarBancoDados) {
        this.inicializarPlugin(plugin, efetuarLogin, utilizarBancoDados);
        try {
            if (((Plugin)PluginBD.getPluginBD().obterLista().elementAt(0)).getIndicadorEfetivacaoBackup().equalsIgnoreCase("N") || ((Plugin)PluginBD.getPluginBD().obterLista().elementAt(0)).getDataEfetivacaoBackup().equals("1980-01-01")) {
                RoteadorUtilitarios.getRoteadorUtilitarios().abrirInterfaceConfigurarBecape();
                this.verificarBecape(1);
                return;
            }
            if (((Plugin)PluginBD.getPluginBD().obterLista().elementAt(0)).getDataEfetivacaoBackup() != null) {
                this.verificarBecape(2);
                return;
            }
        }
        catch (Throwable t) {
            t.getMessage();
        }
    }

    public void abrirAjuda() {
        this.exibirAjudaHTML("ajuda");
    }

    public void abrirCompactacaoBancodeDados() {
        IBarraProgresso barra = this.obterBarraProgresso();
        try {
            if (this.exibirMensagemConfirmacao("Aten\u00e7\u00e3o", "Confirma compacta\u00e7\u00e3o do banco de dados?")) {
                barra.setValorMaximo(7);
                barra.setMensagem("Efetuando c\u00f3pia do banco de dados. Aguarde...");
                barra.setValor(1);
                String diretorioDados = ControleAplicacao.getDiretorioDados();
                ControleAplicacao.getFramePlugin().setCursor(new Cursor(3));
                File bdOrinal = new File(String.valueOf(diretorioDados) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".mdb");
                File bdCopiadoOrinal = new File(String.valueOf(diretorioDados) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + " - n\u00e3o compactado.mdb");
                File bdTemp = new File(String.valueOf(diretorioDados) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + "comp.mdb");
                barra.setMensagem("Reparando banco de dados. Aguarde...");
                barra.setValor(2);
                ConexaoBancoDados.desconectar();
                Util.copiar(bdOrinal, bdCopiadoOrinal);
                barra.setValor(3);
                ConexaoBancoDados.conectar();
                barra.setValor(4);
                this.repararBD();
                barra.setMensagem("Compactando banco de dados. Aguarde...");
                barra.setValor(5);
                File bdCompactado = new File(String.valueOf(diretorioDados) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + "comp.mdb");
                if (bdCompactado.exists()) {
                    bdCompactado.delete();
                }
                this.compactarBDParaArquivo(bdCompactado);
                ConexaoBancoDados.desconectar();
                bdOrinal.delete();
                Util.copiar(bdCompactado, bdOrinal);
                bdCompactado.delete();
                barra.setMensagem("Reconectando ao banco de dados. Aguarde...");
                barra.setValor(6);
                ConexaoBancoDados.conectar();
                barra.setValor(7);
                barra.finalizar();
                ControleAplicacao.getFramePlugin().setCursor(new Cursor(0));
                this.exibirMensagem("Compacta\u00e7\u00e3o realizada. Banco de dados original salvo como: \"" + bdCopiadoOrinal.getName() + "\".");
            }
        }
        catch (Throwable t) {
            barra.finalizar();
            ControleAplicacao.getFramePlugin().setCursor(new Cursor(0));
            this.getRoteadorUsuario().exibirMensagemErro(t);
            System.exit(1);
        }
    }

    public void abrirConfiguracaoLeitora() {
        File procomp = new File(String.valueOf(ControleAplicacao.getDiretorioWindows()) + "procomp.ini");
        Hashtable<String, String> parms = new Hashtable<String, String>();
        if (procomp.exists()) {
            Vector arq = Util.lerArquivo(procomp);
            int i = 0;
            while (i < arq.size()) {
                if (((String)arq.elementAt(i)).length() > 4 && ((String)arq.elementAt(i)).substring(0, 4).equalsIgnoreCase("Port")) {
                    parms.put("porta", ((String)arq.elementAt(i)).substring(5, 9).toUpperCase());
                } else if (((String)arq.elementAt(i)).length() > 6 && ((String)arq.elementAt(i)).substring(0, 6).equalsIgnoreCase("Modelo")) {
                    parms.put("modelo", ((String)arq.elementAt(i)).substring(7, 14).toUpperCase());
                } else if (((String)arq.elementAt(i)).length() > 10 && ((String)arq.elementAt(i)).substring(0, 10).equalsIgnoreCase("Velocidade")) {
                    parms.put("velocidade", ((String)arq.elementAt(i)).substring(11, ((String)arq.elementAt(i)).length()));
                } else if (((String)arq.elementAt(i)).length() > 7 && ((String)arq.elementAt(i)).substring(0, 7).equalsIgnoreCase("Tamanho")) {
                    parms.put("tamanho", ((String)arq.elementAt(i)).substring(8, 9));
                } else if (((String)arq.elementAt(i)).length() > 8 && ((String)arq.elementAt(i)).substring(0, 8).equalsIgnoreCase("StopBits")) {
                    parms.put("stopbits", ((String)arq.elementAt(i)).substring(9, 10));
                } else if (((String)arq.elementAt(i)).length() > 8 && ((String)arq.elementAt(i)).substring(0, 8).equalsIgnoreCase("Paridade")) {
                    parms.put("paridade", ((String)arq.elementAt(i)).substring(9, ((String)arq.elementAt(i)).trim().length()).toUpperCase());
                } else if (((String)arq.elementAt(i)).length() > 8 && ((String)arq.elementAt(i)).substring(0, 8).equalsIgnoreCase("Protocolo")) {
                    parms.put("protocolo", ((String)arq.elementAt(i)).substring(9, ((String)arq.elementAt(i)).trim().length()).toUpperCase());
                }
                ++i;
            }
        }
        IInterfacePluginCadastro dialogCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogConfiguracaoLeitora", null);
        dialogCadastro.alterar(parms);
        dialogCadastro.exibir();
    }

    public void abrirLogin() {
        IInterfacePlugin login = this.abrirInterface("Login", this.getFramePlugin());
        login.setRoteador(this);
        this.getFramePlugin().exibir();
        login.exibir();
        this.getFramePlugin().setUsuarioAtual(ControleAcesso.getUsuario());
    }

    public void abrirManutencaoUsuario() {
        this.getRoteadorUsuario().abrirManutencaoUsuario();
    }

    public void acessarBBOfficeBanking() {
        ControleAplicacao.abrirOffice();
    }

    public void compactarBD() throws Throwable {
        this.compactarBDParaArquivo(new File(String.valueOf(ControleAplicacao.getDiretorioDados()) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".mdb"));
    }

    public void compactarBDParaArquivo(File novoArquivo) throws Throwable {
        String diretorioDados = ControleAplicacao.getDiretorioDados();
        ConexaoBancoDados.desconectar();
        File bdOrinal = new File(String.valueOf(diretorioDados) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".mdb");
        if (!ControleManutencaoAccess.SQLConfigDataSource(1, 1, bdOrinal, novoArquivo, "persona")) {
            throw new Throwable("Problemas durante a compacta\u00e7\u00e3o do banco de dados. Aplicativo ser\u00e1 finalizado.");
        }
        if (!ConexaoBancoDados.conectar()) {
            throw new Throwable("N\u00e3o foi poss\u00edvel reconectar ao banco de dados. Favor reiniciar a aplica\u00e7\u00e3o.");
        }
    }

    private void conectarBD() {
        try {
            ConexaoBancoDados.start();
            Thread.sleep(1500L);
            while (!ConexaoBancoDados.isConectado()) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            this.exibirMensagemErro(e);
            this.sairSemConfirmacao();
        }
    }

    public abstract boolean configurarAplicativo();

    public abstract void configurarDemonstracao();

    public void configurarOffice() {
        ControleAplicacao.configurarOffice();
    }

    public abstract void desconfigurarDemonstracao() throws Throwable;

    public void efetuarBecape() {
        RoteadorUtilitarios.getRoteadorUtilitarios().abrirInterfaceBecape();
    }

    public void efetuarConfiguracaoBecape() throws SQLException {
        RoteadorUtilitarios.getRoteadorUtilitarios().abrirInterfaceConfigurarBecape();
    }

    public void executarCompactadorBD() throws IOException, SQLException, InterruptedException {
        String diretorioDados = ControleAplicacao.getDiretorioDados();
        if (!new File(String.valueOf(ControleAplicacao.getDiretorioCompactador()) + "BBcompactadorBD.exe ").exists()) {
            this.exibirMensagem("Compactador n\u00e3o localizado. Favor instalar acessando a p\u00e1gina de Plugins do Gerenciador Financeiro.");
            return;
        }
        ConexaoBancoDados.desconectar();
        Process process = Runtime.getRuntime().exec(String.valueOf(ControleAplicacao.getDiretorioCompactador()) + "BBcompactadorBD.exe " + diretorioDados + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".mdb");
        process.waitFor();
        ConexaoBancoDados.setNomeBancoDados("BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + "BD");
        ConexaoBancoDados.start();
        while (!ConexaoBancoDados.isConectado()) {
            ConexaoBancoDados.start();
            Thread.sleep(500L);
            if (ConexaoBancoDados.isConectado()) break;
        }
    }

    public File getFileConfiguracao() {
        File arquivoConfiguracao = new File(String.valueOf(ControleAplicacao.getDiretorioContrato()) + "cnfbb" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".bbt");
        if (arquivoConfiguracao.exists()) {
            return arquivoConfiguracao;
        }
        return null;
    }

    public RoteadorUsuario getRoteadorUsuario() {
        if (this.roteadorUsuario == null) {
            this.roteadorUsuario = new RoteadorUsuario();
        }
        return this.roteadorUsuario;
    }

    private void inicializarPlugin(Plugin plugin, boolean efetuarLogin, boolean utilizarBancoDados) {
        try {
            ColorModel cm = null;
            cm = Toolkit.getDefaultToolkit().getColorModel();
            int pixel = cm.getPixelSize();
            ControleAplicacao.setPlugin(plugin);
            ControleAplicacao.setFramePlugin(new FramePlugin());
            ControleAplicacao.setRoteadorPlugins(this);
            Splash s = new Splash(new Frame(), plugin);
            s.show();
            this.getFramePlugin().setPlugin(plugin);
            this.getFramePlugin().setRoteador(this);
            if (utilizarBancoDados) {
                ConexaoBancoDados.start();
            }
            Thread.sleep(1500L);
            this.getFramePlugin().exibir();
            ((Component)s).setVisible(false);
            s.dispose();
            s = null;
            if (utilizarBancoDados) {
                while (!ConexaoBancoDados.isConectado()) {
                    Thread.sleep(1000L);
                }
                ControleInstalacao.getInstance().verificarStatusInstalacao();
                if (ControleInstalacao.getInstance().obterStatus().equalsIgnoreCase("D")) {
                    this.getFramePlugin().setUsuarioAtual(ControleAcesso.getUsuario());
                } else if (efetuarLogin) {
                    this.abrirLogin();
                }
            }
            this.getFramePlugin().setIndLogin(true);
            this.procurarMensagemInstitucional();
        }
        catch (Exception e) {
            this.exibirMensagemErro(e);
            this.sairSemConfirmacao();
        }
    }

    public static void main(String[] args) {
    }

    public boolean moverArquivoConfiguracao() {
        File arquivoConfiguracao = this.getFileConfiguracao();
        if (arquivoConfiguracao != null) {
            File destino = new File(String.valueOf(ControleAplicacao.getDiretorioArquivos()) + "cnfbb" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".bbt");
            destino.delete();
            return arquivoConfiguracao.renameTo(destino);
        }
        return false;
    }

    public Vector obterArquivoConfiguracao() {
        Vector vLinhas = new Vector();
        File arquivoConfiguracao = this.getFileConfiguracao();
        if (arquivoConfiguracao != null) {
            vLinhas = Util.lerArquivo(arquivoConfiguracao);
            if (vLinhas == null || vLinhas.size() < 1) {
                vLinhas = Util.lerArquivo(arquivoConfiguracao);
            }
        } else {
            FileDialog dialog = new FileDialog(this.getFramePlugin());
            while (vLinhas.size() == 0) {
                ((Dialog)dialog).setTitle("Informe a localiza\u00e7\u00e3o do arquivo de configura\u00e7\u00e3o");
                dialog.setModal(true);
                dialog.setResizable(false);
                Util.centralizarJanela(dialog);
                dialog.setDirectory("c:\\bancobrasil\\bbtransf\\contrato\\");
                dialog.setFile("cnfbb" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".bbt");
                dialog.show();
                if (dialog.getFile() == null) {
                    return null;
                }
                arquivoConfiguracao = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                if (arquivoConfiguracao.exists()) {
                    vLinhas = Util.lerArquivo(arquivoConfiguracao);
                    if (vLinhas != null && vLinhas.size() >= 1) continue;
                    vLinhas = Util.lerArquivo(arquivoConfiguracao);
                    continue;
                }
                this.exibirMensagem("N\u00e3o foi encontrado o arquivo CNFBB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".BBT no diret\u00f3rio indicado.");
            }
        }
        return vLinhas;
    }

    public void procurarMensagemInstitucional() {
        File fileMsg = new File(String.valueOf(ControleAplicacao.getDiretorioRetorno()) + "msgbb.txt");
        if (!fileMsg.exists()) {
            return;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileMsg));
            String linha = in.readLine();
            if (linha == null || linha.trim().length() == 0) {
                return;
            }
            in.close();
            DialogMensagensInstitucionais dmi = new DialogMensagensInstitucionais(this.getFramePlugin());
            dmi.setModal(true);
            dmi.setMensagem(linha.trim());
            dmi.show();
            if (dmi.isIndicadorDeletar()) {
                fileMsg.delete();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void repararBD() throws Throwable {
        String diretorioDados = ControleAplicacao.getDiretorioDados();
        File bdOrinal = new File(String.valueOf(diretorioDados) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".mdb");
        ConexaoBancoDados.desconectar();
        if (!ControleManutencaoAccess.SQLConfigDataSource(2, 1, bdOrinal, null, "persona")) {
            throw new Throwable("N\u00e3o foi poss\u00edvel reparar o banco de dados.");
        }
        if (!ConexaoBancoDados.conectar()) {
            throw new Throwable("N\u00e3o foi poss\u00edvel reconectar ao banco de dados. Favor reiniciar a aplica\u00e7\u00e3o.");
        }
    }

    public void restaurarBecape() {
        RoteadorUtilitarios.getRoteadorUtilitarios().abrirInterfaceRestauracaoBecape();
    }

    public void sair() {
        if (this.exibirMensagemConfirmacao("Aten\u00e7\u00e3o", "Deseja sair da aplica\u00e7\u00e3o?")) {
            try {
                ConexaoBancoDados.desconectar();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            System.exit(0);
        }
    }

    public void sairSemConfirmacao() {
        try {
            ConexaoBancoDados.desconectar();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        System.exit(0);
    }

    public void salvarConfiguracaoLeitora(Hashtable parms) {
        File procomp;
        Vector<String> arquivo = new Vector<String>();
        arquivo.addElement("[CMC7CX]");
        arquivo.addElement("PORT=" + (String)parms.get("porta"));
        arquivo.addElement("MODELO=" + (String)parms.get("modelo"));
        arquivo.addElement("VELOCIDADE=" + (String)parms.get("velocidade"));
        arquivo.addElement("TAMANHO=" + (String)parms.get("tamanho"));
        arquivo.addElement("STOPBITS=" + (String)parms.get("stopbits"));
        arquivo.addElement("PARIDADE=" + (String)parms.get("paridade"));
        if (parms.get("protocolo") != null) {
            arquivo.addElement("PROTOCOLO=" + (String)parms.get("protocolo"));
        }
        if ((procomp = new File(String.valueOf(ControleAplicacao.getDiretorioWindows()) + "procomp.ini")).exists()) {
            procomp.delete();
        }
        try {
            Util.gravarArquivo(procomp, arquivo);
            this.exibirMensagem("Leitora configurada com sucesso.");
        }
        catch (Throwable e) {
            this.exibirMensagemErro(e);
        }
    }

    public void setAplicativoConfigurado() {
        ControleInstalacao.getInstance().setStatus("C");
        this.exibirMensagem("O aplicativo saiu do modo Demonstra\u00e7\u00e3o e j\u00e1 pode ser operado normalmente.");
    }

    public void setRoteadorUsuario(RoteadorUsuario newRoteadorUsuario) {
        this.roteadorUsuario = newRoteadorUsuario;
    }

    public void suspenderSessaoUsuario() {
        this.abrirLogin();
    }

    public void validarAcesso(String chave, String senha) throws Throwable {
        ControleAcesso.validarAcesso(chave, senha);
        if (chave.equalsIgnoreCase(senha)) {
            this.getRoteadorUsuario().abrirAlteracaoSenha();
        }
    }

    public void verificarAtualizacao() {
        ControleInstalacao.getInstance().verificarDownloadAtualizacao();
    }

    public void verificarBecape(int parm) throws Throwable {
        Calendar dataAtual = Calendar.getInstance();
        Calendar dataEfetivacao = Calendar.getInstance();
        Calendar dataHoje = Calendar.getInstance();
        Calendar dataRetroceder = Calendar.getInstance();
        dataHoje.setTime(dataAtual.getTime());
        int numeroDiasEfetivacao = ((Plugin)PluginBD.getPluginBD().obterLista().elementAt(0)).getNumeroDiasBackup();
        dataEfetivacao.setTime(((Plugin)PluginBD.getPluginBD().obterLista().elementAt(0)).getDataEfetivacaoBackup());
        dataEfetivacao.add(5, numeroDiasEfetivacao);
        dataRetroceder.set(80, 0, 1);
        if (dataHoje.getTime().after(dataEfetivacao.getTime()) || dataHoje.getTime().equals(dataEfetivacao.getTime())) {
            if (this.getRoteadorUsuario().exibirMensagem("ATEN\u00c7\u00c3O", "C\u00f3pia de Seguran\u00e7a pode ter sido efetuado a mais de " + numeroDiasEfetivacao + " dias. Efetuar C\u00f3pia de Seguran\u00e7a ?", 2) == 0) {
                this.efetuarBecape();
            } else if (parm == 1) {
                this.getPlugin().setDataEfetivacaoBackup(dataRetroceder.getTime());
                this.getPlugin().setIndicadorEfetivacaoBackup("S");
                PluginBD.getPluginBD().salvar(this.getPlugin());
            }
        } else if (parm == 1) {
            if (this.getRoteadorUsuario().exibirMensagem("ATEN\u00c7\u00c3O", "\u00c9 recomendado efetuar C\u00f3pia de Seguran\u00e7a, devido as atualiza\u00e7\u00f5es realizadas na Base de Dados. Efetuar C\u00f3pia de Seguran\u00e7a ?", 2) == 0) {
                this.efetuarBecape();
            } else {
                this.getPlugin().setDataEfetivacaoBackup(dataRetroceder.getTime());
                this.getPlugin().setIndicadorEfetivacaoBackup("S");
                PluginBD.getPluginBD().salvar(this.getPlugin());
            }
        }
    }
}

