/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleAcesso;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginListener;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginManutencao;
import br.com.bb.plugins.interfaces.infraestrutura.InterfacePluginEvent;
import br.com.bb.plugins.negocio.infraestrutura.Usuario;
import br.com.bb.plugins.persistencia.comum.PluginBD;
import br.com.bb.plugins.persistencia.infraestrutura.UsuarioBD;
import br.com.bb.plugins.utilitarios.Criptografia;
import br.com.bb.plugins.utilitarios.Util;
import java.sql.SQLException;
import java.util.Vector;

public class RoteadorUsuario
extends Roteador
implements IInterfacePluginListener {
    private IInterfacePluginManutencao telaListaUsuarios;

    public void abrirAlteracaoSenha() {
        this.abrirInterface("AlteraSenha", null).exibir();
    }

    public void abrirAlteracaoUsuario(String codigoUsuario, Object parent) throws SQLException {
        Usuario u = new Usuario();
        u.setCodigoChave(codigoUsuario);
        UsuarioBD.getUsuarioBD().obter(u);
        IInterfacePluginCadastro iu = (IInterfacePluginCadastro)this.abrirInterface("UsuarioCad", parent);
        if (iu == null) {
            return;
        }
        iu.alterar(u);
        iu.exibir();
    }

    public void abrirDetalhamentoUsuario(String codigoUsuario, Object parent) throws SQLException {
        Usuario u = new Usuario();
        u.setCodigoChave(codigoUsuario);
        UsuarioBD.getUsuarioBD().obter(u);
        IInterfacePluginCadastro iu = (IInterfacePluginCadastro)this.abrirInterface("UsuarioCad", parent);
        if (iu == null) {
            return;
        }
        iu.detalhar(u);
        iu.exibir();
    }

    public void abrirExclusaoUsuario(String codigoUsuario, Object parent) throws SQLException {
        Usuario u = new Usuario();
        u.setCodigoChave(codigoUsuario);
        UsuarioBD.getUsuarioBD().obter(u);
        IInterfacePluginCadastro iu = (IInterfacePluginCadastro)this.abrirInterface("UsuarioCad", parent);
        if (iu == null) {
            return;
        }
        iu.excluir(u);
        iu.exibir();
    }

    public void abrirInclusaoUsuario(Object parent) {
        IInterfacePluginCadastro iu = (IInterfacePluginCadastro)this.abrirInterface("UsuarioCad", parent);
        if (iu == null) {
            return;
        }
        iu.incluir(null);
        iu.exibir();
    }

    public void abrirManutencaoUsuario() {
        this.telaListaUsuarios = (IInterfacePluginManutencao)this.abrirInterface("UsuarioMan", this.getFramePlugin());
        this.telaListaUsuarios.addInterfacePluginListener(this);
        this.telaListaUsuarios.listar(this.obterListaUsuarios());
        this.telaListaUsuarios.exibir();
    }

    public boolean alterarSenhaUsuarioAtual(String senhaAtual, String novaSenha) {
        try {
            boolean ok = ControleAcesso.getUsuario().alterarSenha(senhaAtual, novaSenha);
            if (ok) {
                UsuarioBD.getUsuarioBD().salvar(ControleAcesso.getUsuario());
            }
            return ok;
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
            return false;
        }
    }

    public void alterarUsuario(Usuario u) throws Throwable {
        UsuarioBD.getUsuarioBD().salvar(u);
        this.telaListaUsuarios.alterado(u);
    }

    public void excluirUsuario(Usuario u) throws Throwable {
        UsuarioBD.getUsuarioBD().remover(u);
        this.telaListaUsuarios.excluido(u);
    }

    public void exibirInterfacePlugin(InterfacePluginEvent ipe) {
    }

    public void fecharInterfacePlugin(InterfacePluginEvent ipe) {
        if (ipe.getInterfacePlugin().getCodigoInterface().equalsIgnoreCase("UsuarioMan")) {
            this.telaListaUsuarios = null;
        }
    }

    public static void forcarSenhaAdmin(String novaSenha) {
        try {
            ControleAcesso.getUsuario().setTextoSenha(Criptografia.cifrar(novaSenha));
            UsuarioBD.getUsuarioBD().salvar(ControleAcesso.getUsuario());
            ControleAplicacao.getPlugin().setDataInstalacao(ControleAplicacao.getDataAtual());
            PluginBD.getPluginBD().salvar(ControleAplicacao.getPlugin());
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
        }
    }

    public void incluirUsuario(Usuario u) throws Throwable {
        Usuario u1 = new Usuario();
        u1.setCodigoChave(u.getCodigoChave());
        UsuarioBD.getUsuarioBD().obter(u1);
        if (u1.getNomeUsuario() != null) {
            throw new Throwable("Usu\u00e1rio j\u00e1 cadastrado!");
        }
        UsuarioBD.getUsuarioBD().adicionar(u);
        this.telaListaUsuarios.incluido(u);
    }

    public static void main(String[] args) {
    }

    public Vector obterListaUsuarios() {
        try {
            return UsuarioBD.getUsuarioBD().obterLista();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean obterPermissao(String transacao) {
        return ControleAcesso.getUsuario().getCodigoChave().equalsIgnoreCase("admin");
    }

    public void ocultarInterfacePlugin(InterfacePluginEvent ipe) {
    }
}

