/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.grafico;

import br.com.bb.plugins.grafico.BBGraficoDado;
import br.com.bb.plugins.grafico.BBGraficoEixo;
import br.com.bb.plugins.grafico.BBGraficoLabel;
import br.com.bb.plugins.grafico.BBGraficoSerie;
import br.com.bb.plugins.grafico.BBToolTip;
import br.com.bb.plugins.grafico.ToolTipText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.VetoableChangeSupport;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class BBGrafico
extends Component
implements MouseMotionListener,
ComponentListener,
ToolTipText {
    private BBGraficoLabel titulo1 = new BBGraficoLabel();
    private BBGraficoLabel titulo2 = new BBGraficoLabel();
    private BBGraficoEixo eixoX = new BBGraficoEixo();
    private BBGraficoEixo eixoY = new BBGraficoEixo();
    private Vector series = null;
    public boolean indMaximos = false;
    private Color corFundo = new Color(255, 255, 192);
    private Color corEixos = Color.black;
    private Color corBorda = Color.black;
    private Color corSombra = new Color(150, 150, 150);
    private Point baseGrafico = null;
    private Point tamanhoGrafico = null;
    private Label labelValorY = null;
    private double multY = 0.0;
    private double multX = 0.0;
    private Font fonteLegenda = new Font("Arial", 0, 9);
    private boolean indicadorAjusteMaximoMinimo = false;
    private boolean indAlternarValoresEixoX = false;
    private int tipo = 0;
    protected transient VetoableChangeSupport vetoPropertyChange;
    private int numeroSeriesBarra = 0;
    private boolean perspectiva3d = false;
    private double multiplicadorPerspectiva = 1.0;
    private int perspectivaX = 0;
    private int perspectivaY = 0;
    private double proporcaoBarras = 0.8;
    private double proporcaoFonte = 1.0;
    private int espacoEntreBarras = 2;
    private int explosaoPizza = 30;
    private int anguloInicialPizza = 0;
    private byte posicaoLegenda = 0;
    public static final byte LEGENDA_A_DIREITA = 0;
    public static final byte LEGENDA_INFERIOR = 1;
    public static final byte TIPO_LINHAS = 1;
    public static final byte TIPO_BARRAS = 0;
    public static final byte TIPO_MISTO = 2;
    public static final byte TIPO_BARRAS_ACUMULADAS = 3;
    public static final byte TIPO_PIZZA = 4;
    private int alturaTotalLegenda = 0;
    private String toolTipText = null;

    public BBGrafico() {
        this.getTitulo1().setFont(new Font("Arial", 1, 15));
        this.getTitulo1().setColor(Color.blue);
        this.getTitulo2().setFont(new Font("Arial", 1, 12));
        this.getTitulo2().setColor(Color.blue);
        this.addMouseMotionListener(this);
        BBToolTip.addBBToolTip(this);
        this.addComponentListener(this);
    }

    private void adicionarParedeCorAngulo(Vector paredes, Vector anguloParedes, Vector coresParedes, Vector visibilidadeParedes, Polygon p, int angulo, Color corSombra, boolean visivel) {
        int k = 0;
        while (k < anguloParedes.size()) {
            if ((Integer)anguloParedes.elementAt(k) > angulo) break;
            ++k;
        }
        if (k > anguloParedes.size() - 1) {
            anguloParedes.addElement(new Integer(angulo));
            coresParedes.addElement(corSombra);
            paredes.addElement(p);
            visibilidadeParedes.addElement(new Boolean(visivel));
        } else {
            anguloParedes.insertElementAt(new Integer(angulo), k);
            coresParedes.insertElementAt(corSombra, k);
            paredes.insertElementAt(p, k);
            visibilidadeParedes.insertElementAt(new Boolean(visivel), k);
        }
    }

    public void adicionarSerie(BBGraficoSerie serie) {
        this.getSeries().addElement(serie);
        this.indicadorAjusteMaximoMinimo = false;
        if (!serie.isLinha()) {
            ++this.numeroSeriesBarra;
        }
    }

    private void ajustarValoresMaximoMinimo() {
        BBGraficoDado dado = null;
        this.getEixoY().setValorMinimo(1.0E18);
        this.getEixoY().setValorMaximo(-1.0E18);
        this.getEixoX().setValorMinimo(1.0E18);
        this.getEixoX().setValorMaximo(-1.0E18);
        int j = 0;
        while (j < this.getSeries().size()) {
            int i = 0;
            while (i < this.getSerie(j).getValores().size()) {
                dado = (BBGraficoDado)this.getSerie(j).getValores().elementAt(i);
                if (dado.getTipo() == 'S') {
                    this.getEixoX().setValorMinimo(0.0);
                    this.getEixoX().setValorMaximo(i + 1);
                } else if (dado.getTipo() == 'N' || dado.getTipo() == 'D') {
                    if (this.getEixoX().getValorMinimo() > dado.getValorXNumerico()) {
                        this.getEixoX().setValorMinimo(dado.getValorXNumerico());
                    }
                    if (this.getEixoX().getValorMaximo() < dado.getValorXNumerico()) {
                        this.getEixoX().setValorMaximo(dado.getValorXNumerico());
                    }
                }
                ++i;
            }
            ++j;
        }
        int i = 0;
        while (i < this.getSerie(0).getValores().size()) {
            double valorYacumPos = 0.0;
            double valorYacumNeg = 0.0;
            int j2 = 0;
            while (j2 < this.getSeries().size()) {
                dado = (BBGraficoDado)this.getSerie(j2).getValores().elementAt(i);
                if (this.getTipo() != 3) {
                    this.getEixoY().setValorMinimo(dado.getValorY() < this.getEixoY().getValorMinimo() ? dado.getValorY() : this.getEixoY().getValorMinimo());
                    this.getEixoY().setValorMaximo(dado.getValorY() > this.getEixoY().getValorMaximo() ? dado.getValorY() : this.getEixoY().getValorMaximo());
                } else if (dado.getValorY() < 0.0) {
                    valorYacumNeg += dado.getValorY();
                } else {
                    valorYacumPos += dado.getValorY();
                }
                ++j2;
            }
            this.getEixoY().setValorMinimo(valorYacumPos < this.getEixoY().getValorMinimo() ? valorYacumPos : this.getEixoY().getValorMinimo());
            this.getEixoY().setValorMaximo(valorYacumPos > this.getEixoY().getValorMaximo() ? valorYacumPos : this.getEixoY().getValorMaximo());
            this.getEixoY().setValorMinimo(valorYacumNeg < this.getEixoY().getValorMinimo() ? valorYacumNeg : this.getEixoY().getValorMinimo());
            this.getEixoY().setValorMaximo(valorYacumNeg > this.getEixoY().getValorMaximo() ? valorYacumNeg : this.getEixoY().getValorMaximo());
            ++i;
        }
        if (dado.getTipo() != 'S') {
            double amplitudeX = this.getEixoX().getValorMaximo() - this.getEixoX().getValorMinimo();
            double incrementoX = this.calcularIncremento(amplitudeX);
            this.getEixoX().setIncremento(incrementoX);
        } else {
            this.getEixoX().setIncremento(1.0);
        }
        double amplitudeY = this.getEixoY().getValorMaximo() - this.getEixoY().getValorMinimo();
        double incrementoY = this.calcularIncremento(amplitudeY);
        this.getEixoY().setIncremento(incrementoY);
        double valorMinimo = (double)((int)(this.getEixoY().getValorMinimo() / this.getEixoY().getIncremento())) * this.getEixoY().getIncremento();
        if (valorMinimo > this.getEixoY().getValorMinimo()) {
            valorMinimo -= this.getEixoY().getIncremento();
        }
        this.getEixoY().setValorMinimo(valorMinimo);
        double valorMaximo = (double)((int)(this.getEixoY().getValorMaximo() / this.getEixoY().getIncremento())) * this.getEixoY().getIncremento();
        if (valorMaximo < this.getEixoY().getValorMaximo()) {
            valorMaximo += this.getEixoY().getIncremento();
        }
        this.getEixoY().setValorMaximo(valorMaximo);
        if (this.getEixoY().getValorMaximo() == this.getEixoY().getValorMinimo()) {
            this.getEixoY().setValorMaximo(this.getEixoY().getValorMaximo() + 1.0);
            this.getEixoY().setIncremento(1.0);
        }
        if (((BBGraficoDado)this.getSerie(0).getValores().elementAt(0)).getTipo() == 'N') {
            this.getEixoX().setValorMinimo((double)((int)(this.getEixoX().getValorMinimo() / this.getEixoX().getIncremento())) * this.getEixoX().getIncremento());
            this.getEixoX().setValorMaximo((double)((int)(this.getEixoX().getValorMaximo() / this.getEixoX().getIncremento() + 1.0)) * this.getEixoX().getIncremento());
        }
        this.indicadorAjusteMaximoMinimo = true;
    }

    private double calcularIncremento(double amplitude) {
        int i = 0;
        int j = 1;
        double div = amplitude;
        while (Math.abs(div) > 1.0) {
            div = amplitude / Math.pow(10.0, i += j);
        }
        double incremento = div <= 0.1 ? 0.02 : (div <= 0.2 ? 0.025 : (div <= 0.3 ? 0.04 : (div <= 0.4 ? 0.05 : (div <= 0.5 ? 0.06 : (div <= 0.6 ? 0.09 : (div <= 0.7 ? 0.1 : (div <= 0.8 ? 0.1 : (div <= 0.9 ? 0.15 : 0.2))))))));
        if (amplitude / (incremento *= Math.pow(10.0, i)) < 2.0) {
            incremento /= 5.0;
        }
        return incremento;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent ce) {
        double proporcaoX = (double)this.getSize().width / 470.0;
        double proporcaoY = (double)this.getSize().height / 270.0;
        this.proporcaoFonte = proporcaoX < proporcaoY ? proporcaoX : proporcaoY;
    }

    public void componentShown(ComponentEvent e) {
    }

    private void desenharEixoX(Graphics g) {
        String texto = null;
        int posY = this.getBaseGrafico().y;
        int j = 0;
        Polygon p = this.obterPoligonoPerspectiva(this.getBaseGrafico().x, this.getBaseGrafico().y, this.getBaseGrafico().x + this.getTamanhoGrafico().x, this.getBaseGrafico().y);
        g.setColor(Color.lightGray);
        g.fillPolygon(p);
        g.setColor(Color.black);
        g.drawPolygon(p);
        Date data = new Date();
        if (this.getSerie(0).getTipo() == 'N' || this.getSerie(0).getTipo() == 'D') {
            double i = this.getEixoX().getValorMinimo();
            while (i <= this.getEixoX().getValorMaximo()) {
                int posX = (int)((double)this.getBaseGrafico().x + i * this.multX);
                g.setColor(this.getCorBorda());
                if (this.isPerspectiva3d()) {
                    g.drawLine(posX - this.perspectivaX, posY + this.perspectivaY, posX, posY);
                } else {
                    g.drawLine(posX, posY, posX, posY - 2);
                }
                if (this.getTipo() == 68) {
                    data.setTime((long)i);
                    try {
                        texto = this.formatar(data, this.getEixoX().getFormato());
                    }
                    catch (Throwable throwable) {}
                } else {
                    texto = this.formatar(i, this.getEixoX().getFormato());
                }
                g.setColor(this.getEixoX().getColor());
                g.setFont(this.obterFonteProporcional(this.getEixoX().getFont()));
                g.drawString(texto, posX - this.perspectivaX - g.getFontMetrics().stringWidth(texto) / 2, posY + this.perspectivaY + (g.getFontMetrics().getHeight() + g.getFontMetrics().getDescent()) * (j % 2));
                if (this.isIndAlternarValoresEixoX()) {
                    ++j;
                }
                i += this.getEixoX().getIncremento();
            }
        } else if (this.getSerie(0).getTipo() == 'S') {
            int i = 0;
            while (i < this.getSerie(0).getValores().size()) {
                int posX = (int)((double)this.getBaseGrafico().x + (double)(i + 1) * this.multX);
                g.setColor(this.getCorBorda());
                if (this.isPerspectiva3d()) {
                    g.drawLine(posX - this.perspectivaX, posY + this.perspectivaY, posX, posY);
                } else {
                    g.drawLine(posX, posY, posX, posY - 2);
                }
                texto = ((BBGraficoDado)this.getSerie(0).getValores().elementAt(i)).getValorXString();
                g.setColor(this.getEixoX().getColor());
                g.setFont(this.obterFonteProporcional(this.getEixoX().getFont()));
                g.drawString(texto, posX - this.perspectivaX - (int)(this.multX / 2.0) - g.getFontMetrics().stringWidth(texto) / 2, posY + this.perspectivaY + (g.getFontMetrics().getHeight() + 2) * (j % 2 + 1));
                if (this.isIndAlternarValoresEixoX()) {
                    ++j;
                }
                ++i;
            }
        }
        if (this.getEixoX().getLabel().getTexto() != null) {
            g.setColor(this.getEixoX().getLabel().getColor());
            g.setFont(this.obterFonteProporcional(this.getEixoX().getLabel().getFont()));
            g.drawString(this.getEixoX().getLabel().getTexto(), this.getBaseGrafico().x - this.perspectivaX + this.getTamanhoGrafico().x / 2 - g.getFontMetrics().stringWidth(this.getEixoX().getLabel().getTexto()) / 2, this.getSize().height - this.alturaTotalLegenda - 8);
        }
    }

    private void desenharEixoY(Graphics g) {
        Polygon p = this.obterPoligonoPerspectiva(this.getBaseGrafico().x, this.getBaseGrafico().y, this.getBaseGrafico().x, this.getBaseGrafico().y - this.getTamanhoGrafico().y);
        g.setColor(Color.lightGray);
        g.fillPolygon(p);
        g.setColor(Color.black);
        g.drawPolygon(p);
        double i = this.getEixoY().getValorMinimo();
        while (i <= this.getEixoY().getValorMaximo()) {
            int posY = (int)((double)this.getBaseGrafico().y - (i - this.getEixoY().getValorMinimo()) * this.multY);
            g.setColor(this.getCorBorda());
            if (this.isPerspectiva3d()) {
                g.drawLine(this.getBaseGrafico().x - this.perspectivaX, posY + this.perspectivaY, this.getBaseGrafico().x, posY);
            } else {
                g.drawLine(this.getBaseGrafico().x, posY, this.getBaseGrafico().x + 2, posY);
            }
            String texto = this.formatar(i, this.getEixoY().getFormato());
            g.setColor(this.getEixoY().getColor());
            g.setFont(this.obterFonteProporcional(this.getEixoY().getFont()));
            g.drawString(texto, this.getBaseGrafico().x - 2 - this.perspectivaX - g.getFontMetrics().stringWidth(texto), posY + this.perspectivaY + g.getFontMetrics().getHeight() / 2 - 1);
            if (this.getEixoY().isGrade()) {
                g.setColor(Color.black);
                int j = this.getBaseGrafico().x;
                while (j < this.getBaseGrafico().x + this.getTamanhoGrafico().x) {
                    g.drawLine(j, posY, j + 0, posY);
                    j += 4;
                }
            }
            if (i == 0.0) {
                p = this.obterPoligonoPerspectiva(this.getBaseGrafico().x, posY, this.getBaseGrafico().x + this.getTamanhoGrafico().x, posY);
                g.drawPolygon(p);
                double j = this.getEixoX().getValorMinimo();
                while (j < this.getEixoX().getValorMaximo()) {
                    int posX = (int)((double)this.getBaseGrafico().x + (j - this.getEixoX().getValorMinimo()) * this.multX);
                    if (this.perspectivaX == 0) {
                        g.drawLine(posX, posY + 2, posX, posY - 1);
                    } else {
                        g.drawLine(posX - this.perspectivaX, posY + this.perspectivaY, posX, posY);
                    }
                    j += this.getEixoX().getIncremento();
                }
            }
            i += this.getEixoY().getIncremento();
        }
        if (this.getEixoY().getLabel().getTexto() != null) {
            g.setColor(this.getEixoY().getLabel().getColor());
            g.setFont(this.obterFonteProporcional(this.getEixoY().getLabel().getFont()));
            g.drawString(this.getEixoY().getLabel().getTexto(), this.getBaseGrafico().x - g.getFontMetrics().stringWidth(this.getEixoY().getLabel().getTexto()) - 2, this.getBaseGrafico().y - this.getTamanhoGrafico().y);
        }
    }

    private void desenharGraficoBarras(Graphics g) {
        int posX = 0;
        int barras = 0;
        barras = this.getTipo() == 3 ? 1 : (this.getTipo() == 0 ? this.getSeries().size() : this.numeroSeriesBarra);
        int larguraBarra = (int)((this.multX * this.getProporcaoBarras() - (double)(this.espacoEntreBarras * (barras - 1))) / (double)barras);
        int larguraBarras = larguraBarra * barras + this.espacoEntreBarras * (barras - 1);
        double valorBase = this.getEixoY().getValorMinimo() < 0.0 ? (this.getEixoY().getValorMaximo() > 0.0 ? 0.0 : this.getEixoY().getValorMaximo()) : this.getEixoY().getValorMinimo();
        int posicaoBase = (int)((double)this.getBaseGrafico().y - (valorBase - this.getEixoY().getValorMinimo()) * this.multY);
        Color corTopo = null;
        int i = 0;
        while (i < this.getSerie(0).getValores().size()) {
            Polygon p;
            int posicaoMaxima = posicaoBase;
            int posicaoMinima = posicaoBase;
            corTopo = null;
            int numeroBarra = 0;
            int j = 0;
            while (j < this.getSeries().size()) {
                if (this.getTipo() == 0 || this.getTipo() == 3 || this.getTipo() == 2 && !this.getSerie(j).isLinha()) {
                    BBGraficoDado dado = (BBGraficoDado)this.getSerie(j).getValores().elementAt(i);
                    int alturaBarra = (int)((dado.getValorY() - valorBase) * this.multY);
                    int inicioBarra = posicaoBase - alturaBarra;
                    if (this.getTipo() != 3) {
                        if (alturaBarra < 0) {
                            inicioBarra = posicaoBase;
                            alturaBarra *= -1;
                        }
                    } else if (alturaBarra < 0) {
                        inicioBarra = posicaoMinima;
                        posicaoMinima += (alturaBarra *= -1);
                    } else {
                        posicaoMaxima = inicioBarra = posicaoMaxima - alturaBarra;
                        corTopo = dado.getValorY() < 0.0 && this.getSerie(j).getCorNegativo() != null ? this.getSerie(j).getCorNegativo() : this.getSerie(j).getColor();
                    }
                    if (this.getTipo() == 3) {
                        numeroBarra = 0;
                    }
                    posX = (int)((double)this.getBaseGrafico().x + ((double)i + 0.5) * this.multX - (double)(larguraBarras / 2)) + numeroBarra * larguraBarra + numeroBarra * this.espacoEntreBarras;
                    ++numeroBarra;
                    if (this.getTipo() != 3) {
                        if (dado.getValorY() < 0.0 && this.getSerie(j).getCorNegativo() != null) {
                            g.setColor(this.obterSombraCor(this.getSerie(j).getCorNegativo()));
                        } else {
                            g.setColor(this.obterSombraCor(this.getSerie(j).getColor()));
                        }
                        p = this.obterPoligonoPerspectiva(posX, inicioBarra, posX + larguraBarra, inicioBarra);
                        g.fillPolygon(p);
                        g.setColor(Color.black);
                        g.drawPolygon(p);
                    }
                    if (dado.getValorY() < 0.0 && this.getSerie(j).getCorNegativo() != null) {
                        g.setColor(this.obterSombraCor(this.getSerie(j).getCorNegativo()));
                    } else {
                        g.setColor(this.obterSombraCor(this.getSerie(j).getColor()));
                    }
                    p = this.obterPoligonoPerspectiva(posX + larguraBarra, inicioBarra, posX + larguraBarra, inicioBarra + alturaBarra);
                    g.fillPolygon(p);
                    g.setColor(Color.black);
                    g.drawPolygon(p);
                    if (dado.getValorY() < 0.0 && this.getSerie(j).getCorNegativo() != null) {
                        g.setColor(this.getSerie(j).getCorNegativo());
                    } else {
                        g.setColor(this.getSerie(j).getColor());
                    }
                    g.fill3DRect(posX - this.perspectivaX, inicioBarra + this.perspectivaY, larguraBarra, alturaBarra, true);
                    g.setColor(Color.black);
                    g.draw3DRect(posX - this.perspectivaX, inicioBarra + this.perspectivaY, larguraBarra, alturaBarra, true);
                }
                ++j;
            }
            if (this.getTipo() == 3) {
                if (corTopo == null) {
                    corTopo = this.getSerie(0).getColor();
                }
                g.setColor(this.obterSombraCor(corTopo));
                p = this.obterPoligonoPerspectiva(posX, posicaoMaxima, posX + larguraBarra, posicaoMaxima);
                g.fillPolygon(p);
                g.setColor(Color.black);
                g.drawPolygon(p);
            }
            ++i;
        }
    }

    private void desenharGraficoLinhas(Graphics g) {
        int posYanterior = 0;
        int i = 0;
        while (i < this.getSeries().size()) {
            int posXanterior = -1;
            if (this.getTipo() == 2 && this.getSerie(i).isLinha() || this.getTipo() == 1) {
                int j = 0;
                while (j < this.getSerie(0).getValores().size()) {
                    BBGraficoDado dado = (BBGraficoDado)this.getSerie(i).getValores().elementAt(j);
                    int posY = (int)((double)this.getBaseGrafico().y - (dado.getValorY() - this.getEixoY().getValorMinimo()) * this.multY);
                    int posX = dado.getTipo() == 'S' ? this.getBaseGrafico().x + (int)(((double)j + 0.5) * this.multX) : this.getBaseGrafico().x + (int)((dado.getValorY() - this.getEixoX().getValorMinimo()) * this.multX);
                    if (posXanterior != -1) {
                        if (posYanterior < posY) {
                            g.setColor(this.obterSombraCor(this.getSerie(i).getColor()));
                        } else {
                            g.setColor(this.getSerie(i).getColor());
                        }
                        Polygon p = this.obterPoligonoPerspectiva(posXanterior, posYanterior, posX, posY);
                        if (this.isPerspectiva3d()) {
                            g.fillPolygon(p);
                            g.setColor(Color.black);
                            g.drawPolygon(p);
                        } else {
                            g.drawPolygon(p);
                        }
                    }
                    posXanterior = posX;
                    posYanterior = posY;
                    ++j;
                }
            }
            ++i;
        }
    }

    private void desenharGraficoPizza(Graphics g) {
        int angulo;
        double raio;
        double propB;
        double propA;
        int altura = this.perspectivaY * 10;
        int explode = this.getExplosaoPizza();
        int anguloMedio = 0;
        boolean anguloFinal = false;
        Vector paredes = new Vector();
        Vector coresParedes = new Vector();
        Vector anguloParedes = new Vector();
        Vector visibilidadeParedes = new Vector();
        int larguraX = (int)((double)this.getTamanhoGrafico().x * 0.9 - (double)this.perspectivaX - (double)(explode * 2));
        int a = larguraX / 2;
        int alturaFonte = g.getFontMetrics(this.getEixoY().getFont()).getHeight();
        int larguraY = (int)((double)this.getTamanhoGrafico().y * 0.9 - (double)altura - (double)alturaFonte - (double)(explode * 2));
        int b = larguraY / 2;
        if (a < b) {
            propA = (double)a * 1.0 / (double)b;
            propB = 1.0;
            raio = b;
        } else {
            propB = (double)b * 1.0 / (double)a;
            propA = 1.0;
            raio = a;
        }
        int inicioX = this.getBaseGrafico().x + (this.getTamanhoGrafico().x - a * 2) / 2;
        int inicioY = this.getBaseGrafico().y - this.getTamanhoGrafico().y + (this.getTamanhoGrafico().y - b * 2) / 2 - altura / 2;
        int centroX = inicioX + a;
        int centroY = inicioY + b;
        double somaTotal = 0.0;
        int i = 0;
        while (i < this.getSeries().size()) {
            somaTotal += Math.abs(this.getSerie(i).getSomaItens());
            ++i;
        }
        Vector<Integer> vAngulos = new Vector<Integer>();
        int anguloTotal = 0;
        int maiorAngulo = 0;
        int maiorSerie = 0;
        int i2 = 0;
        while (i2 < this.getSeries().size()) {
            angulo = (int)Math.round(Math.abs(this.getSerie(i2).getSomaItens()) / somaTotal * 360.0);
            vAngulos.addElement(new Integer(angulo));
            anguloTotal += angulo;
            if (angulo > maiorAngulo) {
                maiorAngulo = angulo;
                maiorSerie = i2;
            }
            ++i2;
        }
        if (anguloTotal != 360) {
            vAngulos.setElementAt(new Integer((Integer)vAngulos.elementAt(0) + 360 - anguloTotal), 0);
        }
        anguloTotal = this.getAnguloInicialPizza();
        g.setFont(this.obterFonteProporcional(this.getEixoY().getFont()));
        g.setColor(Color.black);
        int m = 0;
        while (m <= 2) {
            Polygon p;
            if (m == 1) {
                int k = 0;
                while (k < coresParedes.size()) {
                    p = (Polygon)paredes.elementAt(k);
                    g.setColor((Color)coresParedes.elementAt(k));
                    g.fillPolygon(p);
                    g.setColor(Color.black);
                    if (((Boolean)visibilidadeParedes.elementAt(k)).booleanValue() && this.explosaoPizza >= 5) {
                        g.drawLine(p.xpoints[0], p.ypoints[0], p.xpoints[3], p.ypoints[3]);
                    } else {
                        g.drawLine(p.xpoints[0], p.ypoints[0], p.xpoints[3], Math.min(p.ypoints[0] + b, p.ypoints[3]));
                    }
                    g.drawLine(p.xpoints[1], p.ypoints[1], p.xpoints[2], p.ypoints[2]);
                    if (((Boolean)visibilidadeParedes.elementAt(k)).booleanValue() && this.explosaoPizza >= 5) {
                        g.drawLine(p.xpoints[2], p.ypoints[2], p.xpoints[3], p.ypoints[3]);
                    }
                    ++k;
                }
            } else {
                int i3 = 0;
                while (i3 < this.getSeries().size()) {
                    angulo = (Integer)vAngulos.elementAt(i3);
                    if (angulo != 0) {
                        anguloMedio = (int)((double)anguloTotal + (double)angulo / 2.0);
                        double anguloRad = ((double)anguloMedio + 90.0) / 180.0 * Math.PI;
                        int incrX = (int)Math.round((double)explode * Math.sin(anguloRad) * propA);
                        int incrY = (int)Math.round((double)explode * Math.cos(anguloRad) * propB);
                        anguloRad = ((double)anguloTotal + 90.0) / 180.0 * Math.PI;
                        int posX1 = centroX + (int)Math.round(raio * Math.sin(anguloRad) * propA);
                        int posY1 = centroY + (int)Math.round(raio * Math.cos(anguloRad) * propB);
                        int anguloHoriz1 = this.obterAnguloHorizontal(anguloTotal + 1);
                        anguloRad = ((double)(anguloTotal + angulo) + 90.0) / 180.0 * Math.PI;
                        int posX2 = centroX + (int)Math.round(raio * Math.sin(anguloRad) * propA);
                        int posY2 = centroY + (int)Math.round(raio * Math.cos(anguloRad) * propB);
                        int anguloHoriz2 = this.obterAnguloHorizontal(anguloTotal + angulo - 1);
                        if (m == 0) {
                            Color corSombra = this.obterSombraCor(this.getSerie(i3).obterCorElemento(-1));
                            g.setColor(corSombra);
                            g.fillArc(inicioX + incrX, inicioY + incrY + altura, a * 2, b * 2, anguloTotal, angulo);
                            p = new Polygon();
                            p.addPoint(centroX + incrX, centroY + incrY + altura);
                            p.addPoint(posX1 + incrX, posY1 + incrY + altura);
                            if (angulo > 180) {
                                p.addPoint(centroX + 3 * incrX, centroY + 3 * incrY + altura);
                            }
                            p.addPoint(posX2 + incrX, posY2 + incrY + altura);
                            g.fillPolygon(p);
                            g.setColor(Color.black);
                            g.drawArc(inicioX + incrX, inicioY + incrY + altura, a * 2, b * 2, anguloTotal, angulo);
                            p = new Polygon();
                            p.addPoint(centroX + incrX, centroY + incrY);
                            p.addPoint(posX1 + incrX, posY1 + incrY);
                            p.addPoint(posX1 + incrX, posY1 + incrY + altura + 1);
                            p.addPoint(centroX + incrX, centroY + incrY + altura + 1);
                            boolean visibilidade = posX1 > centroX;
                            this.adicionarParedeCorAngulo(paredes, anguloParedes, coresParedes, visibilidadeParedes, p, anguloHoriz1, corSombra, visibilidade);
                            p = new Polygon();
                            p.addPoint(centroX + incrX, centroY + incrY);
                            p.addPoint(posX2 + incrX, posY2 + incrY);
                            p.addPoint(posX2 + incrX, posY2 + incrY + altura + 1);
                            p.addPoint(centroX + incrX, centroY + incrY + altura + 1);
                            visibilidade = posX2 < centroX;
                            this.adicionarParedeCorAngulo(paredes, anguloParedes, coresParedes, visibilidadeParedes, p, anguloHoriz2, corSombra, visibilidade);
                            g.setColor(Color.black);
                            g.drawLine(centroX + incrX, centroY + incrY, centroX + incrX, centroY + incrY + altura);
                            g.drawLine(posX1 + incrX, posY1 + incrY, posX1 + incrX, posY1 + incrY + altura);
                            g.drawLine(posX2 + incrX, posY2 + incrY, posX2 + incrX, posY2 + incrY + altura);
                            if (posX1 > centroX) {
                                g.drawLine(centroX + incrX, centroY + incrY + altura, posX1 + incrX, posY1 + incrY + altura);
                            }
                            if (posX2 < centroX) {
                                g.drawLine(centroX + incrX, centroY + incrY + altura, posX2 + incrX, posY2 + incrY + altura);
                            }
                            if (anguloTotal <= 180 && anguloTotal + angulo > 180 || anguloTotal < 540 && anguloTotal + angulo > 540) {
                                p = new Polygon();
                                p.addPoint(centroX + incrX, centroY + incrY);
                                p.addPoint(centroX + incrX - a, centroY + incrY);
                                p.addPoint(centroX + incrX - a, centroY + incrY + altura);
                                p.addPoint(centroX + incrX, centroY + incrY + altura);
                                this.adicionarParedeCorAngulo(paredes, anguloParedes, coresParedes, visibilidadeParedes, p, 0, corSombra, false);
                                g.setColor(Color.black);
                                g.drawLine(centroX + incrX - a, centroY + incrY, centroX + incrX - a, centroY + incrY + altura);
                            }
                            if (anguloTotal < 360 && anguloTotal + angulo >= 360) {
                                p = new Polygon();
                                p.addPoint(centroX + incrX, centroY + incrY);
                                p.addPoint(centroX + incrX + a, centroY + incrY);
                                p.addPoint(centroX + incrX + a, centroY + incrY + altura);
                                p.addPoint(centroX + incrX, centroY + incrY + altura);
                                this.adicionarParedeCorAngulo(paredes, anguloParedes, coresParedes, visibilidadeParedes, p, 0, corSombra, false);
                                g.setColor(Color.black);
                                g.drawLine(centroX + incrX + a, centroY + incrY, centroX + incrX + a, centroY + incrY + altura);
                            }
                        } else {
                            g.setColor(this.getSerie(i3).obterCorElemento(-1));
                            g.fillArc(inicioX + incrX, inicioY + incrY, a * 2, b * 2, anguloTotal, angulo);
                            p = new Polygon();
                            p.addPoint(centroX + incrX, centroY + incrY);
                            p.addPoint(posX1 + incrX, posY1 + incrY);
                            if (angulo > 180) {
                                p.addPoint(centroX + 3 * incrX, centroY + 3 * incrY);
                            }
                            p.addPoint(posX2 + incrX, posY2 + incrY);
                            g.fillPolygon(p);
                            g.setColor(Color.black);
                            g.drawArc(inicioX + incrX, inicioY + incrY, a * 2, b * 2, anguloTotal, angulo);
                            g.drawLine(centroX + incrX, centroY + incrY, posX1 + incrX, posY1 + incrY);
                            g.drawLine(centroX + incrX, centroY + incrY, posX2 + incrX, posY2 + incrY);
                        }
                        anguloMedio = (int)((double)anguloTotal + (double)angulo / 2.0);
                        anguloRad = ((double)anguloMedio + 90.0) / 180.0 * Math.PI;
                        int posX = centroX + (int)(raio * Math.sin(anguloRad) * propA) + incrX;
                        int posY = centroY + (int)(raio * Math.cos(anguloRad) * propB) + incrY;
                        String texto = String.valueOf(this.formatar((double)Math.round(Math.abs(this.getSerie(i3).getSomaItens()) / somaTotal * 1000.0) / 10.0, "0,0")) + "%";
                        posX = posX < centroX ? (posX -= g.getFontMetrics().stringWidth(texto) + 2) : (posX += 2);
                        posY = posY < centroY ? (posY -= 2) : (posY += g.getFontMetrics().getHeight() + 2 + altura);
                        g.drawString(texto, posX, posY);
                        anguloTotal += angulo;
                    }
                    ++i3;
                }
            }
            ++m;
        }
    }

    private String formatar(double valor, String formato) {
        int nroDecimais = 2;
        boolean separadorMilhar = true;
        boolean negativo = false;
        if (valor < 0.0) {
            negativo = true;
            valor *= -1.0;
        }
        if (formato != null) {
            nroDecimais = formato.lastIndexOf(",");
            if (nroDecimais >= 0) {
                nroDecimais = formato.length() - nroDecimais - 1;
            }
            separadorMilhar = formato.indexOf(".") >= 0;
        }
        String texto = String.valueOf(Math.round(valor * Math.pow(10.0, nroDecimais)));
        while (texto.length() <= nroDecimais) {
            texto = "0" + texto;
        }
        if (nroDecimais > 0) {
            texto = String.valueOf(texto.substring(0, texto.length() - nroDecimais)) + "," + texto.substring(texto.length() - nroDecimais);
        }
        if (separadorMilhar) {
            int i = texto.length() - nroDecimais - 4;
            while (i > 0) {
                texto = String.valueOf(texto.substring(0, i)) + "." + texto.substring(i);
                i -= 3;
            }
        }
        return String.valueOf(negativo ? "-" : "") + texto;
    }

    public String formatar(Date d, String formato) throws Throwable {
        if (d == null) {
            return " ";
        }
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(d);
        int ano = calendario.get(1);
        int mes = calendario.get(2) + 1;
        int dia = calendario.get(5);
        String dataFormatada = "";
        if (formato == null) {
            formato = "DD/MM/AA";
        }
        if (formato.equalsIgnoreCase("DD/MM/AAAA")) {
            dataFormatada = String.valueOf(this.strZero(String.valueOf(dia), 2)) + "/" + this.strZero(String.valueOf(mes), 2) + "/" + this.strZero(String.valueOf(ano), 4);
        } else if (formato.equalsIgnoreCase("DD/MM/AA")) {
            dataFormatada = String.valueOf(this.strZero(String.valueOf(dia), 2)) + "/" + this.strZero(String.valueOf(mes), 2) + "/" + this.strZero(String.valueOf(ano - ano / 100 * 100), 2);
        } else if (formato.equalsIgnoreCase("MM/DD/AAAA")) {
            dataFormatada = String.valueOf(this.strZero(String.valueOf(mes), 2)) + "/" + this.strZero(String.valueOf(dia), 2) + "/" + this.strZero(String.valueOf(ano), 4);
        } else if (formato.equalsIgnoreCase("DDMMAAAA")) {
            dataFormatada = String.valueOf(this.strZero(String.valueOf(dia), 2)) + this.strZero(String.valueOf(mes), 2) + this.strZero(String.valueOf(ano), 4);
        } else if (formato.equalsIgnoreCase("AAAAMMDD")) {
            dataFormatada = String.valueOf(this.strZero(String.valueOf(ano), 4)) + this.strZero(String.valueOf(mes), 2) + this.strZero(String.valueOf(dia), 2);
        } else if (formato.equalsIgnoreCase("AAMMDD")) {
            dataFormatada = String.valueOf(this.strZero(String.valueOf(ano - ano / 100 * 100), 2)) + this.strZero(String.valueOf(mes), 2) + this.strZero(String.valueOf(dia), 2);
        } else if (formato.equalsIgnoreCase("DDMMAA")) {
            dataFormatada = String.valueOf(this.strZero(String.valueOf(dia), 2)) + this.strZero(String.valueOf(mes), 2) + this.strZero(String.valueOf(ano - ano / 100 * 100), 4);
        } else if (formato.equalsIgnoreCase("DD/MM")) {
            dataFormatada = String.valueOf(this.strZero(String.valueOf(dia), 2)) + "/" + this.strZero(String.valueOf(mes), 2);
        }
        return dataFormatada;
    }

    public int getAnguloInicialPizza() {
        return this.anguloInicialPizza;
    }

    private Point getBaseGrafico() {
        return this.baseGrafico;
    }

    public Color getCorBorda() {
        return this.corBorda;
    }

    public Color getCorEixos() {
        return this.corEixos;
    }

    public Color getCorFundo() {
        return this.corFundo;
    }

    public Color getCorSombra() {
        return this.corSombra;
    }

    public BBGraficoEixo getEixoX() {
        return this.eixoX;
    }

    public BBGraficoEixo getEixoY() {
        return this.eixoY;
    }

    public int getEspacoEntreBarras() {
        return this.espacoEntreBarras;
    }

    public int getExplosaoPizza() {
        return this.explosaoPizza;
    }

    public Font getFonteLegenda() {
        return this.fonteLegenda;
    }

    private Label getLabelValorY() {
        if (this.labelValorY == null) {
            this.labelValorY = new Label();
            this.labelValorY.setFont(new Font("Arial", 0, 10));
            this.labelValorY.setSize(60, 13);
            this.labelValorY.setVisible(false);
        }
        return this.labelValorY;
    }

    public double getMultiplicadorPerspectiva() {
        return this.multiplicadorPerspectiva;
    }

    public byte getPosicaoLegenda() {
        return this.posicaoLegenda;
    }

    public double getProporcaoBarras() {
        return this.proporcaoBarras;
    }

    private BBGraficoSerie getSerie(int numeroSerie) {
        if (numeroSerie >= this.getSeries().size()) {
            return null;
        }
        return (BBGraficoSerie)this.getSeries().elementAt(numeroSerie);
    }

    private Vector getSeries() {
        if (this.series == null) {
            this.series = new Vector();
        }
        return this.series;
    }

    private Point getTamanhoGrafico() {
        return this.tamanhoGrafico;
    }

    public int getTipo() {
        return this.tipo;
    }

    public BBGraficoLabel getTitulo1() {
        return this.titulo1;
    }

    public BBGraficoLabel getTitulo2() {
        return this.titulo2;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public boolean isIndAlternarValoresEixoX() {
        return this.indAlternarValoresEixoX;
    }

    private boolean isIndMaximos() {
        return this.indMaximos;
    }

    public boolean isPerspectiva3d() {
        return this.perspectiva3d;
    }

    public void limpar() {
        this.numeroSeriesBarra = 0;
        this.getSeries().removeAllElements();
    }

    public static void main(String[] args) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.getTipo() == 4) {
            return;
        }
        Point p = e.getPoint();
        if (p.x > this.getBaseGrafico().x && p.x < this.getBaseGrafico().x + this.getTamanhoGrafico().x && p.y < this.getBaseGrafico().y && p.y > this.getBaseGrafico().y - this.getTamanhoGrafico().y) {
            int altura = this.getBaseGrafico().y - p.y;
            double valorY = (double)altura / this.multY + this.getEixoY().getValorMinimo();
            this.setToolTipText(this.formatar(valorY, this.getEixoY().getFormato()));
        } else {
            this.setToolTipText(null);
            this.getLabelValorY().setVisible(false);
        }
    }

    private int obterAnguloHorizontal(int angulo) {
        if (angulo >= 360) {
            angulo -= 360;
        }
        if (angulo <= 90) {
            return angulo * -1;
        }
        if (angulo <= 270) {
            return angulo - 180;
        }
        return 360 - angulo;
    }

    private Font obterFonteProporcional(Font fonte) {
        if (this.proporcaoFonte == 1.0) {
            return fonte;
        }
        int tamanho = (int)((double)fonte.getSize() * this.proporcaoFonte + 0.5);
        if (tamanho < 9) {
            tamanho = 9;
        }
        return new Font(fonte.getName(), fonte.getStyle(), tamanho);
    }

    private Polygon obterPoligonoPerspectiva(int x1, int y1, int x2, int y2) {
        Polygon p = new Polygon();
        p.addPoint(x1 - this.perspectivaX, y1 + this.perspectivaY);
        p.addPoint(x1, y1);
        p.addPoint(x2, y2);
        p.addPoint(x2 - this.perspectivaX, y2 + this.perspectivaY);
        return p;
    }

    private double obterRaio(int angulo, int a, int b) {
        return Math.sqrt(Math.pow(a, 2.0) * Math.pow(b, 2.0) / (Math.pow(a, 2.0) * Math.pow(Math.cos(((double)angulo + 90.0) / 180.0 * Math.PI), 2.0) + Math.pow(b, 2.0) * Math.pow(Math.sin(((double)angulo + 90.0) / 180.0 * Math.PI), 2.0)));
    }

    private Color obterSombraCor(Color cor) {
        return new Color((int)((double)cor.getRed() * 0.7), (int)((double)cor.getGreen() * 0.7), (int)((double)cor.getBlue() * 0.7));
    }

    public void paint(Graphics g) {
        int margemDireita;
        int margemInferior;
        int margemEsquerda;
        if (!this.indicadorAjusteMaximoMinimo) {
            this.ajustarValoresMaximoMinimo();
        }
        int posX = 0;
        int posY = 0;
        int margemSuperior = 5;
        if (this.getTitulo1().getTexto() != null) {
            g.setFont(this.obterFonteProporcional(this.getTitulo1().getFont()));
            posY = g.getFontMetrics().getHeight() + 5;
            posX = (this.getSize().width - g.getFontMetrics().stringWidth(this.getTitulo1().getTexto())) / 2;
            g.setColor(this.getTitulo1().getColor());
            g.drawString(this.getTitulo1().getTexto(), posX, posY);
        }
        if (this.getTitulo2().getTexto() != null) {
            g.setFont(this.obterFonteProporcional(this.getTitulo2().getFont()));
            posX = (this.getSize().width - g.getFontMetrics().stringWidth(this.getTitulo2().getTexto())) / 2;
            g.setColor(this.getTitulo2().getColor());
            g.drawString(this.getTitulo2().getTexto(), posX, posY += g.getFontMetrics().getHeight() + g.getFontMetrics().getDescent());
        }
        if (this.isPerspectiva3d()) {
            this.perspectivaX = (int)((double)(this.getSize().height / 40) * this.getMultiplicadorPerspectiva());
            this.perspectivaY = (int)((double)this.perspectivaX * 0.5);
        } else {
            this.perspectivaX = 0;
            this.perspectivaY = 0;
        }
        margemSuperior = posY += 10;
        if (this.getTipo() != 4) {
            margemEsquerda = this.perspectivaX + 5 + g.getFontMetrics(this.obterFonteProporcional(this.getEixoY().getLabel().getFont())).stringWidth(this.getEixoY().getLabel().getTexto()) + 5;
            int larguraMaximo = g.getFontMetrics(this.obterFonteProporcional(this.getEixoY().getFont())).stringWidth(this.formatar(this.getEixoY().getValorMaximo(), this.getEixoY().getFormato()));
            if (larguraMaximo + 10 > margemEsquerda) {
                margemEsquerda = larguraMaximo + 10;
            }
            margemInferior = 5;
            FontMetrics fm = g.getFontMetrics(this.obterFonteProporcional(this.getEixoX().getFont()));
            margemInferior += fm.getHeight() + fm.getDescent();
            if (this.isIndAlternarValoresEixoX()) {
                margemInferior += fm.getHeight() + fm.getDescent();
            }
            fm = g.getFontMetrics(this.obterFonteProporcional(this.getEixoX().getLabel().getFont()));
            margemInferior += fm.getHeight() + fm.getDescent();
            margemInferior += this.perspectivaY;
            margemDireita = 10;
        } else {
            margemEsquerda = 10;
            margemInferior = 10;
            margemDireita = 10;
        }
        int larguraLegenda = 0;
        int alturaLegenda = 0;
        this.alturaTotalLegenda = 0;
        if (this.getSeries().size() > 1) {
            g.setFont(this.obterFonteProporcional(this.getFonteLegenda()));
            int i = 0;
            while (i < this.getSeries().size()) {
                if (larguraLegenda < g.getFontMetrics().stringWidth(this.getSerie(i).getDescricao())) {
                    larguraLegenda = g.getFontMetrics().stringWidth(this.getSerie(i).getDescricao());
                }
                ++i;
            }
            alturaLegenda = g.getFontMetrics().getHeight();
            larguraLegenda += alturaLegenda + 15;
            if (this.getPosicaoLegenda() == 0) {
                i = 0;
                while (i < this.getSeries().size()) {
                    if (this.getTipo() == 4) {
                        g.setColor(this.getSerie(i).obterCorElemento(-1));
                    } else {
                        g.setColor(this.getSerie(i).getColor());
                    }
                    g.fillRect(this.getSize().width - larguraLegenda, margemSuperior + 5 + (alturaLegenda + 5) * i, alturaLegenda, alturaLegenda);
                    if (this.getSerie(i).getCorNegativo() != null && (this.getTipo() == 0 || this.getTipo() == 3)) {
                        g.setColor(this.getSerie(i).getCorNegativo());
                        Polygon p = new Polygon();
                        p.addPoint(this.getSize().width - larguraLegenda, margemSuperior + 5 + (alturaLegenda + 5) * i + alturaLegenda);
                        p.addPoint(this.getSize().width - larguraLegenda + alturaLegenda, margemSuperior + 5 + (alturaLegenda + 5) * i);
                        p.addPoint(this.getSize().width - larguraLegenda + alturaLegenda, margemSuperior + 5 + (alturaLegenda + 5) * i + alturaLegenda);
                        g.fillPolygon(p);
                    }
                    g.setColor(Color.black);
                    g.drawRect(this.getSize().width - larguraLegenda, margemSuperior + 5 + (alturaLegenda + 5) * i, alturaLegenda, alturaLegenda);
                    g.drawString(this.getSerie(i).getDescricao(), this.getSize().width - larguraLegenda + alturaLegenda + 5, margemSuperior + 5 + (alturaLegenda + 5) * i + alturaLegenda - 2);
                    ++i;
                }
                g.drawRect(this.getSize().width - larguraLegenda - 5, margemSuperior, larguraLegenda, (alturaLegenda + 5) * this.getSeries().size() + 5);
                margemDireita += larguraLegenda;
            } else {
                int espacoEntreLeg = larguraLegenda / 6;
                if (espacoEntreLeg < 5) {
                    espacoEntreLeg = 5;
                }
                int legendasLinha = (this.getSize().width - margemEsquerda - margemDireita) / (larguraLegenda + espacoEntreLeg);
                int linhasLegenda = this.getSeries().size() / legendasLinha;
                if (linhasLegenda * legendasLinha < this.getSeries().size()) {
                    ++linhasLegenda;
                }
                if (legendasLinha > this.getSeries().size()) {
                    legendasLinha = this.getSeries().size();
                }
                int larguraTotalLeg = legendasLinha * (larguraLegenda + espacoEntreLeg) + 10;
                this.alturaTotalLegenda = linhasLegenda * (alturaLegenda + 5) + 6;
                int inicioLegendaX = margemEsquerda - this.perspectivaX + (this.getSize().width - margemEsquerda - margemDireita - larguraTotalLeg) / 2;
                int inicioLegendaY = this.getSize().height - this.alturaTotalLegenda - 2;
                g.setColor(Color.black);
                g.drawRect(inicioLegendaX, inicioLegendaY, larguraTotalLeg, this.alturaTotalLegenda);
                int coluna = 0;
                int linha = 0;
                int i2 = 0;
                while (i2 < this.getSeries().size()) {
                    g.setColor(this.getSerie(i2).getColor());
                    g.fillRect(inicioLegendaX + coluna * (larguraLegenda + espacoEntreLeg) + 5, inicioLegendaY + 4 + linha * (alturaLegenda + 5), alturaLegenda, alturaLegenda);
                    if (this.getSerie(i2).getCorNegativo() != null && (this.getTipo() == 0 || this.getTipo() == 3)) {
                        g.setColor(this.getSerie(i2).getCorNegativo());
                        Polygon p = new Polygon();
                        p.addPoint(inicioLegendaX + coluna * (larguraLegenda + espacoEntreLeg) + 5, inicioLegendaY + 4 + linha * (alturaLegenda + 5) + alturaLegenda);
                        p.addPoint(inicioLegendaX + coluna * (larguraLegenda + espacoEntreLeg) + 5 + alturaLegenda, inicioLegendaY + 4 + linha * (alturaLegenda + 5));
                        p.addPoint(inicioLegendaX + coluna * (larguraLegenda + espacoEntreLeg) + 5 + alturaLegenda, inicioLegendaY + 4 + linha * (alturaLegenda + 5) + alturaLegenda);
                        g.fillPolygon(p);
                    }
                    g.setColor(Color.black);
                    g.drawRect(inicioLegendaX + coluna * (larguraLegenda + espacoEntreLeg) + 5, inicioLegendaY + 4 + linha * (alturaLegenda + 5), alturaLegenda, alturaLegenda);
                    g.drawString(this.getSerie(i2).getDescricao(), inicioLegendaX + coluna * (larguraLegenda + espacoEntreLeg) + alturaLegenda + 10, inicioLegendaY + 4 + linha * (alturaLegenda + 5) + alturaLegenda - 2);
                    if (++coluna + 1 > legendasLinha) {
                        coluna = 0;
                        ++linha;
                    }
                    ++i2;
                }
                margemInferior += this.alturaTotalLegenda;
            }
        }
        int largura = this.getSize().width - margemEsquerda - margemDireita;
        int altura = this.getSize().height - posY - margemInferior;
        this.setTamanhoGrafico(new Point(largura, altura));
        this.setBaseGrafico(new Point(margemEsquerda, this.getSize().height - margemInferior));
        this.multX = (double)this.getTamanhoGrafico().x / (this.getEixoX().getValorMaximo() - this.getEixoX().getValorMinimo());
        this.multY = (double)(this.getTamanhoGrafico().y - 10) / (this.getEixoY().getValorMaximo() - this.getEixoY().getValorMinimo());
        g.setColor(this.getCorFundo());
        g.fillRect(margemEsquerda, posY, largura, altura);
        g.setColor(this.getCorBorda());
        g.drawRect(margemEsquerda, posY, largura, altura);
        if (this.getTipo() != 4) {
            this.desenharEixoY(g);
            this.desenharEixoX(g);
        } else {
            this.desenharGraficoPizza(g);
        }
        if (this.getTipo() == 0 || this.getTipo() == 2 || this.getTipo() == 3) {
            this.desenharGraficoBarras(g);
            if (this.isPerspectiva3d() && this.getEixoY().getValorMinimo() < 0.0 && this.getEixoY().getValorMaximo() >= 0.0) {
                g.setColor(Color.black);
                int pos = (int)((double)this.getBaseGrafico().y - (0.0 - this.getEixoY().getValorMinimo()) * this.multY);
                g.drawLine(this.getBaseGrafico().x - this.perspectivaX, pos + this.perspectivaY, this.getBaseGrafico().x + this.getTamanhoGrafico().x - this.perspectivaX, pos + this.perspectivaY);
            }
        }
        if (this.getTipo() == 2 || this.getTipo() == 1) {
            this.desenharGraficoLinhas(g);
        }
    }

    public void setAnguloInicialPizza(int newAnguloInicialPizza) {
        this.anguloInicialPizza = newAnguloInicialPizza;
    }

    private void setBaseGrafico(Point newBaseGrafico) {
        this.baseGrafico = newBaseGrafico;
    }

    public void setCorBorda(Color newCorBorda) {
        this.corBorda = newCorBorda;
    }

    public void setCorEixos(Color newCorEixos) {
        this.corEixos = newCorEixos;
    }

    public void setCorFundo(Color newCorFundo) {
        this.corFundo = newCorFundo;
    }

    public void setCorSombra(Color newCorSombra) {
        this.corSombra = newCorSombra;
    }

    public void setEixoX(BBGraficoEixo newEixoX) {
        this.eixoX = newEixoX;
    }

    public void setEixoY(BBGraficoEixo newEixoY) {
        this.eixoY = newEixoY;
    }

    public void setEspacoEntreBarras(int newEspacoEntreBarras) {
        this.espacoEntreBarras = newEspacoEntreBarras;
    }

    public void setExplosaoPizza(int newExplosaoPizza) {
        this.explosaoPizza = newExplosaoPizza;
    }

    public void setFonteLegenda(Font newFonteLegenda) {
        this.fonteLegenda = newFonteLegenda;
    }

    public void setIndAlternarValoresEixoX(boolean newIndAlternarValoresEixoX) {
        this.indAlternarValoresEixoX = newIndAlternarValoresEixoX;
    }

    private void setIndMaximos(boolean newIndMaximos) {
        this.indMaximos = newIndMaximos;
    }

    private void setLabelValorY(Label newLabelValorY) {
        this.labelValorY = newLabelValorY;
    }

    public void setMultiplicadorPerspectiva(double newMultiplicadorPerspectiva) {
        this.multiplicadorPerspectiva = newMultiplicadorPerspectiva;
    }

    public void setPerspectiva3d(boolean newPerspectiva3d) {
        this.perspectiva3d = newPerspectiva3d;
    }

    public void setPosicaoLegenda(byte newPosicaoLegenda) {
        this.posicaoLegenda = newPosicaoLegenda;
    }

    public void setProporcaoBarras(double newProporcaoBarras) {
        this.proporcaoBarras = newProporcaoBarras;
    }

    private void setSeries(Vector newSeries) {
        this.series = newSeries;
    }

    private void setTamanhoGrafico(Point newTamanhoGrafico) {
        this.tamanhoGrafico = newTamanhoGrafico;
    }

    public void setTipo(int newTipo) {
        this.tipo = newTipo;
        this.indicadorAjusteMaximoMinimo = false;
    }

    public void setTitulo1(BBGraficoLabel newTitulo1) {
        this.titulo1 = newTitulo1;
    }

    public void setTitulo2(BBGraficoLabel newTitulo2) {
        this.titulo2 = newTitulo2;
    }

    public void setToolTipText(String newToolTipText) {
        this.toolTipText = newToolTipText;
    }

    private String strZero(String valor, int comprimento) throws Throwable {
        String retorno = "0";
        if ((valor = valor.trim()) != null && valor.length() <= comprimento) {
            retorno = valor;
            int i = 0;
            while (i < comprimento - valor.length()) {
                retorno = "0" + retorno;
                ++i;
            }
        }
        return retorno;
    }

    private class ToolTip
    extends Thread
    implements MouseMotionListener {
        int contadorParado = 0;
        boolean stop;
        Point posicao;

        private ToolTip() {
        }

        public void mouseDragged(MouseEvent evento) {
        }

        public void mouseMoved(MouseEvent evento) {
            this.contadorParado = 0;
            this.posicao = evento.getPoint();
        }

        public void run() {
            this.stop = false;
            while (!this.stop) {
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (BBGrafico.this.getTipo() == 4) continue;
                ++this.contadorParado;
                if (this.contadorParado >= 2 && !BBGrafico.this.getLabelValorY().isVisible() && this.posicao != null) {
                    if (this.posicao.x > ((BBGrafico)BBGrafico.this).getBaseGrafico().x && this.posicao.x < ((BBGrafico)BBGrafico.this).getBaseGrafico().x + ((BBGrafico)BBGrafico.this).getTamanhoGrafico().x && this.posicao.y < ((BBGrafico)BBGrafico.this).getBaseGrafico().y && this.posicao.y > ((BBGrafico)BBGrafico.this).getBaseGrafico().y - ((BBGrafico)BBGrafico.this).getTamanhoGrafico().y) {
                        int altura = ((BBGrafico)BBGrafico.this).getBaseGrafico().y - this.posicao.y;
                        double valorY = (double)altura / BBGrafico.this.multY + BBGrafico.this.getEixoY().getValorMinimo();
                        BBGrafico.this.getLabelValorY().setBackground(BBGrafico.this.getCorFundo());
                        String texto = BBGrafico.this.formatar(valorY, BBGrafico.this.getEixoY().getFormato());
                        BBGrafico.this.getLabelValorY().setText(texto);
                        Graphics g = BBGrafico.this.getLabelValorY().getGraphics();
                        int largura = g.getFontMetrics().stringWidth(texto) + 2;
                        BBGrafico.this.getLabelValorY().setBounds(this.posicao.x + 10, this.posicao.y - 15, largura, ((BBGrafico)BBGrafico.this).getLabelValorY().getSize().height);
                        BBGrafico.this.getLabelValorY().setVisible(true);
                        continue;
                    }
                    BBGrafico.this.getLabelValorY().setVisible(false);
                    continue;
                }
                if (this.contadorParado >= 2) continue;
                BBGrafico.this.getLabelValorY().setVisible(false);
            }
        }
    }
}

