/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.interfaces.infraestrutura;

import br.com.bb.plugins.beans.BBCor;
import br.com.bb.plugins.beans.BBPluginButton;
import br.com.bb.plugins.beans.BBPluginLabel;
import br.com.bb.plugins.beans.BBPluginMaskedTextField;
import br.com.bb.plugins.beans.BBPluginTextField;
import br.com.bb.plugins.controle.infraestrutura.ControleContaCorrente;
import br.com.bb.plugins.interfaces.infraestrutura.DialogBB;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.comum.Agencia;
import br.com.bb.plugins.negocio.comum.Banco;
import br.com.bb.plugins.negocio.comum.ContaCorrente;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class BancoManter
extends DialogBB
implements IInterfacePluginCadastro {
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private BBPluginButton ivjButtonButtonSair = null;
    private BBPluginLabel ivjLabelCodigoAgencia = null;
    private BBPluginLabel ivjLabelNomeAgencia = null;
    private BBPluginLabel ivjLabelTitulo = null;
    private BBPluginMaskedTextField ivjTextFieldCodigoBanco = null;
    private BBPluginTextField ivjTextFieldNomeBanco = null;
    private Panel ivjPanelPrincipal = null;
    private BBPluginButton ivjButtonOk = null;
    private Banco banco;

    public BancoManter(Frame parent) {
        super(parent);
        this.initialize();
    }

    public BancoManter(Frame parent, String title) {
        super(parent, title);
    }

    public BancoManter(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
    }

    public BancoManter(Frame parent, boolean modal) {
        super(parent, modal);
    }

    public void alterar(Object obj) {
        this.banco = (Banco)obj;
        if (this.banco.getCodigo().trim().length() > 0) {
            this.getTextFieldCodigoBanco().setText(this.banco.getCodigo());
            ((Component)((Object)this.getTextFieldCodigoBanco())).setEnabled(false);
            this.getTextFieldNomeBanco().setText(this.banco.getPessoa().getNomePessoa());
            this.getTextFieldNomeBanco().setEnabled(true);
        }
        this.setTitle("Altera\u00e7\u00e3o de Banco");
    }

    private void alterarBanco() {
        try {
            if (this.getTextFieldCodigoBanco().getText().trim().length() == 0 && this.getTextFieldCodigoBanco().getText().trim().equals("00000")) {
                throw new Throwable("Por favor, informe o c\u00f3digo da banco.");
            }
            if (this.getTextFieldNomeBanco().getText().trim().length() == 0) {
                throw new Throwable("Por favor, informe o nome do banco.");
            }
            this.banco.setCodigo(this.getTextFieldCodigoBanco().getText().trim());
            if (!ControleContaCorrente.getControleContaCorrente().isBancoExiste(this.banco)) {
                throw new Throwable("Banco n\u00e3o existe. N\u00e3o foi poss\u00edvel alterar.");
            }
            this.banco.getPessoa().setNomePessoa(this.getTextFieldNomeBanco().getText().trim());
            ControleContaCorrente.getControleContaCorrente().salvarBanco(this.banco);
            ControleContaCorrente.getControleContaCorrente().getInterfaceGerenciadorListaBanco().alterado(this.banco);
            this.dispose();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    public void buttonButtonSair_ActionPerformed(ActionEvent actionEvent) {
        this.fechar();
    }

    public void buttonOk_ActionPerformed(ActionEvent actionEvent) {
        if (ControleContaCorrente.getControleContaCorrente().getIndicadorAcao().equals("A")) {
            this.alterarBanco();
        }
        if (ControleContaCorrente.getControleContaCorrente().getIndicadorAcao().equals("E")) {
            this.excluirBanco();
        }
        if (ControleContaCorrente.getControleContaCorrente().getIndicadorAcao().equals("I")) {
            this.incluirBanco();
        }
        if (ControleContaCorrente.getControleContaCorrente().getIndicadorAcao().equals("D")) {
            this.ocultar();
        }
    }

    private void connEtoC1(WindowEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.buttonOk_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(FocusEvent arg1) {
        try {
            this.textFieldCodigoBanco_FocusLost(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.buttonButtonSair_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(FocusEvent arg1) {
        try {
            this.textFieldNomeBanco_FocusLost(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void detalhar(Object obj) {
        this.banco = (Banco)obj;
        if (this.banco.getCodigo().trim().length() > 0) {
            this.getTextFieldCodigoBanco().setText(this.banco.getCodigo());
            ((Component)((Object)this.getTextFieldCodigoBanco())).setEnabled(false);
            this.getTextFieldNomeBanco().setText(this.banco.getPessoa().getNomePessoa());
            this.getTextFieldNomeBanco().setEnabled(false);
        }
        this.setTitle("Detalhamento de Banco");
    }

    public void excluir(Object obj) {
        this.banco = (Banco)obj;
        if (this.banco.getCodigo().trim().length() > 0) {
            this.getTextFieldCodigoBanco().setText(this.banco.getCodigo());
            ((Component)((Object)this.getTextFieldCodigoBanco())).setEnabled(false);
            this.getTextFieldNomeBanco().setText(this.banco.getPessoa().getNomePessoa());
            this.getTextFieldNomeBanco().setEnabled(false);
        }
        this.setTitle("Exclus\u00e3o de Banco");
    }

    private void excluirBanco() {
        block6: {
            try {
                if (this.getTextFieldCodigoBanco().getText().trim().length() == 0) {
                    throw new Throwable("Por favor, informe o c\u00f3digo do banco.");
                }
                this.banco = new Banco();
                this.banco.setCodigo(this.getTextFieldCodigoBanco().getText().trim());
                if (ControleContaCorrente.getControleContaCorrente().isBancoExiste(this.banco)) {
                    ContaCorrente conta = new ContaCorrente();
                    conta.getAgencia().setBanco(this.banco);
                    Vector contas = ControleContaCorrente.getControleContaCorrente().obterListaContaCorrente(conta);
                    if (contas.size() == 0) {
                        Vector agencias = ControleContaCorrente.getControleContaCorrente().obterListaAgencia(this.banco);
                        int i = 0;
                        while (i < agencias.size()) {
                            ControleContaCorrente.getControleContaCorrente().excluirAgencia((Agencia)agencias.elementAt(i));
                            ++i;
                        }
                        ControleContaCorrente.getControleContaCorrente().excluirBanco(this.banco);
                        this.fechar();
                        break block6;
                    }
                    throw new Throwable("Banco possui conta(s) vinculadas. N\u00e3o foi poss\u00edvel excluir.");
                }
                throw new Throwable("Banco n\u00e3o existe. N\u00e3o foi poss\u00edvel excluir.");
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    private String formatarTextField(String texto) throws Throwable {
        texto = Util.substituirCaracteresEspeciais(texto);
        texto = texto.toUpperCase();
        return texto;
    }

    private BBPluginButton getButtonButtonSair() {
        if (this.ivjButtonButtonSair == null) {
            try {
                this.ivjButtonButtonSair = new BBPluginButton();
                this.ivjButtonButtonSair.setName("ButtonButtonSair");
                this.ivjButtonButtonSair.setBounds(339, 131, 64, 23);
                this.ivjButtonButtonSair.setLabel("Sair");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonButtonSair;
    }

    private BBPluginButton getButtonOk() {
        if (this.ivjButtonOk == null) {
            try {
                this.ivjButtonOk = new BBPluginButton();
                this.ivjButtonOk.setName("ButtonOk");
                this.ivjButtonOk.setBounds(274, 131, 64, 23);
                this.ivjButtonOk.setEnabled(true);
                this.ivjButtonOk.setLabel("Ok");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonOk;
    }

    private BBPluginLabel getLabelCodigoAgencia() {
        if (this.ivjLabelCodigoAgencia == null) {
            try {
                this.ivjLabelCodigoAgencia = new BBPluginLabel();
                this.ivjLabelCodigoAgencia.setName("LabelCodigoAgencia");
                this.ivjLabelCodigoAgencia.setText("C\u00f3digo do banco:");
                this.ivjLabelCodigoAgencia.setBounds(20, 53, 100, 23);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelCodigoAgencia;
    }

    private BBPluginLabel getLabelNomeAgencia() {
        if (this.ivjLabelNomeAgencia == null) {
            try {
                this.ivjLabelNomeAgencia = new BBPluginLabel();
                this.ivjLabelNomeAgencia.setName("LabelNomeAgencia");
                this.ivjLabelNomeAgencia.setText("Nome do banco:");
                this.ivjLabelNomeAgencia.setBounds(20, 89, 100, 23);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelNomeAgencia;
    }

    private BBPluginLabel getLabelTitulo() {
        if (this.ivjLabelTitulo == null) {
            try {
                this.ivjLabelTitulo = new BBPluginLabel();
                this.ivjLabelTitulo.setName("LabelTitulo");
                this.ivjLabelTitulo.setText("Informe os dados do banco:");
                this.ivjLabelTitulo.setBounds(20, 20, 165, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelTitulo;
    }

    private Panel getPanelPrincipal() {
        if (this.ivjPanelPrincipal == null) {
            try {
                this.ivjPanelPrincipal = new Panel();
                this.ivjPanelPrincipal.setName("PanelPrincipal");
                this.ivjPanelPrincipal.setLayout(null);
                this.getPanelPrincipal().add((Component)this.getLabelTitulo(), this.getLabelTitulo().getName());
                this.getPanelPrincipal().add((Component)this.getLabelCodigoAgencia(), this.getLabelCodigoAgencia().getName());
                this.getPanelPrincipal().add((Component)((Object)this.getTextFieldCodigoBanco()), ((Component)((Object)this.getTextFieldCodigoBanco())).getName());
                this.getPanelPrincipal().add((Component)this.getLabelNomeAgencia(), this.getLabelNomeAgencia().getName());
                this.getPanelPrincipal().add((Component)this.getTextFieldNomeBanco(), this.getTextFieldNomeBanco().getName());
                this.getPanelPrincipal().add((Component)this.getButtonOk(), this.getButtonOk().getName());
                this.getPanelPrincipal().add((Component)this.getButtonButtonSair(), this.getButtonButtonSair().getName());
                this.getPanelPrincipal().setBackground(BBCor.getCorFundo());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPanelPrincipal;
    }

    private BBPluginMaskedTextField getTextFieldCodigoBanco() {
        if (this.ivjTextFieldCodigoBanco == null) {
            try {
                this.ivjTextFieldCodigoBanco = new BBPluginMaskedTextField();
                ((Component)((Object)this.ivjTextFieldCodigoBanco)).setName("TextFieldCodigoBanco");
                this.ivjTextFieldCodigoBanco.setBackground(Color.white);
                this.ivjTextFieldCodigoBanco.setTamanhoMaximo(3);
                this.ivjTextFieldCodigoBanco.setMask("###");
                this.ivjTextFieldCodigoBanco.setTransferirFocoPorEnter(true);
                this.ivjTextFieldCodigoBanco.setBounds(127, 53, 60, 23);
                this.ivjTextFieldCodigoBanco.setBlankChar(' ');
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTextFieldCodigoBanco;
    }

    private BBPluginTextField getTextFieldNomeBanco() {
        if (this.ivjTextFieldNomeBanco == null) {
            try {
                this.ivjTextFieldNomeBanco = new BBPluginTextField();
                this.ivjTextFieldNomeBanco.setName("TextFieldNomeBanco");
                this.ivjTextFieldNomeBanco.setBackground(Color.white);
                this.ivjTextFieldNomeBanco.setBounds(127, 89, 276, 23);
                this.ivjTextFieldNomeBanco.setTransferirFocoporEnter(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTextFieldNomeBanco;
    }

    private void handleException(Throwable exception) {
        Util.exibirMensagemErro(exception);
    }

    public void incluir(Object objetoNegocio) {
        this.banco = (Banco)objetoNegocio;
        this.getTextFieldCodigoBanco().setText("");
        ((Component)((Object)this.getTextFieldCodigoBanco())).setEnabled(true);
        this.getTextFieldNomeBanco().setText("");
        this.getTextFieldNomeBanco().setEnabled(true);
        this.setTitle("Inclus\u00e3o de Banco");
    }

    private void incluirBanco() {
        try {
            if (this.getTextFieldCodigoBanco().getText().trim().length() == 0 && this.getTextFieldCodigoBanco().getText().trim().equals("00000")) {
                throw new Throwable("Por favor, informe o c\u00f3digo da banco.");
            }
            if (this.getTextFieldNomeBanco().getText().trim().length() == 0) {
                throw new Throwable("Por favor, informe o nome do banco.");
            }
            this.banco.setCodigo(this.getTextFieldCodigoBanco().getText().trim());
            this.banco.setCodigoPessoa(null);
            if (ControleContaCorrente.getControleContaCorrente().isBancoExiste(this.banco)) {
                throw new Throwable("Banco j\u00e1 existe. N\u00e3o foi poss\u00edvel incluir.");
            }
            this.banco.getPessoa().setNomePessoa(this.getTextFieldNomeBanco().getText().trim());
            ControleContaCorrente.getControleContaCorrente().salvarBanco(this.banco);
            ControleContaCorrente.getControleContaCorrente().getInterfaceGerenciadorListaBanco().incluido(this.banco);
            this.dispose();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    private void initConnections() throws Exception {
        this.addWindowListener(this.ivjEventHandler);
        this.getButtonButtonSair().addActionListener(this.ivjEventHandler);
        this.getTextFieldNomeBanco().addFocusListener(this.ivjEventHandler);
        this.getButtonOk().addActionListener(this.ivjEventHandler);
        ((Component)((Object)this.getTextFieldCodigoBanco())).addFocusListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("AgenciaManter");
            this.setLayout(new BorderLayout());
            ((Component)this).setSize(426, 208);
            this.setModal(true);
            this.setTitle("Manuten\u00e7\u00e3o de banco");
            this.add((Component)this.getPanelPrincipal(), "Center");
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        Util.centralizarJanela(this);
    }

    public static void main(String[] args) {
        try {
            BancoManter aBancoManter = new BancoManter(new Frame());
            aBancoManter.setModal(true);
            aBancoManter.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)aBancoManter).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Ocorreu uma exce\u00e7\u00e3o no main() do br.com.bb.plugins.interfaces.infraestrutura.DialogBB");
            exception.printStackTrace(System.out);
        }
    }

    public void textFieldCodigoBanco_FocusLost(FocusEvent focusEvent) {
        try {
            if (this.getTextFieldCodigoBanco().getText().trim().length() != 0) {
                this.getTextFieldCodigoBanco().setText(Util.strZero(this.getTextFieldCodigoBanco().getText().trim(), 3));
            }
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void textFieldNomeBanco_FocusLost(FocusEvent focusEvent) {
        try {
            this.getTextFieldNomeBanco().setText(Util.substituirCaracteresEspeciais(this.getTextFieldNomeBanco().getText().trim()).toUpperCase());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class IvjEventHandler
    implements ActionListener,
    FocusListener,
    WindowListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == BancoManter.this.getButtonButtonSair()) {
                BancoManter.this.connEtoC5(e);
            }
            if (e.getSource() == BancoManter.this.getButtonOk()) {
                BancoManter.this.connEtoC2(e);
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (e.getSource() == BancoManter.this.getTextFieldNomeBanco()) {
                BancoManter.this.connEtoC6(e);
            }
            if (e.getSource() == BancoManter.this.getTextFieldCodigoBanco()) {
                BancoManter.this.connEtoC3(e);
            }
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            if (e.getSource() == BancoManter.this) {
                BancoManter.this.connEtoC1(e);
            }
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }
}

