/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.interfaces.infraestrutura;

import br.com.bb.plugins.beans.BBPluginButton;
import br.com.bb.plugins.beans.BBPluginLabel;
import br.com.bb.plugins.beans.BBPluginTextField;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.RoteadorPlugins;
import br.com.bb.plugins.controle.infraestrutura.RoteadorUtilitarios;
import br.com.bb.plugins.interfaces.infraestrutura.DialogBB;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.interfaces.infraestrutura.PanelBB;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class DialogBecape
extends DialogBB
implements IInterfacePluginCadastro {
    private BBPluginButton ivjButtonConfirmar = null;
    private BBPluginButton ivjButtonSairGerarCopiaBBPag = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private PanelBB ivjPanelCopiaBBPag = null;
    private FileDialog ivjFileDialogGeraCopiaSeguranca = null;
    private BBPluginButton ivjButtonPesquisarDestino = null;
    private BBPluginLabel ivjLabelDestino = null;
    private BBPluginTextField ivjTextFieldDestino = null;
    public String diretorioOrigem;
    private char indicadorOperacao;
    private Panel ivjPanelBotoes = null;

    public DialogBecape(Frame parent) {
        super(parent);
        this.initialize();
    }

    public DialogBecape(Frame parent, RoteadorPlugins roteadorPlugins) {
        super(parent);
        this.setDiretorioOrigem(roteadorPlugins.getDiretorioDados());
    }

    public void alterar(Object objetoNegocio) {
        this.setTitle("Restaura\u00e7\u00e3o de C\u00f3pia de Seguran\u00e7a");
        this.getLabelDestino().setText("Diret\u00f3rio de Origem");
        this.setIndicadorOperacao('R');
        if (ControleAplicacao.obterParametroConfiguracao("DiretorioBackup") != null) {
            this.getTextFieldDestino().setText(ControleAplicacao.obterParametroConfiguracao("DiretorioBackup"));
            this.getButtonConfirmar().setEnabled(true);
        }
    }

    public void buttonSairGerarCopiaBBPag_ActionPerformed(ActionEvent actionEvent) {
        this.fechar();
    }

    private void connEtoC1(WindowEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.efetuarBackup(new String(), this.getTextFieldDestino().getText());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.buttonSairGerarCopiaBBPag_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.pesquisarDestino();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void copiar(File origem, File destino) throws IOException {
        this.garantirPath(destino);
        FileInputStream in = new FileInputStream(origem);
        FileOutputStream out = new FileOutputStream(destino);
        if (destino.exists()) {
            destino.renameTo(new File(String.valueOf(destino.getName()) + "_"));
        }
        this.copiar(in, out);
        ((OutputStream)out).close();
    }

    public void copiar(InputStream in, OutputStream out) throws IOException {
        int lidos;
        byte[] buffer = new byte[4096];
        while ((lidos = in.read(buffer)) != -1) {
            out.write(buffer, 0, lidos);
        }
        in.close();
    }

    public void detalhar(Object objetoNegocio) {
    }

    public void efetuarBackup(String strOrigemDir, String strDestDir) {
        try {
            File f;
            if (!strDestDir.endsWith(System.getProperty("file.separator"))) {
                strDestDir = String.valueOf(strDestDir) + System.getProperty("file.separator");
            }
            if (!(f = new File(strDestDir)).isDirectory()) {
                throw new Throwable("N\u00e3o \u00e9 um diret\u00f3rio!");
            }
            if (this.getIndicadorOperacao() != 'R') {
                this.setCursor(Cursor.getPredefinedCursor(3));
                RoteadorUtilitarios.getRoteadorUtilitarios().efetuarBackup(strDestDir);
                this.setCursor(Cursor.getPredefinedCursor(0));
                if (ControleAplicacao.obterParametroConfiguracao("DiretorioBackup") == null || strDestDir.equalsIgnoreCase(ControleAplicacao.obterParametroConfiguracao("DiretorioBackup"))) {
                    ControleAplicacao.setarParametroConfiguracao("DiretorioBackup", strDestDir);
                }
            } else {
                this.ocultar();
                RoteadorUtilitarios.getRoteadorUtilitarios().abrirListaArquivos(strDestDir);
            }
            this.dispose();
        }
        catch (Throwable t) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.handleException(t);
            this.exibir();
        }
    }

    public void excluir(Object objetoNegocio) {
    }

    public void garantirPath(File arq) throws IOException {
        String pai = arq.getParent();
        if (pai == null || pai.length() == 0) {
            return;
        }
        new File(pai).mkdirs();
    }

    private BBPluginButton getButtonConfirmar() {
        if (this.ivjButtonConfirmar == null) {
            try {
                this.ivjButtonConfirmar = new BBPluginButton();
                this.ivjButtonConfirmar.setName("ButtonConfirmar");
                this.ivjButtonConfirmar.setEnabled(true);
                this.ivjButtonConfirmar.setLabel("Ok");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonConfirmar;
    }

    private BBPluginButton getButtonPesquisarDestino() {
        if (this.ivjButtonPesquisarDestino == null) {
            try {
                this.ivjButtonPesquisarDestino = new BBPluginButton();
                this.ivjButtonPesquisarDestino.setName("ButtonPesquisarDestino");
                this.ivjButtonPesquisarDestino.setEnabled(true);
                this.ivjButtonPesquisarDestino.setVisible(true);
                this.ivjButtonPesquisarDestino.setLabel("...");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonPesquisarDestino;
    }

    private BBPluginButton getButtonSairGerarCopiaBBPag() {
        if (this.ivjButtonSairGerarCopiaBBPag == null) {
            try {
                this.ivjButtonSairGerarCopiaBBPag = new BBPluginButton();
                this.ivjButtonSairGerarCopiaBBPag.setName("ButtonSairGerarCopiaBBPag");
                this.ivjButtonSairGerarCopiaBBPag.setEnabled(true);
                this.ivjButtonSairGerarCopiaBBPag.setLabel("Cancelar");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonSairGerarCopiaBBPag;
    }

    public String getDiretorioOrigem() {
        return this.diretorioOrigem;
    }

    private FileDialog getFileDialogGeraCopiaSeguranca() {
        if (this.ivjFileDialogGeraCopiaSeguranca == null) {
            try {
                this.ivjFileDialogGeraCopiaSeguranca = new FileDialog(new Frame());
                this.ivjFileDialogGeraCopiaSeguranca.setName("FileDialogGeraCopiaSeguranca");
                this.ivjFileDialogGeraCopiaSeguranca.setLayout(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileDialogGeraCopiaSeguranca;
    }

    private char getIndicadorOperacao() {
        return this.indicadorOperacao;
    }

    private BBPluginLabel getLabelDestino() {
        if (this.ivjLabelDestino == null) {
            try {
                this.ivjLabelDestino = new BBPluginLabel();
                this.ivjLabelDestino.setName("LabelDestino");
                this.ivjLabelDestino.setAlignment(0);
                this.ivjLabelDestino.setText("Destino da c\u00f3pia:");
                this.ivjLabelDestino.setForeground(SystemColor.textHighlight);
                this.ivjLabelDestino.setVisible(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelDestino;
    }

    private Panel getPanelBotoes() {
        if (this.ivjPanelBotoes == null) {
            try {
                this.ivjPanelBotoes = new Panel();
                this.ivjPanelBotoes.setName("PanelBotoes");
                this.ivjPanelBotoes.setLayout(new GridLayout());
                this.getPanelBotoes().add((Component)this.getButtonConfirmar(), this.getButtonConfirmar().getName());
                this.ivjPanelBotoes.add(this.getButtonSairGerarCopiaBBPag());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPanelBotoes;
    }

    private PanelBB getPanelCopiaBBPag() {
        if (this.ivjPanelCopiaBBPag == null) {
            try {
                this.ivjPanelCopiaBBPag = new PanelBB();
                this.ivjPanelCopiaBBPag.setName("PanelCopiaBBPag");
                this.ivjPanelCopiaBBPag.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLabelDestino = new GridBagConstraints();
                constraintsLabelDestino.gridx = 0;
                constraintsLabelDestino.gridy = 0;
                constraintsLabelDestino.ipadx = 3;
                constraintsLabelDestino.insets = new Insets(5, 22, 1, 52);
                this.getPanelCopiaBBPag().add((Component)this.getLabelDestino(), constraintsLabelDestino);
                GridBagConstraints constraintsTextFieldDestino = new GridBagConstraints();
                constraintsTextFieldDestino.gridx = 0;
                constraintsTextFieldDestino.gridy = 1;
                constraintsTextFieldDestino.gridwidth = 3;
                constraintsTextFieldDestino.fill = 2;
                constraintsTextFieldDestino.weightx = 1.0;
                constraintsTextFieldDestino.insets = new Insets(1, 22, 14, 50);
                this.getPanelCopiaBBPag().add((Component)this.getTextFieldDestino(), constraintsTextFieldDestino);
                GridBagConstraints constraintsButtonPesquisarDestino = new GridBagConstraints();
                constraintsButtonPesquisarDestino.gridx = 2;
                constraintsButtonPesquisarDestino.gridy = 1;
                constraintsButtonPesquisarDestino.anchor = 13;
                constraintsButtonPesquisarDestino.ipadx = 7;
                constraintsButtonPesquisarDestino.ipady = -1;
                constraintsButtonPesquisarDestino.insets = new Insets(2, 1, 14, 21);
                this.getPanelCopiaBBPag().add((Component)this.getButtonPesquisarDestino(), constraintsButtonPesquisarDestino);
                GridBagConstraints constraintsPanelBotoes = new GridBagConstraints();
                constraintsPanelBotoes.gridx = 2;
                constraintsPanelBotoes.gridy = 2;
                constraintsPanelBotoes.anchor = 13;
                constraintsPanelBotoes.insets = new Insets(4, 4, 4, 20);
                this.getPanelCopiaBBPag().add((Component)this.getPanelBotoes(), constraintsPanelBotoes);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPanelCopiaBBPag;
    }

    private BBPluginTextField getTextFieldDestino() {
        if (this.ivjTextFieldDestino == null) {
            try {
                this.ivjTextFieldDestino = new BBPluginTextField();
                this.ivjTextFieldDestino.setName("TextFieldDestino");
                this.ivjTextFieldDestino.setToolTipText("Informe o diret\u00f3rio de destino da c\u00f3pia (ex: F:\\becape)");
                this.ivjTextFieldDestino.setBackground(Color.white);
                this.ivjTextFieldDestino.setVisible(true);
                this.ivjTextFieldDestino.setTamanhoMaximo(90);
                this.ivjTextFieldDestino.setEnabled(true);
                this.ivjTextFieldDestino.setEditable(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTextFieldDestino;
    }

    private void handleException(Throwable exception) {
        Util.exibirMensagemErro(exception);
    }

    public void incluir(Object objetoNegocio) {
        this.setTitle("C\u00f3pia de Seguran\u00e7a");
        this.getLabelDestino().setText("Diret\u00f3rio de Destino");
        this.setIndicadorOperacao('C');
        if (ControleAplicacao.obterParametroConfiguracao("DiretorioBackup") != null) {
            this.getTextFieldDestino().setText(ControleAplicacao.obterParametroConfiguracao("DiretorioBackup"));
            this.getButtonConfirmar().setEnabled(true);
        }
    }

    private void initConnections() throws Exception {
        this.addWindowListener(this.ivjEventHandler);
        this.getButtonPesquisarDestino().addActionListener(this.ivjEventHandler);
        this.getButtonConfirmar().addActionListener(this.ivjEventHandler);
        this.getButtonSairGerarCopiaBBPag().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("GeraCopiaSeguranca");
            this.setLayout(new BorderLayout());
            ((Component)this).setSize(511, 175);
            this.setModal(true);
            this.setTitle("C\u00f3pia de seguran\u00e7a");
            this.add((Component)this.getPanelCopiaBBPag(), "Center");
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        Util.centralizarJanela(this);
        this.getButtonConfirmar().setEnabled(false);
    }

    public static void main(String[] args) {
        try {
            DialogBecape aDialogBecape = new DialogBecape(new Frame());
            aDialogBecape.setModal(true);
            aDialogBecape.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)aDialogBecape).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Ocorreu uma exce\u00e7\u00e3o no main() do br.com.bb.plugins.interfaces.infraestrutura.DialogBB");
            exception.printStackTrace(System.out);
        }
    }

    public void pesquisarDestino() {
        try {
            ((Dialog)this.getFileDialogGeraCopiaSeguranca()).setTitle("Selecione o caminho");
            this.getFileDialogGeraCopiaSeguranca().setFile(String.valueOf(this.getRoteador().getPlugin().getCodigoPlugin()) + Util.formatarData(new Date(), "AAAAMMDD") + ".CSB");
            ((Component)this.getFileDialogGeraCopiaSeguranca()).setLocation(500, 400);
            this.getFileDialogGeraCopiaSeguranca().setDirectory(this.getTextFieldDestino().getText().trim());
            this.getFileDialogGeraCopiaSeguranca().show();
            String caminhoEncontrado = this.getFileDialogGeraCopiaSeguranca().getDirectory();
            if (caminhoEncontrado == null) {
                return;
            }
            this.getTextFieldDestino().setText(caminhoEncontrado);
            if (this.getTextFieldDestino().getText().trim().compareTo("") != 0) {
                this.getButtonConfirmar().setEnabled(true);
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void setDiretorioOrigem(String newDiretorioOrigem) {
        this.diretorioOrigem = newDiretorioOrigem;
    }

    private void setIndicadorOperacao(char newIndicadorOperacao) {
        this.indicadorOperacao = newIndicadorOperacao;
    }

    class IvjEventHandler
    implements ActionListener,
    WindowListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DialogBecape.this.getButtonPesquisarDestino()) {
                DialogBecape.this.connEtoC4(e);
            }
            if (e.getSource() == DialogBecape.this.getButtonConfirmar()) {
                DialogBecape.this.connEtoC2(e);
            }
            if (e.getSource() == DialogBecape.this.getButtonSairGerarCopiaBBPag()) {
                DialogBecape.this.connEtoC3(e);
            }
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            if (e.getSource() == DialogBecape.this) {
                DialogBecape.this.connEtoC1(e);
            }
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }
}

