/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.negocio.infraestrutura;

import br.com.bb.plugins.negocio.infraestrutura.RegistroRemessa;
import br.com.bb.plugins.utilitarios.Util;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class CampoRemessa {
    private char natureza = (char)83;
    private int tamanho = 0;
    private String formato = "";
    private double valorDuplo;
    private Date valorData;
    private String valorString;
    private String nome = "";
    private int numeroDecimais = 0;
    private RegistroRemessa registroPai;
    private int inicio;
    private int fim;
    private byte alinhamento = 0;
    private Vector conteudoCampoRemessa;
    private boolean obrigatorio;
    private String descricao;

    public CampoRemessa copia() throws Throwable {
        CampoRemessa c = new CampoRemessa();
        c.setNome(this.getNome());
        c.setNatureza(this.getNatureza());
        c.setNumeroDecimais(this.getNumeroDecimais());
        c.setObrigatorio(this.isObrigatorio());
        c.setDescricao(this.getDescricao());
        c.setConteudoCampoRemessa(this.getConteudoCampoRemessa());
        if (this.getNatureza() == 'D') {
            c.setFormato(this.getFormato());
        }
        c.setTamanho(this.getTamanho());
        if (this.getNatureza() == 'D') {
            c.setValor(this.getValorData());
        }
        if (this.getNatureza() == 'N') {
            c.setValor(this.getValorNumerico());
        }
        if (this.getNatureza() == 'S') {
            c.setValor(this.getValorString());
            c.setAlinhamento(this.getAlinhamento());
        }
        return c;
    }

    public String gerarTexto() throws Throwable {
        switch (this.getNatureza()) {
            case 'D': {
                if (this.getValorData() == null) {
                    return Util.padR("", this.getFormato().length(), "0");
                }
                GregorianCalendar g = new GregorianCalendar();
                g.setTime(this.getValorData());
                if (this.getFormato().length() == 0 || this.getFormato().equalsIgnoreCase("AAAAMMDD")) {
                    return String.valueOf(Util.padR(String.valueOf(g.get(1)), 4, "0")) + Util.padR(String.valueOf(g.get(2) + 1), 2, "0") + Util.padR(String.valueOf(g.get(5)), 2, "0");
                }
                if (this.getFormato().equalsIgnoreCase("AAMMDD")) {
                    return String.valueOf(Util.padR(String.valueOf(g.get(1) % 100), 2, "0")) + Util.padR(String.valueOf(g.get(2) + 1), 2, "0") + Util.padR(String.valueOf(g.get(5)), 2, "0");
                }
                if (this.getFormato().equalsIgnoreCase("DDMMAA")) {
                    return String.valueOf(Util.padR(String.valueOf(g.get(5)), 2, "0")) + Util.padR(String.valueOf(g.get(2) + 1), 2, "0") + Util.padR(String.valueOf(g.get(1) % 100), 2, "0");
                }
                if (this.getFormato().equalsIgnoreCase("DDMMAAAA")) {
                    return String.valueOf(Util.padR(String.valueOf(g.get(5)), 2, "0")) + Util.padR(String.valueOf(g.get(2) + 1), 2, "0") + Util.padR(String.valueOf(g.get(1)), 4, "0");
                }
                if (this.getFormato().equalsIgnoreCase("DD.MM.AAAA")) {
                    return String.valueOf(Util.padR(String.valueOf(g.get(5)), 2, "0")) + "." + Util.padR(String.valueOf(g.get(2) + 1), 2, "0") + "." + Util.padR(String.valueOf(g.get(1)), 4, "0");
                }
                if (this.getFormato().equalsIgnoreCase("ADDD")) {
                    return String.valueOf(String.valueOf(g.get(1) % 10)) + Util.padR(String.valueOf(g.get(6)), 3, "0");
                }
                throw new Throwable(String.valueOf(this.getNome()) + " - Formato de data n\u00e3o reconhecido!");
            }
            case 'S': {
                if (this.getValorString() == null) {
                    this.setValor("");
                }
                String retorno = this.getAlinhamento() == 0 ? Util.padL(this.getValorString(), this.getTamanho()) : Util.padR(this.getValorString(), this.getTamanho());
                return retorno;
            }
            case 'N': {
                double valorDouble = this.getValorNumerico() * Math.pow(10.0, this.getNumeroDecimais()) + 1.0 / Math.pow(10.0, this.getNumeroDecimais() + 4);
                long valorLong = (long)valorDouble;
                String valorLongTexto = String.valueOf(valorLong);
                return Util.padR(valorLongTexto, this.getTamanho(), "0");
            }
            case 'R': {
                String valorLongTexto = String.valueOf(this.getRegistroPai().getArquivoRemessa().getContador());
                if (valorLongTexto.length() > this.getTamanho()) {
                    throw new Throwable(String.valueOf(this.getNome()) + " - N\u00famero excede tamanho m\u00e1ximo!");
                }
                return Util.padR(valorLongTexto, this.getTamanho(), "0");
            }
        }
        throw new Throwable(String.valueOf(this.getNome()) + " - Campo inv\u00e1lido!");
    }

    public byte getAlinhamento() {
        return this.alinhamento;
    }

    public Vector getConteudoCampoRemessa() {
        return this.conteudoCampoRemessa;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public int getFim() {
        return this.fim;
    }

    public String getFormato() {
        return this.formato;
    }

    public int getInicio() {
        return this.inicio;
    }

    public char getNatureza() {
        return this.natureza;
    }

    public String getNome() {
        return this.nome;
    }

    public int getNumeroDecimais() {
        return this.numeroDecimais;
    }

    public RegistroRemessa getRegistroPai() {
        return this.registroPai;
    }

    public int getTamanho() {
        return this.tamanho;
    }

    public Date getValorData() throws Throwable {
        if (this.getNatureza() != 'D') {
            throw new Throwable(String.valueOf(this.getNome()) + "Campo n\u00e3o \u00e9 do tipo data!");
        }
        return this.valorData;
    }

    public double getValorDouble() throws Throwable {
        if (this.getNatureza() != 'N' && this.getNatureza() != 'R') {
            throw new Throwable(String.valueOf(this.getNome()) + "Campo n\u00e3o \u00e9 do tipo num\u00e9rico!");
        }
        return this.valorDuplo;
    }

    public int getValorInt() throws Throwable {
        if (this.getNatureza() != 'N' && this.getNatureza() != 'R') {
            throw new Throwable(String.valueOf(this.getNome()) + "Campo n\u00e3o \u00e9 do tipo num\u00e9rico!");
        }
        return (int)this.valorDuplo;
    }

    public long getValorLong() throws Throwable {
        if (this.getNatureza() != 'N' && this.getNatureza() != 'R') {
            throw new Throwable(String.valueOf(this.getNome()) + "Campo n\u00e3o \u00e9 do tipo num\u00e9rico!");
        }
        return (long)this.valorDuplo;
    }

    public double getValorNumerico() throws Throwable {
        if (this.getNatureza() != 'N' && this.getNatureza() != 'R') {
            throw new Throwable(String.valueOf(this.getNome()) + "Campo n\u00e3o \u00e9 do tipo num\u00e9rico!");
        }
        return this.valorDuplo;
    }

    public String getValorString() throws Throwable {
        if (this.getNatureza() != 'S') {
            throw new Throwable(String.valueOf(this.getNome()) + "Campo n\u00e3o \u00e9 do tipo string!");
        }
        return this.valorString;
    }

    public boolean isObrigatorio() {
        return this.obrigatorio;
    }

    public void lerTexto(String texto) throws Throwable {
        try {
            switch (this.getNatureza()) {
                case 'D': {
                    try {
                        GregorianCalendar hoje = new GregorianCalendar();
                        hoje.setTime(new Date());
                        int anoBase = hoje.get(1) / 100 * 100;
                        if (this.getFormato().length() == 0 || this.getFormato().equalsIgnoreCase("AAAAMMDD")) {
                            GregorianCalendar g = new GregorianCalendar(Integer.parseInt(texto.substring(0, 4)), Integer.parseInt(texto.substring(4, 6)) - 1, Integer.parseInt(texto.substring(6, 8)));
                            this.setValor(g.getTime());
                            break;
                        }
                        if (this.getFormato().equalsIgnoreCase("AAMMDD")) {
                            GregorianCalendar g = new GregorianCalendar(anoBase + Integer.parseInt(texto.substring(0, 2)), Integer.parseInt(texto.substring(2, 4)) - 1, Integer.parseInt(texto.substring(4, 6)));
                            this.setValor(g.getTime());
                            break;
                        }
                        if (this.getFormato().equalsIgnoreCase("DDMMAA")) {
                            GregorianCalendar g = new GregorianCalendar(anoBase + Integer.parseInt(texto.substring(4, 6)), Integer.parseInt(texto.substring(2, 4)) - 1, Integer.parseInt(texto.substring(0, 2)));
                            this.setValor(g.getTime());
                            break;
                        }
                        if (this.getFormato().equalsIgnoreCase("DDMMAAAA")) {
                            GregorianCalendar g = new GregorianCalendar(Integer.parseInt(texto.substring(4, 8)), Integer.parseInt(texto.substring(2, 4)) - 1, Integer.parseInt(texto.substring(0, 2)));
                            this.setValor(g.getTime());
                            break;
                        }
                        if (this.getFormato().equalsIgnoreCase("DD.MM.AAAA")) {
                            GregorianCalendar g = new GregorianCalendar(Integer.parseInt(texto.substring(6, 10)), Integer.parseInt(texto.substring(3, 5)) - 1, Integer.parseInt(texto.substring(0, 2)));
                            this.setValor(g.getTime());
                            break;
                        }
                        if (this.getFormato().equalsIgnoreCase("ADDD")) {
                            anoBase = hoje.get(1) / 10 * 10;
                            GregorianCalendar g = new GregorianCalendar(anoBase + Integer.parseInt(texto.substring(0, 1)), 0, 1);
                            g.add(6, Integer.parseInt(texto.substring(1, 4)));
                            this.setValor(g.getTime());
                        }
                        break;
                    }
                    catch (Throwable th) {
                        throw new Throwable("Conte\u00fado do campo n\u00e3o \u00e9 uma data v\u00e1lida");
                    }
                }
                case 'S': {
                    this.setValor(texto.trim());
                    break;
                }
                case 'N': 
                case 'R': {
                    try {
                        this.setValor(Double.valueOf(texto) / Math.pow(10.0, this.getNumeroDecimais()));
                        break;
                    }
                    catch (Throwable th) {
                        throw new Throwable("Counte\u00fado do campo n\u00e3o num\u00e9rico");
                    }
                }
            }
        }
        catch (Throwable t) {
            if (this.getDescricao() != null && this.getDescricao().trim().length() > 0) {
                throw new Throwable("Campo: " + this.getDescricao() + " - " + t.getMessage());
            }
            throw new Throwable(String.valueOf(this.getNome()) + " - " + t.getMessage());
        }
    }

    public void setAlinhamento(byte newAlinhamento) {
        this.alinhamento = newAlinhamento;
    }

    public void setConteudoCampoRemessa(Vector newConteudoCampoRemessa) {
        this.conteudoCampoRemessa = newConteudoCampoRemessa;
    }

    public void setDescricao(String newDescricao) {
        this.descricao = newDescricao;
    }

    public void setFim(int newFim) {
        this.fim = newFim;
    }

    public void setFormato(String newFormato) throws Throwable {
        if (this.getNatureza() != 'D') {
            throw new Throwable(String.valueOf(this.getNome()) + " - Formato dispon\u00edvel somente para campos data!");
        }
        this.formato = newFormato;
        this.setTamanho(newFormato.length());
    }

    public void setInicio(int newInicio) {
        this.inicio = newInicio;
    }

    public void setNatureza(char newNatureza) throws Throwable {
        switch (newNatureza) {
            case 'D': 
            case 'N': 
            case 'R': 
            case 'S': {
                break;
            }
            default: {
                throw new Throwable(String.valueOf(this.getNome()) + " - Tipo n\u00e3o suportado!");
            }
        }
        this.natureza = newNatureza;
    }

    public void setNome(String newNome) {
        this.nome = newNome;
    }

    public void setNumeroDecimais(int newNumeroDecimais) {
        this.numeroDecimais = newNumeroDecimais;
    }

    public void setObrigatorio(boolean newObrigatorio) {
        this.obrigatorio = newObrigatorio;
    }

    public void setRegistroPai(RegistroRemessa newRegistro) {
        this.registroPai = newRegistro;
    }

    public void setTamanho(int newTamanho) {
        this.tamanho = newTamanho;
    }

    public void setValor(double valor) throws Throwable {
        if (this.getNatureza() != 'N' && this.getNatureza() != 'R') {
            throw new Throwable(String.valueOf(this.getNome()) + " - N\u00e3o \u00e9 do tipo num\u00e9rico");
        }
        if (Math.pow(10.0, this.getTamanho()) <= valor * Math.pow(10.0, this.getNumeroDecimais())) {
            throw new Throwable(String.valueOf(this.getNome()) + " - Valor muito grande para o campo");
        }
        this.valorDuplo = valor;
    }

    public void setValor(String valor) throws Throwable {
        if (this.getNatureza() != 'S') {
            throw new Throwable(String.valueOf(this.getNome()) + " - N\u00e3o \u00e9 do tipo string");
        }
        this.valorString = valor.length() > this.getTamanho() ? valor.substring(0, this.getTamanho()) : valor;
    }

    public void setValor(Date valor) throws Throwable {
        if (this.getNatureza() != 'D') {
            throw new Throwable(String.valueOf(this.getNome()) + " - N\u00e3o \u00e9 do tipo data");
        }
        this.valorData = valor;
    }
}

