/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.comum;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;

public class ConexaoBancoDados {
    private static String protocol = "jdbc";
    private static String subprotocol = "odbc";
    private static String DBName = "BBPluginBD";
    private static String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private static String padraoSQL = "ANSI";
    protected static Connection con = null;
    public static boolean conectado;

    private ConexaoBancoDados() {
    }

    public static synchronized boolean conectar() throws SQLException {
        block13: {
            if (con == null) break block13;
            if (con.isClosed()) {
                con = null;
                break block13;
            }
            ConexaoBancoDados.setConectado(true);
            return true;
        }
        try {
            if (!protocol.equalsIgnoreCase("jdbc:interbase:")) {
                String url = String.valueOf(protocol) + ":" + subprotocol + ":" + DBName;
                Class.forName(driver).newInstance();
                Properties p = new Properties();
                ((Hashtable)p).put("password", "persona");
                try {
                    con = DriverManager.getConnection(url, p);
                }
                catch (SQLException sqlEx) {
                    if (sqlEx.getSQLState().equals("42000")) {
                        url = String.valueOf(url) + ";Pwd=persona";
                        con = DriverManager.getConnection(url);
                    }
                    throw sqlEx;
                }
                SQLWarning w = con.getWarnings();
                while (w != null) {
                    System.out.println("----------------- SQLWarning - Conex\u00e3o --------------------");
                    System.out.println("SQLState: " + w.getSQLState());
                    System.out.println("Message: " + w.getMessage());
                    System.out.println("Vendor: " + w.getErrorCode());
                    w = w.getNextWarning();
                }
            } else {
                String url = String.valueOf(protocol) + ":" + subprotocol + ":" + DBName;
                Class.forName("interbase.interclient.Driver").newInstance();
                Properties p = new Properties();
                ((Hashtable)p).put("password", "persona");
                con = DriverManager.getConnection(url, p);
            }
            con.setAutoCommit(true);
        }
        catch (ClassNotFoundException e) {
            ConexaoBancoDados.setConectado(false);
            throw new SQLException("conectar_driver: " + e.getMessage());
        }
        catch (SQLException de) {
            ConexaoBancoDados.setConectado(false);
            if (de.getSQLState().equalsIgnoreCase("IM002") || de.getSQLState().equalsIgnoreCase("S1000")) {
                throw new SQLException("Banco de dados n\u00e3o localizado. Entre em contato com o suporte.");
            }
            System.out.println("msg: " + de.getMessage());
            System.out.println("sqlState: " + de.getSQLState());
            System.out.println("vendor: " + de.getErrorCode());
            throw new SQLException("Conex\u00e3o: " + de.getMessage());
        }
        catch (Throwable ie) {
            ConexaoBancoDados.setConectado(false);
            throw new SQLException("Erro Conexao: " + ie.getMessage());
        }
        ConexaoBancoDados.setConectado(true);
        return true;
    }

    public static boolean desconectar() throws SQLException {
        if (con != null && !con.isClosed()) {
            con.close();
            con = null;
            conectado = false;
        }
        return true;
    }

    public static Connection getConexao() throws SQLException {
        if (con == null) {
            ConexaoBancoDados.conectar();
        }
        return con;
    }

    public static String getNomeBancoDados() {
        return DBName;
    }

    public static String getPadraoSQL() {
        return padraoSQL;
    }

    public static boolean isConectado() {
        return conectado;
    }

    private static void setConectado(boolean newConectado) {
        conectado = newConectado;
    }

    public static void setConexao(Connection newCon) {
        con = newCon;
    }

    public static void setDriver(String newDriver) {
        driver = newDriver;
    }

    public static void setNomeBancoDados(String newDBName) {
        DBName = newDBName;
    }

    public static void setPadraoSQL(String newPadrao) {
        padraoSQL = newPadrao;
    }

    public static void setProtocolo(String newProtocol) {
        protocol = newProtocol;
    }

    public static void setSubprotocolo(String newSubprotocol) {
        subprotocol = newSubprotocol;
    }

    public static void start() {
        Thread t1 = new Thread(new Runnable(){

            public void run() {
                try {
                    ConexaoBancoDados.conectar();
                }
                catch (SQLException e) {
                    ControleAplicacao.getRoteadorPlugins().exibirMensagemErro(e);
                    System.exit(0);
                }
            }
        });
        t1.start();
    }
}

