/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.comum;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.persistencia.comum.Persistencia;
import br.com.bb.plugins.utilitarios.Util;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.Vector;

public class PersistenciaDBF
extends Persistencia {
    private static PersistenciaDBF persistenciaDBF = null;
    private String protocol = "jdbc";
    private String subprotocol = "odbc";
    private String DBName = "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + "OLD";
    private String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String padraoSQL = "ANSI";

    private PersistenciaDBF() {
    }

    public int abrirLista() throws SQLException {
        return 0;
    }

    public int abrirLista(String query) throws SQLException {
        return this.adicionarLista(query);
    }

    public void adicionar(Object objetoNegocio) throws SQLException {
    }

    public void alterar(Object objetoNegocio) throws SQLException {
    }

    public void conectar() throws SQLException {
        try {
            String url = String.valueOf(this.protocol) + ":" + this.subprotocol + ":" + this.DBName;
            if (this.con != null) {
                if (!this.con.isClosed()) {
                    return;
                }
                this.desconectar();
                return;
            }
            Class.forName(this.driver).newInstance();
            Properties p = new Properties();
            this.con = DriverManager.getConnection(url);
            SQLWarning w = this.con.getWarnings();
            while (w != null) {
                System.out.println("----------------- SQLWarning - Conex\u00e3o --------------------");
                System.out.println("SQLState: " + w.getSQLState());
                System.out.println("Message: " + w.getMessage());
                System.out.println("Vendor: " + w.getErrorCode());
                w = w.getNextWarning();
            }
            this.con.setAutoCommit(true);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("conectar_driver: " + e.getMessage());
        }
        catch (SQLException de) {
            if (de.getSQLState().equalsIgnoreCase("IM002")) {
                throw new SQLException("Banco de dados n\u00e3o localizado. Entre em contato com o suporte.");
            }
            System.out.println("msg: " + de.getMessage());
            System.out.println("sqlState: " + de.getSQLState());
            System.out.println("vendor: " + de.getErrorCode());
            throw new SQLException("Conex\u00e3o: " + de.getMessage());
        }
        catch (Throwable ie) {
            throw new SQLException("Erro Conexao: " + ie.getMessage());
        }
    }

    public void desconectar() throws SQLException {
        if (this.con != null && !this.con.isClosed()) {
            this.con.close();
            this.con = null;
        }
    }

    public static PersistenciaDBF getPersistenciaDBF() {
        if (persistenciaDBF == null) {
            persistenciaDBF = new PersistenciaDBF();
        }
        return persistenciaDBF;
    }

    public void lerRegistro(Object objetoNegocio, ResultSet rs) throws SQLException {
        String[] s = (String[])objetoNegocio;
        int i = rs.getMetaData().getColumnCount();
        int j = 0;
        while (j < i) {
            switch (rs.getMetaData().getColumnType(j + 1)) {
                case 8: {
                    s[j] = String.valueOf(rs.getDouble(j + 1));
                    break;
                }
                case 4: {
                    s[j] = String.valueOf(rs.getInt(j + 1));
                    break;
                }
                case -5: {
                    s[j] = String.valueOf(rs.getLong(j + 1));
                    break;
                }
                case 12: {
                    s[j] = rs.getString(j + 1);
                    break;
                }
                case 93: {
                    try {
                        s[j] = Util.formatarData(rs.getDate(j + 1));
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                case 91: {
                    try {
                        s[j] = Util.formatarData(rs.getDate(j + 1));
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                case 5: {
                    s[j] = String.valueOf(rs.getInt(j + 1));
                }
            }
            ++j;
        }
    }

    public Object lerRegistro(ResultSet rs) throws SQLException {
        int i = rs.getMetaData().getColumnCount();
        String[] s = new String[i];
        this.lerRegistro(s, rs);
        return s;
    }

    public boolean localizado(Object objetoNegocio) throws SQLException {
        return false;
    }

    public void obter(Object objetoNegocio) throws SQLException {
    }

    public Vector obterLista() throws SQLException {
        return null;
    }

    public Vector obterLista(String query) throws SQLException {
        return this.gerarVetor(query);
    }

    public void remover(Object objetoNegocio) throws SQLException {
    }

    public void salvar(Object objetoNegocio) throws SQLException {
    }
}

