/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.infraestrutura;

import br.com.bb.plugins.negocio.infraestrutura.Transacao;
import br.com.bb.plugins.persistencia.infraestrutura.XmlBD;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TransacaoBD {
    public void lerNodeListTransacao(NodeList nosI, Vector listaTransacoes) {
        int j = 0;
        while (j < nosI.getLength()) {
            Transacao transacao = new Transacao();
            transacao.setCodigoTransacao(((Element)nosI.item(j)).getAttribute("Codigo"));
            transacao.setDescricaoTransacao(((Element)nosI.item(j)).getAttribute("NomeComponente"));
            transacao.setIndicadorControleAcesso(((Element)nosI.item(j)).getAttribute("TipoComponente") == "1");
            NodeList nos = ((Element)nosI.item(j)).getChildNodes();
            if (nos.getLength() > 0) {
                this.lerNodeListTransacao(nos, listaTransacoes);
            }
            listaTransacoes.addElement(transacao);
            ++j;
        }
    }

    public Vector lerNodeListTransacaoHierarquica(NodeList nosI) {
        Vector<Transacao> listaTransacoes = new Vector<Transacao>();
        int j = 0;
        while (j < nosI.getLength()) {
            Transacao transacao = new Transacao();
            transacao.setCodigoTransacao(((Element)nosI.item(j)).getAttribute("Codigo"));
            transacao.setDescricaoTransacao(((Element)nosI.item(j)).getAttribute("NomeComponente"));
            transacao.setIndicadorControleAcesso(((Element)nosI.item(j)).getAttribute("TipoComponente") == "1");
            NodeList nos = ((Element)nosI.item(j)).getChildNodes();
            if (nos.getLength() > 0) {
                transacao.setSubtransacoes(this.lerNodeListTransacaoHierarquica(nos));
            }
            listaTransacoes.addElement(transacao);
            ++j;
        }
        return listaTransacoes;
    }

    public static void main(String[] args) {
        TransacaoBD t = new TransacaoBD();
        Vector v = t.obterLista("PLG");
        int i = 0;
        while (i < v.size()) {
            System.out.println(((Transacao)v.elementAt(i)).getCodigoTransacao());
            ++i;
        }
    }

    public Vector obterLista(String plugin) {
        Vector listaTransacoes = new Vector();
        XmlDocumentBuilder builder = XmlBD.obter(plugin, "Transacao_" + plugin + ".xml");
        Element elemento = builder.getDocument().getDocumentElement();
        if (elemento != null) {
            NodeList list = elemento.getChildNodes();
            this.lerNodeListTransacao(list, listaTransacoes);
        }
        return listaTransacoes;
    }

    public Vector obterListaHierarquica(String plugin) {
        Vector listaTransacoes = new Vector();
        File arquivoXML = new File(String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "aplicativos" + System.getProperty("file.separator") + "classes" + System.getProperty("file.separator") + "transacao_" + plugin + ".xml");
        XmlDocumentBuilder builder = new XmlDocumentBuilder();
        try {
            InputSource in = Resolver.createInputSource((File)arquivoXML);
            ValidatingParser parser = new ValidatingParser();
            parser.setDocumentHandler((DocumentHandler)builder);
            parser.parse(in);
        }
        catch (IOException i) {
            System.out.println("Erro de Leitura ou Gravacao" + i);
        }
        catch (SAXParseException s) {
            System.out.println("Erro no arquivo " + arquivoXML.getName());
            System.out.println(String.valueOf(s.getMessage()) + " linha:" + s.getLineNumber() + " coluna:" + s.getColumnNumber());
        }
        catch (SAXException sa) {
            System.out.println(sa.getMessage());
        }
        Element elemento = builder.getDocument().getDocumentElement();
        if (elemento != null) {
            NodeList list = elemento.getChildNodes();
            listaTransacoes = this.lerNodeListTransacaoHierarquica(list);
        }
        return listaTransacoes;
    }
}

