/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.utilitarios.ParserXMLToEstrutura;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class XmlBD {
    private static String diretorioXML = ControleAplicacao.getDiretorioClasses();

    public boolean adicionar(String arquivo) throws IOException {
        return XmlBD.adicionar("infra", arquivo);
    }

    public static boolean adicionar(String base, String nomeArquivo) throws IOException {
        File f = new File(String.valueOf(XmlBD.getDiretorioXML()) + System.getProperty("file.separator") + "xml" + base + ".bbz");
        File f1 = new File(String.valueOf(XmlBD.getDiretorioXML()) + System.getProperty("file.separator") + "xml" + base + ".new");
        File f2 = new File(nomeArquivo);
        if (!f2.exists()) {
            return false;
        }
        ZipFile zipExistente = null;
        ZipOutputStream novoArquivo = null;
        FileOutputStream out = null;
        boolean indRenomear = false;
        if (f.exists()) {
            indRenomear = true;
            zipExistente = new ZipFile(f);
            out = new FileOutputStream(f1);
            novoArquivo = new ZipOutputStream(out);
            Enumeration<? extends ZipEntry> entries = zipExistente.entries();
            while (true) {
                int lidos;
                ZipEntry ze;
                try {
                    ze = entries.nextElement();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                if (ze.getName().equalsIgnoreCase(f2.getName())) continue;
                InputStream zin = zipExistente.getInputStream(ze);
                byte[] b = new byte[(int)ze.getSize()];
                novoArquivo.putNextEntry(new ZipEntry(ze.getName()));
                int totalLidos = 0;
                while ((lidos = zin.read(b, totalLidos, b.length - totalLidos)) > 0) {
                    totalLidos += lidos;
                }
                novoArquivo.write(b);
                zin.close();
                novoArquivo.closeEntry();
            }
            zipExistente.close();
        } else {
            out = new FileOutputStream(f);
            novoArquivo = new ZipOutputStream(out);
        }
        FileInputStream fi = new FileInputStream(f2);
        byte[] b = new byte[fi.available()];
        fi.read(b);
        fi.close();
        ZipEntry ze = new ZipEntry(f2.getName());
        novoArquivo.putNextEntry(ze);
        novoArquivo.write(b);
        novoArquivo.closeEntry();
        novoArquivo.close();
        out.close();
        if (indRenomear) {
            if (!f.delete()) {
                return false;
            }
            if (!f1.renameTo(f)) {
                return false;
            }
        }
        return true;
    }

    public static String getArquivoXML() {
        File f = new File(String.valueOf(XmlBD.getDiretorioXML()) + System.getProperty("file.separator") + "xmlinfra.bbz");
        if (!f.exists()) {
            XmlBD.setDiretorioXML(System.getProperty("user.dir"));
        }
        return String.valueOf(XmlBD.getDiretorioXML()) + System.getProperty("file.separator") + "xmlinfra.bbz";
    }

    public static String getDiretorioXML() {
        return diretorioXML;
    }

    public static void main(String[] args) {
        XmlDocumentBuilder x = XmlBD.obter("Arquivo_ART300.xml");
        System.out.println(x);
    }

    public static XmlDocumentBuilder obter(String nome) {
        return XmlBD.obter(ControleAplicacao.getPlugin().getCodigoPlugin(), nome);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XmlDocumentBuilder obter(String base, String nome) {
        try {
            File fz;
            File f = new File(String.valueOf(XmlBD.getDiretorioXML()) + System.getProperty("file.separator") + nome);
            ZipFile zf = null;
            if (f.exists()) {
                XmlBD.adicionar(base, String.valueOf(XmlBD.getDiretorioXML()) + System.getProperty("file.separator") + nome);
            }
            if (!(fz = new File(String.valueOf(XmlBD.getDiretorioXML()) + System.getProperty("file.separator") + "xml" + base.toLowerCase() + ".bbz")).exists()) {
                if (base.equalsIgnoreCase("infra")) {
                    return null;
                }
                return XmlBD.obter("infra", nome);
            }
            zf = new ZipFile(String.valueOf(XmlBD.getDiretorioXML()) + System.getProperty("file.separator") + "xml" + base.toLowerCase() + ".bbz");
            Enumeration<? extends ZipEntry> entries = zf.entries();
            ZipEntry ze = null;
            while (entries.hasMoreElements()) {
                ze = entries.nextElement();
                System.out.println(ze.getName());
                if (!ze.getName().equalsIgnoreCase(nome)) continue;
            }
            if (!ze.getName().equalsIgnoreCase(nome)) {
                if (!base.equalsIgnoreCase("infra")) {
                    return XmlBD.obter("infra", nome);
                }
                return null;
            }
            XmlDocumentBuilder builder = XmlBD.obter(zf, ze);
            zf.close();
            if (f.exists()) {
                f.delete();
            }
            return builder;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static XmlDocumentBuilder obter(ZipFile zf, ZipEntry ze) {
        try {
            InputStream i = zf.getInputStream(ze);
            InputStreamReader isr = new InputStreamReader(i);
            BufferedReader br = new BufferedReader(isr);
            int lidos = 0;
            while (true) {
                br.mark(300);
                String linha = br.readLine();
                if (!linha.trim().startsWith("<!") && !linha.trim().startsWith("<?") && linha.trim().length() != 0) break;
                lidos += linha.length() + 2;
            }
            br.reset();
            i.close();
            isr.close();
            br.close();
            i = zf.getInputStream(ze);
            i.skip(lidos);
            XmlDocumentBuilder builder = ParserXMLToEstrutura.getDocumentBuilder(i);
            i.close();
            return builder;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static void setDiretorioXML(String newDiretorioXML) {
        diretorioXML = newDiretorioXML;
    }
}

