/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.utilitarios;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public class Estrutura {
    private Connection con;
    private Vector tabelas;
    private static String protocol = "jdbc";
    private static String subprotocol = "odbc";
    private static String DBName = "BBEmpBD";
    private static String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private static String tipoDB = "Mdb_jdbcodbc";

    public Estrutura() {
    }

    public Estrutura(Connection con) {
        this.con = con;
    }

    public boolean conectar() throws SQLException {
        String url;
        block8: {
            block9: {
                url = String.valueOf(protocol) + ":" + subprotocol + ":" + DBName;
                if (this.con == null) break block8;
                if (this.con.isClosed()) break block9;
                return true;
            }
            this.desconectar();
            return false;
        }
        try {
            Class.forName(driver).newInstance();
            this.con = DriverManager.getConnection(url, "admin", "persona");
            SQLWarning w = this.con.getWarnings();
            while (w != null) {
                System.out.println("----------------- SQLWarning - Conex\u00e3o --------------------");
                System.out.println("SQLState: " + w.getSQLState());
                System.out.println("Message: " + w.getMessage());
                System.out.println("Vendor: " + w.getErrorCode());
                w = w.getNextWarning();
            }
            this.con.setAutoCommit(true);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("conectar_driver: " + e.getMessage());
        }
        catch (SQLException de) {
            if (de.getSQLState().equalsIgnoreCase("IM002")) {
                throw new SQLException("Banco de dados n\u00e3o localizado. Entre em contato com o suporte.");
            }
            System.out.println("msg: " + de.getMessage());
            System.out.println("sqlState: " + de.getSQLState());
            System.out.println("vendor: " + de.getErrorCode());
            throw new SQLException("Conex\u00e3o: " + de.getMessage());
        }
        catch (Throwable ie) {
            throw new SQLException("Erro Conexao: " + ie.getMessage());
        }
        return true;
    }

    public boolean desconectar() throws SQLException {
        if (this.con != null && !this.con.isClosed()) {
            this.con.close();
        }
        return true;
    }

    public Connection getCon() {
        return this.con;
    }

    public Vector getTabelas() {
        return this.tabelas;
    }

    public static void main(String[] args) {
        Estrutura estr = new Estrutura();
        try {
            estr.conectar();
            estr.obterTabelas();
        }
        catch (Throwable th) {
            System.out.println(th);
        }
    }

    public void obterEstruturaTabela(String tabela) {
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery("select * from " + tabela);
            ResultSetMetaData rsmt = rs.getMetaData();
            int i = 1;
            while (i <= rsmt.getColumnCount()) {
                System.out.print(String.valueOf(rsmt.getColumnName(i)) + "  ");
                System.out.print(String.valueOf(rsmt.getColumnTypeName(i)) + "  ");
                System.out.print(String.valueOf(rsmt.getColumnDisplaySize(i)) + "  ");
                if (rsmt.isNullable(i) != 0) {
                    System.out.println("          ");
                } else {
                    System.out.println("not null  ");
                }
                ++i;
            }
        }
        catch (Throwable th) {
            System.out.println(th);
        }
    }

    public Vector obterTabelas() throws Throwable {
        DatabaseMetaData dbmd = this.con.getMetaData();
        ResultSet rs = dbmd.getCatalogs();
        rs.next();
        String catalog = rs.getString(1);
        rs.close();
        this.tabelas = new Vector();
        String[] types = new String[]{"TABLE"};
        String schema = null;
        rs = dbmd.getTables(catalog, schema, "%", types);
        while (rs.next()) {
            this.tabelas.addElement(rs.getString(3));
            System.out.println("TABELA: " + this.tabelas.elementAt(this.tabelas.size() - 1));
            System.out.println("CAMPOS:");
            this.obterEstruturaTabela((String)this.tabelas.elementAt(this.tabelas.size() - 1));
            System.out.println("INDICES:");
            ResultSet rs2 = dbmd.getIndexInfo(catalog, schema, (String)this.tabelas.elementAt(this.tabelas.size() - 1), false, false);
            while (rs2.next()) {
                System.out.println(String.valueOf(rs2.getShort("TYPE")) + " - " + rs2.getString("INDEX_NAME") + " - " + rs2.getShort("ORDINAL_POSITION") + " " + rs2.getString("COLUMN_NAME") + " " + rs2.getString("ASC_OR_DESC") + " " + (rs2.getBoolean("NON_UNIQUE") ? "     " : "UNICO"));
            }
            rs2.close();
            rs2 = dbmd.getImportedKeys(catalog, schema, (String)this.tabelas.elementAt(this.tabelas.size() - 1));
            while (rs2.next()) {
                System.out.println(String.valueOf(rs2.getShort("TYPE")) + " - " + rs2.getString("INDEX_NAME") + " - " + rs2.getShort("ORDINAL_POSITION") + " " + rs2.getString("COLUMN_NAME") + " " + rs2.getString("ASC_OR_DESC") + " " + (rs2.getBoolean("NON_UNIQUE") ? "     " : "UNICO"));
            }
        }
        return null;
    }

    public void setCon(Connection newCon) {
        this.con = newCon;
    }

    public void setTabelas(Vector newTabelas) {
        this.tabelas = newTabelas;
    }
}

