/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.xml.kernel;

import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.reflexao.UtilReflexaoInvocarMetodo;
import br.com.politec.reflexao.UtilReflexaoMetodo;
import br.com.politec.reflexao.exception.ReflexaoException;
import br.com.politec.xml.UtilXmlDOM;
import br.com.politec.xml.excecao.XmlException;
import br.com.politec.xml.kernel.FabricaKernel;
import br.com.politec.xml.util.UtilXmlException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeradorDeElementoKernel
extends FabricaKernel {
    public Element gerar(Document documento, Object objeto) throws XmlException {
        Element resposta = null;
        if (this.isReferencia(documento, objeto)) {
            String nomeObjeto = UtilObjeto.getNomeSemPacote((Object)objeto);
            resposta = this.novoElemento(documento, nomeObjeto);
            Class classe = UtilObjeto.getClasse((Object)objeto);
            Collection gets = UtilReflexaoMetodo.getMetodosGet((Class)classe);
            Iterator metodos = this.getColecaoFactory().novoIterator(gets);
            this.loopMetodos(documento, objeto, resposta, metodos);
        }
        return resposta;
    }

    public Element gerar(Document documento, Collection colecao) throws XmlException {
        String nome = UtilObjeto.getNomeSemPacote((Object)colecao);
        return this.gerar(documento, colecao, nome);
    }

    public Element gerar(Document documento, Collection colecao, String nome) throws XmlException {
        Element resposta = null;
        if (this.isReferencia(documento) && !this.isVazio(colecao) && !this.isVazio(nome)) {
            resposta = this.novoElemento(documento, nome);
            Element filho = null;
            Iterator iterator = this.getColecaoFactory().novoIterator(colecao);
            while (iterator.hasNext()) {
                Object objeto = iterator.next();
                filho = this.gerar(documento, objeto);
                UtilXmlDOM.adicionarElementoNoElemento(resposta, filho);
            }
        }
        return resposta;
    }

    private void loopMetodos(Document documento, Object objeto, Element elemento, Iterator metodos) throws XmlException {
        if (metodos.hasNext()) {
            Method metodo = (Method)metodos.next();
            Class<?> tipo = metodo.getReturnType();
            Object resposta = this.invocarMetodo(objeto, metodo);
            String nome = UtilString.getNomeDoAtributo((String)metodo.getName());
            if (UtilObjeto.isColecao(tipo)) {
                Collection colecao = (Collection)resposta;
                Element filho = this.gerar(documento, colecao, nome);
                UtilXmlDOM.adicionarElementoNoElemento(elemento, filho);
            } else {
                String valor = this.formatar(tipo, resposta);
                Attr atributo = this.novoAtributo(documento, nome, valor);
                UtilXmlDOM.adicionarAtributoNoElemento(elemento, atributo);
            }
            this.loopMetodos(documento, objeto, elemento, metodos);
        }
    }

    private Object invocarMetodo(Object objeto, Method metodo) throws XmlException {
        try {
            return UtilReflexaoInvocarMetodo.invocar((Object)objeto, (Method)metodo);
        }
        catch (ReflexaoException e) {
            throw UtilXmlException.erro(e);
        }
    }
}

