/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.product.DynamicProductReference;
import com.installshield.product.DynamicSuite;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.Locatable;
import com.installshield.product.Product;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionEvent;
import com.installshield.product.ProductActionListener;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductComponentReference;
import com.installshield.product.ProductFeature;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.StaticProductReference;
import com.installshield.product.StaticSuite;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.product.actions.UninstallerJVMResolution;
import com.installshield.product.actions.UninstallerLauncher;
import com.installshield.qjml.QJML;
import com.installshield.util.FileUtils;
import com.installshield.util.GenericTreeNode;
import com.installshield.util.OperationRejectedException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ProductTree {
    private ProductBean root = null;
    private ProductTree uninstallTree = null;
    private UninstallerArchive uninstaller = new UninstallerArchive();
    private UninstallerLauncher uninstallerLauncher = new UninstallerLauncher();
    private UninstallerJVMResolution uninstallerJVMResolution = new UninstallerJVMResolution();
    private String logFile = "";
    private String selectedLocales = "";
    public static int LOCALE_OPTION_SYSTEM = 0;
    public static int LOCALE_OPTION_PROMPT = 1;
    public static int LOCALE_OPTION_SYSTEM_THEN_PROMPT = 2;
    public static int LOCALE_OPTION_SYSTEM_THEN_DEFAULT = 3;
    private int localeOption = LOCALE_OPTION_PROMPT;
    private Vector productActionListeners = new Vector();
    static /* synthetic */ Class class$com$installshield$product$ProductTree;
    static /* synthetic */ Class class$com$installshield$product$Product;

    public ProductTree() {
        this.uninstaller.tree = this;
        this.uninstallerLauncher.tree = this;
        this.uninstallerJVMResolution.tree = this;
    }

    public ProductTree(ProductBean productBean) throws OperationRejectedException {
        this();
        this.setRoot(productBean);
    }

    public void add(ProductBean productBean, ProductBean productBean2) throws OperationRejectedException {
        if (!this.canAdd(productBean, productBean2)) {
            throw new OperationRejectedException();
        }
        GenericTreeNode genericTreeNode = productBean.node;
        genericTreeNode.addChild(this.getNode(productBean2));
    }

    public void addAction(ProductComponent productComponent, ProductAction productAction) throws OperationRejectedException {
        this.add(productComponent, productAction);
    }

    public void addComponent(Product product, ProductComponent productComponent) throws OperationRejectedException {
        this.add(product, productComponent);
    }

    public void addComponent(Product product, ProductComponentReference productComponentReference) throws OperationRejectedException {
        this.add(product, productComponentReference);
    }

    public void addComponent(ProductFeature productFeature, ProductComponent productComponent) throws OperationRejectedException {
        this.add(productFeature, productComponent);
    }

    public void addComponent(ProductFeature productFeature, ProductComponentReference productComponentReference) throws OperationRejectedException {
        this.add(productFeature, productComponentReference);
    }

    public void addFeature(Product product, ProductFeature productFeature) throws OperationRejectedException {
        this.add(product, productFeature);
    }

    public void addFeature(ProductFeature productFeature, ProductFeature productFeature2) throws OperationRejectedException {
        this.add(productFeature, productFeature2);
    }

    public void addProductActionListener(ProductActionListener productActionListener) {
        this.productActionListeners.addElement(productActionListener);
        if (this.uninstallTree != null) {
            this.uninstallTree.addProductActionListener(productActionListener);
        }
    }

    public boolean canAdd(ProductBean productBean, ProductBean productBean2) {
        if (productBean instanceof DynamicSuite) {
            return productBean2 instanceof DynamicProductReference;
        }
        if (productBean instanceof StaticSuite) {
            return productBean2 instanceof StaticProductReference || productBean2.getClass() == (class$com$installshield$product$Product != null ? class$com$installshield$product$Product : (class$com$installshield$product$Product = ProductTree.class$("com.installshield.product.Product")));
        }
        if (productBean instanceof Product) {
            return productBean2 instanceof ProductFeature || productBean2 instanceof ProductComponent || productBean2 instanceof ProductComponentReference;
        }
        if (productBean instanceof ProductFeature) {
            return productBean2 instanceof ProductFeature || productBean2 instanceof ProductComponent || productBean2 instanceof ProductComponentReference;
        }
        if (productBean instanceof ProductComponent) {
            return productBean2 instanceof ProductAction;
        }
        return false;
    }

    public boolean canRemove(ProductBean productBean) {
        return true;
    }

    public Enumeration children(ProductBean productBean) {
        Vector<Object> vector = new Vector<Object>();
        GenericTreeNode genericTreeNode = this.getNode(productBean);
        if (genericTreeNode != null) {
            Enumeration enumeration = genericTreeNode.children();
            while (enumeration.hasMoreElements()) {
                vector.addElement(((GenericTreeNode)enumeration.nextElement()).getUserObject());
            }
        }
        return vector.elements();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ProductBean copyBean(ProductBean productBean) throws IOException {
        ProductBean productBean2 = null;
        try {
            ProductTree productTree;
            if (productBean.getProductTree() != null) {
                productTree = productBean.getProductTree();
            } else {
                productTree = new ProductTree();
                if (productBean instanceof Product) {
                    productTree.setRoot(productBean);
                } else {
                    if (productBean instanceof DynamicProductReference) {
                        productTree.setRoot(new DynamicSuite());
                    } else if (productBean instanceof StaticProductReference) {
                        productTree.setRoot(new StaticSuite());
                    } else {
                        productTree.setRoot(new Product());
                    }
                    if (productBean instanceof ProductFeature || productBean instanceof ProductComponentReference || productBean instanceof DynamicProductReference || productBean instanceof StaticProductReference) {
                        productTree.add(productTree.getRoot(), productBean);
                    } else if (productBean instanceof ProductAction) {
                        ProductComponent productComponent = new ProductComponent();
                        productTree.add(productTree.getRoot(), productComponent);
                        productTree.add(productComponent, productBean);
                    } else {
                        throw new IllegalArgumentException("unknown bean type: " + productBean.getClass());
                    }
                }
            }
            productTree = (ProductTree)QJML.clone(productTree, class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = ProductTree.class$("com.installshield.product.ProductTree")));
            productBean2 = productTree.getBean(productBean.getBeanId());
        }
        catch (OperationRejectedException operationRejectedException) {
            throw new Error();
        }
        return productBean2;
    }

    private ProductBean findProductBean(ProductBean productBean, String string) {
        String string2 = productBean.getBeanId();
        if (string2 != null && string2.equals(string)) {
            return productBean;
        }
        Enumeration enumeration = this.children(productBean);
        while (enumeration.hasMoreElements()) {
            ProductBean productBean2 = this.findProductBean((ProductBean)enumeration.nextElement(), string);
            if (productBean2 == null) continue;
            return productBean2;
        }
        return null;
    }

    public SoftwareObject findSoftwareObject(String string, String string2) {
        SoftwareObject softwareObject = null;
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(this);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (softwareObject == null && productBean != null && productBean != standardProductTreeIterator.end()) {
            SoftwareObject softwareObject2;
            if (productBean instanceof SoftwareObject && (softwareObject2 = (SoftwareObject)((Object)productBean)).getKey().getUID().equals(string) && FileUtils.comparePaths(this.getInstallLocation(productBean), string2)) {
                softwareObject = softwareObject2;
            }
            productBean = standardProductTreeIterator.getNext(productBean);
        }
        return softwareObject;
    }

    void fireProductActionEvent(ProductActionEvent productActionEvent) {
        int n = 0;
        while (n < this.productActionListeners.size()) {
            ((ProductActionListener)this.productActionListeners.elementAt(n)).productActionPerformed(productActionEvent);
            ++n;
        }
    }

    public ProductBean getBean(String string) {
        return this.findProductBean(this.getRoot(), string);
    }

    public ProductBean getChild(ProductBean productBean, int n) {
        return (ProductBean)((GenericTreeNode)productBean.node.getChildAt(n)).getUserObject();
    }

    public int getChildCount(ProductBean productBean) {
        return productBean.node.getChildCount();
    }

    public int getChildIndex(ProductBean productBean) {
        GenericTreeNode genericTreeNode = (GenericTreeNode)productBean.node.getParent();
        int n = 0;
        while (genericTreeNode != null && n < genericTreeNode.getChildCount()) {
            if (((GenericTreeNode)genericTreeNode.getChildAt(n)).getUserObject().equals(productBean)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ProductBean getFirstChild(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node.getFirstChild();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    public int getInstallFailureOption(ProductBean productBean) {
        int n;
        int n2 = 1;
        if (productBean != null && productBean instanceof GenericSoftwareObject) {
            n2 = ((GenericSoftwareObject)productBean).getInstallFailureOption();
        }
        if (productBean != null && n2 != 3 && (n = this.getInstallFailureOption(this.getParent(productBean))) != 1) {
            n2 = n;
        }
        return n2;
    }

    public String getInstallLocation(ProductBean productBean) {
        String string = null;
        if (productBean instanceof Locatable) {
            string = ((Locatable)((Object)productBean)).getInstallLocation();
        }
        if (string == null || string.trim().length() == 0) {
            return this.getParentInstallLocation(productBean);
        }
        string = FileUtils.normalizeFileName(string.trim());
        if (FileUtils.isAbsolute(string = productBean.resolveString(string).trim())) {
            return string;
        }
        if (this.getParent(productBean) != null) {
            String string2 = this.getParentInstallLocation(productBean);
            return FileUtils.createFileName(string2, string);
        }
        if (productBean != this.root && this.root instanceof SoftwareObject) {
            return FileUtils.createFileName(this.getInstallLocation(this.root), string);
        }
        return FileUtils.createFileName(new File("").getAbsolutePath(), string);
    }

    public ProductBean getLastChild(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node.getLastChild();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    public int getLevel(ProductBean productBean) {
        int n = 1;
        ProductBean productBean2 = this.getParent(productBean);
        ProductBean productBean3 = this.getRoot();
        if (productBean2 != null && productBean2 != productBean3) {
            n += this.getLevel(productBean2);
        }
        return n;
    }

    public int getLocaleOption() {
        return this.localeOption;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public ProductBean getNextSibling(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node.getNextSibling();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    private GenericTreeNode getNode(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node;
        if (genericTreeNode == null) {
            genericTreeNode = new GenericTreeNode();
        }
        this.updateBean(productBean, genericTreeNode);
        return genericTreeNode;
    }

    public ProductBean getParent(ProductBean productBean) {
        GenericTreeNode genericTreeNode = (GenericTreeNode)productBean.node.getParent();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    private String getParentInstallLocation(ProductBean productBean) {
        ProductBean productBean2 = this.getParent(productBean);
        if (productBean2 != null) {
            return this.getInstallLocation(productBean2);
        }
        return new File("").getAbsolutePath().trim();
    }

    public ProductBean getPreviousSibling(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node.getPreviousSibling();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    public int getRemoveOption(ProductBean productBean) {
        int n = 0;
        if (productBean != null && productBean instanceof GenericSoftwareObject) {
            n = ((GenericSoftwareObject)productBean).getRemoveOption();
        }
        if (productBean != null && n == 0) {
            n = this.getRemoveOption(this.getParent(productBean));
        }
        return n == 0 ? 4 : n;
    }

    public int getReplaceFailureOption(ProductBean productBean) {
        int n;
        int n2 = 1;
        if (productBean != null && productBean instanceof GenericSoftwareObject) {
            n2 = ((GenericSoftwareObject)productBean).getReplaceFailureOption();
        }
        if (productBean != null && n2 != 3 && (n = this.getReplaceFailureOption(this.getParent(productBean))) != 1) {
            n2 = n;
        }
        return n2;
    }

    public int getReplaceOption(ProductBean productBean) {
        int n = 0;
        if (productBean != null && productBean instanceof GenericSoftwareObject) {
            n = ((GenericSoftwareObject)productBean).getReplaceOption();
        }
        if (productBean != null && n == 0) {
            n = this.getReplaceOption(this.getParent(productBean));
        }
        return n == 0 ? 4 : n;
    }

    public ProductBean getRoot() {
        return this.root;
    }

    public String getSelectedLocales() {
        return this.selectedLocales;
    }

    public ProductTree getUninstallTree() {
        return this.uninstallTree;
    }

    public UninstallerArchive getUninstallerArchive() {
        return this.uninstaller;
    }

    public UninstallerJVMResolution getUninstallerJVMResolution() {
        return this.uninstallerJVMResolution;
    }

    public UninstallerLauncher getUninstallerLauncher() {
        return this.uninstallerLauncher;
    }

    public void insert(ProductBean productBean, int n, ProductBean productBean2) throws OperationRejectedException {
        if (!this.canAdd(productBean, productBean2)) {
            throw new OperationRejectedException();
        }
        GenericTreeNode genericTreeNode = productBean.node;
        genericTreeNode.insertChild(this.getNode(productBean2), n);
    }

    public boolean isDescendant(ProductBean productBean, ProductBean productBean2) {
        boolean bl = this.isDescendant(productBean.node, productBean2.node);
        return bl;
    }

    private boolean isDescendant(GenericTreeNode genericTreeNode, GenericTreeNode genericTreeNode2) {
        boolean bl = false;
        Enumeration enumeration = genericTreeNode.children();
        while (enumeration.hasMoreElements() && !bl) {
            GenericTreeNode genericTreeNode3 = (GenericTreeNode)enumeration.nextElement();
            bl = genericTreeNode3 == genericTreeNode2 ? true : this.isDescendant(genericTreeNode3, genericTreeNode2);
        }
        return bl;
    }

    public static boolean isReplaceInstall(ProductBean productBean) {
        return ProductTree.isReplaceInstall(productBean.getProductTree());
    }

    public static boolean isReplaceInstall(ProductTree productTree) {
        return productTree.getUninstallTree() != null;
    }

    public void remove(ProductBean productBean) throws OperationRejectedException {
        if (!this.canRemove(productBean)) {
            throw new OperationRejectedException();
        }
        GenericTreeNode genericTreeNode = (GenericTreeNode)productBean.node.getParent();
        genericTreeNode.removeChild(productBean.node);
    }

    public void removeAllChildren(ProductBean productBean) throws OperationRejectedException {
        GenericTreeNode genericTreeNode = productBean.node;
        if (genericTreeNode == null) {
            throw new OperationRejectedException();
        }
        genericTreeNode.removeAllChildren();
    }

    public void removeProductActionListener(ProductActionListener productActionListener) {
        this.productActionListeners.removeElement(productActionListener);
        if (this.uninstallTree != null) {
            this.uninstallTree.removeProductActionListener(productActionListener);
        }
    }

    public SoftwareObject resolveKey(SoftwareObjectKey softwareObjectKey) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(this);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            if (productBean instanceof SoftwareObject && ((SoftwareObject)((Object)productBean)).getKey().equals(softwareObjectKey)) {
                return (SoftwareObject)((Object)productBean);
            }
            productBean = standardProductTreeIterator.getNext(productBean);
        }
        return null;
    }

    public void setChild(ProductBean productBean, int n, ProductBean productBean2) throws OperationRejectedException {
        GenericTreeNode genericTreeNode = productBean.node;
        this.updateBean(productBean2, (GenericTreeNode)genericTreeNode.getChildAt(n));
    }

    public void setLocaleOption(int n) {
        this.localeOption = n;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public void setRoot(ProductBean productBean) throws OperationRejectedException {
        this.root = productBean;
        if (productBean != null) {
            this.updateBean(this.root, this.getNode(productBean));
        }
    }

    public void setSelectedLocales(String string) {
        this.selectedLocales = string;
    }

    public void setUninstallTree(ProductTree productTree) {
        this.uninstallTree = productTree;
    }

    public void setUninstallerArchive(UninstallerArchive uninstallerArchive) {
        this.uninstaller = uninstallerArchive;
        if (uninstallerArchive != null) {
            uninstallerArchive.tree = this;
        }
    }

    public void setUninstallerJVMResolution(UninstallerJVMResolution uninstallerJVMResolution) {
        this.uninstallerJVMResolution = uninstallerJVMResolution;
        if (this.uninstallerJVMResolution != null) {
            this.uninstallerJVMResolution.tree = this;
        }
    }

    public void setUninstallerLauncher(UninstallerLauncher uninstallerLauncher) {
        this.uninstallerLauncher = uninstallerLauncher;
        if (this.uninstallerLauncher != null) {
            this.uninstallerLauncher.tree = this;
        }
    }

    private void updateBean(ProductBean productBean, GenericTreeNode genericTreeNode) {
        genericTreeNode.setUserObject(productBean);
        productBean.node = genericTreeNode;
        this.updateTree(productBean);
    }

    private void updateTree(ProductBean productBean) {
        ProductBean productBean2 = this.getFirstChild(productBean);
        while (productBean2 != null) {
            this.updateTree(productBean2);
            productBean2 = this.getNextSibling(productBean2);
        }
        productBean.tree = this;
    }
}

