/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.BaseProductTreeIterator;
import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductComponentReference;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.iterators.MultiProductTreeIterator;
import com.installshield.product.iterators.SoftwareObjectTreeIterator;
import com.installshield.product.iterators.VisitOnceComponentTreeIterator;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.util.Log;
import java.util.Hashtable;
import java.util.Vector;

public class OrderedProductTreeIterator
implements ProductTreeIterator {
    Vector orderedList = new Vector();

    public OrderedProductTreeIterator(ProductBean productBean) {
        this(productBean, null, null, false);
    }

    public OrderedProductTreeIterator(ProductBean productBean, ProductTreeSource productTreeSource, Log log, boolean bl) {
        ProductComponent productComponent;
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        Hashtable<ProductComponent, String> hashtable = new Hashtable<ProductComponent, String>();
        this.orderedList.addElement(new Marker());
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean, true);
        if (bl) {
            filteredProductTreeIterator = new MultiProductTreeIterator((BaseProductTreeIterator)filteredProductTreeIterator, productTreeSource, log);
        }
        VisitOnceComponentTreeIterator visitOnceComponentTreeIterator = new VisitOnceComponentTreeIterator(filteredProductTreeIterator);
        SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(visitOnceComponentTreeIterator);
        ProductBean productBean2 = softwareObjectTreeIterator.getNext(softwareObjectTreeIterator.begin());
        while (productBean2 != softwareObjectTreeIterator.end()) {
            object2 = null;
            if (productBean2 instanceof SoftwareObjectReference) {
                object = productBean2.getProductTree().resolveKey(((SoftwareObjectReference)productBean2).getKey());
                if (productBean2 instanceof ProductComponentReference) {
                    if (object instanceof ProductComponent) {
                        object2 = (ProductComponent)object;
                    }
                } else if (object instanceof ProductFeature) {
                    this.addRequiredChildComponents((ProductFeature)object, vector, hashtable);
                } else if (object instanceof ProductComponent && !hashtable.containsKey(productComponent = (ProductComponent)object)) {
                    hashtable.put(productComponent, new String(""));
                }
            } else if (productBean2 instanceof ProductComponent) {
                object2 = (ProductComponent)productBean2;
            }
            if (object2 != null && !vector.contains(object2)) {
                vector.addElement(object2);
            }
            productBean2 = softwareObjectTreeIterator.getNext(productBean2);
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (ProductComponent)object2.nextElement();
            if (!hashtable.containsKey(object) || this.orderedList.contains(object)) continue;
            this.orderedList.addElement(object);
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            productComponent = (ProductComponent)object.nextElement();
            if (hashtable.containsKey(productComponent) || this.orderedList.contains(productComponent)) continue;
            this.orderedList.addElement(productComponent);
        }
        this.orderedList.addElement(new Marker());
    }

    private void addRequiredChildComponents(ProductFeature productFeature, Vector vector, Hashtable hashtable) {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createChildIterator(productFeature);
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean != productTreeIterator.end()) {
            ProductComponent productComponent = null;
            if (productBean instanceof ProductComponentReference) {
                SoftwareObject softwareObject = productBean.getProductTree().resolveKey(((ProductComponentReference)productBean).getKey());
                if (softwareObject instanceof ProductComponent) {
                    productComponent = (ProductComponent)softwareObject;
                }
            } else if (productBean instanceof ProductComponent) {
                productComponent = (ProductComponent)productBean;
            }
            if (productComponent != null && !hashtable.containsKey(productComponent)) {
                hashtable.put(productComponent, new String(""));
            }
            productBean = productTreeIterator.getNext(productBean);
        }
    }

    public ProductBean begin() {
        return (ProductBean)this.orderedList.firstElement();
    }

    public ProductBean end() {
        return (ProductBean)this.orderedList.lastElement();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = null;
        if (productBean != null && productBean != this.end() && this.orderedList.contains(productBean)) {
            productBean2 = (ProductBean)this.orderedList.elementAt(this.orderedList.indexOf(productBean) + 1);
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2 = null;
        if (productBean != null && productBean != this.begin() && this.orderedList.contains(productBean)) {
            productBean2 = (ProductBean)this.orderedList.elementAt(this.orderedList.indexOf(productBean) - 1);
        }
        return productBean2;
    }

    class Marker
    extends ProductBean {
        Marker() {
        }
    }
}

