/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.ProductBean;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;

public class ProductFeatureTreeIterator
implements ProductTreeIterator {
    private ProductTreeIterator iter;

    public ProductFeatureTreeIterator(ProductTreeIterator productTreeIterator) {
        this.iter = productTreeIterator;
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getNext(productBean);
        while (productBean2 != this.end() && !this.isProductFeature(productBean2)) {
            productBean2 = this.iter.getNext(productBean2);
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getPrevious(productBean);
        while (productBean2 != this.begin() && !this.isProductFeature(productBean2)) {
            productBean2 = this.iter.getPrevious(productBean2);
        }
        return productBean2;
    }

    private boolean isProductFeature(ProductBean productBean) {
        boolean bl = false;
        if (productBean instanceof ProductFeature) {
            bl = true;
        } else if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            SoftwareObject softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
            if (softwareObject != null && softwareObject instanceof ProductFeature) {
                bl = true;
            }
        }
        return bl;
    }
}

