/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.ProductBean;
import com.installshield.product.SoftwareObject;
import com.installshield.product.service.product.ProductService;
import com.installshield.product.wizardbeans.FeaturePanel;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;

public class UninstallFeaturePanel
extends FeaturePanel {
    public UninstallFeaturePanel() {
        this.setDescription("$L(com.installshield.product.i18n.ProductResources, UninstallFeaturePanel.description, $P(displayName))");
        this.setRootDisplayName("$L(com.installshield.product.i18n.ProductResources, UninstallFeaturePanel.rootNodeName)");
    }

    protected String[] getRequiredFeatureProperties() {
        return new String[]{"activeForUninstall", "displayName"};
    }

    protected boolean isBeanActive(String string) {
        try {
            ProductBean productBean = this.getProductTree().getBean(string);
            return productBean instanceof SoftwareObject ? ((SoftwareObject)((Object)productBean)).isActiveForUninstall() : false;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    protected boolean isBeanVisible(String string) {
        return this.isBeanInstalled(string);
    }

    protected void setBeanActive(String string, boolean bl) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            productService.setProductBeanProperty("/product.xml", string, "activeForUninstall", new Boolean(bl));
            this.resetCachedValues();
        }
        catch (ServiceException serviceException) {
            this.getWizard().getUI().displayUserMessage(this.resolveString(this.getWizard().getTitle()), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "SoftwareObjectTreeListenerUninstall.setPropertyErrorMessage", new String[]{serviceException.getMessage()}), 4);
        }
    }
}

