/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.qjml;

import com.installshield.qjml.QProperty;
import com.installshield.util.sort.SortUtils;
import com.jxml.quick.access.QIterator;
import java.util.Dictionary;
import java.util.Enumeration;

public class QExtendedPropertiesIterator
implements QIterator {
    private Object parent = null;
    private Dictionary properties = null;
    private Object curKey = null;
    private Object[] keys = null;
    private int keyIndex = 0;

    public void clear() {
        this.keys = null;
        this.keyIndex = 0;
        this.curKey = null;
    }

    public Object getCurrent() {
        if (this.curKey != null) {
            return this.curKey;
        }
        this.verifyKeys();
        if (this.keyIndex < this.keys.length) {
            this.curKey = this.keys[this.keyIndex];
            Object v = this.properties.get(this.curKey);
            return new QProperty(this.curKey.toString(), v.getClass(), v, true);
        }
        return null;
    }

    public void getNext() {
        this.verifyKeys();
        this.curKey = null;
        ++this.keyIndex;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean isComplete() {
        return this.keyIndex >= this.keys.length;
    }

    public void setParent(Object object) {
        try {
            this.properties = (Dictionary)object.getClass().getMethod("getExtendedProperties", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("parent must have a method getExtendedProperties that returns java.util.Dictionary");
        }
        this.parent = object;
        this.clear();
    }

    private void verifyKeys() {
        if (this.keys == null) {
            if (this.properties == null) {
                throw new IllegalStateException("parent not set");
            }
            this.keys = new Object[this.properties.size()];
            Enumeration enumeration = this.properties.keys();
            int n = 0;
            while (enumeration.hasMoreElements() && n < this.keys.length) {
                this.keys[n] = enumeration.nextElement();
                ++n;
            }
            SortUtils.qsort(this.keys);
            this.keyIndex = 0;
        }
    }
}

