/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.win32service;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.Log;
import com.installshield.wizard.service.WizardServices;
import java.util.Vector;

public class NTServiceConfig
implements PropertyAccessible {
    public static final int SERVICE_FILE_SYSTEM_DRIVER = 2;
    public static final int SERVICE_KERNEL_DRIVER = 1;
    public static final int SERVICE_ADAPTER = 4;
    public static final int SERVICE_RECOGNIZER_DRIVER = 8;
    public static final int SERVICE_DRIVER = 15;
    public static final int SERVICE_WIN32_OWN_PROCESS = 16;
    public static final int SERVICE_WIN32_SHARE_PROCESS = 32;
    public static final int SERVICE_WIN32 = 48;
    public static final int SERVICE_TYPE_ALL = 63;
    public static final int SERVICE_AUTO_START = 2;
    public static final int SERVICE_BOOT_START = 0;
    public static final int SERVICE_DEMAND_START = 3;
    public static final int SERVICE_DISABLED = 4;
    public static final int SERVICE_SYSTEM_START = 1;
    public static final int SERVICE_ERROR_IGNORE = 0;
    public static final int SERVICE_ERROR_NORMAL = 1;
    public static final int SERVICE_ERROR_SEVERE = 2;
    public static final int SERVICE_ERROR_CRITICAL = 3;
    private String displayName = "";
    private int serviceType = 16;
    private boolean enableDesktopInteraction = false;
    private int startType = 2;
    private int errorControl = 1;
    private String command = "";
    private String loadOrderGroup = "";
    private Vector dependencies = new Vector();
    private String userName = "";
    private String password = "";

    public NTServiceConfig() {
    }

    public NTServiceConfig(NTServiceConfig nTServiceConfig) {
        this.displayName = nTServiceConfig.displayName;
        this.serviceType = nTServiceConfig.serviceType;
        this.enableDesktopInteraction = nTServiceConfig.enableDesktopInteraction;
        this.startType = nTServiceConfig.startType;
        this.errorControl = nTServiceConfig.errorControl;
        this.command = nTServiceConfig.command;
        this.loadOrderGroup = nTServiceConfig.loadOrderGroup;
        this.dependencies = nTServiceConfig.dependencies;
        this.userName = nTServiceConfig.userName;
        this.password = nTServiceConfig.password;
    }

    public void addDependency(String string) {
        this.verifyDependencies();
        if (!this.dependencies.contains(string)) {
            this.dependencies.addElement(string);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getDependencies() {
        this.verifyDependencies();
        Object[] objectArray = new String[this.dependencies.size()];
        this.dependencies.copyInto(objectArray);
        return objectArray;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean getEnableDesktopInteraction() {
        return this.enableDesktopInteraction;
    }

    public int getErrorControl() {
        return this.errorControl;
    }

    public String getLoadOrderGroup() {
        return this.loadOrderGroup;
    }

    public String getPassword() {
        return this.password;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public int getStartType() {
        return this.startType;
    }

    public String getUserName() {
        return this.userName;
    }

    public NTServiceConfig resolve(WizardServices wizardServices) {
        NTServiceConfig nTServiceConfig = new NTServiceConfig(this);
        nTServiceConfig.setDisplayName(wizardServices.resolveString(this.getDisplayName()));
        nTServiceConfig.setCommand(wizardServices.resolveString(this.getCommand()));
        nTServiceConfig.setLoadOrderGroup(wizardServices.resolveString(this.getLoadOrderGroup()));
        String[] stringArray = this.getDependencies();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = wizardServices.resolveString(stringArray[n]);
                ++n;
            }
            nTServiceConfig.setDependencies(stringArray);
        }
        nTServiceConfig.setUserName(wizardServices.resolveString(this.getUserName()));
        nTServiceConfig.setPassword(wizardServices.resolveString(this.getPassword()));
        return nTServiceConfig;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setDependencies(String[] stringArray) {
        if (stringArray == null) {
            if (this.dependencies != null) {
                this.dependencies.removeAllElements();
                this.dependencies = null;
            }
            return;
        }
        this.verifyDependencies();
        this.dependencies.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.addDependency(stringArray[n]);
            ++n;
        }
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setEnableDesktopInteraction(boolean bl) {
        this.enableDesktopInteraction = bl;
    }

    public void setErrorControl(int n) {
        this.errorControl = n;
    }

    public void setLoadOrderGroup(String string) {
        this.loadOrderGroup = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setServiceType(int n) {
        this.serviceType = n;
    }

    public void setStartType(int n) {
        this.startType = n;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String toString() {
        return "Service Configuration";
    }

    public void validateForBuild(Log log, Object object) {
        if ((this.startType == 1 || this.startType == 0) && (this.serviceType & 0xF) == 0) {
            log.logEvent(object, "err", "Use service start type 'System Start' or 'Boot Start' only if you are installing a driver service");
        }
        if (this.getEnableDesktopInteraction() && this.userName != null && this.userName.length() > 0) {
            log.logEvent(object, "err", "Desktop interaction can only be enabled if the local system account is used to start the service.");
        }
    }

    private void verifyDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new Vector();
        }
    }
}

