/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.LexCacheCell;
import ice.htmlbrowser.Tag;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

final class Lex {
    private LexCacheCell cache;
    private Reader reader;
    private int readCount;
    private boolean flagPreformatted = false;
    private boolean flagPlainText = false;
    private boolean flagIsochars = true;
    private boolean flagChinese = false;
    private char[] tokenChars = new char[1024];
    private int tokenLength;
    private int curChar;
    private int tokenType = -1;
    private boolean flagBreakBefore = false;
    private int commentCount;
    private boolean flagPreStart = false;
    static final int TOKEN_WORD = 2;
    static final int TOKEN_TAG = 3;
    static final int TOKEN_COMMENT = 4;
    static Hashtable isochars = new Hashtable();

    Lex() {
    }

    private void appendChar() {
        if (this.tokenLength >= this.tokenChars.length) {
            char[] cArray = this.tokenChars;
            this.tokenChars = new char[cArray.length + 1024];
            System.arraycopy(cArray, 0, this.tokenChars, 0, cArray.length);
        }
        this.tokenChars[this.tokenLength++] = (char)this.curChar;
    }

    private void readChar() throws IOException {
        if (this.cache != null) {
            this.cache.appendChar(this.curChar);
        }
        this.curChar = this.reader.read();
        ++this.readCount;
    }

    void setReader(Reader reader, LexCacheCell lexCacheCell, String string) throws IOException {
        this.reader = reader;
        this.cache = lexCacheCell;
        this.curChar = this.reader.read();
        this.readCount = 0;
        this.flagChinese = false;
        if (string != null) {
            if (string.equals("Big5")) {
                this.flagChinese = true;
                return;
            }
            if (string.equals("UTF8")) {
                this.flagChinese = true;
                return;
            }
            if (string.equalsIgnoreCase("sjis")) {
                this.flagChinese = true;
                return;
            }
            if (string.equalsIgnoreCase("shift_jis")) {
                this.flagChinese = true;
                return;
            }
            if (string.equalsIgnoreCase("iso-2022-jp")) {
                this.flagChinese = true;
                return;
            }
            if (string.startsWith("EUC-")) {
                this.flagChinese = true;
                return;
            }
            if (string.startsWith("ISO2")) {
                this.flagChinese = true;
                return;
            }
            if (string.startsWith("JIS")) {
                this.flagChinese = true;
            }
        }
    }

    void setPreformatted(boolean bl) {
        this.flagPreformatted = bl;
        this.flagPreStart = true;
    }

    boolean isPreformatted() {
        return this.flagPreformatted;
    }

    void setPlainText(boolean bl) {
        this.flagPlainText = bl;
    }

    void setIsochars(boolean bl) {
        this.flagIsochars = bl;
    }

    int getReadCount() {
        return this.readCount;
    }

    int getNextToken() {
        if (this.reader == null) {
            return -1;
        }
        if (this.curChar < 0) {
            this.killReader();
            return -1;
        }
        try {
            this.flagBreakBefore = false;
            this.tokenLength = 0;
            if (this.findFirstNonBlank()) {
                if (this.flagPreformatted) {
                    this.tokenType = 2;
                    return this.tokenType;
                }
                this.flagBreakBefore = true;
            }
            if (this.flagPreformatted) {
                boolean bl = !this.flagPreStart;
                this.flagPreStart = false;
                if (this.curChar == 10 || this.curChar == 13) {
                    this.tokenType = 2;
                    int n = this.curChar;
                    this.readChar();
                    if (n == 10 && this.curChar == 13 || n == 13 && this.curChar == 10) {
                        this.readChar();
                    }
                    if (bl) {
                        this.tokenChars[0] = 10;
                        this.tokenLength = 1;
                        return this.tokenType;
                    }
                } else if (this.curChar == 9) {
                    this.tokenType = 2;
                    this.readChar();
                    this.tokenChars[0] = 32;
                    this.tokenLength = 1;
                    return this.tokenType;
                }
            }
            if (this.curChar == 60 && !this.flagPlainText) {
                this.readChar();
                if (this.curChar == 32) {
                    this.tokenChars[0] = 60;
                    this.tokenLength = 1;
                    this.tokenType = 2;
                } else {
                    this.commentCount = 0;
                    this.findTagEnd();
                    this.tokenType = this.commentCount == 3 ? 4 : 3;
                }
            } else if (this.curChar == 38 && !this.flagPlainText && this.flagIsochars) {
                this.findSpecialEnd();
                this.makeSpecial();
                this.tokenType = 2;
            } else {
                this.findWordEnd();
                this.tokenType = 2;
            }
        }
        catch (IOException iOException) {
            this.killReader();
        }
        return this.tokenType;
    }

    int getTokenType() {
        return this.tokenType;
    }

    String getTokenString() {
        return new String(this.tokenChars, 0, this.tokenLength);
    }

    boolean isTokenBreakable() {
        return this.flagBreakBefore && !this.flagPreformatted;
    }

    void killReader() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {}
        this.reader = null;
        this.tokenType = -1;
        if (this.cache != null) {
            this.cache.endCaching();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean findFirstNonBlank() throws IOException {
        block4: {
            var1_1 = 0;
            if (!this.flagPreformatted) ** GOTO lbl15
            while (this.curChar >= 0) {
                if (this.curChar == 32) {
                    if (this.flagPreformatted) {
                        this.appendChar();
                    }
                    this.readChar();
                    ++var1_1;
                    continue;
                }
                break block4;
            }
            break block4;
            while (this.curChar == 32 || this.curChar == 10 || this.curChar == 13 || this.curChar == 9) {
                this.readChar();
                ++var1_1;
lbl15:
                // 2 sources

                if (this.curChar >= 0) continue;
            }
        }
        return var1_1 > 0;
    }

    private void findTagEnd() throws IOException {
        int n = 0;
        while (this.curChar >= 0 && this.commentCount < 3) {
            if (this.curChar == 62) {
                this.readChar();
                break;
            }
            if (n == 0 && this.curChar == 33 || n == 1 && this.curChar == 45 || n == 2 && this.curChar == 45) {
                ++this.commentCount;
            }
            this.appendChar();
            this.readChar();
            ++n;
        }
        if (this.commentCount == 3) {
            int n2 = 0;
            int n3 = 0;
            while (this.curChar >= 0) {
                if (this.curChar == 62 && (n2 == 45 || n2 == 33) && n3 == 45) {
                    this.readChar();
                    break;
                }
                n3 = n2;
                n2 = this.curChar;
                this.readChar();
            }
        }
        while (this.curChar >= 0) {
            if (this.curChar != 13) break;
            this.readChar();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void findWordEnd() throws IOException {
        if (!this.flagChinese) ** GOTO lbl20
        if (this.curChar <= 4096) ** GOTO lbl13
        this.appendChar();
        this.readChar();
        this.flagBreakBefore = true;
        return;
        while (!(this.curChar == 32 && !this.flagPreformatted || (this.curChar == 60 || this.curChar == 38 && this.flagIsochars) && !this.flagPlainText || this.curChar == 10 || this.curChar == 13)) {
            if (this.curChar == 9) {
                return;
            }
            if (this.curChar > 255) break;
            this.appendChar();
            this.readChar();
lbl13:
            // 2 sources

            if (this.curChar >= 0) continue;
        }
        return;
        while (!(this.curChar == 32 && !this.flagPreformatted || (this.curChar == 60 || this.curChar == 38 && this.flagIsochars) && !this.flagPlainText || this.curChar == 10 || this.curChar == 13)) {
            if (this.curChar == 9) {
                return;
            }
            this.appendChar();
            this.readChar();
lbl20:
            // 2 sources

            if (this.curChar >= 0) continue;
        }
    }

    private void findSpecialEnd() throws IOException {
        while (this.curChar >= 0) {
            if (this.curChar == 59) {
                this.appendChar();
                this.readChar();
                return;
            }
            if (this.curChar == 32 || this.curChar == 60 || this.curChar == 10 || this.curChar == 13) break;
            if (this.curChar == 9) {
                return;
            }
            this.appendChar();
            this.readChar();
        }
    }

    void makeSpecial() {
        if (this.tokenLength < 2) {
            return;
        }
        char c = Lex.do_subst(new String(this.tokenChars, 1, this.tokenLength - 1));
        if (c != '*') {
            this.tokenChars[0] = c;
            this.tokenLength = 1;
        }
    }

    private static final char do_subst(String string) {
        int n = 42;
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        Integer n2 = (Integer)isochars.get(string);
        if (string.equalsIgnoreCase("LT")) {
            n = 60;
        } else if (string.equalsIgnoreCase("GT")) {
            n = 62;
        } else if (string.equalsIgnoreCase("AMP")) {
            n = 38;
        } else if (string.equalsIgnoreCase("QUOT")) {
            n = 34;
        } else if (string.equalsIgnoreCase("COPY")) {
            n = 169;
        } else if (string.equalsIgnoreCase("REG")) {
            n = 174;
        } else if (string.length() >= 2 && string.charAt(0) == '#') {
            n = (char)Tag.decStrToInt(string.substring(1));
        } else if (n2 != null) {
            n = (char)n2.intValue();
        }
        return (char)n;
    }

    static String substituteIsochars(String string) {
        if (string == null || string.indexOf(38) < 0 || string.indexOf(59) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(1200);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf("&", n2);
            if (n3 < 0) {
                stringBuffer.append(string.substring(n2));
                break;
            }
            n = string.indexOf(";", n3);
            if (n < 0) {
                stringBuffer.append(string.substring(n2));
                break;
            }
            stringBuffer.append(string.substring(n2, n3));
            stringBuffer.append(Lex.do_subst(string.substring(n3 + 1, n)));
            n2 = n + 1;
        }
        return new String(stringBuffer);
    }

    static {
        isochars.put("nbsp", new Integer(160));
        isochars.put("iexcl", new Integer(161));
        isochars.put("cent", new Integer(162));
        isochars.put("pound", new Integer(163));
        isochars.put("curren", new Integer(164));
        isochars.put("yen", new Integer(165));
        isochars.put("brvbar", new Integer(166));
        isochars.put("sect", new Integer(167));
        isochars.put("uml", new Integer(168));
        isochars.put("copy", new Integer(169));
        isochars.put("ordf", new Integer(170));
        isochars.put("laquo", new Integer(171));
        isochars.put("not", new Integer(172));
        isochars.put("shy", new Integer(173));
        isochars.put("reg", new Integer(174));
        isochars.put("macr", new Integer(175));
        isochars.put("deg", new Integer(176));
        isochars.put("plusmn", new Integer(177));
        isochars.put("sup2", new Integer(178));
        isochars.put("sup3", new Integer(179));
        isochars.put("acute", new Integer(180));
        isochars.put("micro", new Integer(181));
        isochars.put("para", new Integer(182));
        isochars.put("middot", new Integer(183));
        isochars.put("cedil", new Integer(184));
        isochars.put("sup1", new Integer(185));
        isochars.put("ordm", new Integer(186));
        isochars.put("raquo", new Integer(187));
        isochars.put("frac14", new Integer(188));
        isochars.put("frac12", new Integer(189));
        isochars.put("frac34", new Integer(190));
        isochars.put("iquest", new Integer(191));
        isochars.put("Agrave", new Integer(192));
        isochars.put("Aacute", new Integer(193));
        isochars.put("Acirc", new Integer(194));
        isochars.put("Atilde", new Integer(195));
        isochars.put("Auml", new Integer(196));
        isochars.put("Aring", new Integer(197));
        isochars.put("AElig", new Integer(198));
        isochars.put("Ccedil", new Integer(199));
        isochars.put("Egrave", new Integer(200));
        isochars.put("Eacute", new Integer(201));
        isochars.put("Ecirc", new Integer(202));
        isochars.put("Euml", new Integer(203));
        isochars.put("Igrave", new Integer(204));
        isochars.put("Iacute", new Integer(205));
        isochars.put("Icirc", new Integer(206));
        isochars.put("Iuml", new Integer(207));
        isochars.put("ETH", new Integer(208));
        isochars.put("Ntilde", new Integer(209));
        isochars.put("Ograve", new Integer(210));
        isochars.put("Oacute", new Integer(211));
        isochars.put("Ocirc", new Integer(212));
        isochars.put("Otilde", new Integer(213));
        isochars.put("Ouml", new Integer(214));
        isochars.put("times", new Integer(215));
        isochars.put("Oslash", new Integer(216));
        isochars.put("Ugrave", new Integer(217));
        isochars.put("Uacute", new Integer(218));
        isochars.put("Ucirc", new Integer(219));
        isochars.put("Uuml", new Integer(220));
        isochars.put("Yacute", new Integer(221));
        isochars.put("THORN", new Integer(222));
        isochars.put("szlig", new Integer(223));
        isochars.put("agrave", new Integer(224));
        isochars.put("aacute", new Integer(225));
        isochars.put("acirc", new Integer(226));
        isochars.put("atilde", new Integer(227));
        isochars.put("auml", new Integer(228));
        isochars.put("aring", new Integer(229));
        isochars.put("aelig", new Integer(230));
        isochars.put("ccedil", new Integer(231));
        isochars.put("egrave", new Integer(232));
        isochars.put("eacute", new Integer(233));
        isochars.put("ecirc", new Integer(234));
        isochars.put("euml", new Integer(235));
        isochars.put("igrave", new Integer(236));
        isochars.put("iacute", new Integer(237));
        isochars.put("icirc", new Integer(238));
        isochars.put("iuml", new Integer(239));
        isochars.put("eth", new Integer(240));
        isochars.put("ntilde", new Integer(241));
        isochars.put("ograve", new Integer(242));
        isochars.put("oacute", new Integer(243));
        isochars.put("ocirc", new Integer(244));
        isochars.put("otilde", new Integer(245));
        isochars.put("ouml", new Integer(246));
        isochars.put("divide", new Integer(247));
        isochars.put("oslash", new Integer(248));
        isochars.put("ugrave", new Integer(249));
        isochars.put("uacute", new Integer(250));
        isochars.put("ucirc", new Integer(251));
        isochars.put("uuml", new Integer(252));
        isochars.put("yacute", new Integer(253));
        isochars.put("thorn", new Integer(254));
        isochars.put("yuml", new Integer(255));
        isochars.put("ndash", new Integer(8211));
        isochars.put("mdash", new Integer(8212));
        isochars.put("euro", new Integer(8364));
    }
}

