/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import ice.htmlbrowser.BrowserAuthException;
import ice.htmlbrowser.BrowserTools;
import ice.htmlbrowser.BrowserURLLoader;
import ice.htmlbrowser.FrameInfo;
import ice.htmlbrowser.LexCache;
import ice.htmlbrowser.LexCacheCell;
import ice.htmlbrowser.Parser;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;

class ProcessURL
implements Runnable {
    private Thread procThread;
    private boolean stop_flag = false;
    private URL url;
    private FrameInfo frame;
    private Component comp;
    private Parser parser;
    private String outputString;

    ProcessURL(FrameInfo frameInfo, Component component, Parser parser, URL uRL, String string) {
        this.frame = frameInfo;
        this.comp = component;
        this.parser = parser;
        this.url = uRL;
        this.outputString = string;
    }

    void startThread() {
        if (this.procThread != null) {
            return;
        }
        this.procThread = new Thread(this);
        this.procThread.start();
    }

    void stopThread() {
        this.stop_flag = true;
        this.procThread = null;
    }

    public void run() {
        String string;
        Object object;
        Object object2;
        BrowserURLLoader browserURLLoader;
        boolean bl;
        do {
            bl = false;
            browserURLLoader = new BrowserURLLoader(this.url, this.outputString, this.comp, this.frame.getReferer());
            if (this.stop_flag) {
                return;
            }
            object2 = null;
            try {
                object2 = browserURLLoader.getInputStream();
                object = browserURLLoader.getConnection();
                this.url = ((URLConnection)object).getURL();
                this.frame.setDocumentBase(this.url);
            }
            catch (UnknownHostException unknownHostException) {
                String string2 = "<H4>Unknown host : " + unknownHostException.getMessage() + "<BR>" + "</H4>";
                this.frame.htmlAppend(string2);
                return;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                String string3 = "<hr>\nAn error occurred while connecting to " + this.url.toString() + "<dl><dt>The server responded with:</dt><dd>" + noRouteToHostException.getMessage() + "</dd></dl><hr>";
                this.frame.htmlAppend(string3);
                return;
            }
            catch (BrowserAuthException browserAuthException) {
                this.frame.htmlAppend(browserAuthException.getMessage());
                return;
            }
            catch (IOException iOException) {
                String string4 = "<H4>Cannot connect to " + this.url.toString() + "</H4>";
                this.frame.htmlAppend(String.valueOf(string4) + "<p>" + iOException.getMessage());
                return;
            }
            catch (Exception exception) {
            }
            catch (Error error) {}
            string = browserURLLoader.getContentType();
            if (string == null) {
                string = "unknown";
            }
            if (this.stop_flag) {
                return;
            }
            object = this.url.getFile();
            if (!((String)object).endsWith(".jar") && !((String)object).endsWith(".JAR")) continue;
            try {
                this.url = this.constructJamURL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                String string5 = "A malformed URL was encounteredwhile connecting to " + this.url.toString() + "<dl><dt>The response was :</dt>" + "<dd>" + malformedURLException.getMessage() + "</dd></dl><hr>";
                this.frame.htmlAppend(string5);
                return;
            }
            bl = true;
        } while (bl);
        if (string.equals("image/gif") || string.equals("image/jpeg")) {
            this.frame.htmlAppend("<H4>" + this.url.toString() + "</H4>" + "<P> <CENTER><IMG SRC=\"" + this.url.toString() + "\"></CENTER>");
            return;
        }
        if (string.startsWith("application")) {
            this.saveFromStream(browserURLLoader, this.url.getFile());
            return;
        }
        if (this.stop_flag) {
            return;
        }
        try {
            object2 = Browser.getLexCache();
            if (this.outputString == null && this.url.getFile().indexOf(63) < 0 && object2 != null) {
                object = ((LexCache)object2).beginCaching(this.url, string);
                this.parser.setLexURLLoader(browserURLLoader, string, (LexCacheCell)object);
                return;
            }
            this.parser.setLexURLLoader(browserURLLoader, string, null);
            return;
        }
        catch (IOException iOException) {
            object = "<H4>Cannot connect to " + this.url.toString() + "<BR>" + "</H4>";
            this.frame.htmlAppend(String.valueOf(object) + iOException.getMessage());
            return;
        }
    }

    private URL constructJamURL(URL uRL) throws MalformedURLException {
        String string = String.valueOf(uRL.getProtocol()) + "://" + uRL.getHost() + uRL.getFile();
        String string2 = uRL.getRef();
        if (string2 == null || string2.equals("")) {
            string2 = "index.html";
        }
        string = URLEncoder.encode(string);
        String string3 = "jam://" + string + "/" + string2;
        URL uRL2 = new URL(string3);
        return uRL2;
    }

    private void saveFromStream(BrowserURLLoader browserURLLoader, String string) {
        Object object;
        try {
            object = new BrowserTools(this.comp);
            ((BrowserTools)object).saveFromStream(browserURLLoader.getInputStream(), string);
        }
        catch (IOException iOException) {
            String string2 = "<H4>Could not save " + this.url.toString() + "</H4>";
            this.frame.htmlAppend(string2);
            return;
        }
        object = "<H4>" + this.url.toString() + "<BR>" + "File download complete </H4>";
        this.frame.htmlAppend((String)object);
    }
}

