/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

public class SingletonBeanFactoryLocator
implements BeanFactoryLocator {
    private static final String DEFAULT_RESOURCE_LOCATION = "classpath*:beanRefFactory.xml";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator == null ? (class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator = SingletonBeanFactoryLocator.class$("org.springframework.beans.factory.access.SingletonBeanFactoryLocator")) : class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator));
    private static Map instances = new HashMap();
    private final Map bfgInstancesByKey = new HashMap();
    private final Map bfgInstancesByObj = new HashMap();
    private final String resourceLocation;
    static /* synthetic */ Class class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator;

    public static BeanFactoryLocator getInstance() throws BeansException {
        return SingletonBeanFactoryLocator.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String selector) throws BeansException {
        String resourceLocation = selector;
        if (resourceLocation == null) {
            resourceLocation = DEFAULT_RESOURCE_LOCATION;
        }
        if (!ResourcePatternUtils.isUrl((String)resourceLocation)) {
            resourceLocation = "classpath*:" + resourceLocation;
        }
        Map map = instances;
        synchronized (map) {
            BeanFactoryLocator bfl;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("SingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + ((Object)instances).hashCode() + ", instances=" + instances));
            }
            if ((bfl = (BeanFactoryLocator)instances.get(resourceLocation)) == null) {
                bfl = new SingletonBeanFactoryLocator(resourceLocation);
                instances.put(resourceLocation, bfl);
            }
            return bfl;
        }
    }

    protected SingletonBeanFactoryLocator(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanFactoryReference useBeanFactory(String factoryKey) throws BeansException {
        Map map = this.bfgInstancesByKey;
        synchronized (map) {
            Object bean;
            BeanFactory groupContext;
            BeanFactoryGroup bfg = (BeanFactoryGroup)this.bfgInstancesByKey.get(this.resourceLocation);
            if (bfg != null) {
                bfg.refCount++;
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Factory group with resource name [" + this.resourceLocation + "] requested. Creating new instance."));
                }
                groupContext = this.createDefinition(this.resourceLocation, factoryKey);
                bfg = new BeanFactoryGroup();
                bfg.definition = groupContext;
                bfg.refCount = 1;
                this.bfgInstancesByKey.put(this.resourceLocation, bfg);
                this.bfgInstancesByObj.put(groupContext, bfg);
                try {
                    this.initializeDefinition(groupContext);
                }
                catch (BeansException ex) {
                    this.bfgInstancesByKey.remove(this.resourceLocation);
                    this.bfgInstancesByObj.remove(groupContext);
                    throw new BootstrapException("Unable to initialize group definition. Group resource name [" + this.resourceLocation + "], factory key [" + factoryKey + "]", (Throwable)((Object)ex));
                }
            }
            groupContext = bfg.definition;
            String beanName = factoryKey;
            try {
                bean = groupContext.getBean(beanName);
                if (bean instanceof String) {
                    logger.warn((Object)"You're using the deprecated alias-through-String-bean feature, which will be removed as of Spring 2.5. It is recommended to replace this with an <alias> tag (see SingletonBeanFactoryLocator javadoc).");
                    beanName = (String)bean;
                    bean = groupContext.getBean(beanName);
                }
            }
            catch (BeansException ex) {
                throw new BootstrapException("Unable to return specified BeanFactory instance: factory key [" + factoryKey + "], from group with resource name [" + this.resourceLocation + "]", (Throwable)((Object)ex));
            }
            if (!(bean instanceof BeanFactory)) {
                throw new BootstrapException("Bean '" + beanName + "' is not a BeanFactory: factory key [" + factoryKey + "], from group with resource name [" + this.resourceLocation + "]");
            }
            final BeanFactory beanFactory = (BeanFactory)bean;
            return new BeanFactoryReference(){
                BeanFactory groupContextRef;
                {
                    this.groupContextRef = groupContext;
                }

                public BeanFactory getFactory() {
                    return beanFactory;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void release() throws FatalBeanException {
                    Map map = SingletonBeanFactoryLocator.this.bfgInstancesByKey;
                    synchronized (map) {
                        BeanFactory savedRef = this.groupContextRef;
                        if (savedRef != null) {
                            this.groupContextRef = null;
                            BeanFactoryGroup bfg = (BeanFactoryGroup)SingletonBeanFactoryLocator.this.bfgInstancesByObj.get(savedRef);
                            if (bfg != null) {
                                bfg.refCount--;
                                if (bfg.refCount == 0) {
                                    SingletonBeanFactoryLocator.this.destroyDefinition(savedRef, SingletonBeanFactoryLocator.this.resourceLocation);
                                    SingletonBeanFactoryLocator.this.bfgInstancesByKey.remove(SingletonBeanFactoryLocator.this.resourceLocation);
                                    SingletonBeanFactoryLocator.this.bfgInstancesByObj.remove(savedRef);
                                }
                            } else {
                                logger.warn((Object)("Tried to release a SingletonBeanFactoryLocator group definition more times than it has actually been used. Resource name [" + SingletonBeanFactoryLocator.this.resourceLocation + "]"));
                            }
                        }
                    }
                }
            };
        }
    }

    protected BeanFactory createDefinition(String resourceLocation, String factoryKey) {
        DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(factory);
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] configResources = resourcePatternResolver.getResources(resourceLocation);
            if (configResources.length == 0) {
                throw new FatalBeanException("Unable to find resource for specified definition. Group resource name [" + this.resourceLocation + "], factory key [" + factoryKey + "]");
            }
            reader.loadBeanDefinitions(configResources);
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("Error accessing bean definition resource [" + this.resourceLocation + "]", ex);
        }
        catch (BeanDefinitionStoreException ex) {
            throw new FatalBeanException("Unable to load group definition: group resource name [" + this.resourceLocation + "], factory key [" + factoryKey + "]", (Throwable)((Object)ex));
        }
        return factory;
    }

    protected void initializeDefinition(BeanFactory groupDef) {
        if (groupDef instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)groupDef).preInstantiateSingletons();
        }
    }

    protected void destroyDefinition(BeanFactory groupDef, String selector) {
        if (groupDef instanceof ConfigurableBeanFactory) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Factory group with selector '" + selector + "' being released, as there are no more references to it"));
            }
            ((ConfigurableBeanFactory)groupDef).destroySingletons();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BeanFactoryGroup {
        private BeanFactory definition;
        private int refCount = 0;

        private BeanFactoryGroup() {
        }
    }
}

