/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class UtlrDatas_Dt
extends GregorianCalendar {
    private static final long serialVersionUID = 1L;
    private static String BARRA = "/";
    private static String TRACO = "-";
    private static String PONTO = ".";
    private static String DOIS_PONTOS = ":";
    private static String DOIS_ZEROS = "00";
    protected static String BRC = " ";
    private static DecimalFormat formato2Digitos = null;
    private static SimpleDateFormat formato_hora = null;
    private static String[] diasDaSemana = new String[]{"Domingo", "Segunda", "Ter\u00e7a", "Quarta", "Quinta", "Sexta", "S\u00e1bado"};
    private static String[] mesesDoAno = new String[]{"Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"};

    public UtlrDatas_Dt() {
        UtlrDatas_Dt.acertaHora(this);
    }

    public UtlrDatas_Dt(UtlrDatas_Dt data) {
        super(data.get(1), data.get(2), data.get(5), data.get(10), data.get(12), data.get(13));
    }

    public UtlrDatas_Dt(String data) {
        if (data != null && data.length() == 10) {
            GregorianCalendar newDt = UtlrDatas_Dt.converteData(data);
            this.set(5, newDt.get(5));
            this.set(2, newDt.get(2));
            this.set(1, newDt.get(1));
            UtlrDatas_Dt.acertaHora(this);
            Object var2_2 = null;
        }
    }

    public UtlrDatas_Dt(java.sql.Date data) {
        if (data != null) {
            UtlrDatas_Dt.acertaDia(data, this);
            UtlrDatas_Dt.acertaHora(this);
        }
    }

    public UtlrDatas_Dt(Timestamp data) {
        if (data == null) {
            return;
        }
        UtlrDatas_Dt.acertaDia(data, this);
        int hr = 0;
        int mn = 0;
        int sc = 0;
        int ms = 0;
        try {
            String hora = UtlrDatas_Dt.getFormatoHora().format(data);
            hr = Integer.parseInt(hora.substring(0, 2));
            mn = Integer.parseInt(hora.substring(3, 5));
            sc = Integer.parseInt(hora.substring(6, 8));
            if (hora.length() >= 9) {
                ms = Integer.parseInt(hora.substring(9));
            }
        }
        catch (Exception e) {
            throw new NumberFormatException();
        }
        this.set(11, hr);
        this.set(12, mn);
        this.set(13, sc);
        this.set(14, ms);
    }

    public UtlrDatas_Dt(Date data) {
        if (data != null) {
            UtlrDatas_Dt.acertaDia(data, this);
            UtlrDatas_Dt.acertaHora(this);
        }
    }

    private static void acertaDia(Object dt, UtlrDatas_Dt data) {
        SimpleDateFormat fmt = null;
        if (dt instanceof Timestamp) {
            fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.sss");
            try {
                int dia = Integer.parseInt(fmt.format((Timestamp)dt).substring(0, 2));
                int mes = Integer.parseInt(fmt.format((Timestamp)dt).substring(3, 5)) - 1;
                if (mes < 0) {
                    mes = 0;
                }
                int ano = Integer.parseInt(fmt.format((Timestamp)dt).substring(6, 10));
                data.set(1, ano);
                data.set(2, mes);
                data.set(5, dia);
                fmt = null;
            }
            catch (Exception e) {
                throw new NumberFormatException();
            }
        }
        if (dt instanceof Date) {
            fmt = new SimpleDateFormat("dd/MM/yyyy");
            try {
                int dia = Integer.parseInt(fmt.format((Date)dt).substring(0, 2));
                int mes = Integer.parseInt(fmt.format((Date)dt).substring(3, 5));
                int ano = Integer.parseInt(fmt.format((Date)dt).substring(6));
                data.set(5, dia);
                data.set(2, mes - 1);
                data.set(1, ano);
                fmt = null;
            }
            catch (Exception e) {
                throw new NumberFormatException();
            }
        }
    }

    private static void acertaHora(UtlrDatas_Dt data) {
        Date agora = new Date();
        String hora = UtlrDatas_Dt.getFormatoHora().format(agora);
        int hr = 0;
        int mn = 0;
        int sc = 0;
        int ms = 0;
        try {
            hr = Integer.parseInt(hora.substring(0, 2));
            mn = Integer.parseInt(hora.substring(3, 5));
            sc = Integer.parseInt(hora.substring(6, 8));
            if (hora.length() >= 9) {
                ms = Integer.parseInt(hora.substring(9));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        data.set(11, hr);
        data.set(12, mn);
        data.set(13, sc);
        data.set(14, ms);
        hora = null;
        agora = null;
    }

    public void add(int dias) {
        boolean ahead = true;
        if (dias < 0) {
            ahead = false;
            dias *= -1;
        }
        int i = 0;
        while (i < dias) {
            this.addDay(ahead);
            ++i;
        }
    }

    private void addDay(boolean avanca) {
        int diaMax = this.getActualMaximum(5);
        int diaMin = this.getActualMinimum(5);
        if (this.get(5) >= diaMax && avanca) {
            this.addMonth(avanca);
            this.set(5, this.getActualMinimum(5));
            return;
        }
        if (this.get(5) <= diaMin && !avanca) {
            this.addMonth(avanca);
            this.set(5, this.getActualMaximum(5));
            return;
        }
        this.roll(5, avanca);
    }

    public void addMes() {
        this.addMonth(true);
    }

    public void addMes(int meses) {
        boolean avc = true;
        if (meses < 0) {
            avc = false;
            meses *= -1;
        }
        int i = 0;
        while (i < meses) {
            this.addMonth(avc);
            ++i;
        }
    }

    private void addMonth(boolean avanca) {
        int mesMax = this.getActualMaximum(2);
        int mesMin = this.getActualMinimum(2);
        if (this.get(2) >= mesMax && avanca) {
            this.roll(1, avanca);
            this.set(2, this.getActualMinimum(2));
            return;
        }
        if (this.get(2) <= mesMin && !avanca) {
            this.roll(1, avanca);
            this.set(2, this.getActualMaximum(2));
            return;
        }
        this.roll(2, avanca);
    }

    public void avancaMes(int qtMeses, int diaVcto) {
        if (qtMeses <= 0 || diaVcto <= 0) {
            return;
        }
        int i = 0;
        while (i < qtMeses) {
            if (this.get(2) >= 11) {
                this.roll(1, true);
            }
            this.roll(2, true);
            int maxDia = this.getActualMaximum(5);
            if (this.get(5) != diaVcto) {
                while (this.get(5) < diaVcto && this.get(5) < maxDia) {
                    this.add(1);
                }
                while (this.get(5) > diaVcto && this.get(5) > 1) {
                    this.sub(1);
                }
            }
            ++i;
        }
    }

    public static GregorianCalendar converteData(String dt) {
        if (dt == null || dt.length() < 8 || dt.length() > 10) {
            return new GregorianCalendar();
        }
        int separador = dt.indexOf(BARRA);
        if (separador <= 0) {
            separador = dt.indexOf(TRACO);
        }
        GregorianCalendar retorna = new GregorianCalendar();
        int dia = retorna.get(5);
        int mes = retorna.get(2) + 1;
        int ano = retorna.get(1);
        switch (separador) {
            case 2: {
                try {
                    dia = Integer.parseInt(dt.substring(0, 2));
                    mes = Integer.parseInt(dt.substring(3, 5));
                    ano = Integer.parseInt(dt.substring(6));
                    if (!UtlrDatas_Dt.validaData(dia, mes, ano)) {
                        throw new NumberFormatException();
                    }
                    retorna.set(5, dia);
                    retorna.set(2, mes - 1);
                    retorna.set(1, ano);
                    break;
                }
                catch (Exception e) {
                    throw new NumberFormatException();
                }
            }
            case 4: {
                try {
                    dia = Integer.parseInt(dt.substring(8));
                    mes = Integer.parseInt(dt.substring(5, 7));
                    ano = Integer.parseInt(dt.substring(0, 4));
                    if (!UtlrDatas_Dt.validaData(dia, mes, ano)) {
                        throw new NumberFormatException();
                    }
                    retorna.set(5, dia);
                    retorna.set(2, mes - 1);
                    retorna.set(1, ano);
                    break;
                }
                catch (Exception e) {
                    throw new NumberFormatException();
                }
            }
        }
        return retorna;
    }

    public int getAno() {
        return this.get(1);
    }

    public String getAnoAsString() {
        return String.valueOf(this.get(1));
    }

    public Date getDataAsDate() {
        SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy");
        try {
            return new Date(fmt.parse(this.toString()).getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public java.sql.Date getDataAsSqlDate() {
        try {
            return new java.sql.Date(this.getDataAsDate().getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDataAsString() {
        return this.toString();
    }

    public Timestamp getDataAsTimestamp() {
        SimpleDateFormat fmt_dt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.sss");
        Date agora = null;
        try {
            agora = fmt_dt.parse(String.valueOf(this.toString()) + " " + this.getHoraAsString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        fmt_dt = null;
        if (agora != null) {
            return new Timestamp(agora.getTime());
        }
        return null;
    }

    public int getDia() {
        return this.get(5);
    }

    public String getDiaAsString() {
        return UtlrDatas_Dt.getFormato2Digitos().format(this.get(5));
    }

    public String getDiaDaSemana() {
        switch (this.get(7)) {
            case 1: {
                return diasDaSemana[0];
            }
            case 2: {
                return diasDaSemana[1];
            }
            case 3: {
                return diasDaSemana[2];
            }
            case 4: {
                return diasDaSemana[3];
            }
            case 5: {
                return diasDaSemana[4];
            }
            case 6: {
                return diasDaSemana[5];
            }
            case 7: {
                return diasDaSemana[6];
            }
        }
        return BRC;
    }

    /*
     * Unable to fully structure code
     */
    public static int getDiferenca(UtlrDatas_Dt dtInicial, UtlrDatas_Dt dtFinal) {
        block3: {
            if (dtInicial == null || dtFinal == null) {
                return 0;
            }
            dIni = new UtlrDatas_Dt(dtInicial);
            dFin = new UtlrDatas_Dt(dtFinal);
            dIni.set(11, 0);
            dIni.set(12, 0);
            dIni.set(13, 0);
            dIni.set(14, 0);
            dFin.set(11, 0);
            dFin.set(12, 0);
            dFin.set(13, 0);
            dFin.set(14, 0);
            qt = 0;
            if (!dIni.before(dFin)) ** GOTO lbl22
            while (dIni.before(dFin)) {
                dIni.add(1);
                ++qt;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                dFin.add(1);
                --qt;
lbl22:
                // 2 sources

                ** while (dFin.before((Object)dIni))
            }
        }
        dIni = null;
        dFin = null;
        return qt;
    }

    public static int getDiferenca(String dtInicial, String dtFinal) {
        try {
            UtlrDatas_Dt dInic = new UtlrDatas_Dt(dtInicial);
            UtlrDatas_Dt dFin = new UtlrDatas_Dt(dtFinal);
            return UtlrDatas_Dt.getDiferenca(dInic, dFin);
        }
        catch (Exception e) {
            throw new NumberFormatException();
        }
    }

    public static UtlrDatas_Dt[] getFeriados(int ano) {
        Vector<UtlrDatas_Dt> dts = new Vector<UtlrDatas_Dt>();
        int dim = 0;
        UtlrDatas_Dt domPascoa = UtlrDatas_Dt.getPascoa(ano);
        domPascoa.setHora(0);
        domPascoa.setMinuto(0);
        domPascoa.setSegundo(0);
        domPascoa.setMiliSec(0);
        if (domPascoa != null) {
            domPascoa.add(-2);
            dts.add(new UtlrDatas_Dt(domPascoa));
            ++dim;
            domPascoa.add(-45);
            dts.add(new UtlrDatas_Dt(domPascoa));
            ++dim;
            domPascoa.add(-1);
            dts.add(new UtlrDatas_Dt(domPascoa));
            ++dim;
            domPascoa.add(48);
            domPascoa.add(60);
            dts.add(new UtlrDatas_Dt(domPascoa));
            ++dim;
        }
        dts.addElement(new UtlrDatas_Dt("01/01/" + String.valueOf(ano)));
        ++dim;
        dts.addElement(new UtlrDatas_Dt("21/04/" + String.valueOf(ano)));
        ++dim;
        dts.addElement(new UtlrDatas_Dt("01/05/" + String.valueOf(ano)));
        ++dim;
        dts.addElement(new UtlrDatas_Dt("07/09/" + String.valueOf(ano)));
        ++dim;
        dts.addElement(new UtlrDatas_Dt("12/10/" + String.valueOf(ano)));
        ++dim;
        dts.addElement(new UtlrDatas_Dt("02/11/" + String.valueOf(ano)));
        ++dim;
        dts.addElement(new UtlrDatas_Dt("15/11/" + String.valueOf(ano)));
        ++dim;
        dts.addElement(new UtlrDatas_Dt("25/12/" + String.valueOf(ano)));
        dts.setSize(++dim);
        Object[] retorno = new UtlrDatas_Dt[dim];
        int i = 0;
        while (i < dim) {
            retorno[i] = (UtlrDatas_Dt)dts.elementAt(i);
            ++i;
        }
        domPascoa = null;
        dts = null;
        Arrays.sort(retorno);
        return retorno;
    }

    private static DecimalFormat getFormato2Digitos() {
        if (formato2Digitos == null) {
            formato2Digitos = new DecimalFormat(DOIS_ZEROS);
        }
        return formato2Digitos;
    }

    private static SimpleDateFormat getFormatoHora() {
        if (formato_hora == null) {
            Locale myLocale = new Locale("pt", "BR");
            formato_hora = new SimpleDateFormat("HH:mm:ss.SSS", myLocale);
        }
        return formato_hora;
    }

    public String getHoraAsString() {
        return String.valueOf(UtlrDatas_Dt.getFormato2Digitos().format(this.get(11))) + DOIS_PONTOS + UtlrDatas_Dt.getFormato2Digitos().format(this.get(12)) + DOIS_PONTOS + UtlrDatas_Dt.getFormato2Digitos().format(this.get(13)) + PONTO + this.get(14);
    }

    public int getMes() {
        return this.get(2) + 1;
    }

    public String getMesAsString() {
        return UtlrDatas_Dt.getFormato2Digitos().format(this.get(2) + 1);
    }

    public String getMesDoAno() {
        int mes = this.get(2);
        if (mes >= 0 && mes <= 11) {
            return mesesDoAno[mes];
        }
        return BRC;
    }

    private static UtlrDatas_Dt getPascoa(int ano) {
        if (ano < 1590) {
            return null;
        }
        int a = ano % 19;
        int b = ano / 100;
        int d = b / 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int e = b % 4;
        int c = ano % 100;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int mes_Da_Pascoa = (h + l - 7 * m + 114) / 31;
        if (mes_Da_Pascoa < 3 || mes_Da_Pascoa > 4) {
            return null;
        }
        int p = (h + l - 7 * m + 114) % 31;
        int data_Da_Pascoa = p + 1;
        if (data_Da_Pascoa < 1 || data_Da_Pascoa > 31) {
            return null;
        }
        UtlrDatas_Dt pascoa = new UtlrDatas_Dt();
        pascoa.setDia(data_Da_Pascoa);
        pascoa.setMes(mes_Da_Pascoa);
        pascoa.setAno(ano);
        pascoa.setHora(0);
        pascoa.setMinuto(0);
        pascoa.setSegundo(0);
        pascoa.setMiliSec(0);
        return pascoa;
    }

    /*
     * Unable to fully structure code
     */
    public String getTimestampAsString() {
        block1: {
            ts = this.getDataAsTimestamp();
            aux = ts.toString();
            if (aux.length() <= 23) ** GOTO lbl7
            aux = aux.substring(0, 23);
            break block1;
lbl-1000:
            // 1 sources

            {
                aux = String.valueOf(aux) + "0";
lbl7:
                // 2 sources

                ** while (aux.length() < 23)
            }
        }
        return aux;
    }

    public static boolean isDataValida(String dt) {
        int ano;
        int mes;
        int dia;
        if (dt == null) {
            return false;
        }
        if (dt.length() != 10) {
            return false;
        }
        int pos = dt.indexOf(BARRA);
        if (pos <= 0) {
            pos = dt.indexOf(TRACO);
        }
        if (pos <= 0) {
            return false;
        }
        if (pos == 2) {
            try {
                dia = Integer.parseInt(dt.substring(0, 2));
                mes = Integer.parseInt(dt.substring(3, 5));
                ano = Integer.parseInt(dt.substring(6));
            }
            catch (Exception e) {
                return false;
            }
        } else if (pos == 4) {
            try {
                dia = Integer.parseInt(dt.substring(8));
                mes = Integer.parseInt(dt.substring(5, 7));
                ano = Integer.parseInt(dt.substring(0, 4));
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        return UtlrDatas_Dt.validaData(dia, mes, ano);
    }

    public static boolean isData6Valida(String dt) {
        if (dt == null || dt.length() != 6) {
            return false;
        }
        String wk = String.valueOf(dt.substring(0, 2)) + "-" + dt.substring(2, 4) + "-20" + dt.substring(4);
        return UtlrDatas_Dt.isDataValida(wk);
    }

    public void setAno(int ano) {
        this.set(1, ano);
    }

    public void setDia(int dia) {
        if (dia < 1) {
            dia = 1;
        }
        int mesCorrente = this.getMes();
        boolean bis = this.isLeapYear(this.get(1));
        switch (mesCorrente) {
            case 2: {
                if (bis && dia > 29) {
                    dia = 29;
                }
                if (bis || dia <= 28) break;
                dia = 28;
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (dia <= 30) break;
                dia = 30;
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                if (dia <= 30) break;
                dia = 30;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                if (dia <= 30) break;
                dia = 30;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                if (dia <= 30) break;
                dia = 30;
                break;
            }
            case 12: {
                if (dia <= 31) break;
                dia = 1;
                break;
            }
            default: {
                if (dia <= 30) break;
                dia = 1;
            }
        }
        this.set(5, dia);
    }

    public void setHora(int hora) {
        if (hora < 0) {
            return;
        }
        if (hora > 23) {
            this.set(11, hora % 23);
        } else {
            this.set(11, hora);
        }
    }

    public void setMes(int mes) {
        if (mes < 1 || mes > 12) {
            return;
        }
        this.set(2, mes - 1);
    }

    public void setMiliSec(int seg) {
        if (seg < 0) {
            return;
        }
        if (seg > 999) {
            this.set(14, seg % 999);
        } else {
            this.set(14, seg);
        }
    }

    public void setMinuto(int min) {
        if (min < 0) {
            return;
        }
        if (min > 59) {
            this.set(12, min % 59);
        } else {
            this.set(12, min);
        }
    }

    public void setSegundo(int seg) {
        if (seg < 0) {
            return;
        }
        if (seg > 59) {
            this.set(13, seg % 59);
        } else {
            this.set(13, seg);
        }
    }

    public void sub(int dias) {
        boolean ahead = false;
        if (dias < 0) {
            ahead = true;
        }
        int i = 0;
        while (i < dias) {
            this.addDay(ahead);
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(this.getDiaAsString()) + BARRA + this.getMesAsString() + BARRA + this.getAnoAsString();
    }

    private static boolean validaData(int dia, int mes, int ano) {
        if (dia < 1 || dia > 31) {
            return false;
        }
        if (mes < 1 || mes > 12) {
            return false;
        }
        boolean bis = false;
        if (mes == 2 && (ano % 4 == 0 && ano % 100 != 0 || ano % 400 == 0)) {
            bis = true;
        }
        switch (mes) {
            case 2: {
                if (bis && dia > 29) {
                    return false;
                }
                if (bis || dia <= 28) break;
                return false;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (dia <= 31) break;
                return false;
            }
            default: {
                if (dia <= 30) break;
                return false;
            }
        }
        return true;
    }

    public static String getDataHora() {
        String[] diasSemana = new String[]{"Domingo", "Segunda-Feira", "Ter\u00e7a-Feira", "Quarta-Feira", "Quinta-Feira", "Sexta-Feira", "S\u00e1bado"};
        String[] meses = new String[]{"Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"};
        TimeZone.getAvailableIDs();
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        String str = String.valueOf(diasSemana[calendar.get(7) - 1]) + ", " + calendar.get(5) + " de " + meses[calendar.get(2)] + " de " + calendar.get(1) + " - " + calendar.get(11) + ":" + calendar.get(12);
        return str;
    }
}

