/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing;

import br.com.bb.cdbb.util.swing.BBJBordaOval;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ComponentTitledBorder
implements Border,
MouseListener,
SwingConstants {
    int offset = 5;
    Component comp;
    JComponent container;
    Rectangle rect;
    Border border;

    public ComponentTitledBorder(Component comp, JComponent container, Border border) {
        this.comp = comp;
        this.container = container;
        this.border = border;
        container.addMouseListener(this);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets borderInsets = this.border.getBorderInsets(c);
        Insets insets = this.getBorderInsets(c);
        int temp = insets.top - borderInsets.top;
        this.border.paintBorder(c, g, x, y + temp, width, height - temp);
        Dimension size = this.comp.getPreferredSize();
        this.rect = new Rectangle(this.offset + 3, 0, size.width, size.height);
        SwingUtilities.paintComponent(g, this.comp, (Container)c, this.rect);
    }

    public Insets getBorderInsets(Component c) {
        Dimension size = this.comp.getPreferredSize();
        Insets insets = this.border.getBorderInsets(c);
        insets.top = Math.max(insets.top, size.height);
        return insets;
    }

    private void dispatchEvent(MouseEvent me) {
        if (this.rect != null && this.rect.contains(me.getX(), me.getY())) {
            Point pt = me.getPoint();
            pt.translate(-this.offset, 0);
            this.comp.setBounds(this.rect);
            this.comp.dispatchEvent(new MouseEvent(this.comp, me.getID(), me.getWhen(), me.getModifiers(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
            if (!this.comp.isValid()) {
                this.container.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseEntered(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseExited(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mousePressed(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseReleased(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public static void main(String[] args) {
        final JPanel proxyPanel = new JPanel();
        proxyPanel.add(new JLabel("Proxy Host: "));
        proxyPanel.add(new JTextField("proxy.xyz.com"));
        proxyPanel.add(new JLabel("  Proxy Port"));
        proxyPanel.add(new JTextField("8080"));
        final JCheckBox checkBox = new JCheckBox("", true);
        checkBox.setFocusPainted(false);
        ComponentTitledBorder componentBorder = new ComponentTitledBorder(checkBox, proxyPanel, BBJBordaOval.createOvalBorder("Mensagem da Aplica\u00e7\u00e3o"));
        checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean enable = checkBox.isSelected();
                Component[] comp = proxyPanel.getComponents();
                int i = 0;
                while (i < comp.length) {
                    comp[i].setEnabled(enable);
                    ++i;
                }
            }
        });
        proxyPanel.setBorder(componentBorder);
        JFrame frame = new JFrame("ComponentTitledBorder - santhosh@in.fiorano.com");
        Container contents = frame.getContentPane();
        contents.setLayout(new FlowLayout());
        contents.add(proxyPanel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

