/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.apresentacao.action.PluginActionAbstrato;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class BBJComboBox
extends JComboBox
implements KeyListener {
    private DefaultComboBoxModel model = null;
    private boolean primeiraOpcao = false;
    private PluginActionAbstrato acao;

    public BBJComboBox() {
        this.setFont(BBJEstilos.TEXTOEDITAVEL.getFont());
        this.setForeground(BBJEstilos.TEXTOEDITAVEL.getColor());
        this.setBackground(BBJEstilos.TEXTOEDITAVEL.getBackcolor());
        this.addKeyListener(this);
    }

    public void populate(Set objects, String codValue, String nameValue) {
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
        } else {
            this.model.removeAllElements();
        }
    }

    public void setCollection(Collection colecao) {
        this.setCollection(colecao, "");
    }

    public void setCollection(Collection colecao, String primeiraOpcao) {
        if (primeiraOpcao.equals("")) {
            this.setPrimeiraOpcao(false);
        } else {
            this.setPrimeiraOpcao(true);
        }
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
        } else {
            this.model = null;
            this.model = new DefaultComboBoxModel();
        }
        if (!primeiraOpcao.trim().equals("")) {
            this.model.addElement(new String(primeiraOpcao));
        }
        Iterator it = colecao.iterator();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.setModel(this.model);
        this.validate();
        this.repaint();
    }

    public Collection getCollection() {
        if (this.model == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        int pos = 0;
        if (this.isPrimeiraOpcao()) {
            pos = 1;
        }
        int i = pos;
        while (i < this.model.getSize()) {
            list.add(this.model.getElementAt(i));
            ++i;
        }
        return list;
    }

    public Object getObjetoSelecionado() {
        if (this.model == null || this.getSelectedIndex() == -1) {
            return null;
        }
        return this.model.getElementAt(this.getSelectedIndex());
    }

    public void setObjeto(Object object) {
        if (this.model != null) {
            int i = 0;
            while (i < this.model.getSize()) {
                if (this.model.getElementAt(i).toString().equals(object.toString())) {
                    this.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
    }

    public boolean isPrimeiraOpcao() {
        return this.primeiraOpcao;
    }

    public void setPrimeiraOpcao(boolean primeiraOpcao) {
        this.primeiraOpcao = primeiraOpcao;
    }

    public DefaultComboBoxModel getModel() {
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
        }
        return this.model;
    }

    public void Atualiza() {
        this.setModel(this.model);
        this.validate();
        this.repaint();
    }

    public PluginActionAbstrato getAcao() {
        return this.acao;
    }

    public void setAcao(PluginActionAbstrato acao) {
        this.acao = acao;
    }

    public void keyPressed(KeyEvent evento) {
        if (this.isDisplayable()) {
            this.setPopupVisible(true);
        }
        if (evento.getKeyCode() == 10) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            return;
        }
        int selectedIndex = this.getSelectedIndex();
        if (evento.getKeyCode() == 38) {
            --selectedIndex;
        } else if (evento.getKeyCode() == 40) {
            ++selectedIndex;
        } else if (evento.getKeyCode() == 32 && selectedIndex <= 0) {
            selectedIndex = 1;
        }
        if (selectedIndex <= 0) {
            selectedIndex = this.getModel().getElementAt(0) == null || this.getModel().getElementAt(0).toString() == null ? 1 : 0;
        }
        evento.consume();
        try {
            this.setSelectedIndex(selectedIndex);
            this.validate();
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage());
        }
    }

    public void keyReleased(KeyEvent evento) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

