/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.swing.componente.BBJCalendar;
import br.com.bb.cdbb.util.swing.componente.BBJDate;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BBJMaskDateChooser
extends JPanel
implements ActionListener,
PropertyChangeListener,
ChangeListener {
    private JButton calendarButton;
    private ImageIcon icon;
    private JPopupMenu popup;
    private BBJDate dataText;
    private boolean dateSelected;
    private BBJCalendar jcalendar;
    private boolean isInitialized = false;
    private Date lastSelectedDate;

    public BBJMaskDateChooser() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDataText(), "Center");
        this.add((Component)this.getCalendarButton(), "East");
    }

    public JButton getCalendarButton() {
        if (this.calendarButton == null) {
            this.calendarButton = new JButton(this.getIcon());
            this.calendarButton.setBackground(Color.WHITE);
            this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
            this.calendarButton.addActionListener(this);
            this.calendarButton.setFocusable(true);
            this.calendarButton.setRolloverEnabled(false);
            this.calendarButton.setCursor(Cursor.getPredefinedCursor(12));
            this.calendarButton.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.calendarButton.setMnemonic(67);
            this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
            this.calendarButton.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent evento) {
                    BBJMaskDateChooser.this.tratarEnterDoBotao(evento);
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            });
        }
        return this.calendarButton;
    }

    public void actionPerformed(ActionEvent e) {
        int x = this.calendarButton.getWidth() - (int)this.getPopup().getPreferredSize().getWidth();
        int y = this.calendarButton.getY() + this.calendarButton.getHeight();
        Calendar calendar = Calendar.getInstance();
        if (this.getDataText().getDate() != null) {
            calendar.setTime(this.getDataText().getDate());
            this.getJcalendar().setCalendar(calendar);
        }
        this.getPopup().show(this.getCalendarButton(), x, y);
        this.dateSelected = false;
    }

    public void limpar() {
        this.getDataText().clear();
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.getDataText().addFocusListener(l);
    }

    public boolean isDateSelected() {
        return this.dateSelected;
    }

    public void setDateSelected(boolean dateSelected) {
        this.dateSelected = dateSelected;
    }

    public BBJCalendar getJcalendar() {
        if (this.jcalendar == null) {
            this.jcalendar = new BBJCalendar();
            this.jcalendar.getDayChooser().addPropertyChangeListener(this);
            this.jcalendar.getDayChooser().setAlwaysFireDayProperty(false);
            this.jcalendar.setWeekOfYearVisible(false);
        }
        return this.jcalendar;
    }

    public BBJDate getDataText() {
        if (this.dataText == null) {
            this.dataText = new BBJDate();
            this.dataText.setFocusable(true);
        }
        return this.dataText;
    }

    public ImageIcon getIcon() {
        URL iconURL;
        if (this.icon == null && (iconURL = this.getClass().getResource("/images/ico_calendario.gif")) != null) {
            this.icon = new ImageIcon(iconURL);
        }
        return this.icon;
    }

    public JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu(){

                public void setVisible(boolean b) {
                    Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                    if (b || !b && BBJMaskDateChooser.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                        super.setVisible(b);
                    }
                }
            };
            this.popup.setLightWeightPopupEnabled(true);
            this.popup.add(this.getJcalendar());
        }
        return this.popup;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getDataText().addPropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day")) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            this.getDataText().setDate(this.getJcalendar().getCalendar().getTime());
            this.repaint();
            this.getDataText().requestFocus();
        } else if (evt.getPropertyName().equals("date")) {
            this.getDataText().setDate((Date)evt.getNewValue());
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.isInitialized) {
            this.firePropertyChange("date", this.lastSelectedDate, this.getDataText().getDate());
            this.lastSelectedDate = this.getDataText().getDate();
        }
    }

    public Date getDate() {
        return this.getDataText().getDate();
    }

    public void setDate(Date date) {
        this.getDataText().setDate(date);
    }

    public String getText() {
        return UtilFormatadorDeData.formatar_ddMMyyyy((Date)this.getDataText().getDate());
    }

    public void setEnabled(boolean enabled) {
        this.getDataText().setEnabled(enabled);
        this.getDataText().setFocusable(enabled);
        this.getCalendarButton().setEnabled(enabled);
    }

    public void setName(String name) {
        this.getDataText().setName(name);
    }

    public String getName() {
        return this.getDataText().getName();
    }

    public void setToolTipText(String text) {
        this.getDataText().setToolTipText(text);
    }

    public void requestFocus() {
        this.getDataText().requestFocusInWindow();
    }

    public void setVisible(boolean visivel) {
        super.setVisible(visivel);
        this.getDataText().setVisible(visivel);
    }

    private void tratarEnterDoBotao(KeyEvent evento) {
        if (evento.getKeyCode() == 10) {
            ActionEvent evt = new ActionEvent(evento.getSource(), 2008, "");
            if (this.getCalendarButton().getActionListeners() != null && this.getCalendarButton().getActionListeners().length > 0) {
                this.getCalendarButton().getActionListeners()[0].actionPerformed(evt);
            }
        }
    }
}

