/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.ColumnSorter;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJTableListener;
import br.com.bb.cdbb.util.swing.componente.IObjectTableModel;
import br.com.politec.infra.util.UtilLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJTable<T extends IObjectTableModel>
extends AbstractTableModel {
    private JTable table;
    protected List<T> dataListTabela = null;
    protected String[] columnNames = null;
    protected int[] columnSizes = null;
    protected int[] columnAlignment = null;
    private final JCheckBox checkbox = new JCheckBox();
    public TableCellRenderer renderer = null;
    private ArrayList<T> itensChecados = null;
    private ActionListener actionListener = null;
    public static final int NENHUM = 0;
    public static final int SIMPLES = 5;
    public static final int MULTIPLO = 10;
    protected boolean mousePressed = false;
    private int tiposelecao = 0;
    private int linhaselecionada = -1;
    public static final String SELECIONADO = "SELECIONADO";
    public static final String NAOSELECIONADO = "NAOSELECIONADO";
    public static final String ORDENACAO = "EVENTO_ORDENACAO";
    private int colunaordenada = -1;
    private String tipoordenacao = "ASC";
    private boolean ordenacaoAutomatica = true;
    private String[] nomeColunas;
    private boolean enabled = true;

    public String[] getNomeColunas() {
        return this.nomeColunas;
    }

    public void setNomeColunas(String[] nomeColunas) {
        this.nomeColunas = nomeColunas;
    }

    public BBJTable(String[] columnNames) {
        this(columnNames, null);
    }

    public BBJTable(String[] columnNames, int[] columnSizes) {
        this(columnNames, columnSizes, null);
    }

    public BBJTable(String[] columnNamesM, int[] columnSizesM, int[] columnAlignmentM) {
        this(columnNamesM, columnSizesM, columnAlignmentM, 0);
    }

    public BBJTable(String[] columnNamesM, int[] columnSizesM, int[] columnAlignmentM, int tiposelecao) {
        this.columnNames = columnNamesM;
        this.columnSizes = columnSizesM;
        this.columnAlignment = columnAlignmentM;
        this.tiposelecao = tiposelecao;
        this.dataListTabela = new ArrayList<T>();
    }

    public void setConfiguracoes(String[] columnNamesM, int[] columnSizesM, int[] columnAlignmentM) {
        this.columnNames = columnNamesM;
        this.columnSizes = columnSizesM;
        this.columnAlignment = columnAlignmentM;
    }

    public void setTableProps(JTable table) {
        this.table = table;
        this.checkbox.setFocusable(true);
        table.setAutoResizeMode(3);
        table.setSurrendersFocusOnKeystroke(true);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        BBJTableListener listener = new BBJTableListener();
        table.addFocusListener(listener);
        table.addKeyListener(listener);
        if (this.columnNames == null || this.columnSizes == null) {
            return;
        }
        JTableHeader header = table.getTableHeader();
        header.setDefaultRenderer(new CabecalhoRenderer());
        int total = header.getMouseListeners().length;
        int icnt = total - 1;
        while (icnt >= 0) {
            header.removeMouseListener(header.getMouseListeners()[icnt]);
            --icnt;
        }
        header.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                BBJTable.this.handleClickEvent(e);
                ((JTableHeader)e.getSource()).repaint();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                BBJTable.this.mousePressed = true;
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        TableColumn colcheck = table.getColumnModel().getColumn(0);
        int ilargura = this.getTiposelecao() == 0 ? 5 : 22;
        colcheck.setMaxWidth(ilargura);
        colcheck.setPreferredWidth(ilargura);
        colcheck.setWidth(ilargura);
        int icnt2 = 0;
        while (icnt2 < this.columnNames.length) {
            int iposic = icnt2 + 1;
            TableColumn column = table.getColumnModel().getColumn(iposic);
            if (icnt2 < this.columnSizes.length - 1) {
                column.setMaxWidth(this.columnSizes[icnt2]);
                column.setPreferredWidth(this.columnSizes[icnt2]);
                column.setWidth(this.columnSizes[icnt2]);
            }
            if (this.columnAlignment != null && icnt2 < this.columnAlignment.length) {
                LinhaRenderer tcrColumn = new LinhaRenderer();
                tcrColumn.setAlignmentX(this.columnAlignment[icnt2]);
                column.setCellRenderer(tcrColumn);
            }
            ++icnt2;
        }
        table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 || e.getClickCount() == 2) {
                    Point point = e.getPoint();
                    BBJTable.this.TrocaLinhaMarcada(point, e.getClickCount());
                }
                BBJTable.this.metodoInMouseClicked();
            }
        });
        header.updateUI();
        table.updateUI();
    }

    public void metodoInMouseClicked() {
    }

    protected void handleClickEvent(MouseEvent e) {
        if (this.mousePressed && this.isEnabled()) {
            TableColumnModel columnModel;
            int viewColumn;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            int column = tableView.convertColumnIndexToModel(viewColumn = (columnModel = tableView.getColumnModel()).getColumnIndexAtX(e.getX()));
            if (column == 0) {
                if (e.getClickCount() == 1 && this.tiposelecao == 10) {
                    boolean selected = !this.checkbox.isSelected();
                    this.checkbox.setSelected(selected);
                    this.marcaTodos(selected);
                    this.fireAction(selected ? SELECIONADO : NAOSELECIONADO);
                }
            } else {
                if (this.colunaordenada == column) {
                    this.setTipoordenacao(this.getTipoordenacao().equalsIgnoreCase("ASC") ? "DESC" : "ASC");
                } else {
                    this.colunaordenada = column;
                }
                if (this.isOrdenacaoAutomatica()) {
                    IObjectTableModel objetoSelecionado = null;
                    if (this.linhaselecionada != -1 && ((IObjectTableModel)this.dataListTabela.get(this.linhaselecionada)).isMarcado()) {
                        objetoSelecionado = (IObjectTableModel)this.dataListTabela.get(this.linhaselecionada);
                        this.zerarSelecao();
                    }
                    this.executarOrdenacao();
                    if (objetoSelecionado != null) {
                        List<T> listaTabela = this.getDataListTabela();
                        int icnt = 0;
                        for (IObjectTableModel objeto : listaTabela) {
                            if (objeto == objetoSelecionado) {
                                objeto.setMarcado(true);
                                this.fireTableDataChanged();
                                this.linhaselecionada = icnt;
                                this.fireAction(SELECIONADO);
                                break;
                            }
                            ++icnt;
                        }
                    }
                } else {
                    this.fireAction(ORDENACAO);
                }
            }
        }
    }

    public void executarOrdenacao() {
        if (this.getColunaordenada() == 0) {
            return;
        }
        List<T> listaTabela = this.getDataListTabela();
        Collections.sort(listaTabela, new ColumnSorter(this.getColunaordenada() - 1, this.getTipoordenacao().equalsIgnoreCase("ASC")));
        this.fireTableDataChanged();
    }

    public void marcaTodos(boolean selected) {
        int row = 0;
        while (row < this.dataListTabela.size()) {
            IObjectTableModel obj = (IObjectTableModel)this.dataListTabela.get(row);
            obj.setMarcado(selected);
            ++row;
        }
        this.checkbox.setSelected(selected);
        this.table.getTableHeader().repaint();
        this.table.updateUI();
    }

    public void focusPrimeiroCampoCheckBox() {
        if (this.getDataListTabela().size() > 0) {
            this.table.setRowSelectionInterval(0, 0);
            this.table.updateUI();
        }
    }

    public void marcaLinha() {
        int linha = this.getSelectedRow();
        if (linha >= 0) {
            IObjectTableModel obj;
            if (this.getTiposelecao() == 5 && this.linhaselecionada != linha) {
                if (this.linhaselecionada >= 0) {
                    IObjectTableModel objsel = (IObjectTableModel)this.dataListTabela.get(this.linhaselecionada);
                    objsel.setMarcado(false);
                }
                this.linhaselecionada = linha;
            }
            obj.setMarcado(!(obj = (IObjectTableModel)this.dataListTabela.get(linha)).isMarcado());
            if (this.getTiposelecao() == 5) {
                this.fireAction(obj.isMarcado() ? SELECIONADO : NAOSELECIONADO);
            } else if (this.getTiposelecao() == 10) {
                this.fireAction(this.TemObjetoSelecionado() ? SELECIONADO : NAOSELECIONADO);
            }
            this.table.updateUI();
        }
    }

    protected void TrocaLinhaMarcada(Point point, int clicks) {
        IObjectTableModel obj;
        int row = this.table.rowAtPoint(point);
        int col = this.table.columnAtPoint(point);
        if (row >= this.dataListTabela.size() || row < 0) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (col > 0 && clicks == 1) {
            return;
        }
        if (this.getTiposelecao() == 5 && this.linhaselecionada != row) {
            if (this.linhaselecionada >= 0) {
                IObjectTableModel objsel = (IObjectTableModel)this.dataListTabela.get(this.linhaselecionada);
                objsel.setMarcado(false);
            }
            this.linhaselecionada = row;
        }
        obj.setMarcado(!(obj = (IObjectTableModel)this.dataListTabela.get(row)).isMarcado());
        if (this.getTiposelecao() == 5) {
            this.fireAction(obj.isMarcado() ? SELECIONADO : NAOSELECIONADO);
        } else if (this.getTiposelecao() == 10) {
            this.fireAction(this.TemObjetoSelecionado() ? SELECIONADO : NAOSELECIONADO);
        }
        this.table.updateUI();
    }

    private boolean TemObjetoSelecionado() {
        int icnt = 0;
        while (icnt < this.dataListTabela.size()) {
            if (((IObjectTableModel)this.dataListTabela.get(icnt)).isMarcado()) {
                return true;
            }
            ++icnt;
        }
        return false;
    }

    public void excluiObjetoSelecionado() {
        this.excluiObjeto(this.getObjetoSelecionado());
    }

    public void excluiObjeto(T posicao) {
        this.dataListTabela.remove(posicao);
    }

    public T getObjetoSelecionado() {
        if (this.table != null) {
            ArrayList<T> list = new ArrayList<T>();
            list.addAll(this.dataListTabela);
            int linha = this.table.getSelectedRow();
            if (linha < 0) {
                return null;
            }
            return (T)((IObjectTableModel)list.get(linha));
        }
        return null;
    }

    public int getSelectedRow() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getSelectedRow();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "";
        }
        return this.columnNames[column - 1];
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public int getRowCount() {
        if (this.dataListTabela == null) {
            return 0;
        }
        return this.dataListTabela.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length + 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            IObjectTableModel record = (IObjectTableModel)this.dataListTabela.get(row);
            if (column == 0) {
                return this.getTiposelecao() == 0 ? "" : new Boolean(record.isMarcado());
            }
            return record.getColumn(column - 1);
        }
        catch (Exception e) {
            UtilLog.getLog().debug((Throwable)e);
            return "";
        }
    }

    public List<T> getDataListTabela() {
        return this.dataListTabela;
    }

    public void setDataListTabela(List<T> dataVector) {
        this.dataListTabela = null;
        this.itensChecados = null;
        this.linhaselecionada = -1;
        this.checkbox.setSelected(false);
        this.table.getTableHeader().repaint();
        this.fireAction(NAOSELECIONADO);
        this.dataListTabela = dataVector;
        this.fireTableDataChanged();
    }

    public static IObjectTableModel getIObjectTableModel(Object o) {
        return (IObjectTableModel)o;
    }

    public ArrayList<T> getItensChecadosCheckBox() {
        return this.getItensSelecionados();
    }

    public ArrayList<T> getItensSelecionados() {
        this.itensChecados = new ArrayList();
        if (this.dataListTabela != null) {
            if (this.getTiposelecao() == 10) {
                int icnt = 0;
                while (icnt < this.dataListTabela.size()) {
                    if (((IObjectTableModel)this.dataListTabela.get(icnt)).isMarcado()) {
                        this.itensChecados.add((IObjectTableModel)this.dataListTabela.get(icnt));
                    }
                    ++icnt;
                }
            } else if (this.linhaselecionada >= 0 && ((IObjectTableModel)this.dataListTabela.get(this.linhaselecionada)).isMarcado()) {
                this.itensChecados.add((IObjectTableModel)this.dataListTabela.get(this.linhaselecionada));
            }
        }
        return this.itensChecados;
    }

    public T getObjetoMarcado() {
        if (this.linhaselecionada >= 0 && ((IObjectTableModel)this.dataListTabela.get(this.linhaselecionada)).isMarcado()) {
            return (T)((IObjectTableModel)this.dataListTabela.get(this.linhaselecionada));
        }
        return null;
    }

    public int getTiposelecao() {
        return this.tiposelecao;
    }

    public void setTiposelecao(int tiposelecao) {
        this.tiposelecao = tiposelecao;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = listener;
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 2008, command);
        this.fireAction(evt);
    }

    public void fireAction(ActionEvent event) {
        if (this.actionListener != null && event != null) {
            this.actionListener.actionPerformed(event);
        }
    }

    public int getColunaordenada() {
        return this.colunaordenada;
    }

    public void setColunaordenada(int colunaordenada) {
        this.colunaordenada = colunaordenada;
    }

    public String getTipoordenacao() {
        return this.tipoordenacao;
    }

    public void setTipoordenacao(String tipoordenacao) {
        this.tipoordenacao = tipoordenacao;
    }

    public boolean isOrdenacaoAutomatica() {
        return this.ordenacaoAutomatica;
    }

    public void setOrdenacaoAutomatica(boolean ordenacaoAutomatica) {
        this.ordenacaoAutomatica = ordenacaoAutomatica;
    }

    public String getNomeColunaOrdenada() {
        String[] colunas = this.getNomeColunas();
        String nomeColuna = null;
        if (colunas != null && this.getColunaordenada() <= colunas.length && this.getColunaordenada() > 0) {
            nomeColuna = this.getNomeColunas()[this.getColunaordenada() - 1];
        }
        return nomeColuna;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void zerarSelecao() {
        this.linhaselecionada = -1;
        this.fireAction(NAOSELECIONADO);
    }

    private class CabecalhoRenderer
    extends DefaultTableCellRenderer {
        CabecalhoRenderer(Integer colunacheck) {
            this.setBackground(BBJEstilos.TABELATITULO.getColor());
        }

        CabecalhoRenderer() {
            this.setBackground(BBJEstilos.TABELATITULO.getColor());
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JPanelHeader panelHeader = new JPanelHeader(column, column > 0 && BBJTable.this.columnNames != null && BBJTable.this.columnNames.length > 1 ? BBJTable.this.columnNames[column - 1] : "");
            panelHeader.setForeground(BBJEstilos.TABELATITULO.getColor());
            panelHeader.setBackground(BBJEstilos.TABELATITULO.getBackcolor());
            panelHeader.setFont(BBJEstilos.TABELATITULO.getFont());
            panelHeader.setPreferredSize(new Dimension(100, 20));
            JComponentTableCellRenderer rendererF = new JComponentTableCellRenderer();
            TableColumnModel columnModel = table.getColumnModel();
            TableColumn tbcolumn = columnModel.getColumn(column);
            tbcolumn.setHeaderRenderer(rendererF);
            if (column == 0) {
                if (BBJTable.this.getTiposelecao() == 10) {
                    panelHeader.setAlignment(1);
                    BBJTable.this.checkbox.setOpaque(false);
                    panelHeader.add(BBJTable.this.checkbox);
                }
            } else {
                panelHeader.setAlignment(BBJTable.this.columnAlignment[column - 1]);
                if (column < BBJTable.this.columnSizes.length) {
                    tbcolumn.setMaxWidth(BBJTable.this.columnSizes[column - 1]);
                }
                tbcolumn.setPreferredWidth(BBJTable.this.columnSizes[column - 1]);
                tbcolumn.setWidth(BBJTable.this.columnSizes[column - 1]);
            }
            tbcolumn.setHeaderValue(panelHeader);
            return this;
        }
    }

    class JComponentTableCellRenderer
    implements TableCellRenderer {
        JComponentTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }

    private class JPanelHeader
    extends JPanel {
        private ImageIcon imgIconeDescendente = null;
        private ImageIcon imgIconeAscendente = null;
        private int coluna = 0;
        private String texto = "";
        private int alignment = 0;

        public JPanelHeader(int coluna, String texto) {
            this.coluna = coluna;
            this.texto = texto;
            this.setLayout(new BoxLayout(this, 0));
            this.imgIconeDescendente = this.getImageIcon("/images/Seta_abaixo.jpg");
            this.imgIconeAscendente = this.getImageIcon("/images/Seta_acima.jpg");
        }

        public void paint(Graphics g) {
            super.paint(g);
            int posicx = 2;
            if (this.getColuna() == BBJTable.this.getColunaordenada()) {
                ImageIcon icone = BBJTable.this.getTipoordenacao().equalsIgnoreCase("ASC") ? this.imgIconeAscendente : this.imgIconeDescendente;
                g.drawImage(icone.getImage(), 0, BBJTable.this.getTipoordenacao().equalsIgnoreCase("ASC") ? 6 : 8, null, null);
                posicx = 13;
            }
            g.setColor(BBJEstilos.TABELATITULO.getColor());
            g.setFont(BBJEstilos.TABELATITULO.getFont());
            switch (this.getAlignment()) {
                case 0: {
                    posicx = ((int)this.getSize().getWidth() - this.getLarguraTexto(g) - 5) / 2;
                    break;
                }
                case 4: {
                    posicx = (int)this.getSize().getWidth() - this.getLarguraTexto(g) - 5;
                }
            }
            g.drawString(this.getTexto(), posicx, 15);
        }

        private int getLarguraTexto(Graphics g) {
            Rectangle2D textBounds = this.getFontMetrics(BBJEstilos.TABELATITULO.getFont()).getStringBounds(this.getTexto(), g);
            return (int)textBounds.getWidth();
        }

        public int getColuna() {
            return this.coluna;
        }

        public void setColuna(int coluna) {
            this.coluna = coluna;
        }

        private ImageIcon getImageIcon(String image) {
            if (image == null || image.trim().length() == 0) {
                return null;
            }
            return new ImageIcon(this.getClass().getResource(image));
        }

        public String getTexto() {
            return this.texto;
        }

        public void setTexto(String texto) {
            this.texto = texto;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int alignment) {
            this.alignment = alignment;
        }
    }

    private class LinhaRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        public final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

        private LinhaRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)renderer).setOpaque(true);
            ((JLabel)renderer).setFont(BBJEstilos.TABELALINHAPAR.getFont());
            Color foreground = null;
            Color background = null;
            if (row % 2 == 0) {
                foreground = BBJEstilos.TABELALINHAPAR.getColor();
                background = BBJEstilos.TABELALINHAPAR.getBackcolor();
            } else if (row % 2 != 0) {
                foreground = BBJEstilos.TABELALINHAIMPAR.getColor();
                background = BBJEstilos.TABELALINHAIMPAR.getBackcolor();
            }
            if (column == 0) {
                ((JLabel)renderer).setHorizontalAlignment(0);
            } else {
                ((JLabel)renderer).setHorizontalAlignment(BBJTable.this.columnAlignment[column - 1]);
                renderer.setForeground(foreground);
                renderer.setBackground(background);
                renderer.setFont(BBJEstilos.TABELALINHAPAR.getFont());
            }
            return renderer;
        }
    }
}

