/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.swing.componente.BBJMask;
import br.com.bb.cdbb.util.swing.componente.Mask;
import br.com.bb.cdbb.util.swing.componente.Permissao;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.InvalidObjectException;

public class MaskContainer {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private static final char WRITED = '#';
    protected static final char SPACE = ' ';
    private int align;
    private String text_;
    private String delimiters_;
    private Mask[] mask_;
    private StringBuffer writtenMask_;
    private int posicao_inicio;
    private int posicao_fim;
    private int countSemDelimitador_ = -1;

    public MaskContainer(Mask[] mask, int inicio, int fim) {
        this.delimiters_ = this.createDelimiters(mask);
        this.mask_ = mask;
        this.text_ = this.clearFormat(mask);
        this.writtenMask_ = new StringBuffer(this.getText());
        this.posicao_inicio = inicio;
        this.posicao_fim = fim;
    }

    public void clean() {
        this.text_ = this.clearFormat(this.mask_);
        this.writtenMask_ = new StringBuffer(this.getText());
    }

    protected void cleanMaskedText(int caretPos) {
        int align = this.getHorizontalAlignment();
        this.cleanWrittenMask(align);
        this.text_ = align == 0 ? this.removeStringLeft(caretPos) : this.removeStringRight(caretPos);
    }

    private void cleanWrittenMask(int align) {
        if (align == 0) {
            char c;
            int off = this.writtenMask_.length() - 1;
            while ((c = this.writtenMask_.charAt(off)) != '#' || this.isDelimiter(c)) {
                --off;
            }
            if (off >= 0) {
                this.writtenMask_.setCharAt(off, ' ');
            }
        } else {
            char c;
            int off = 0;
            while ((c = this.writtenMask_.charAt(off)) != '#' || this.isDelimiter(c)) {
                ++off;
            }
            if (off < this.writtenMask_.length()) {
                this.writtenMask_.setCharAt(off, ' ');
            }
        }
    }

    private String clearFormat(Mask[] format) {
        String s = "";
        int tam = format.length;
        int i = 0;
        while (i < tam) {
            s = !format[i].isDelimiter() ? String.valueOf(s) + ' ' : String.valueOf(s) + format[i].getChar();
            ++i;
        }
        return s;
    }

    protected int computeSpace() {
        String s = this.writtenMask_.toString();
        int count = 0;
        int ind = s.indexOf(32);
        while (ind != -1) {
            ++count;
            ind = s.indexOf(32, ind + 1);
        }
        return count;
    }

    private boolean conferirMascara(String text) {
        int tam = text.length();
        int i = 0;
        while (i < tam) {
            if (text.charAt(i) != ' ' && !this.getMaskAt(i).isPermitted(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int converter(int pos) {
        return pos - this.posicao_inicio;
    }

    private String convertStringLeft(int off, char str) {
        char[] texto = this.getText().toCharArray();
        int offMask = off;
        String s = this.getText().substring(0, off);
        Mask[] mask = this.getMask();
        while (offMask < mask.length && mask[offMask].isDelimiter()) {
            s = String.valueOf(s) + mask[offMask++].getChar();
        }
        s = String.valueOf(s) + str;
        ++offMask;
        while (s.length() < mask.length) {
            if (offMask < mask.length && mask[offMask].isDelimiter()) {
                s = String.valueOf(s) + mask[offMask++].getChar();
                continue;
            }
            if (!this.isDelimiter(texto[off])) {
                s = String.valueOf(s) + texto[off];
                ++offMask;
            }
            ++off;
        }
        return s;
    }

    private String convertStringRight(int off, char str) {
        char[] texto = this.getText().toCharArray();
        Mask[] mask = this.getMask();
        int offMask = off - 1;
        String s = this.getText().substring(off, texto.length);
        while (offMask >= 0 && mask[offMask].isDelimiter()) {
            s = String.valueOf(mask[offMask--].getChar()) + s;
        }
        s = String.valueOf(str) + s;
        --offMask;
        --off;
        while (s.length() < mask.length) {
            if (offMask >= 0 && mask[offMask].isDelimiter()) {
                s = String.valueOf(mask[offMask--].getChar()) + s;
                continue;
            }
            if (!this.isDelimiter(texto[off])) {
                s = String.valueOf(texto[off]) + s;
                --offMask;
            }
            --off;
        }
        return s;
    }

    public int count() {
        return this.mask_.length;
    }

    public int countSemDelimitador() {
        if (this.countSemDelimitador_ == -1) {
            this.countSemDelimitador_ = 0;
            int i = this.count() - 1;
            while (i >= 0) {
                if (!this.getMaskAt(i).isDelimiter()) {
                    ++this.countSemDelimitador_;
                }
                --i;
            }
        }
        return this.countSemDelimitador_;
    }

    public String createDelimiters(Mask[] mask) {
        String s = "";
        int tam = mask.length;
        int i = 0;
        while (i < tam) {
            if (mask[i].isDelimiter()) {
                s = String.valueOf(s) + mask[i].getChar();
            }
            ++i;
        }
        return s;
    }

    public boolean estaNoIntervalo(int pos) {
        return pos >= this.posicao_inicio && pos <= this.posicao_fim;
    }

    public String getData() {
        String s = this.getText();
        String nova = "";
        int tam = s.length();
        int i = 0;
        while (i < tam) {
            if (!this.isDelimiter(s.charAt(i))) {
                nova = String.valueOf(nova) + s.charAt(i);
            }
            ++i;
        }
        return nova;
    }

    public String getDelimiters() {
        return this.delimiters_;
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    public Mask[] getMask() {
        return this.mask_;
    }

    public Mask getMaskAt(int i) {
        if (this.getMask() == null || i >= this.getMask().length) {
            return new Mask();
        }
        return this.getMask()[i];
    }

    public int getPosicaoFim() {
        return this.posicao_fim;
    }

    public int getPosicaoInicio() {
        return this.posicao_inicio;
    }

    public String getText() {
        return this.text_;
    }

    private boolean isDelimiter(char c) {
        return this.delimiters_.indexOf(c) != -1;
    }

    public boolean isPermitted(int caretPos, char c) {
        if (this.align == 1 && caretPos > 0) {
            --caretPos;
        }
        return this.getMaskAt(caretPos).isPermitted(c);
    }

    public boolean isWritten(int posicao) {
        if (this.estaNoIntervalo(posicao)) {
            posicao = this.converter(posicao);
        }
        if (this.writtenMask_.length() <= posicao) {
            return false;
        }
        return this.writtenMask_.charAt(posicao) == '#';
    }

    protected int lastPositionWritten() {
        String s = this.writtenMask_.toString();
        if (this.getHorizontalAlignment() == 0) {
            int i = s.length() - 1;
            while (i >= 0) {
                if (s.charAt(i) == '#') {
                    return i;
                }
                --i;
            }
            return 0;
        }
        int i = s.length() - 1;
        while (i >= 0) {
            if (s.charAt(i) == ' ') {
                return i;
            }
            --i;
        }
        return -1;
    }

    private String removeStringLeft(int off) {
        char[] texto = this.getText().toCharArray();
        int offMask = off;
        String s = this.getText().substring(0, off);
        Mask[] mask = this.getMask();
        while (offMask < mask.length && mask[offMask].isDelimiter()) {
            s = String.valueOf(s) + mask[offMask++].getChar();
        }
        ++off;
        while (s.length() < mask.length) {
            if (offMask < mask.length && mask[offMask].isDelimiter()) {
                s = String.valueOf(s) + mask[offMask++].getChar();
                continue;
            }
            if (off < texto.length) {
                if (!this.isDelimiter(texto[off])) {
                    s = String.valueOf(s) + texto[off];
                    ++offMask;
                }
            } else {
                s = String.valueOf(s) + ' ';
                ++offMask;
            }
            ++off;
        }
        return s;
    }

    private String removeStringRight(int off) {
        char[] texto = this.getText().toCharArray();
        Mask[] mask = this.getMask();
        int offMask = off;
        String s = this.getText().substring(off + 1, texto.length);
        while (offMask >= 0 && mask[offMask].isDelimiter()) {
            s = String.valueOf(mask[offMask--].getChar()) + s;
        }
        --off;
        while (s.length() < mask.length) {
            if (offMask >= 0 && mask[offMask].isDelimiter()) {
                s = String.valueOf(mask[offMask--].getChar()) + s;
                continue;
            }
            if (off >= 0) {
                if (!this.isDelimiter(texto[off])) {
                    s = String.valueOf(texto[off]) + s;
                    --offMask;
                }
            } else {
                s = String.valueOf(' ') + s;
            }
            --off;
        }
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setData(String s) throws InvalidObjectException {
        if (s == null) throw new InvalidObjectException("String n\u00e3o aceita.");
        String nova = "";
        Mask[] mask = this.getMask();
        int ind = 0;
        if (this.getHorizontalAlignment() == 0) {
            int i = 0;
            while (i < mask.length) {
                if (ind < s.length()) {
                    if (!mask[i].isDelimiter()) {
                        if (!mask[i].isPermitted(s.charAt(ind))) throw new InvalidObjectException("String n\u00e3o aceita.");
                        this.setWrittenMask(this.getHorizontalAlignment(), i);
                        nova = String.valueOf(nova) + s.charAt(ind++);
                    } else {
                        nova = String.valueOf(nova) + mask[i].getChar();
                    }
                } else {
                    nova = !mask[i].isDelimiter() ? String.valueOf(nova) + ' ' : String.valueOf(nova) + mask[i].getChar();
                }
                ++i;
            }
        } else {
            ind = s.length() - 1;
            int i = mask.length - 1;
            while (i >= 0) {
                if (ind >= 0) {
                    if (!mask[i].isDelimiter()) {
                        if (!mask[i].isPermitted(s.charAt(ind))) throw new InvalidObjectException("String n\u00e3o aceita.");
                        this.setWrittenMask(this.getHorizontalAlignment(), i + 1);
                        nova = String.valueOf(s.charAt(ind--)) + nova;
                    } else {
                        nova = String.valueOf(mask[i].getChar()) + nova;
                    }
                } else {
                    nova = !mask[i].isDelimiter() ? String.valueOf(' ') + nova : String.valueOf(mask[i].getChar()) + nova;
                }
                --i;
            }
        }
        this.text_ = nova;
    }

    public void setHorizontalAlignment(int align) {
        this.align = align;
    }

    private int setMaskedText(int caretPos, char c) {
        String newText;
        int align = this.getHorizontalAlignment();
        this.setWrittenMask(align, caretPos);
        int caretPosAntigo = caretPos;
        if (align == 1) {
            newText = this.convertStringRight(caretPos, c);
        } else {
            newText = this.convertStringLeft(caretPos, c);
            ++caretPos;
            while (caretPos < this.text_.length() && this.isDelimiter(this.text_.charAt(caretPos))) {
                ++caretPos;
            }
        }
        if (!this.conferirMascara(newText)) {
            this.cleanWrittenMask(align);
            return caretPosAntigo;
        }
        this.text_ = newText;
        return caretPos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setText(String s) throws InvalidObjectException {
        if (s == null) throw new InvalidObjectException("String n\u00e3o aceita.");
        String nova = "";
        Mask[] mask = this.getMask();
        int ind = 0;
        if (this.getHorizontalAlignment() == 0) {
            int i = 0;
            while (i < mask.length) {
                if (ind < s.length()) {
                    if (!mask[i].isDelimiter()) {
                        if (!mask[i].isPermitted(s.charAt(ind))) throw new InvalidObjectException("String n\u00e3o aceita.");
                        this.setWrittenMask(this.getHorizontalAlignment(), i);
                        nova = String.valueOf(nova) + s.charAt(ind++);
                    } else {
                        if (mask[i].getChar() != s.charAt(ind)) throw new InvalidObjectException("String n\u00e3o aceita.Delimitador diferente da m\u00e1scara.");
                        nova = String.valueOf(nova) + s.charAt(ind++);
                    }
                } else {
                    nova = !mask[i].isDelimiter() ? String.valueOf(nova) + ' ' : String.valueOf(nova) + mask[i].getChar();
                }
                ++i;
            }
        } else {
            ind = s.length() - 1;
            int i = mask.length - 1;
            while (i >= 0) {
                if (ind >= 0) {
                    if (!mask[i].isDelimiter()) {
                        if (!mask[i].isPermitted(s.charAt(ind))) throw new InvalidObjectException("String n\u00e3o aceita.");
                        this.setWrittenMask(this.getHorizontalAlignment(), i + 1);
                        nova = String.valueOf(s.charAt(ind--)) + nova;
                    } else {
                        if (mask[i].getChar() != s.charAt(ind)) throw new InvalidObjectException("String n\u00e3o aceita.Delimitador diferente da m\u00e1scara.");
                        nova = String.valueOf(s.charAt(ind--)) + nova;
                    }
                } else {
                    nova = !mask[i].isDelimiter() ? String.valueOf(' ') + nova : String.valueOf(mask[i].getChar()) + nova;
                }
                --i;
            }
        }
        this.text_ = nova;
    }

    private void setWrittenMask(int align, int off) {
        if (align == 0) {
            char c;
            while (off < this.writtenMask_.length() && ((c = this.writtenMask_.charAt(off)) == '#' || this.isDelimiter(c))) {
                ++off;
            }
            if (off < this.writtenMask_.length()) {
                this.writtenMask_.setCharAt(off, '#');
            }
        } else {
            char c;
            --off;
            while (off >= 0 && ((c = this.writtenMask_.charAt(off)) == '#' || this.isDelimiter(c))) {
                --off;
            }
            if (off >= 0) {
                this.writtenMask_.setCharAt(off, '#');
            }
        }
    }

    public int tratarKeyPressed(int caretPos, KeyEvent evt) {
        caretPos -= this.getPosicaoInicio();
        char[] text = this.getText().toCharArray();
        int align = this.getHorizontalAlignment();
        switch (evt.getKeyCode()) {
            case 39: {
                char c;
                if (caretPos >= this.writtenMask_.length() || (c = this.writtenMask_.charAt(caretPos)) != '#' && !this.isDelimiter(c)) break;
                ++caretPos;
                break;
            }
            case 37: {
                char c;
                if (caretPos <= 0 || (c = this.writtenMask_.charAt(caretPos - 1)) != '#' && !this.isDelimiter(c)) break;
                --caretPos;
                break;
            }
            case 127: {
                int off = caretPos;
                while (off < this.writtenMask_.length() && this.isDelimiter(this.writtenMask_.charAt(off))) {
                    ++off;
                }
                if (off < this.writtenMask_.length() && this.writtenMask_.charAt(off) == '#') {
                    this.cleanMaskedText(off);
                }
                if (align != 1 || off >= this.writtenMask_.length()) break;
                caretPos = off + 1;
                break;
            }
            case 8: {
                int off = caretPos - 1;
                while (off >= 0 && this.isDelimiter(this.writtenMask_.charAt(off))) {
                    --off;
                }
                if (off >= 0 && this.writtenMask_.charAt(off) == '#') {
                    this.cleanMaskedText(off);
                }
                if (align != 0) break;
                if (off >= 0) {
                    caretPos = off;
                    break;
                }
                caretPos = 0;
                break;
            }
            case 36: {
                if (align == 0) {
                    caretPos = 0;
                    break;
                }
                caretPos = this.lastPositionWritten() + 1;
                break;
            }
            case 35: {
                if (align == 1) {
                    caretPos = this.writtenMask_.length();
                    break;
                }
                caretPos = this.lastPositionWritten() + 1;
                break;
            }
            default: {
                char car = evt.getKeyChar();
                if (this.computeSpace() <= 0 || align == 0 && caretPos > text.length || align == 1 && caretPos <= 0) break;
                BBJMask origem = (BBJMask)evt.getSource();
                if (this.isPermitted(caretPos, car)) {
                    if (origem instanceof Permissao) {
                        if (((Permissao)((Object)origem)).isPermitted(caretPos + this.getPosicaoInicio(), car)) {
                            caretPos = this.setMaskedText(caretPos, car);
                            break;
                        }
                        if (!origem.isBeepOnError()) break;
                        Toolkit.getDefaultToolkit().beep();
                        break;
                    }
                    caretPos = this.setMaskedText(caretPos, car);
                    break;
                }
                if (!origem.isBeepOnError()) break;
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return caretPos + this.getPosicaoInicio();
    }
}

