/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.menu;

import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJAbaServico
extends JButton
implements FocusListener,
KeyListener {
    public String texto;
    public String viewName;
    public boolean ativado = false;
    public Font fonteDesativado = BBJEstilos.TEXTOABAINATIVO.getFont();
    public Font fonteAtivado = BBJEstilos.TEXTOABAATIVO.getFont();
    public ImageIcon iconeInativoEsq = null;
    public ImageIcon iconeInativoDireito = null;
    public ImageIcon iconeAtivoEsq = null;
    public ImageIcon iconeAtivoDireito = null;
    public ImageIcon iconeInativoTabMeio = null;
    public ImageIcon iconeAtivoTabMeio = null;
    private Map<String, BBJAbaServico> children;
    public static final int BOTAOARREDONDADO = 1;
    public static final int BOTAOLISO = 2;
    private int tipobotao = 1;
    private String codigoAuditoria;
    private String indicadorEstado;
    private boolean focoNoObjeto = false;
    private ActionListener actionListener = null;
    private FocusListener focusListener = null;

    public BBJAbaServico() {
        this("", false);
    }

    public BBJAbaServico(String texto) {
        this(texto, false);
    }

    public BBJAbaServico(String texto, boolean ativado) {
        this.texto = texto;
        this.ativado = ativado;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(null);
        this.setTexto(this.texto);
        this.setSize();
        this.setBackground(Color.WHITE);
        this.setRolloverEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.setVisible(true);
        this.setFocusable(true);
        this.iconeInativoEsq = new ImageIcon(this.getClass().getResource("/images/img_tab_esq.gif"));
        this.iconeInativoDireito = new ImageIcon(this.getClass().getResource("/images/img_tab_dir.gif"));
        this.iconeAtivoEsq = new ImageIcon(this.getClass().getResource("/images/img_tab_sel_esq.gif"));
        this.iconeAtivoDireito = new ImageIcon(this.getClass().getResource("/images/img_tab_sel_dir.gif"));
        this.iconeInativoTabMeio = new ImageIcon(this.getClass().getResource("/images/img_tab_meio.gif"));
        this.iconeAtivoTabMeio = new ImageIcon(this.getClass().getResource("/images/img_tab_sel_meio.gif"));
    }

    public boolean isAtivado() {
        return this.ativado;
    }

    public void setAtivado(boolean ativado) {
        this.ativado = ativado;
        this.setSize();
    }

    public void setSize() {
        super.setText(this.texto);
        this.setFont(this.ativado ? this.fonteAtivado : this.fonteDesativado);
        this.setMaximumSize(new Dimension(this.getTextWidth() + 20, 33));
        this.setPreferredSize(new Dimension(this.getTextWidth() + 20, 33));
    }

    private int getTextWidth() {
        FontRenderContext frc = new FontRenderContext(null, true, false);
        Rectangle2D bounds = this.getFont().getStringBounds(this.texto, frc);
        return (int)bounds.getWidth();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.setFont(this.ativado ? this.fonteAtivado : this.fonteDesativado);
        int itop = this.ativado ? 0 : 5;
        g.setColor(BBJEstilos.TEXTOABAATIVO.getBackcolor());
        int posicx = (int)((this.getSize().getWidth() - (double)this.getTextWidth()) / 2.0);
        int posicy = 22;
        if (this.getTipobotao() == 1) {
            ImageIcon imgAbaEsq = this.ativado ? this.iconeAtivoEsq : this.iconeInativoEsq;
            ImageIcon imgAbaDir = this.ativado ? this.iconeAtivoDireito : this.iconeInativoDireito;
            ImageIcon iconeFundo = this.ativado ? this.iconeAtivoTabMeio : this.iconeInativoTabMeio;
            g.drawImage(imgAbaEsq.getImage(), 0, itop, null);
            g.drawImage(imgAbaDir.getImage(), this.getSize().width - imgAbaDir.getIconWidth(), itop, null, null);
            int icnt = imgAbaEsq.getIconWidth();
            while (icnt < this.getSize().width - imgAbaDir.getIconWidth()) {
                g.drawImage(iconeFundo.getImage(), icnt, itop, null, null);
                icnt += iconeFundo.getIconWidth();
            }
            g.fillRect(imgAbaEsq.getIconWidth(), itop, (int)this.getSize().getWidth() - (imgAbaEsq.getIconWidth() + imgAbaDir.getIconWidth()), 1);
            g.setColor(this.isEnabled() ? (this.focoNoObjeto ? new Color(32, 71, 164) : BBJEstilos.TEXTOABAATIVO.getColor()) : Color.LIGHT_GRAY);
            g.drawString(this.texto, posicx, posicy);
        }
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public Map<String, BBJAbaServico> getChildren() {
        return this.children;
    }

    public void setChildren(Map<String, BBJAbaServico> children) {
        this.children = children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public int getTipobotao() {
        return this.tipobotao;
    }

    public void setTipobotao(int tipobotao) {
        this.tipobotao = tipobotao;
    }

    public String getCodigoAuditoria() {
        return this.codigoAuditoria;
    }

    public void setCodigoAuditoria(String codigoAuditoria) {
        this.codigoAuditoria = codigoAuditoria;
    }

    public String getIndicadorEstado() {
        return this.indicadorEstado;
    }

    public void setIndicadorEstado(String indicadorEstado) {
        this.indicadorEstado = indicadorEstado;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.focoNoObjeto = true;
        this.setSize();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.focoNoObjeto = false;
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent evento) {
        if (evento.getKeyCode() == 10) {
            ActionEvent evt = new ActionEvent(evento.getSource(), 2008, "");
            if (this.getActionListeners() != null && this.getActionListeners().length > 0) {
                this.getActionListeners()[0].actionPerformed(evt);
            }
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        if (this.actionListener == null) {
            this.actionListener = actionListener;
            super.addActionListener(actionListener);
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        if (this.focusListener == null) {
            this.focusListener = focusListener;
            super.addFocusListener(focusListener);
        }
    }

    @Override
    public void keyReleased(KeyEvent evento) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

