/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.menu;

import br.com.bb.cdbb.apresentacao.action.PluginActionAbstrato;
import br.com.bb.cdbb.util.swing.IAcao;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class BBJBasicButton
extends JButton
implements IAcao,
KeyListener,
FocusListener {
    private String texto;
    private String viewName;
    private String icone;
    private String iconeativo;
    private String abaesquerda;
    private String abadireita;
    private String abaesquerdainativo;
    private String abadireitainativo;
    private boolean bordertop = false;
    private boolean borderbottom = true;
    private Font fonte;
    private BBJEstilos estilo;
    private int altura = 29;
    private int alturatexto = 6;
    private int tamanhotexto = 30;
    private int offset = 45;
    private int bottomline = 2;
    private boolean ativar = false;
    private boolean centralizartexto = false;
    private ImageIcon imgAbaEsq = null;
    private ImageIcon imgAbaDir = null;
    private ImageIcon imgAbaEsqInativo = null;
    private ImageIcon imgAbaDirInativo = null;
    private ImageIcon imgIcone = null;
    private ImageIcon imgIconeAtivo = null;
    private ImageIcon iconeFundo = null;
    private ImageIcon iconeFundoInativo = null;
    private PluginActionAbstrato acao;
    private boolean focoNoObjeto = false;

    public BBJBasicButton() {
    }

    public BBJBasicButton(String texto) {
        this(texto, "", "/images/btIniTrs.gif", "/images/btEndTrs.gif", BBJEstilos.TEXTOBOTAO, 17, 26, true, true);
        this.setBottomline(1);
        this.centralizartexto = true;
    }

    public BBJBasicButton(String texto, String icone, String abaesquerda, String abadireita, BBJEstilos estilo, int altura, int offset) {
        this(texto, icone, abaesquerda, abadireita, estilo, altura, offset, false, true);
    }

    public BBJBasicButton(String texto, String icone, String abaesquerda, String abadireita, BBJEstilos estilo, int altura, int offset, boolean bordertop, boolean borderbottom) {
        this(texto, icone, abaesquerda, abadireita, estilo, altura, offset, bordertop, borderbottom, "", "");
    }

    public BBJBasicButton(String texto, String icone, String abaesquerda, String abadireita, BBJEstilos estilo, int altura, int offset, boolean bordertop, boolean borderbottom, String abaesquerdainativo, String abadireitainativo) {
        this(texto, icone, abaesquerda, abadireita, estilo, altura, offset, bordertop, borderbottom, abaesquerdainativo, abadireitainativo, "");
    }

    public BBJBasicButton(String texto, String icone, String abaesquerda, String abadireita, BBJEstilos estilo, int altura, int offset, boolean bordertop, boolean borderbottom, String abaesquerdainativo, String abadireitainativo, String iconeativo) {
        this.texto = texto;
        this.icone = icone;
        this.abaesquerda = abaesquerda;
        this.abadireita = abadireita;
        this.bordertop = bordertop;
        this.borderbottom = borderbottom;
        this.estilo = estilo;
        this.altura = altura;
        this.offset = offset;
        this.iconeativo = iconeativo;
        this.abaesquerdainativo = abaesquerdainativo;
        this.abadireitainativo = abadireitainativo;
        this.imgAbaEsq = this.getImageIcon(this.abaesquerda);
        this.imgAbaDir = this.getImageIcon(this.abadireita);
        this.imgAbaEsqInativo = this.getImageIcon(this.abaesquerdainativo);
        this.imgAbaDirInativo = this.getImageIcon(this.abadireitainativo);
        this.imgIcone = this.getImageIcon(this.icone);
        this.imgIconeAtivo = this.getImageIcon(this.iconeativo);
        this.Initialize();
    }

    private void Initialize() {
        this.setFocusable(true);
        this.setVisible(true);
        this.setBackground(this.estilo.getBackcolor());
        this.setForeground(this.estilo.getColor());
        this.setRolloverEnabled(false);
        this.setAlignmentX(8.0f);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBorder(null);
        this.setFont(this.estilo.getFont());
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setSize();
        this.setFocusPainted(true);
        this.setEnabled(true);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void setSize(Dimension dim) {
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
    }

    public void setSize() {
        this.setSize(new Dimension(this.getTextoWidth(), this.altura));
    }

    public int getTextoWidth() {
        FontRenderContext frc = new FontRenderContext(null, true, false);
        String s_texto = "textobotao";
        if (this.texto != null && this.texto.length() > 0) {
            s_texto = this.texto;
        }
        Rectangle2D bounds = this.getFont().getStringBounds(s_texto, frc);
        this.alturatexto = (int)bounds.getHeight();
        this.tamanhotexto = (int)bounds.getWidth();
        return this.tamanhotexto + this.offset;
    }

    public void paint(Graphics g) {
        int i_tamedir;
        ImageIcon imgIco;
        ImageIcon abadir;
        super.paint(g);
        int posicx = 12;
        int posicy = 0;
        if (this.iconeFundo != null) {
            int icnt = this.imgAbaEsq.getIconWidth();
            while (icnt < this.getSize().width - this.imgAbaDir.getIconWidth()) {
                g.drawImage(this.iconeFundo.getImage(), icnt, -1, null, null);
                icnt += this.iconeFundo.getIconWidth();
            }
        }
        ImageIcon abaesq = this.ativar ? this.imgAbaEsqInativo : this.imgAbaEsq;
        ImageIcon imageIcon = abadir = this.ativar ? this.imgAbaDirInativo : this.imgAbaDir;
        if (abaesq != null && abaesq.getIconHeight() > 0) {
            g.drawImage(abaesq.getImage(), 0, 0, null, null);
        }
        if (abadir != null && abadir.getIconHeight() > 0) {
            g.drawImage(abadir.getImage(), (int)(this.getSize().getWidth() - (double)abadir.getIconWidth()), 0, null, null);
        }
        ImageIcon imageIcon2 = imgIco = this.ativar ? this.imgIconeAtivo : this.imgIcone;
        if (imgIco != null && imgIco.getIconHeight() > 0) {
            posicx += imgIco.getIconWidth() + 6;
            posicy = (int)((this.getSize().getHeight() - (double)imgIco.getIconHeight()) / 2.0);
            g.drawImage(imgIco.getImage(), 12, posicy, null, null);
        }
        g.setColor(new Color(229, 229, 229));
        posicy = (int)((this.getSize().getHeight() + (double)this.alturatexto) / 2.0) - 2;
        int i_tamesq = abaesq != null ? abaesq.getIconWidth() : 0;
        int n = i_tamedir = abadir != null ? abadir.getIconWidth() : 0;
        if (this.bordertop) {
            g.fillRect(i_tamesq, 0, (int)this.getSize().getWidth() - (i_tamesq + i_tamedir), 1);
        }
        if (this.borderbottom) {
            g.fillRect(i_tamesq, (int)(this.getSize().getHeight() - (double)this.bottomline), (int)this.getSize().getWidth() - (i_tamesq + i_tamedir) + 1, this.bottomline);
        }
        if (this.centralizartexto) {
            posicx = (int)((this.getSize().getWidth() - (double)this.tamanhotexto) / 2.0);
        }
        g.setFont(this.getFont());
        g.setColor(this.isEnabled() ? (this.focoNoObjeto ? new Color(32, 71, 164) : this.estilo.getColor()) : Color.LIGHT_GRAY);
        g.drawString(this.texto, posicx, posicy);
    }

    public void setIconeFundo(ImageIcon iconeFundo) {
        this.iconeFundo = iconeFundo;
    }

    public String getAbadireita() {
        return this.abadireita;
    }

    public void setAbadireita(String abadireita) {
        this.abadireita = abadireita;
    }

    public String getAbaesquerda() {
        return this.abaesquerda;
    }

    public void setAbaesquerda(String abaesquerda) {
        this.abaesquerda = abaesquerda;
    }

    public String getIcone() {
        return this.icone;
    }

    public void setIcone(String icone) {
        this.icone = icone;
    }

    public Font getFonte() {
        return this.fonte;
    }

    public void setFonte(Font fonte) {
        this.fonte = fonte;
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    private ImageIcon getImageIcon(String image) {
        if (image == null || image.trim().length() == 0) {
            return null;
        }
        return new ImageIcon(this.getClass().getResource(image));
    }

    public boolean isBorderbottom() {
        return this.borderbottom;
    }

    public void setBorderbottom(boolean borderbottom) {
        this.borderbottom = borderbottom;
    }

    public boolean isBordertop() {
        return this.bordertop;
    }

    public void setBordertop(boolean bordertop) {
        this.bordertop = bordertop;
    }

    public boolean isAtivo() {
        return this.ativar;
    }

    public void setAtivar(boolean ativar) {
        this.ativar = ativar;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public int getBottomline() {
        return this.bottomline;
    }

    public void setBottomline(int bottomline) {
        this.bottomline = bottomline;
    }

    public boolean isCentralizartexto() {
        return this.centralizartexto;
    }

    public void setCentralizartexto(boolean centralizartexto) {
        this.centralizartexto = centralizartexto;
    }

    public PluginActionAbstrato getAcao() {
        return this.acao;
    }

    public void setAcao(PluginActionAbstrato acao) {
        this.acao = acao;
    }

    public ImageIcon getIconeFundoInativo() {
        return this.iconeFundoInativo;
    }

    public void setIconeFundoInativo(ImageIcon iconeFundoInativo) {
        this.iconeFundoInativo = iconeFundoInativo;
    }

    public void keyPressed(KeyEvent evento) {
        if (evento.getKeyCode() == 10) {
            this.clicar((Component)evento.getSource());
        }
    }

    public void clicar() {
        this.clicar(this);
    }

    public void clicar(Component componente) {
        ActionEvent evt = new ActionEvent(componente, 2008, "");
        if (this.getActionListeners() != null && this.getActionListeners().length > 0) {
            this.getActionListeners()[0].actionPerformed(evt);
        }
    }

    public void keyReleased(KeyEvent evento) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.focoNoObjeto = true;
    }

    public void focusLost(FocusEvent e) {
        this.focoNoObjeto = false;
    }
}

