/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.view;

import br.com.bb.cdbb.util.swing.BBJBordaOval;
import br.com.bb.cdbb.util.swing.componente.BBJButton;
import br.com.bb.cdbb.util.swing.componente.BBJComboBoxLabel;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJLabel;
import br.com.bb.cdbb.util.view.BBJFormPopup;
import br.com.bb.cdbb.util.view.ViewProcurarCartao;
import br.com.bb.cdbb.util.view.ViewSenhaCertificado;
import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerTokenListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JPanel;

public class ViewListarCertificados
extends BBJFormPopup {
    private static final long serialVersionUID = 5744479110314992276L;
    private BBJButton btnCancelar = null;
    private BBJButton btnOK = null;
    private BBJButton btnVoltar = null;
    private JPanel pnlBotoes = null;
    private JPanel panelPrincipal = null;
    private BBJLabel labelEmitidoPara = null;
    private BBJLabel valorEmitidoPara = null;
    private BBJLabel labelEmitidoPor = null;
    private BBJLabel valorEmitidoPor = null;
    private BBJLabel labelValidade = null;
    private BBJLabel valorValidade = null;
    private BBJComboBoxLabel cmbCertificados = null;
    private Map<String, String> opcoesCertificados;
    private String mDefaultCertLabel;
    private byte[] mDefaultCertID;
    private Signer mSigner;
    private Boolean mProcessTerminated = null;
    private final SignerTokenListener mTokenListener = new SignerTokenListener(){

        public void tokenEvent(Signer signer) {
            ViewListarCertificados.this.processTokenEvent();
        }

        public void tokenInserted(Signer signer) {
            if (ViewListarCertificados.this.mProcessTerminated != null) {
                ViewListarCertificados.this.processTokenRemotion();
            } else {
                ViewListarCertificados.this.processTokenInsertion();
            }
        }

        public void tokenRemoved(Signer signer) {
            if (ViewListarCertificados.this.mProcessTerminated == null) {
                ViewListarCertificados.this.processTokenRemotion();
            }
        }
    };

    public void doShow() {
        this.setVisible(true);
    }

    public ViewListarCertificados(Signer signer) throws HeadlessException {
        super("Certificado Digital do Banco do Brasil", "", new Dimension(500, 400));
        this.mSigner = signer;
        this.mSigner.detectToken(this.mTokenListener);
        this.iniciarlizarCombo();
        this.initComponents();
    }

    public void inicializaTela() {
        super.inicializaTela();
        this.setVisible(true);
    }

    private void initComponents() {
        this.setSize(500, 400);
        this.setContentPanel(this.getPanelPrincipal());
        this.Centralizar();
        this.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public JPanel getPanelPrincipal() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = new JPanel();
            this.panelPrincipal.setOpaque(false);
            this.panelPrincipal.setBorder(BBJBordaOval.createOvalBorder(""));
            this.panelPrincipal.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.insets = new Insets(5, 5, 5, 5);
            gc.fill = 2;
            gc.weightx = 0.9;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 3;
            this.panelPrincipal.add((Component)this.getCmbCertificado(), gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            ++gc.gridx;
            this.panelPrincipal.add((Component)this.getLabelEmitidoPara(), gc);
            gc.weightx = 0.1;
            gc.fill = 2;
            ++gc.gridx;
            this.panelPrincipal.add((Component)this.getValorEmitidoPara(), gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            ++gc.gridx;
            this.panelPrincipal.add((Component)this.getLabelEmitidoPor(), gc);
            gc.weightx = 0.1;
            gc.fill = 2;
            ++gc.gridx;
            this.panelPrincipal.add((Component)this.getValorEmitidoPor(), gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            ++gc.gridx;
            this.panelPrincipal.add((Component)this.getLabelValidade(), gc);
            gc.weightx = 0.1;
            gc.fill = 2;
            ++gc.gridx;
            this.panelPrincipal.add((Component)this.getValorValidade(), gc);
        }
        return this.panelPrincipal;
    }

    public BBJComboBoxLabel getCmbCertificado() {
        if (this.cmbCertificados == null) {
            this.cmbCertificados = new BBJComboBoxLabel<String>("Nome: ", false, 0, this.opcoesCertificados, 250, 70);
            this.cmbCertificados.setVisible(true);
            this.cmbCertificados.getComboBox().addActionListener(this.actionListenerSelecionarCertificado());
            this.cmbCertificados.getAccessibleContext().setAccessibleName("Selecione um certificado");
            this.setSelectedCert(null);
        }
        return this.cmbCertificados;
    }

    private void iniciarlizarCombo() {
        this.getCmbCertificado().getComboBox().removeAllItems();
        try {
            SignerCertificate[] certs = this.mSigner.getPublicCerts();
            int i = 0;
            while (i < certs.length) {
                SignerCertificate cert = certs[i];
                this.getCmbCertificado().getComboBox().addItem(cert);
                if ((this.mDefaultCertLabel == null || this.mDefaultCertLabel.equals(cert.getLabel())) && (this.mDefaultCertID == null || Arrays.equals(cert.getID(), this.mDefaultCertID))) {
                    this.getCmbCertificado().setSelectedItem(cert);
                }
                ++i;
            }
        }
        catch (SignerException e) {
            this.getCmbCertificado().getComboBox().removeAllItems();
            System.err.println("Erro ao carregar certificados: " + e);
        }
        if (this.getCmbCertificado().getComboBox().getSelectedObjects().length <= 0) {
            System.out.println("Nenhum certificado aceit\u00e1vel encontrado.");
        }
    }

    private ActionListener actionListenerSelecionarCertificado() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewListarCertificados.this.setSelectedCert((SignerCertificate)ViewListarCertificados.this.cmbCertificados.getSelectedItem());
            }
        };
        return listener;
    }

    public BBJLabel getLabelEmitidoPara() {
        if (this.labelEmitidoPara == null) {
            this.labelEmitidoPara = new BBJLabel("Emitido para:");
            this.labelEmitidoPara.setFont(BBJEstilos.LABELTEXTOBOLD.getFont());
            this.labelEmitidoPara.setHorizontalAlignment(4);
        }
        return this.labelEmitidoPara;
    }

    public BBJLabel getValorEmitidoPara() {
        if (this.valorEmitidoPara == null) {
            this.valorEmitidoPara = new BBJLabel("");
            this.valorEmitidoPara.setFont(BBJEstilos.LABELTEXTO.getFont());
            this.valorEmitidoPara.setHorizontalAlignment(2);
        }
        return this.valorEmitidoPara;
    }

    public BBJLabel getLabelEmitidoPor() {
        if (this.labelEmitidoPor == null) {
            this.labelEmitidoPor = new BBJLabel("Emitido por:");
            this.labelEmitidoPor.setFont(BBJEstilos.LABELTEXTOBOLD.getFont());
            this.labelEmitidoPor.setHorizontalAlignment(4);
        }
        return this.labelEmitidoPor;
    }

    public BBJLabel getValorEmitidoPor() {
        if (this.valorEmitidoPor == null) {
            this.valorEmitidoPor = new BBJLabel("");
            this.valorEmitidoPor.setFont(BBJEstilos.LABELTEXTO.getFont());
            this.valorEmitidoPor.setHorizontalAlignment(2);
        }
        return this.valorEmitidoPor;
    }

    public BBJLabel getLabelValidade() {
        if (this.labelValidade == null) {
            this.labelValidade = new BBJLabel("Validade do Certificado:");
            this.labelValidade.setFont(BBJEstilos.LABELTEXTOBOLD.getFont());
            this.labelValidade.setHorizontalAlignment(4);
        }
        return this.labelValidade;
    }

    public BBJLabel getValorValidade() {
        if (this.valorValidade == null) {
            this.valorValidade = new BBJLabel("");
            this.valorValidade.setFont(BBJEstilos.LABELTEXTO.getFont());
            this.valorValidade.setHorizontalAlignment(2);
        }
        return this.valorValidade;
    }

    public JPanel getBarraBotoes() {
        if (this.pnlBotoes == null) {
            this.pnlBotoes = new JPanel();
            this.pnlBotoes.setOpaque(false);
            this.pnlBotoes.setPreferredSize(new Dimension(0, 35));
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(1);
            this.pnlBotoes.setLayout(layout);
            this.pnlBotoes.add(this.getBtnOK());
            this.pnlBotoes.add(this.getBtnVoltar());
            this.pnlBotoes.add(this.getBtnSim());
        }
        return this.pnlBotoes;
    }

    public BBJButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BBJButton("OK");
            this.btnOK.setSize();
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewSenhaCertificado view = new ViewSenhaCertificado();
                    view.inicializaTela();
                }
            });
        }
        return this.btnOK;
    }

    public BBJButton getBtnVoltar() {
        if (this.btnVoltar == null) {
            this.btnVoltar = new BBJButton("VOLTAR");
            this.btnVoltar.setSize();
            this.btnVoltar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewProcurarCartao view = new ViewProcurarCartao(ViewListarCertificados.this.mSigner);
                    view.doShow();
                }
            });
        }
        return this.btnVoltar;
    }

    public BBJButton getBtnSim() {
        if (this.btnCancelar == null) {
            this.btnCancelar = new BBJButton("CANCELAR");
            this.btnCancelar.setSize();
            this.btnCancelar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.btnCancelar;
    }

    public void setSelectedCert(SignerCertificate cert) {
        if (cert == null) {
            this.getCmbCertificado().setSelectedItem(null);
            this.getValorEmitidoPara().setText("");
            this.getValorEmitidoPor().setText("");
            this.getValorValidade().setText("          ");
            return;
        }
        if (this.getCmbCertificado().getSelectedItem() != cert) {
            this.getCmbCertificado().setSelectedItem(cert);
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        this.getValorEmitidoPara().setText(cert.getSubjectName());
        this.getValorEmitidoPor().setText(cert.getIssuerName());
        try {
            this.getValorValidade().setText(df.format(cert.getX509Certificate().getNotBefore()));
        }
        catch (SignerException e) {
            System.err.println("Erro ao carregar validade do certificado: " + e);
        }
    }

    protected void processTokenEvent() {
        System.out.println("Evento");
    }

    protected void processTokenInsertion() {
        System.out.println("Insere");
    }

    protected void processTokenRemotion() {
        System.out.println("Remover");
        ViewProcurarCartao view = new ViewProcurarCartao(this.mSigner);
        view.doShow();
    }

    protected boolean isProcessTerminated() {
        return this.mProcessTerminated != null && (this.mSigner == null || !this.mSigner.isActive());
    }

    protected boolean getTerminationState() {
        return this.mProcessTerminated == Boolean.TRUE;
    }
}

