/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.view.painel;

import br.com.bb.cdbb.apresentacao.SwingCDGA3;
import br.com.bb.cdbb.util.FileUtils;
import br.com.bb.cdbb.util.swing.BBJBordaOval;
import br.com.bb.cdbb.util.swing.componente.BBJButton;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJLabel;
import br.com.bb.cdbb.util.swing.componente.BBJPopupMensagem;
import br.com.bb.cdbb.util.swing.componente.BBJProgressAnimate;
import br.com.bb.cdbb.util.view.JanelaPrincipal;
import br.com.bb.cdbb.util.view.painel.PainelProcessoCancelado;
import br.com.bb.cdbb.util.view.painel.PainelSucesso;
import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.util.PKCS7;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.swing.JPanel;
import org.bouncycastle.util.encoders.Base64;

public class PainelGerandoArquivo {
    private BBJButton botaoCancelar = null;
    private JPanel painelBotoes = null;
    private JPanel painelPrincipal = null;
    private BBJLabel labelInseriCertDigital = null;
    private BBJProgressAnimate progressAnimate = null;
    private JanelaPrincipal janelaPrincipal = null;
    private ThreadGerarRemessa threadGerarRemessa;

    public PainelGerandoArquivo(JanelaPrincipal janelaPrincipal) {
        this.janelaPrincipal = janelaPrincipal;
        this.progressAnimate = new BBJProgressAnimate();
    }

    public JanelaPrincipal getJanelaPrincipal() {
        return this.janelaPrincipal;
    }

    public JPanel getPainelPrincipal() {
        if (this.painelPrincipal == null) {
            this.painelPrincipal = new JPanel();
            this.painelPrincipal.setOpaque(false);
            this.painelPrincipal.setLayout(new GridBagLayout());
            this.painelPrincipal.setBorder(BBJBordaOval.createOvalBorder());
            GridBagConstraints gc = new GridBagConstraints();
            gc.insets = new Insets(4, 25, 4, 25);
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 0.9;
            this.painelPrincipal.add((Component)this.getLabelInseriCertDigital(), gc);
            ++gc.gridy;
            this.painelPrincipal.add((Component)this.progressAnimate, gc);
            this.progressAnimate.iniciarAnimacao();
            this.iniciarGeracaoRemessa();
        }
        return this.painelPrincipal;
    }

    public BBJLabel getLabelInseriCertDigital() {
        if (this.labelInseriCertDigital == null) {
            this.labelInseriCertDigital = new BBJLabel("Gerando arquivo");
            this.labelInseriCertDigital.setFont(BBJEstilos.LABELTEXTOBOLD.getFont());
            this.labelInseriCertDigital.setHorizontalAlignment(0);
        }
        return this.labelInseriCertDigital;
    }

    public JPanel getPainelBotoes() {
        if (this.painelBotoes == null) {
            this.painelBotoes = new JPanel();
            this.painelBotoes.setOpaque(false);
            this.painelBotoes.setPreferredSize(new Dimension(0, 35));
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(1);
            this.painelBotoes.setLayout(layout);
            this.painelBotoes.add(this.getBotaoCancelar());
        }
        return this.painelBotoes;
    }

    public BBJButton getBotaoCancelar() {
        if (this.botaoCancelar == null) {
            this.botaoCancelar = new BBJButton("CANCELAR");
            this.botaoCancelar.setSize();
            this.botaoCancelar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PainelGerandoArquivo.this.apagaArquivoAssinado();
                    PainelProcessoCancelado view = new PainelProcessoCancelado(PainelGerandoArquivo.this.janelaPrincipal);
                    PainelGerandoArquivo.this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), 8);
                }
            });
        }
        return this.botaoCancelar;
    }

    protected void apagaArquivoAssinado() {
        File arquivoAssinado = new File(SwingCDGA3.get().getPathArquivoAssinado());
        arquivoAssinado.delete();
    }

    private void iniciarGeracaoRemessa() {
        this.threadGerarRemessa = new ThreadGerarRemessa();
        this.threadGerarRemessa.setDaemon(true);
        this.threadGerarRemessa.setPriority(10);
        this.threadGerarRemessa.start();
    }

    private class ThreadGerarRemessa
    extends Thread {
        private ThreadGerarRemessa() {
        }

        public void run() {
            this.assinaRemessa();
        }

        public void assinaRemessa() {
            try {
                SwingCDGA3.get().setArquivoAssinado(false);
                String nomeArquivoA3 = this.obtenhaNomeArquivoA3();
                String pathArquivoA3 = this.obtenhaPathArquivoA3();
                FileInputStream fis = new FileInputStream(SwingCDGA3.get().getArquivo());
                FileOutputStream fos = new FileOutputStream(pathArquivoA3);
                ByteArrayOutputStream baosArquivo = new ByteArrayOutputStream();
                try {
                    SignerCertificate cert = PainelGerandoArquivo.this.getJanelaPrincipal().getMSignerCertificate();
                    FileUtils.copyInputStream(new BufferedInputStream(fis), new BufferedOutputStream(baosArquivo));
                    byte[] sd = PainelGerandoArquivo.this.getJanelaPrincipal().getMSigner().sign(baosArquivo.toByteArray(), cert);
                    System.err.println("Verify: " + PainelGerandoArquivo.this.getJanelaPrincipal().getMSigner().verify(baosArquivo.toByteArray(), sd, cert));
                    sd = PKCS7.generatePKCS7Signature(sd, baosArquivo.toByteArray(), cert.getX509Certificate());
                    sd = Base64.encode((byte[])sd);
                    PainelGerandoArquivo.this.getJanelaPrincipal().setMSignedData(sd);
                    FileUtils.copyInputStream(new BufferedInputStream(new ByteArrayInputStream(sd)), new BufferedOutputStream(fos));
                    PainelGerandoArquivo.this.getJanelaPrincipal().setMProcessTerminated(true);
                    SwingCDGA3.get().setPathArquivoAssinado(pathArquivoA3);
                    SwingCDGA3.get().setNomeArquivoAssinado(nomeArquivoA3);
                    PainelSucesso view = new PainelSucesso(PainelGerandoArquivo.this.janelaPrincipal);
                    PainelGerandoArquivo.this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), 6);
                    SwingCDGA3.get().setArquivoAssinado(true);
                }
                finally {
                    PainelGerandoArquivo.this.getJanelaPrincipal().getMSigner().logout();
                    PainelGerandoArquivo.this.getJanelaPrincipal().getMSigner().close();
                    fis.close();
                    fos.close();
                    baosArquivo.close();
                }
            }
            catch (SignerException e) {
                System.err.println(e);
                BBJPopupMensagem.exibirMensagemErro(e.getMessage());
            }
            catch (GeneralSecurityException e) {
                System.err.println(e);
                BBJPopupMensagem.exibirMensagemErro("Erro ao processar arquivo: " + e.getMessage());
            }
            catch (IOException e) {
                System.err.println(e);
                BBJPopupMensagem.exibirMensagemErro("Erro ao processar arquivo: " + e.getMessage());
            }
            catch (Exception e) {
                System.err.println(e);
                BBJPopupMensagem.exibirMensagemErro("Erro ao processar arquivo: " + e.getMessage());
            }
        }

        private String obtenhaPathArquivoA3() {
            return SwingCDGA3.get().getArquivo().getPath().endsWith(".A3.REM") ? SwingCDGA3.get().getArquivo().getPath() : SwingCDGA3.get().getArquivo().getPath().replaceFirst(".REM", ".A3.REM");
        }

        private String obtenhaNomeArquivoA3() {
            String nomeArquivoA3 = SwingCDGA3.get().getArquivo().getName().endsWith(".A3.REM") ? SwingCDGA3.get().getArquivo().getName() : SwingCDGA3.get().getArquivo().getName().replaceFirst(".REM", ".A3.REM");
            return nomeArquivoA3;
        }
    }
}

