/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.view.painel;

import br.com.bb.cdbb.util.swing.BBJBordaOval;
import br.com.bb.cdbb.util.swing.componente.BBJButton;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJLabel;
import br.com.bb.cdbb.util.swing.componente.BBJPasswordLabel;
import br.com.bb.cdbb.util.view.JanelaPrincipal;
import br.com.bb.cdbb.util.view.painel.PainelGerandoArquivo;
import br.com.bb.cdbb.util.view.painel.PainelProcessoCancelado;
import br.com.bb.cdbb.util.view.painel.PainelSenhaErro;
import br.com.bb.cdbb.util.view.painel.PainelSenhaErroTentativa;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerLoginException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class PainelSenhaCertificado {
    private BBJLabel labelSenhaCertificado = null;
    private BBJPasswordLabel txtSenhaCertificado = null;
    private BBJButton botaoOK = null;
    private BBJButton botaoCancelar = null;
    private JPanel painelBotoes = null;
    private JPanel painelPrincipal = null;
    private JanelaPrincipal janelaPrincipal = null;

    public PainelSenhaCertificado(JanelaPrincipal janelaPrincipal) {
        this.janelaPrincipal = janelaPrincipal;
    }

    public JPanel getPainelPrincipal() {
        if (this.painelPrincipal == null) {
            this.painelPrincipal = new JPanel();
            this.painelPrincipal.setOpaque(false);
            this.painelPrincipal.setLayout(new GridBagLayout());
            this.painelPrincipal.setBorder(BBJBordaOval.createOvalBorder("Acesso ao Sistema"));
            GridBagConstraints gc = new GridBagConstraints();
            gc.insets = new Insets(4, 25, 4, 25);
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 0.9;
            this.painelPrincipal.add((Component)this.getLabelSenhaCertificado(), gc);
            ++gc.gridy;
            this.painelPrincipal.add((Component)this.getTxtSenhaCertificado(), gc);
        }
        return this.painelPrincipal;
    }

    public BBJPasswordLabel getTxtSenhaCertificado() {
        if (this.txtSenhaCertificado == null) {
            this.txtSenhaCertificado = new BBJPasswordLabel("", 8, true, 0, 0, 0, 8);
        }
        return this.txtSenhaCertificado;
    }

    public BBJLabel getLabelSenhaCertificado() {
        if (this.labelSenhaCertificado == null) {
            this.labelSenhaCertificado = new BBJLabel("Digite a senha do certificado digital");
            this.labelSenhaCertificado.setFont(BBJEstilos.LABELTEXTOBOLD.getFont());
            this.labelSenhaCertificado.setHorizontalAlignment(0);
        }
        return this.labelSenhaCertificado;
    }

    public JPanel getPainelBotoes() {
        if (this.painelBotoes == null) {
            this.painelBotoes = new JPanel();
            this.painelBotoes.setOpaque(false);
            this.painelBotoes.setPreferredSize(new Dimension(0, 35));
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(1);
            this.painelBotoes.setLayout(layout);
            this.painelBotoes.add(this.getBotaoOK());
            this.painelBotoes.add(this.getBotaoCancelar());
        }
        return this.painelBotoes;
    }

    public BBJButton getBotaoOK() {
        if (this.botaoOK == null) {
            this.botaoOK = new BBJButton("OK");
            this.botaoOK.setSize();
            this.botaoOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PainelSenhaCertificado.this.janelaPrincipal.setTentativaSenha(PainelSenhaCertificado.this.janelaPrincipal.getTentativaSenha() + 1);
                    if (PainelSenhaCertificado.this.validaTentativaSenha()) {
                        PainelSenhaCertificado.this.login(PainelSenhaCertificado.this.getTxtSenhaCertificado().getText());
                    }
                    if (PainelSenhaCertificado.this.validaTentativaMaximaSenha()) {
                        PainelSenhaErroTentativa view = new PainelSenhaErroTentativa(PainelSenhaCertificado.this.janelaPrincipal);
                        PainelSenhaCertificado.this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), 11);
                    }
                    PainelSenhaCertificado.this.getTxtSenhaCertificado().setText("");
                }
            });
        }
        return this.botaoOK;
    }

    public BBJButton getBotaoCancelar() {
        if (this.botaoCancelar == null) {
            this.botaoCancelar = new BBJButton("CANCELAR");
            this.botaoCancelar.setSize();
            this.botaoCancelar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PainelProcessoCancelado view = new PainelProcessoCancelado(PainelSenhaCertificado.this.janelaPrincipal);
                    PainelSenhaCertificado.this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), 8);
                }
            });
        }
        return this.botaoCancelar;
    }

    private void login(String senha) {
        try {
            this.janelaPrincipal.getMSigner().login(senha.toString().toCharArray());
            if (this.janelaPrincipal.getMSigner().isActive()) {
                System.out.println("Ativo");
            } else {
                System.out.println("Inativo");
            }
            PainelGerandoArquivo view = new PainelGerandoArquivo(this.janelaPrincipal);
            this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), 4);
        }
        catch (SignerLoginException e) {
            PainelSenhaErro view = new PainelSenhaErro(this.janelaPrincipal, e.getMessage());
            this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), 13);
        }
        catch (SignerException e) {
            PainelSenhaErro view = new PainelSenhaErro(this.janelaPrincipal, e.getMessage());
            this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), 13);
        }
    }

    private boolean validaTentativaSenha() {
        return this.janelaPrincipal.getTentativaSenha() <= 3;
    }

    private boolean validaTentativaMaximaSenha() {
        return this.janelaPrincipal.getTentativaSenha() >= 4;
    }
}

