/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador;

import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerIcpData;
import br.com.bb.cdg.assinador.util.IcpUtils;
import java.security.cert.X509Certificate;

public abstract class BaseSignerCertificate
implements SignerCertificate {
    private final Signer mSigner;
    private final X509Certificate mX509Certificate;
    private SignerIcpData mIcpData;

    public BaseSignerCertificate(Signer signer, X509Certificate certificate) {
        this.mSigner = signer;
        this.mX509Certificate = certificate;
    }

    public Signer getSigner() {
        return this.mSigner;
    }

    public SignerIcpData getIcpData() throws SignerException {
        if (this.mIcpData == null) {
            this.mIcpData = IcpUtils.loadCertData(this.getX509Certificate());
        }
        return this.mIcpData;
    }

    public boolean isICP() throws SignerException {
        return this.getIcpData() != null;
    }

    public boolean isA3() throws SignerException {
        return IcpUtils.isA3(this.getX509Certificate());
    }

    public int getIssuerID() {
        return IcpUtils.buildIssuerID(this.getIssuerObjectData());
    }

    protected abstract byte[] getIssuerObjectData();

    public X509Certificate getX509Certificate() {
        return this.mX509Certificate;
    }
}

