/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador;

import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SignerIcpData {
    private static final SimpleDateFormat BIRTH_DATE_FORMAT = new SimpleDateFormat("ddMMyyyy");
    private Date mBirthDay;
    private String mCPF;
    private String mPIS;
    private String mRG;
    private String mRGIssuer;
    private String mState;

    public SignerIcpData(String data) {
        if (data.length() >= 41) {
            try {
                this.mBirthDay = BIRTH_DATE_FORMAT.parse(data.substring(0, 8));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.mCPF = data.substring(8, 19);
            this.mPIS = data.substring(19, 30);
            int tamanho = data.length();
            if (tamanho == 41) {
                this.mRG = data.substring(30);
                return;
            }
            int posEstado = tamanho - 2;
            char c = data.charAt(41);
            if (Character.isLetter(c)) {
                this.mRG = data.substring(30, 41).trim();
                if (tamanho - 41 <= 3) {
                    this.mRGIssuer = data.substring(41).trim();
                    this.mState = "";
                } else {
                    this.mRGIssuer = data.substring(41, posEstado).replace('/', ' ').trim();
                    this.mState = data.substring(posEstado);
                }
            } else {
                this.mRG = data.substring(30, 45).trim();
                if (tamanho - 45 <= 3) {
                    this.mRGIssuer = data.substring(45).trim();
                    this.mState = "";
                } else {
                    this.mRGIssuer = data.substring(45, posEstado).replace('/', ' ').trim();
                    this.mState = data.substring(posEstado);
                }
            }
        } else {
            throw new InvalidParameterException();
        }
    }

    public Date getBirthDay() {
        return this.mBirthDay;
    }

    public String getCPF() {
        return this.mCPF;
    }

    public String getPIS() {
        return this.mPIS;
    }

    public String getRG() {
        return this.mRG;
    }

    public String getRGIssuer() {
        return this.mRGIssuer;
    }

    public String getState() {
        return this.mState;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getBirthDay() != null) {
            buffer.append("Nascimento=").append(this.getBirthDay()).append(';');
        }
        buffer.append("CPF=").append(this.getCPF()).append(';');
        buffer.append("RG=").append(this.getRG()).append(';');
        buffer.append("EmissorRG=").append(this.getRGIssuer()).append(';');
        buffer.append("EstadoRG=").append(this.getState()).append(';');
        return buffer.toString();
    }
}

