/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.applet;

import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.applet.BaseSignerApplet;
import br.com.bb.cdg.assinador.panels.CertListPanel;
import br.com.bb.cdg.assinador.util.IcpUtils;
import java.security.cert.CertificateEncodingException;
import org.bouncycastle.util.encoders.Base64;

public class CollectApplet
extends BaseSignerApplet {
    private final CertListPanel mCertsPanel = new CertListPanel(this);

    public boolean ok() {
        if (this.getCurrentPanel() == this.mCertsPanel) {
            if (this.validateCurrentPanel()) {
                this.terminateProcess(true);
            }
        } else if (this.isProcessTerminated()) {
            return true;
        }
        return false;
    }

    protected void processTokenInsertion() {
        this.setCurrentPanel(this.mCertsPanel);
    }

    public String getCert() {
        try {
            return new String(Base64.encode((byte[])this.mCertsPanel.getSelectedCert().getX509Certificate().getEncoded()));
        }
        catch (CertificateEncodingException e) {
            System.err.println("Erro ao codificar certificado.");
        }
        catch (SignerException e) {
            System.err.println("Erro ao recuperar certificado.");
        }
        return null;
    }

    public String getCertIssuer() {
        return Integer.toHexString(this.mCertsPanel.getSelectedCert().getIssuerID());
    }

    public String getCertSerialNumber() {
        try {
            return IcpUtils.getCertSerialNumber(this.mCertsPanel.getSelectedCert());
        }
        catch (SignerException e) {
            System.err.println("Erro ao recuperar numero de serie do certificado: " + e);
            return null;
        }
    }

    public String getCertId() {
        return this.mCertsPanel.getSelectedCertID();
    }
}

