/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.applet;

import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.applet.AppletException;
import br.com.bb.cdg.assinador.applet.BaseSignerApplet;
import br.com.bb.cdg.assinador.panels.CertListPanel;
import br.com.bb.cdg.assinador.panels.PinPanel;
import br.com.bb.cdg.assinador.util.IcpUtils;
import org.bouncycastle.util.encoders.Hex;

public class SignApplet
extends BaseSignerApplet {
    private final PinPanel mPinPanel = new PinPanel(this);
    private final CertListPanel mCertsPanel = new CertListPanel(this);
    private byte[] mData = null;
    private byte[] mSignedData = null;

    public void init() {
        try {
            this.mCertsPanel.setDefaultCertID(this.getParameter("c"));
            String data = this.getParameter("d");
            if (data.charAt(data.length() - 1) == '#') {
                data = data.substring(0, data.length() - 1);
            }
            this.mData = data.getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            System.err.println("Par\u00e2metros inv\u00e1lidos: " + e);
            this.showErrorPanel("Par\u00e2metros inv\u00e1lidos para a applet.");
            return;
        }
        super.init();
    }

    public boolean ok() {
        if (this.getCurrentPanel() == this.mCertsPanel) {
            this.changePanel(this.mPinPanel);
        } else if (this.getCurrentPanel() == this.mPinPanel) {
            try {
                try {
                    this.getSigner().login(this.mPinPanel.getPin());
                    SignerCertificate cert = this.mCertsPanel.getSelectedCert();
                    this.mSignedData = this.getSigner().sign(this.mData, cert);
                    this.mPinPanel.clearPin();
                    this.terminateProcess(true);
                }
                finally {
                    this.getSigner().logout();
                }
            }
            catch (SignerException e) {
                System.err.println(e);
                this.showMessage(e.getMessage());
            }
        } else if (this.isProcessTerminated()) {
            return true;
        }
        return false;
    }

    protected void processTokenInsertion() {
        try {
            this.mCertsPanel.init();
        }
        catch (AppletException e) {
            System.err.println("Erro ao validar usu\u00e1rio: " + e);
            this.showMessage("Erro ao validar usu\u00e1rio: " + e);
            return;
        }
        boolean certSelected = this.mCertsPanel.isDefaultCertPresent();
        if (!certSelected && this.mCertsPanel.getCertCount() == 1) {
            certSelected = true;
        }
        if (certSelected) {
            this.setCurrentPanel(this.mPinPanel);
        } else {
            this.setCurrentPanel(this.mCertsPanel);
        }
    }

    public String getSignedData() {
        return new String(Hex.encode((byte[])this.mSignedData));
    }

    public String getCertId() {
        return this.mCertsPanel.getSelectedCertID();
    }

    public String getCertIssuer() {
        SignerCertificate cert = this.mCertsPanel.getSelectedCert();
        if (cert == null) {
            return null;
        }
        return Integer.toHexString(cert.getIssuerID());
    }

    public String getCertSerialNumber() {
        try {
            return IcpUtils.getCertSerialNumber(this.mCertsPanel.getSelectedCert());
        }
        catch (SignerException e) {
            System.err.println("Erro ao recuperar numero de serie do certificado: " + e);
            return null;
        }
    }

    public void showApplet() {
        this.getCurrentPanel().invalidate();
        this.getCurrentPanel().repaint();
        this.takeFocus();
    }
}

