/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.iaik;

import br.com.bb.cdg.assinador.BaseSignerCertificate;
import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerKey;
import br.com.bb.cdg.assinador.iaik.IAIKSigner;
import br.com.bb.cdg.assinador.iaik.IAIKSignerKey;
import br.com.bb.cdg.assinador.util.IcpUtils;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;

public class IAIKSignerCertificate
extends BaseSignerCertificate {
    private final X509PublicKeyCertificate mCertificate;
    private IAIKSignerKey mPublicKey;
    private IAIKSignerKey mPrivateKey;

    protected IAIKSignerCertificate(Signer signer, X509PublicKeyCertificate certificate) throws SignerException {
        super(signer, IcpUtils.parseCert(certificate.getValue().getByteArrayValue()));
        this.mCertificate = certificate;
    }

    public SignerKey getPrivateKey() throws SignerException {
        if (this.mPrivateKey == null) {
            RSAPrivateKey key = ((IAIKSigner)this.getSigner()).getPrivateKey(this);
            this.mPrivateKey = new IAIKSignerKey(this, key);
        }
        return this.mPrivateKey;
    }

    public SignerKey getPublicKey() throws SignerException {
        if (this.mPublicKey == null) {
            RSAPublicKey key = ((IAIKSigner)this.getSigner()).getPublicKey(this);
            this.mPublicKey = new IAIKSignerKey(this, key);
        }
        return this.mPublicKey;
    }

    protected X509PublicKeyCertificate getCertificate() {
        return this.mCertificate;
    }

    public String getLabel() {
        return new String(this.mCertificate.getLabel().getCharArrayValue());
    }

    protected byte[] getIssuerObjectData() {
        return this.getCertificate().getIssuer().getByteArrayValue();
    }

    public String getSubjectName() {
        byte[] data = this.getCertificate().getSubject().getByteArrayValue();
        String subject = IcpUtils.extractFieldName(data);
        if (subject == null) {
            return null;
        }
        int pos = subject.indexOf(58);
        if (pos != -1) {
            return subject.substring(0, pos);
        }
        return subject;
    }

    public String getIssuerName() {
        byte[] data = this.getCertificate().getIssuer().getByteArrayValue();
        return IcpUtils.extractFieldName(data);
    }

    public byte[] getID() {
        return this.getCertificate().getId().getByteArrayValue();
    }

    public String toString() {
        byte[] data = this.getCertificate().getSubject().getByteArrayValue();
        String subject = IcpUtils.extractFieldName(data);
        if (subject == null) {
            return null;
        }
        int pos = subject.indexOf(58);
        if (pos != -1) {
            String nome = subject.substring(0, pos);
            String cpf = subject.substring(pos + 1);
            if (cpf.length() == 11) {
                return String.valueOf(nome) + " CPF: " + cpf.substring(0, 3) + "." + cpf.substring(3, 6) + "." + cpf.substring(6, 9) + "-" + cpf.substring(9);
            }
        }
        return subject;
    }
}

