/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.iaikLL;

import br.com.bb.cdg.assinador.BaseSigner;
import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerKey;
import br.com.bb.cdg.assinador.SignerLoginException;
import br.com.bb.cdg.assinador.SignerTokenListener;
import br.com.bb.cdg.assinador.iaikLL.IAIKSignerCertificate;
import br.com.bb.cdg.assinador.iaikLL.IAIKSignerKey;
import br.com.bb.cdg.assinador.iaikLL.IAIKTokenListenerThread;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import iaik.pkcs.pkcs11.wrapper.PKCS11Implementation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class IAIKSigner
extends BaseSigner {
    private PKCS11 mModule;
    private long mSlot;
    private long mSession;
    private IAIKTokenListenerThread mTokenListenerThread;
    private static final iaik.pkcs.pkcs11.objects.Object syncLoadSesssion = new iaik.pkcs.pkcs11.objects.Object();

    public IAIKSigner(String configDir) throws SignerException, IOException {
        super(configDir);
        this.loadModule();
        this.loadSession();
    }

    public synchronized boolean isActive() {
        return this.mModule != null && this.mSession != 0L;
    }

    protected PKCS11 getModule() {
        return this.mModule;
    }

    protected long getSession() {
        return this.mSession;
    }

    protected String getModuleLib() throws IOException {
        if (this.getConfigDir().indexOf(".dll") != -1 || this.getConfigDir().indexOf(".so") != -1) {
            return this.getConfigDir();
        }
        String configName = this.getConfigFile();
        Properties prop = new Properties();
        prop.load(new FileInputStream(configName));
        return prop.getProperty("library");
    }

    protected long getObject(CK_ATTRIBUTE[] modelo, String descricao) throws SignerException {
        long[] objs;
        try {
            this.mModule.C_FindObjectsInit(this.mSession, modelo);
            objs = this.mModule.C_FindObjects(this.mSession, 2L);
            this.mModule.C_FindObjectsFinal(this.mSession);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao recuperar o objeto '" + descricao + "': " + e.getMessage(), e);
        }
        if (objs.length == 0) {
            throw new SignerException("N\u00e3o encontrado nenhum objeto '" + descricao + "'.");
        }
        if (objs.length > 1) {
            throw new SignerException("N\u00famero inv\u00e1lido de objetos '" + descricao + "' encontrados.");
        }
        return objs[0];
    }

    protected long getKey(IAIKSignerCertificate cert, boolean privada) throws SignerException {
        byte[] id = cert.getID();
        try {
            CK_ATTRIBUTE[] modelo = new CK_ATTRIBUTE[id != null ? 4 : 3];
            modelo[0] = new CK_ATTRIBUTE();
            modelo[0].type = 256L;
            modelo[0].pValue = new Long(0L);
            modelo[1] = new CK_ATTRIBUTE();
            modelo[1].type = 0L;
            modelo[1].pValue = new Long(privada ? 3L : 2L);
            modelo[2] = new CK_ATTRIBUTE();
            modelo[2].type = 3L;
            modelo[2].pValue = cert.getLabel().toCharArray();
            if (id != null) {
                modelo[3] = new CK_ATTRIBUTE();
                modelo[3].type = 258L;
                modelo[3].pValue = id;
            }
            return this.getObject(modelo, privada ? "chave privada" : "chave publica");
        }
        catch (SignerException e) {
            if (id == null || !e.getMessage().startsWith("N\u00e3o encontrado nenhum objeto")) {
                throw e;
            }
            CK_ATTRIBUTE[] modelo = new CK_ATTRIBUTE[3];
            modelo[0] = new CK_ATTRIBUTE();
            modelo[0].type = 256L;
            modelo[0].pValue = new Long(0L);
            modelo[1] = new CK_ATTRIBUTE();
            modelo[1].type = 0L;
            modelo[1].pValue = new Long(privada ? 3L : 2L);
            modelo[2] = new CK_ATTRIBUTE();
            modelo[2].type = 258L;
            modelo[2].pValue = id;
            return this.getObject(modelo, privada ? "chave privada" : "chave publica");
        }
    }

    protected long getPrivateKey(IAIKSignerCertificate cert) throws SignerException {
        return this.getKey(cert, true);
    }

    protected long getPublicKey(IAIKSignerCertificate cert) throws SignerException {
        return this.getKey(cert, false);
    }

    public SignerCertificate[] getPublicCerts() throws SignerException {
        long[] objs;
        if (!this.isActive()) {
            return null;
        }
        try {
            CK_ATTRIBUTE[] modelo = new CK_ATTRIBUTE[2];
            modelo[0] = new CK_ATTRIBUTE();
            modelo[0].type = 128L;
            modelo[0].pValue = new Long(0L);
            modelo[1] = new CK_ATTRIBUTE();
            modelo[1].type = 0L;
            modelo[1].pValue = new Long(1L);
            this.mModule.C_FindObjectsInit(this.mSession, modelo);
            objs = this.mModule.C_FindObjects(this.mSession, 100L);
            this.mModule.C_FindObjectsFinal(this.mSession);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao recuperar certificados: " + e.getMessage(), e);
        }
        if (objs.length == 0) {
            throw new SignerException("Nenhum certificado encontrado.");
        }
        ArrayList<IAIKSignerCertificate> list = new ArrayList<IAIKSignerCertificate>(objs.length);
        int i = 0;
        while (i < objs.length) {
            IAIKSignerCertificate cert;
            try {
                cert = new IAIKSignerCertificate((Signer)this, objs[i]);
            }
            catch (PKCS11Exception e) {
                throw new SignerException("Erro ao carregar o certificado.", e);
            }
            if (cert.isICP()) {
                list.add(cert);
            }
            ++i;
        }
        SignerCertificate[] arr = new SignerCertificate[list.size()];
        return list.toArray(arr);
    }

    public SignerCertificate getPublicCert(String label, byte[] id) throws SignerException {
        IAIKSignerCertificate cert;
        CK_ATTRIBUTE[] modelo = new CK_ATTRIBUTE[id != null ? 4 : 3];
        modelo[0] = new CK_ATTRIBUTE();
        modelo[0].type = 128L;
        modelo[0].pValue = new Long(0L);
        modelo[1] = new CK_ATTRIBUTE();
        modelo[1].type = 0L;
        modelo[1].pValue = new Long(1L);
        modelo[2] = new CK_ATTRIBUTE();
        modelo[2].type = 3L;
        modelo[2].pValue = label.toCharArray();
        if (id != null) {
            modelo[3] = new CK_ATTRIBUTE();
            modelo[3].type = 258L;
            modelo[3].pValue = id;
        }
        long x509 = this.getObject(modelo, "certificado p\u00fablico");
        try {
            cert = new IAIKSignerCertificate((Signer)this, x509);
        }
        catch (PKCS11Exception e) {
            throw new SignerException("Erro ao carregar o certificado.", e);
        }
        if (!cert.isICP() || !cert.isA3()) {
            throw new SignerException("Certificado p\u00fablico n\u00e3o \u00e9 v\u00e1lido.");
        }
        return cert;
    }

    public boolean isLogginNeeded() {
        try {
            CK_TOKEN_INFO ckTokenInfo = this.mModule.C_GetTokenInfo(this.mSlot);
            return (ckTokenInfo.flags & 4L) != 0L;
        }
        catch (TokenException e) {
            return true;
        }
    }

    public void login(char[] pin) throws SignerException, SignerLoginException {
        try {
            this.mModule.C_Login(this.mSession, 1L, pin);
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() == 256L) {
                return;
            }
            if (e.getErrorCode() == 162L || e.getErrorCode() == 160L || e.getErrorCode() == 161L) {
                throw new SignerLoginException("O PIN informado \u00e9 invalido: " + e.getMessage(), e);
            }
            if (e.getErrorCode() == 164L || e.getErrorCode() == 163L) {
                throw new SignerLoginException("O PIN informado n\u00e3o pode ser utilizado: " + e.getMessage(), e);
            }
            if (e.getErrorCode() == 258L) {
                throw new SignerLoginException("O cart\u00e3o n\u00e3o tem um PIN inicializado: " + e.getMessage(), e);
            }
            throw new SignerException("Erro no login: " + e.getMessage(), e);
        }
    }

    public void logout() throws SignerException {
        if (this.mSession != 0L) {
            try {
                this.mModule.C_Logout(this.mSession);
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() == 257L) {
                    return;
                }
                throw new SignerException("Erro ao fechar sess\u00e3o: " + e.getMessage(), e);
            }
        }
    }

    public byte[] sign(byte[] data, SignerCertificate cert) throws SignerException {
        try {
            long key = ((IAIKSignerKey)cert.getPrivateKey()).getKey();
            CK_MECHANISM ckMechanism = new CK_MECHANISM();
            ckMechanism.mechanism = 1L;
            this.mModule.C_SignInit(this.mSession, ckMechanism, key);
            return this.mModule.C_Sign(this.mSession, this.generateSignData(new ByteArrayInputStream(data)));
        }
        catch (IOException e) {
            try {
                this.mModule.C_SignFinal(this.mSession);
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
            throw new SignerException("Erro ao gerar assinatura: " + e.getMessage(), e);
        }
        catch (PKCS11Exception e) {
            try {
                this.mModule.C_SignFinal(this.mSession);
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
            throw new SignerException("Erro ao assinar dados: " + e.getMessage(), e);
        }
    }

    public byte[] sign(InputStream in, SignerCertificate cert) throws SignerException {
        try {
            long key = ((IAIKSignerKey)cert.getPrivateKey()).getKey();
            CK_MECHANISM ckMechanism = new CK_MECHANISM();
            ckMechanism.mechanism = 1L;
            this.mModule.C_SignInit(this.mSession, ckMechanism, key);
            return this.mModule.C_Sign(this.mSession, this.generateSignData(in));
        }
        catch (IOException e) {
            throw new SignerException("Erro ao gerar assinatura: " + e.getMessage(), e);
        }
        catch (PKCS11Exception e) {
            throw new SignerException("Erro ao assinar dados: " + e.getMessage(), e);
        }
    }

    protected byte[] generateSignData(InputStream in) throws IOException {
        int size;
        SHA1Digest digest = new SHA1Digest();
        byte[] hash = new byte[digest.getDigestSize()];
        byte[] data = new byte[8192];
        while ((size = in.read(data)) != -1) {
            digest.update(data, 0, size);
        }
        digest.doFinal(hash, 0);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        dOut.writeObject((Object)new DigestInfo(new AlgorithmIdentifier(new DERObjectIdentifier("1.3.14.3.2.26"), null), hash));
        return bOut.toByteArray();
    }

    public boolean verify(byte[] data, byte[] signature, SignerCertificate cert) throws SignerException {
        try {
            long key = ((IAIKSignerKey)cert.getPublicKey()).getKey();
            CK_MECHANISM ckMechanism = new CK_MECHANISM();
            ckMechanism.mechanism = 6L;
            this.mModule.C_VerifyInit(this.mSession, ckMechanism, key);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao verificar assinatura: " + e.getMessage(), e);
        }
        try {
            this.mModule.C_Verify(this.mSession, data, signature);
            return true;
        }
        catch (TokenException e) {
            return false;
        }
    }

    public boolean verify(InputStream in, byte[] signature, SignerCertificate cert) throws SignerException {
        try {
            int size;
            long key = ((IAIKSignerKey)cert.getPublicKey()).getKey();
            CK_MECHANISM ckMechanism = new CK_MECHANISM();
            ckMechanism.mechanism = 6L;
            this.mModule.C_VerifyInit(this.mSession, ckMechanism, key);
            byte[] data = new byte[8192];
            while ((size = in.read(data)) != -1) {
                if (size == data.length) {
                    this.mModule.C_VerifyUpdate(this.mSession, data);
                    continue;
                }
                byte[] bufferBurro = new byte[size];
                System.arraycopy(data, 0, bufferBurro, 0, size);
                this.mModule.C_VerifyUpdate(this.mSession, bufferBurro);
            }
        }
        catch (TokenException e) {
            try {
                this.mModule.C_VerifyFinal(this.mSession, signature);
            }
            catch (TokenException tokenException) {
                // empty catch block
            }
            throw new SignerException("Erro ao verificar assinatura: " + e.getMessage(), e);
        }
        catch (IOException e) {
            try {
                this.mModule.C_VerifyFinal(this.mSession, signature);
            }
            catch (TokenException tokenException) {
                // empty catch block
            }
            throw new SignerException("Erro ao verificar assinatura: " + e.getMessage(), e);
        }
        try {
            this.mModule.C_VerifyFinal(this.mSession, signature);
            return true;
        }
        catch (TokenException e) {
            return false;
        }
    }

    public byte[] encrypt(byte[] data, SignerKey key) throws SignerException {
        try {
            CK_MECHANISM ckMechanism = new CK_MECHANISM();
            ckMechanism.mechanism = 1L;
            this.mModule.C_EncryptInit(this.mSession, ckMechanism, ((IAIKSignerKey)key).getKey());
            return this.mModule.C_Encrypt(this.mSession, data);
        }
        catch (PKCS11Exception e) {
            throw new SignerException("Erro ao cifrar dados: " + e.getMessage(), e);
        }
    }

    public void encrypt(InputStream in, OutputStream out, SignerKey key) throws SignerException {
        try {
            int size;
            CK_MECHANISM ckMechanism = new CK_MECHANISM();
            ckMechanism.mechanism = 1L;
            this.mModule.C_EncryptInit(this.mSession, ckMechanism, ((IAIKSignerKey)key).getKey());
            byte[] data = new byte[8192];
            while ((size = in.read(data)) != -1) {
                byte[] res;
                if (size == data.length) {
                    res = this.mModule.C_EncryptUpdate(this.mSession, data);
                } else {
                    byte[] bufferBurro = new byte[size];
                    System.arraycopy(data, 0, bufferBurro, 0, size);
                    res = this.mModule.C_EncryptUpdate(this.mSession, bufferBurro);
                }
                if (res == null) continue;
                out.write(res);
            }
            out.write(this.mModule.C_EncryptFinal(this.mSession));
        }
        catch (IOException e) {
            throw new SignerException("Erro ao cifrar dados: " + e.getMessage(), e);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao cifrar dados: " + e.getMessage(), e);
        }
    }

    public byte[] decrypt(byte[] data, SignerKey key) throws SignerException {
        try {
            long cardkey = ((IAIKSignerKey)key).getKey();
            CK_MECHANISM ckMechanism = new CK_MECHANISM();
            ckMechanism.mechanism = 1L;
            this.mModule.C_DecryptInit(this.mSession, ckMechanism, cardkey);
            return this.mModule.C_Decrypt(this.mSession, data);
        }
        catch (PKCS11Exception e) {
            if (!(((IAIKSignerKey)key).isPrivate() || e.getErrorCode() != 99L && e.getErrorCode() != 6L)) {
                return super.decrypt(data, key);
            }
            throw new SignerException("Erro ao decifrar dados: " + e.getMessage(), e);
        }
    }

    public void decrypt(InputStream in, OutputStream out, SignerKey key) throws SignerException {
        try {
            int size;
            CK_MECHANISM ckMechanism = new CK_MECHANISM();
            ckMechanism.mechanism = 1L;
            this.mModule.C_DecryptInit(this.mSession, ckMechanism, ((IAIKSignerKey)key).getKey());
            byte[] data = new byte[8192];
            while ((size = in.read(data)) != -1) {
                byte[] res;
                if (size == data.length) {
                    res = this.mModule.C_DecryptUpdate(this.mSession, data);
                } else {
                    byte[] bufferBurro = new byte[size];
                    System.arraycopy(data, 0, bufferBurro, 0, size);
                    res = this.mModule.C_DecryptUpdate(this.mSession, bufferBurro);
                }
                if (res == null) continue;
                out.write(res);
            }
            out.write(this.mModule.C_DecryptFinal(this.mSession));
        }
        catch (IOException e) {
            throw new SignerException("Erro ao decifrar dados: " + e.getMessage(), e);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao decifrar dados: " + e.getMessage(), e);
        }
    }

    protected synchronized void loadModule() throws IOException, SignerException {
        if (this.mModule != null) {
            return;
        }
        PKCS11Implementation module = null;
        String library = this.getModuleLib();
        if (library == null) {
            throw new SignerException("Modulo PKCS #11 n\u00e3o especificado.");
        }
        try {
            module = new PKCS11Implementation(library);
            CK_C_INITIALIZE_ARGS wrapperInitArgs = new CK_C_INITIALIZE_ARGS();
            wrapperInitArgs.flags = 2L;
            module.C_Initialize(wrapperInitArgs);
        }
        catch (PKCS11Exception e) {
            if (module == null || e.getErrorCode() != 401L) {
                throw new SignerException("Leitora n\u00e3o encontrada: " + e.getMessage(), e);
            }
            try {
                module.C_Finalize(null);
                CK_C_INITIALIZE_ARGS wrapperInitArgs = new CK_C_INITIALIZE_ARGS();
                wrapperInitArgs.flags = 2L;
                module.C_Initialize(wrapperInitArgs);
            }
            catch (TokenException e1) {
                throw new SignerException("Erro ao reinicializar dispositivo: " + e1.getMessage(), e1);
            }
            System.err.println("Dispositivo reinicializado.");
        }
        this.mModule = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized boolean loadSession() throws SignerException {
        try {
            long[] slots = this.mModule.C_GetSlotList(true);
            if (slots.length == 0) {
                slots = this.mModule.C_GetSlotList(false);
                if (slots.length != 0) return false;
                throw new SignerException("Leitora n\u00e3o encontrada.");
            }
            long token = slots[0];
            try {
                iaik.pkcs.pkcs11.objects.Object object = syncLoadSesssion;
                synchronized (object) {
                    try {
                        this.mModule.C_CloseAllSessions(token);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mSession = this.mModule.C_OpenSession(token, 4L, null, null);
                    this.mSlot = token;
                    return true;
                }
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() != 225L) throw e;
                return false;
            }
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao carregar cart\u00e3o: " + e.getMessage(), e);
        }
    }

    public synchronized void detectToken(SignerTokenListener stl) {
        if (this.mModule == null) {
            return;
        }
        if (this.mTokenListenerThread == null) {
            this.mTokenListenerThread = new IAIKTokenListenerThread(this, stl);
            this.mTokenListenerThread.start();
        } else {
            this.mTokenListenerThread.addListener(stl);
        }
    }

    public synchronized void close() {
        this.closeSession();
        this.closeModule();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected void closeSession() {
        block6: {
            long s;
            block5: {
                if (this.mSession == 0L) {
                    return;
                }
                s = this.mSession;
                this.mSession = 0L;
                try {
                    this.mModule.C_Logout(s);
                }
                catch (PKCS11Exception e) {
                    if (e.getErrorCode() == 179L || e.getErrorCode() == 224L || e.getErrorCode() == 257L) break block5;
                    System.err.println("Erro ao cancelar login: " + e);
                }
            }
            try {
                this.mModule.C_CloseSession(s);
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() == 179L || e.getErrorCode() == 224L) break block6;
                System.err.println("Erro ao finalizar sess\u00e3o: " + e);
            }
        }
    }

    protected void closeModule() {
        if (this.mModule == null) {
            return;
        }
        PKCS11 module = this.mModule;
        this.mModule = null;
        if (this.mTokenListenerThread != null) {
            this.mTokenListenerThread.terminate();
            this.mTokenListenerThread = null;
        }
        try {
            module.C_Finalize(null);
        }
        catch (TokenException e) {
            System.err.println("Erro ao finalizar modulo: " + e);
        }
        try {
            module.finalize();
        }
        catch (Throwable e) {
            System.err.println("Erro ao descarregar modulo: " + e);
        }
    }
}

